package users;
#
#  Package:      users.pm
#
#  Copyright:     COPYRIGHT Compaq Computer Corporation 2001.  All rights reserved.
#
#  Description:  The OS specific routines for changing the system.
#
#    These routines handle USER specific changes including:
#
#     - Add/Delete/Edit user
#     - Disk quota management
#     - Permission management
#     - etc.
#
#  History:
#
use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Quota;
use Time::localtime;
use custom::sendmail;

use config;
use general;
use datastore;
use message;
use error;



# A sub-routine to remove a user from the system
sub delUser {

    my $loginname = shift || "";

    my %system = config::system();

    my %userInfo = datastore::userInfo($loginname);

    # First make sure they are completely off the system
    my $command = "/bin/ps -U $userInfo{'uid'} -o pid | /bin/grep \\\\.*";
    my $result = `$command`;

    general::debug( "PIDS for user $userInfo{'uid'} $command\n $result");

    # Gather PIDs and drop the header "PID"
    my @pids = split("\n", $result);
    shift(@pids);

    # Kill all user processes
    foreach my $pid (@pids) {
	$command = "/bin/kill -9 $pid";
	$result = `$command`;
#	general::debug( "$command\n $result");
    }

    # Remove the user from the system
    $command = "/usr/sbin/userdel -r $loginname";
    $result = `$command`;
    $command = "/usr/sbin/groupdel $loginname";
    $result = `$command`;

    general::debug( "User $loginname Deleted from the system!");

    # Remove the user from the XML
    datastore::delUser($loginname);

    updateSendmailGenericsTable();

    general::debug( "User completely deleted!");

    return(1);
}


# A sub-routine to update user attributes
sub updateUser {

    general::debug( "Beginning user update");

    my $loginname = shift || return(0);
    my $password = shift || "";

    my %userinfo = datastore::userInfo($loginname);


#    general::debug( "Got password of $password");

    if ($password ne "") {
	my $command = "/usr/sbin/usermod -p $password $loginname";
	`$command`;
    }

    my %system = config::system();

    # Parse the user file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    # Locate this user
    my $users = $doc->getElementsByTagName("User");
    my $userNode = "";
    my $numOfUsers = $users->getLength();
    
    for (my $i=0; $i < $numOfUsers; $i++) {
	
	my $thisLoginName = $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData();
	
	# Did we find it?
	if ($thisLoginName eq $loginname) {
	    $userNode = $users->item($i);
	    last;
	}
	
    }

    my $status = "";
    my $diskquota = "";
    my $ssh = "";
    my $ftp = "";
    my $telnet = "";
    my $pop3 = "";
    my $imap = "";

    # If we found the user, then populate the variables for edit
    if ($userNode ne "") {
    
	# Populate variables
	$status = eval { $userNode->getElementsByTagName("Status")->item(0)->getFirstChild->getData(); } || "";
	$diskquota = eval { $userNode->getElementsByTagName("DiskQuota")->item(0)->getFirstChild->getData(); } || "";
	$ssh = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("SSH")->item(0)->getFirstChild->getData(); } || "";
	$ftp = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("FTP")->item(0)->getFirstChild->getData(); } || "";
	$telnet = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("Telnet")->item(0)->getFirstChild->getData(); } || "";
	$pop3 = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("POP3")->item(0)->getFirstChild->getData(); } || "";
	$imap = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("IMAP")->item(0)->getFirstChild->getData(); } || "";

    }
    else {
	general::debug( "Could not find the user node!!!");
	return(0);
    }

    my $password = "";

    general::debug( "About to open shadow file");

    # Grab the password for this user
    if (open(FILE, "</etc/shadow")) {
	
	my $foundUser = 0;
	my @lines = <FILE>;

	general::debug( "Shadow open and read");
	
	foreach my $line (@lines) {
	    
	    if ($line =~ m/^$loginname:([^:]*):/) {
		$password = $1;
	    }
	}
    }

    general::debug( "Finished with shadow file");

    # Check to see if we've found the right user
    if ($password eq "") {
	print "This user is not valid ($loginname)!";
	return();
    }
    else {

	general::debug( "Updating user $loginname");

	# Update password
	my $command = "/usr/sbin/usermod -p $password $loginname";
	my $result = `$command`;

	general::debug( "Status = $status");

	# Activate/In-activate user
	if ($status eq "Active") {

	    $command = "/usr/sbin/usermod -U $loginname";

	}
	else {

	    # First make sure they are completely off the system
	    $command = "/bin/ps -U $userinfo{'uid'} -o pid | /bin/grep \\\\.*";
	    $result = `$command`;
	    
	    general::debug( "PIDS for user $userinfo{'uid'} $command\n $result");
	    
	    # Gather PIDs and drop the header "PID"
	    my @pids = split("\n", $result);
	    shift(@pids);
	    
	    # Kill all user processes
	    foreach my $pid (@pids) {
		$command = "/bin/kill -9 $pid";
		$result = `$command`;
#		general::debug( "$command\n $result");
	    }

	    $command = "/usr/sbin/usermod -L $loginname";

	    delHTPasswd ($loginname, "$system{'root'}/siteAdmin/.htpasswd");	
	    delHTPasswd ($loginname, "$system{'root'}/user/.htpasswd");

	}

	$result = `$command`;

	general::debug( "HTPasswd updated");

	# Update disk quotas
	general::debug( "About to update quotas");
	my $dev = Quota::getqcarg("/home");
	my $diskquotablocks = $diskquota * 1.15;
	general::debug( "Changed quota of $diskquota kilobytes into $diskquotablocks blocks.");
      Quota::setqlim($dev,$userinfo{'uid'},$diskquotablocks,$diskquotablocks,0,0,0);
	general::debug( "Quotas updated...$!");
	

    }

    # check the services and enable them on the user
    # SSH
    if (open(FILE,"</etc/sshusers")) {

	my @sshlines = <FILE>;

	close (FILE);

	open (FILE, ">/etc/sshusers");

	# Run through each line if the file and skip this user
	foreach my $sshline (@sshlines) {
	    
	    $sshline =~ s/\n//g;

	    if ($loginname eq $sshline) {
		next;
	    }

	    print FILE "$sshline\n";

	}

	# Add them if they're not supposed to have access
	if ($ssh ne "Yes") {
	    print FILE "$loginname\n";
	}

	close(FILE);
    }

    # FTP
    if (open(FILE, "</etc/ftpusers")) {
	my @ftplines = <FILE>;
	close(FILE);

	open(FILE, ">/etc/ftpusers");

	foreach my $ftpline (@ftplines) {

	    $ftpline =~ s/\n//g;
	    if ($loginname eq $ftpline) {
		next;
	}
	    print FILE "$ftpline\n";

	}
	# Add them if they're not supposed to 
	if ($ftp ne "Yes") {
	    print FILE "$loginname\n";
	}
	close(FILE);
    }
   

    # Telnet
    if (open(FILE, "</etc/telnetusers")) {

	my @telnetlines = <FILE>;
	close(FILE);
	
	open(FILE, ">/etc/telnetusers");

	foreach my $telnetline (@telnetlines) {

	    $telnetline =~ s/\n//g;

	    if ($loginname eq $telnetline) {
		next;
	    }

	    print FILE "$telnetline\n";

	}

	# Add them if they're not supposed to
	if ($telnet ne "Yes") {
	    print FILE "$loginname\n";
	}
	close(FILE);

    }

    # POP3
    if (open(FILE, "</etc/pop3users")) {
	my @pop3lines = <FILE>;
	close(FILE);

	open(FILE, ">/etc/pop3users");
    
	foreach my $pop3line (@pop3lines) {
	    $pop3line =~ s/\n//g;
	    if ($loginname eq $pop3line) {
		next;
	    }
	    print FILE "$pop3line\n";
	}
	# Add them if they're not supposed to
	if ($pop3 ne "Yes") {
	    print FILE "$loginname\n";
	}
	close(FILE);
    }  

    # IMAP

    if (open(FILE, "</etc/imapusers")) {
	my @imaplines = <FILE>;
	close(FILE);

	open(FILE, ">/etc/imapusers");
    
	foreach my $imapline (@imaplines) {
	    $imapline =~ s/\n//g;
	    if ($loginname eq $imapline) {
		next;
	    }
	    print FILE "$imapline\n";
	}
	# Add them if they're not supposed to
	if ($imap ne "Yes") {
	    print FILE "$loginname\n";
	}
	close(FILE);
    }

    # Reset permissions on password files
    my $command = "$system{'root'}/system/bin/chgrp cpqcfg /etc/passwd* /etc/shadow*";
    my $result = `$command`;

    general::debug( "Results from passwd fix = $result");

    sendmail::updateSendmailGenericsTable();
    
}

# A sub-routine to add a user to the system
sub addUser {

    my $loginname = shift || return(0);
    my $passwd = shift || return(0);

    my $userID = "";
    my $ssh = "";
    my $ftp = "";
    my $telnet = "";
    my $pop3 = "";
    my $imap = "";
    my $diskquota = "";

    my %system = config::system();

    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");
    
    my $users = $doc->getElementsByTagName("User");
    my $numOfUsers = $users->getLength;
    my $result = "";
    for (my $u=0; $u<$numOfUsers;$u++) {

	my $checkname = eval {$users->item($u)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData();} || "";

	if ($checkname eq $loginname) {
	    my $status = eval {$users->item($u)->getElementsByTagName("Status")->item(0)->getFirstChild->getData();} || "";

	    $result = $status;
	}
    }

    # Check to see if we've found the interface
    if ($result eq "") {
	print "This user is not valid ($loginname)!";
	return();
    }
    else {

	# Add the User
	my $command = "/usr/sbin/adduser $loginname -p $passwd";
	my $result = `$command`;

	# Reset permissions on password files
	$command = "$system{'root'}/system/bin/chgrp cpqcfg /etc/passwd* /etc/shadow*";
	$result = `$command`;

	general::debug( "Results from password permission change = $result");

	# Do post configuration updates to the XML
	$userID = `/usr/bin/id -u $loginname`;
	$userID =~ s/\n//g;
	my $groupID = `/usr/bin/id -g $loginname`;
	$groupID =~ s/\n//g;

	# Build public_html directory and make apache able to see it
	$command = "/bin/mkdir /home/$loginname/public_html";
	$result = `$command`;
	$command = "/bin/chmod +x /home/$loginname";
	$result = `$command`;

	# Build temporary place holder for public_html
	if (open(INDEXFILE, ">/home/$loginname/public_html/index.html")) {

	    print INDEXFILE "<HTML>
<HEAD>
  <TITLE>Future site for \"$loginname\"</TITLE>
</HEAD>

<BODY bgcolor=white>
  <CENTER><H2>Future site for \"$loginname\"</H2></CENTER>
</BODY>

</HTML>
";

	    close(INDEXFILE);

	}

	# Fix-up permissions
	$command = "/bin/chown $loginname:$loginname /home/$loginname";
	$result = `$command`;
	$command = "/bin/chown -R $loginname:$loginname /home/$loginname";
	$result = `$command`;

	# Update the XML

	my $userNode = "";

	# Search through the users
	for (my $i=0; $i<$numOfUsers; $i++) {

	    my $thisUser = eval { $users->item($i)->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData(); } || "";

	    # Did we find the right node?
	    if ($thisUser eq $loginname) {
		$userNode = $users->item($i);
	    }

	}
	
	if ($userNode eq "") {
	    print "<H1><FONT color=red>Unknown user: $loginname</FONT></H1>";
	}
	else {

	    # Populate variables
	    $ssh = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("SSH")->item(0)->getFirstChild->getData(); } || "";
	    $ftp = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("FTP")->item(0)->getFirstChild->getData(); } || "";
	    $telnet = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("Telnet")->item(0)->getFirstChild->getData(); } || "";
	    $pop3 = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("POP3")->item(0)->getFirstChild->getData(); } || "";
	    $imap = eval { $userNode->getElementsByTagName("Services")->item(0)->getElementsByTagName("IMAP")->item(0)->getFirstChild->getData(); } || "";
	    $diskquota = eval { $userNode->getElementsByTagName("DiskQuota")->item(0)->getFirstChild->getData(); } || "";

 	    datastore::attributeNodeUpdate($userNode->getAttributeNode("uid"), $userID);
 	    datastore::attributeNodeUpdate($userNode->getAttributeNode("gid"), $groupID);
	    
	    # Write out the file
	    $doc->printToFile("$system{'datastore'}/users.xml");
	    
	}


	# Update the disk quota for this user
	my $dev = Quota::getqcarg("/home");
	my $diskquotablocks = $diskquota * 1.15;
	general::debug( "Add user quota of $diskquotablocks");
      Quota::setqlim($dev,$userID,$diskquotablocks,$diskquotablocks,0,0,0);

	$doc->dispose();

	# Update the group.xml file
	my $parser = new XML::DOM::Parser;
	my $doc = $parser->parsefile("$system{'datastore'}/groups.xml");

      datastore::addGroup($doc, $groupID, $loginname, $loginname, "", $userID);

	$doc->printToFile("$system{'datastore'}/groups.xml");

	$doc->dispose();

	# check the services and enable them on the user
	# SSH
	if (open(FILE,"</etc/sshusers")) {

	    my @sshlines = <FILE>;

	    close (FILE);

	    open (FILE, ">/etc/sshusers");

	    # Run through each line if the file and skip this user
	    foreach my $sshline (@sshlines) {
		
		$sshline =~ s/\n//g;

		if ($loginname eq $sshline) {
		    next;
		}

		print FILE "$sshline\n";

	    }

	    # Add them if they're not supposed to have access
	    if ($ssh eq "No") {
		print FILE "$loginname\n";
	    }

	    close(FILE);
	}

	# FTP
	if (open(FILE, "</etc/ftpusers")) {
	    my @ftplines = <FILE>;
	    close(FILE);

	    open(FILE, ">/etc/ftpusers");

	    foreach my $ftpline (@ftplines) {

		$ftpline =~ s/\n//g;
		if ($loginname eq $ftpline) {
		    next;
		}
		print FILE "$ftpline\n";

	    }
	    # Add them if they'r not supposed to 
	    if ($ftp eq "No") {
		print FILE "$loginname\n";
	    }
	    close(FILE);
	}
	

	# Telnet
	if (open(FILE, "</etc/telnetusers")) {

	    my @telnetlines = <FILE>;
	    close(FILE);
	    
	    open(FILE, ">/etc/telnetusers");

	    foreach my $telnetline (@telnetlines) {

		$telnetline =~ s/\n//g;

		if ($loginname eq $telnetline) {
		    next;
		}

		print FILE "$telnetline\n";

	    }

	    # Add them if they're not supposed to
	    if ($telnet eq "No") {
		print FILE "$loginname\n";
	    }
	    close(FILE);

	}

	# POP3
	if (open(FILE, "</etc/pop3users")) {

	    my @pop3lines = <FILE>;
	    close(FILE);

	    open(FILE, ">/etc/pop3users");
	    
	    foreach my $pop3line (@pop3lines) {
		$pop3line =~ s/\n//g;
		if ($loginname eq $pop3line) {
		    next;
		}
		print FILE "$pop3line\n";
	    }
	    # Add them if they're not supposed to
	    if ($pop3 eq "No") {
		general::debug( "  POP3 user being denied access $loginname");
		print FILE "$loginname\n";
	    }
	    close(FILE);
	}  
	# IMAP
	if (open(FILE, "</etc/imapusers")) {

	    my @imaplines = <FILE>;
	    close(FILE);

	    open(FILE, ">/etc/imapusers");
	    
	    foreach my $imapline (@imaplines) {
		$imapline =~ s/\n//g;
		if ($loginname eq $imapline) {
		    next;
		}
		print FILE "$imapline\n";
	    }
	    # Add them if they're not supposed to
	    if ($imap eq "No") {
		general::debug( "  IMAP user being denied access $loginname");
		print FILE "$loginname\n";
	    }
	    close(FILE);
	}

    }

    return($userID);

}

# A subroutine for check quota
sub checkQuota {

    my $uid = shift || return();
    my $isgrp = shift || "0";

    my $dev = Quota::getqcarg("/home");

    my ($bc, $bs, $bh, $bt, $ic, $is, $ih, $it) = ();

    if ($isgrp == 0) {
	($bc, $bs, $bh, $bt, $ic, $is, $ih, $it) = Quota::query($dev, $uid);
    }
    else {
	($bc, $bs, $bh, $bt, $ic, $is, $ih, $it) = Quota::query($dev, $uid, 1);
    }

    print "$bc $bs $bh $bt $ic $is $ih $it";
}

# A sub-routine to restore all user quotas to the system
sub restoreQuotas {

    my %system = config::system();

    # Read the datastore for quotas
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    my $users = $doc->getElementsByTagName("User");
    my $numOfUsers = $users->getLength;

  general::debug("Restoring user disk quotas!");

    for (my $i=0;$i<$numOfUsers;$i++) {
	
	# Get user ID and Quota for the user

	my $userID = eval {$users->item($i)->getAttribute("uid")} || "";
	my $quota = eval {$users->item($i)->getElementsByTagName("DiskQuota")->item(0)->getFirstChild->getData();} || "0";

	# Update the disk quota for this user

	my $dev = Quota::getqcarg("/home");
	my $diskquotablocks = $quota * 1.15;

      Quota::setqlim($dev,$userID,$diskquotablocks,$diskquotablocks,0,0,0);

    }

    $doc->dispose;

    return();

}

# A sub-routine that adds a user to the OS group
sub addUserToOSGroup {

    my $user = shift || return(0);
    my $group = shift || return(0);

#    general::debug( "<<<<<<<<<<<<<< Called addusertoosgroup \"$user\" \"$group\">>>>>>>>>>>>>>>>>");

    my $command = "/usr/bin/groups $user";
#    general::debug( "Checking users = $command");
    my $result = `$command`;

    my @pieces = split(/:/,$result);
    my @groups = split(/ /,$pieces[1]);
    push(@groups, $group);

    my $newgrouplist = "";

    foreach my $grp (@groups) {
	$grp =~ s/\n//;
	if ($grp ne "") {
	    if ($newgrouplist eq "") {
		$newgrouplist = "$grp";
	    }
	    else {
		$newgrouplist = $newgrouplist . ",$grp";
	    }
	}
    }

    # Step 2: Add them to every group and this one
    $command = "/usr/sbin/usermod -G $newgrouplist $user";
#    general::debug( " - ($group) Command = $command");
    $result = `$command`;
#    general::debug( "Result of addUserToOSGroup = $result");

}

# A sub-rotine that removes a user from the OS group
sub delUserFromOSGroup {

    my $user = shift || return(0);
    my $group = shift || return(0);

#    general::debug( "                   <<<<<<<<<<<<<< Called DELuserfromosgroup \"$user\" \"$group\">>>>>>>>>>>>>>>>>");

    my $command = "/usr/bin/groups $user";
    my $result = `$command`;

    $result =~ s/\n//g;
    my @pieces = split(/:/,$result);
    my @groups = split(/ /,$pieces[1]);

    # Remove the group
    my $newgrouplist = "";
    foreach my $thisGroup (@groups) {
#	general::debug( " &&& thisGroup = \"$thisGroup\" and group = \"$group\"");
	if ($thisGroup ne $group && $thisGroup ne "") {
	    $newgrouplist = $newgrouplist . "$thisGroup,";
	}
    }

    $newgrouplist = $newgrouplist . "$user";
    $newgrouplist =~ s/\n//g;

    # Step 2: Add them to every group and this one
    if ($newgrouplist ne "") {
	$command = "/usr/sbin/usermod -G $newgrouplist $user";
#    general::debug( " - ($group) Command = $command");
	$result = `$command`;
    }
#    general::debug( "Result of delUserToOSGroup = $result");

}

1;
