package upgrade;
#
#  Package:      upgrade.pm
#
#  Copyright:     COPYRIGHT Compaq Computer Corporation 2001.  All rights reserved.
#
#  Description:  The OS specific routines for changing the system.
#
#    These routines handle UPGRADE specific changes including:
#
#     - Applying an upgrade
#     - Version checking
#
#  History:
#
use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Quota;
use Time::localtime;

use config;
use general;
use datastore;
use message;
use error;


# A sub-routine to upgrade the system
sub upgradeSystem {

    my $force = shift || "";

    my %system = config::system();

    # Step 1: Backup the datastore and webalizer data
    my $result = `/bin/mkdir $system{'datastore'}/backup`;
    general::debug( "$result");
    $result = `/bin/cp $system{'datastore'}/* $system{'datastore'}/backup`;
    general::debug( "$result");
    $result = `/bin/mkdir /var/cpqcfg/html/webalizer/backup`;
    general::debug( "$result");
    $result = `/bin/cp /var/cpqcfg/html/webalizer/* /var/cpqcfg/html/webalizer/backup`;
    general::debug( "$result");

    # Step 2: Apply the upgrade
    my $errorcode = "";
    if ($force eq "Yes") {
	$errorcode = system("/bin/rpm --replacefiles --force -U $system{'root'}/util/upgrade.rpm");
    }
    else {
	$errorcode = system("/bin/rpm -U $system{'root'}/util/upgrade.rpm");
    }

    print "Errorcode = $errorcode\n";

    # Step 3: Restore the datastore
    $result = `/bin/cp $system{'datastore'}/backup/* $system{'datastore'}/`;
    general::debug( "$result");

    # Cycle apache
    my $command = "$system{'root'}/system/custom/custom update_apache";
    $result = `$command`;

    return(1);

}


1;
