#!/usr/bin/perl
#
#  Program: history.cpq
#
#  Copyright: COPYRIGHT 2001 Compaq Computer Corporation. All rights reserved
#
#  Description: A program to keep track of project history.
#
#  History:  Changing history
#

use strict;
use lib qw (
        /var/cpqcfg/cgi-bin/CompaqConfigurator/system
);

use CGI;
use XML::DOM;

use config;
use general;

my %system = config::system;

general::header("history.pl");

print "
<BODY>
<TABLE class='sysAdminprog' width=100%  border=2 cellpadding=0 cellspacing=0 align=center>
<CAPTION align=center><B>History<BR>Compaq TaskSmart W2200 Version $system{'version'}-$system{'release'} Build ";

# Print current build number
if (open(BUILDFILE, "/usr/compaq/build")) {
    my @input = <BUILDFILE>;
    print "@input\n";
    close BUILDFILE;
}

print "
   
   <TR>
     <TH class='sysAdminprog' align=left>Version</TH>
     <TH class='sysAdminprog' align=left>Date</TH>
     <TH class='sysAdminprog' align=left>Changes</TH>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-21</TD>
     <TD class='sysAdminprogform' align=left>05/29/2001</TD>
     <TD class='sysAdminprogform' aling=left>
        <UL>
           <LI>Fixed NFS deleting entries problem
        </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-20</TD>
     <TD class='sysAdminprog' align=left>05/24/2001</TD>
     <TD class='sysAdminprog' align=left>
	<UL>
	   <LI>Fixed group maintenace bugs
        </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-19</TD>
     <TD class='sysAdminprogform' align=left>05/22/2001</TD>
     <TD class='sysAdminprogform' align=left>
	<UL>
	   <LI>Fixed NIC cycle after restore
	   <LI>Forced cpqcfg log rotation during install/upgrade
	   <LI>Fixed SNMP setup in rapid startup
	   <LI>Made upgrade code work on combination of error leve and error log file
	   <LI>Made default gateway warning if not on same network
	   <LI>Fixed cpqcfg log rotation issue to correctly restart after logrotation
	   <LI>Fixed proftp NIC disable issue
	   <LI>Fixed FP enable/disable on module level work
	   <LI>Added name resolution disable for route add/delete (prevents long delays)
	   <LI>Updated revision numbering scheme
	   <LI>Added code to restart Compaq Management Agents on host name change
	   <LI>Added link to version history on system upgrade page
        </UL>
     </TD>
   </TR>

   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-18</TD>
     <TD class='sysAdminprog' align=left>05/08/2001</TD>
     <TD class='sysAdminprog' align=left>
	<UL>
	  <LI>Made upgrade code work on combination of error level and error log file
	  <LI>Made default gateway warning if not on same network
	  <LI>Fixed cpqcfg log rotation issue to correctly restart after logrotation
	  <LI>Fixed proftp NIC disable issue
          <LI>Fixed FP enable/disable on module level work
          <LI>Added name resolution disable for route add/delete (prevents long delays)
          <LI>Updated revision numbering scheme and system uptime
          <LI>Added code to restart Compaq Management Agents on host name change
          <LI>Added link to version history on system upgrade page
        </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-17</TD>
     <TD class='sysAdminprogform' align=left>04/20/2001</TD>
     <TD class='sysAdminprogform' align=left>
	<UL>
          <LI>Fixed code that switches between upgrade and new install
          <LI>Fixed bug in edit virtual site that caused site admins to be removed
          <LI>Added country code to user data
          <LI>Made numerous textual changes to messages
          <LI>Fixed HTML bug that prevented the display of errors during upgrade download process
          <LI>Made NFS connections reconnect after a system restore and removed directories after NFS deletion
        </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-16</TD>
     <TD class='sysAdminprog' align=left>04/12/2001</TD>
     <TD class='sysAdminprog' align=left>
	<UL>
          <LI>Fixed memory-leak on webalizer report script
          <LI>Changed virtual site directories to include group suid bit
          <LI>Fixed error that prevented users with similar login names from being added (i.e. \"Billy\" and \"bill\")
          <LI>Included check to make sure SSH key regen value is equal to or above 3600
          <LI>Included maximum limits on advanced Apache fields
          <LI>Fixed log rotation config. file errors
          <LI>Fixed rapid startup to populate with current name server
	  <LI>Modified current user list to show FTP users as well
	  <LI>Fixed e-mail alias code
	  <LI>Fixed sendmail.cf permissions errors that prevented masquerade change
	  <LI>Cleaned-up CPQCFG log rotation configuration
	  <LI>Enhanced virtual site permissions to be more restrictive on viewing
	  <LI>Modified backup routine to include interface configuration files
	  <LI>Modified the welcome screen to immediately go to rapid startup if host name is blank
	  <LI>Included IP chains command for IMAP server
	  <LI>Fixed host name lock-out after system restore
	  <LI>Fixed POP3 user-level security issue
	  <LI>Enhanced system upgrade to allow user to force upgrade
	  <LI>Enhanced NTP setup to capture more errors
	  <LI>Added code to select a default send e-mail address
	  <LI>Fixed SMTP IP Chains issue
	  <LI>Added code to blank IP address on disabled interface
	  <LI>Modified setup scripts to perform upgrade as well as install
	  <LI>Re-configured setup scripts to use empty datastore only
	  <LI>Removed BOOTP options
          <LI>Added public_html to users home directory
          <LI>Added symbolic links in users home directory to their virtual sites
	  <LI>Fixed proftpd anonymous login to be NIC specific
	  <LI>Fixed restore issues (IPchains, vhosts.conf, etc.)
          <LI>Fixed performance profiles/rapid startup Apache restart issue
          <LI>Fixed /etc/hosts issue to populate with current IP addresses
          <LI>Made initialize.cpq also populate the default gateway
	</UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-15</TD>
     <TD class='sysAdminprogform' align=left>03/15/01</TD>
     <TD class='sysAdminprogform' align=left>
	<UL>
          <LI>Fixed site admin. add/edit user service permissions
	  <LI>Fixed system-wide Front Page setting
	  <LI>Added compressed and daily as defaults to log configuration
	  <LI>Removed itemized restore
	  <LI>Re-introduced vhosts.conf creation in RPM setup
	  <LI>Fixed primary site administrator login failure
	  <LI>Fixed fax phone number edit problem with users
	  <LI>Setup temporary restore location on /home/tmp
	  <LI>Fixed root web Front Page issue
	  <LI>Fixed mod_info, mod_perl, mod_status, mod_speling issues
	  <LI>Fixed quota bytes/blocks conversion issues
	</UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-14</TD>
     <TD class='sysAdminprog' align=left>03/13/01</TD>
     <TD class='sysAdminprog' align=left>
	<UL>
           <LI>Fixed site admin tool bug that slowed system
	   <LI>Improved Apache shutdown/restart/startup code
	   <LI>Improved speed when adding/deleting/updating virtual sites
	   <LI>Switched to ntpdate instead of rdate
	   <LI>Re-wrote virtual site update code
	   <LI>Stabilized group add/remove code
	   <LI>Fixed security hole in delete virtual site user
	   <LI>Made site admin tools check for user presence on other virtual sites
	   <LI>Included domain names in mail masquerading
	</UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-13</TD>
     <TD class='sysAdminprogform' align=left>03/08/01</TD>
     <TD class='sysAdminprogform' align=left>
       <UL>
          <LI>Fixed name server duplication bug in TCU configuration reader
          <LI>Re-introduced the system upgrade menu into the navigation
          <LI>Fixed several bugs related to virtual sites
          <LI>Fixed bug that prevented site admin. and user logins
          <LI>Added return to main menu links
          <LI>Added valid check for same destination and gateway, to routing setup
          <LI>Added \"configuration file\" alert
          <LI>Multiple message/help changes
          <LI>Improved edit group/virtual site interaction
          <LI>Included virtual sites in normal log rotation
          <LI>Fixed logout screens
          <LI>Made enable/disable buttons for floppy drive
          <LI>Added STDERR filter on ping/traceroute to trap !H 2999ms errors
          <LI>Fixed web server restart issue after changing web server name
          <LI>Implemented many minor GUI changes
          <LI>Fixed performance profiles (time out on switching between optimized/standard dameons)
          <LI>Changed \"Bytes\" to \"Kilobytes\"
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-12</TD>
     <TD class='sysAdminprog' align=left>03/04/01</TD>
     <TD class='sysAdminprog' align=left>
       <UL>
          <LI>Fixed bug with anonymous FTP control
          <LI>Implemented sendmail configuration for virtual web sites
          <LI>Fixed bug that prevented manual SSL key update
          <LI>Fixed routing bug that dropped default route ocassionally
          <LI>Updated displays to show ALL e-mails associated with a login account
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-11</TD>
     <TD class='sysAdminprogform' align=left>02/28/01</TD>
     <TD class='sysAdminprogform' align=left>
       <UL>
          <LI>Multiple cosmetic changes - uptime display, index page, cleaned out phase II menu options
          <LI>Fully implemented performance profiles
          <LI>Fixed several bugs with floppy configuration (TCU) reader
          <LI>Enhanced IP and netmask validation
          <LI>Added root web user and domain name server steps to rapid startup
          <LI>Fixed blank SNMP community strings error (prevented IM from starting)
          <LI>Implemented intermediate backup screen with cancel button
          <LI>Re-sorted navigation menu
          <LI>Multiple RQM fixes
          <LI>Fixed initialize.cpq bug that prevented eth1 from showing as enabled
          <LI>Fixed rapid startup bug that did not set default gateway
          <LI>Moved scattered static messages into \"messages.xml\"
          <LI>Improved PAM setup for telnet, ssh, ftp, pop3, etc.
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-10</TD>
     <TD class='sysAdminprog' align=left>02/21/01</TD>
     <TD class='sysAdminprog' align=left>
       <UL>
          <LI>Made splash screen an included file (/usr/compaq/html/splash.html)
          <LI>Update siteAdmin and user password to use PAM instead of static .htpasswd
          <LI>Fixed multiple bugs with rapid startup (netmask, wrong step, etc.)
          <LI>Completed valid IP, netmask, and domain name checks
          <LI>Fixed SSL setup bug
          <LI>Added program to read configuration from OCU floppy
          <LI>Patched security hole on site admin user display/add/edit
          <LI>Standardized alert e-mail format
          <LI>Finalized performance profiles and their details (not fully implemented yet)
          <LI>Improved setup script (wipes out logs, cycles apache, etc.)
          <LI>Re-instated code for virtual site system resource limits (CPU, Memory, etc.)
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-9</TD>
     <TD class='sysAdminprogform' align=left>02/15/01</TD>
     <TD class='sysAdminprogform' align=left>
       <UL>
          <LI>Implemented the majority of alerts cron program
          <LI>Added menu keywords to all screens
          <LI>Added return buttons for system admin, site admin, and users
          <LI>Added system up time and system current time to all splash screens
          <LI>Fixed bugs in listGroups.cpq
          <LI>Built data validation subroutines for advanced Apache setup
          <LI>Finished validation checks of groups
          <LI>Fixed SNMP configuration in rapidStartup.cpq
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-8</TD>
     <TD class='sysAdminprog' align=left>02/12/01</TD>
     <TD class='sysAdminprog' align=left>
       <UL>
          <LI>Simplified and fixed apache module load issues
          <LI>Fixed typo in webalizer install script
          <LI>Fixed Front Page issue (Order of install with builds)
          <LI>Added Cancel/Done/Back buttons to GUI
          <LI>Fixed user/group add to dis-allow addition of users not in the datastore, but on the OS
          <LI>Included Front Page password files in password change utility
          <LI>Backup and Restore routines functional  (Fixed issue with streamed I/O)
          <LI>Fixed time zone bug (Code was temporarily disabled)
          <LI>Added SNMP setup to rapid startup
          <LI>Added creation/modfiy date/time stamps to users
          <LI>Added \"Last logged in\" to user display
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' align=left>Version 1.0-7</TD>
     <TD class='sysAdminprogform' align=left>02/06/01</TD>
     <TD class='sysAdminprogform' align=left>
      <UL>
        <LI>Added validation routines to admin/root password
        <LI>Completed DoS limits on virtual sites
        <LI>Introduced initial backup routine
        <LI>Strengthened host name and virtual site name validation
     </UL>
    </TD> 
   </TR>       
   <TR>
     <TD class='sysAdminprog' align=left>Version 1.0-6</TD>
     <TD class='sysAdminprog' align=left>02/05/01</TD>
     <TD class='sysAdminprog' align=left>
      <UL>
        <LI>Added the ability to manage SSH key regeneration
        <LI>Added trap community/server address to SNMP setup
        <LI>Added key regeneration and root login to SSHSetup.cpq
        <LI>Added maximum users to Add/Edit virtual sites
        <LI>Prevented siteAdmin from deleting self
        <LI>Limited primary site administrators to administer one site only
        <LI>Introduced DoS parameters - CPU, Memory, and Process limits
        <LI>Fixed Webalizer crontab entries and missing log file issue
        <LI>Added Apache SSL key management
     </UL>
    </TD> 
   </TR>       
   <TR> 
    <TD class='sysAdminprogform' valign=top>Version 1.0-5</TD>   
    <TD class='sysAdminprogform' valign=top>01/31/01</TD>
    <TD class='sysAdminprogform' valign=top>
     <UL>
       <LI>Included setup code to empty datastore after install
       <LI>Fixed addUser.cpq bug that prevented site/user login
       <LI>Included Front Page custom pieces
       <LI>Included maximum user limit on virtual sites
       <LI>Fixed addUser.cpq for site admin, to include maximum user limit
       <LI>Enhanced delUser.cpq to forcefully revoke access upon deletion
       <LI>Fixed name resolution code to include localhost.localdomain in /etc/hosts rebuild
     </UL>
    </TD>
   </TR> 
   <TR>
     <TD class='sysAdminprog' valign=top>Version 1.0-4</TD>
     <TD class='sysAdminprog' valign=top>01/30/01</TD>
     <TD class='sysAdminprog' valign=top>
       <UL>
	 <LI>Fixed issue with root server and virtual servers clashing
         <LI>Fixed bug in change password programs
         <LI>Fixed ISE on site administrator
         <LI>Added initialization script to run on startup/install
         <LI>Changed system administrator login/password to work-around IE5.0 bug
         <LI>Added cursory versions of test plan document
         <LI>Fixed bug with webalizer scheduler that prevented webalizer from running routinely
         <LI>Fixed install script bug that prevented webalizer install
       </UL>
     </TD>
   </TR>


   <TR>
     <TD class='sysAdminprogform' valign=top>Version 1.0-3</TD>
     <TD class='sysAdminprogform' valign=top>01/29/01</TD>
     <TD class='sysAdminprogform' valign=top>
       <UL>
	 <LI>Added quality of service to virtual sites form and XML  (mod_throttle is missing for complete functionality)
	 <LI>Now using IP Chains for service/security control
	 <LI>Updated and debuged style sheets; removed extra borders from certain classes
	 <LI>Changed serviceSetup.cpq to enable/disable Compaq Configurator
	 <LI>Added basic SNMP setup
	 <LI>Fixed bugs dealing with writing to XML and cosmetics in editVirtualSite, addVirtualSite, and listVirtualSite
	 <LI>Added build numbers to splash screens, Current System Software, and History
	 <LI>Added warnings to interfaceSetup.cpq when user selects DHCP
	 <LI>Updated Messages, Errors, and Help notices to synch with Compaq changes
	 <LI>Added \"history.cpq\" to track changes between versions/builds
	 <LI>Built confirmation and completion screens for profiledSetup.cpq
       </UL>
     </TD>
   </TR>

   <TR>
     <TD class='sysAdminprog' valign=top>Version 1.0-2</TD>
     <TD class='sysAdminprog' valign=top>01/19/01</TD>
     <TD class='sysAdminprog' valign=top>
       <UL>
	 <LI>Added \"Use as Default\" to Users and Virtual Sites
	 <LI>Built system upgrade
	 <LI>Added syslogd server functionality to log configuration
	 <LI>Added NIC configuration to Rapid Startup
       </UL>
     </TD>
   </TR>
   <TR>
     <TD class='sysAdminprogform' valign=top>Version 1.0-1</TD>
     <TD class='sysAdminprogform' valign=top>01/16/01</TD>
     <TD class='sysAdminprogform' valign=top>
       <UL>
       <LI>Initial Release
       </UL>
     </TD>
   </TR>
</TABLE>
</BODY>

</HTML>
";


