package backup;
#
#  Package:      backup.pm
#
#  Copyright:     COPYRIGHT Compaq Computer Corporation 2001.  All rights reserved.
#
#  Description:  The OS specific routines for changing the system.
#
#    These routines handle BACKUP/RESTORE specific changes including:
#
#     - Backup creation
#     - Restoration
#     - Backup scheduling
#
#  History:
#
use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Quota;
use Time::localtime;

use config;
use general;
use datastore;
use message;
use error;


# A routine to handle system backups
sub systemBackup {

    my %system = config::system;

    my $type = shift || return();

    my %items = {};

    foreach my $parameter (@_) {
	$items{$parameter} = 1;
    }

    # Build a random file suffix
    srand();
    my $suffix = int(rand(5000));
    my $date = sprintf ("%d%d%d", localtime->year()+1900, localtime->mon(), localtime->mday());

    my $file = "Cpqcfgbackup_$suffix" . "_" . "$date.tgz";

    # Build file list by groups
    my $network = "/etc/ftpusers /etc/pop3users /etc/telnetusers /etc/sshusers /etc/cpqcfgusers /etc/sysconfig/network-scripts/ifcfg-eth0 /etc/sysconfig/network-scripts/ifcfg-eth1 /etc/sysconfig/network /etc/ssh/*";
    my $home = "/home/*";
    my $users = "/etc/passwd /etc/shadow /var/cpqcfg/cgi-bin/CompaqConfigurator/siteAdmin/.htpasswd /var/cpqcfg/cgi-bin/CompaqConfigurator/systemAdmin/.htpasswd /var/cpqcfg/cgi-bin/CompaqConfigurator/user/.htpasswd /home/quota.user";
    my $groups = "/etc/group /etc/gshadow /home/quota.group";
    my $primarysite = "/var/www/* /usr/local/frontpage/*.cnf /etc/httpd/conf/ssl.* /etc/httpd/conf/httpd.conf";
    my $virtualsites = "/home/VirtualSites/* /usr/local/frontpage/*.cnf /etc/httpd/conf/vhosts.conf /etc/httpd/conf/fphttpd.conf /etc/logrotate.d/*";
    my $sendmail = "/etc/mail/* /etc/aliases /var/spool/mail/* /var/spool/mqueue/*";
    my $majordomo = "/etc/majordomo.cf /var/lib/majordomo/*";
    my $datastore = "$system{'datastore'}/*.xml";
    my $reports = "$system{'root'}/system/reports/*";

    # We start with files that are ALWAYS included
    my $filelist = "$users $groups $datastore $reports $network";

    # Build the correct backup file
    if ($items{'syscfg'} == 1) {
	$filelist .= "";
    }
    if ($items{'primary'} == 1) {
	$filelist .= " $primarysite";
    }
    if ($items{'virtual'} == 1) {
	$filelist .= " $virtualsites";
    }
    if ($items{'user'} == 1) {
	$filelist .= " $home";
    }
    if ($items{'mail'} == 1) {
	$filelist .= " $sendmail";
    }

    my $command = "$system{'root'}/system/bin/tar -P --ignore-failed-read --preserve-order --preserve-permissions -c $filelist -O | /bin/gzip -c |";

    general::debug( "Command = $command");

    # Do the backup
    if (open(BACKUP, "$command")) {
	
	# Make the backup using controled data release
	while (!eof(BACKUP)) {
	    
	    my $buffer = "";
	    read (BACKUP, $buffer, $system{'backupbuffersize'});
	    print $buffer;
	    
	}
	
	close(BACKUP);
	
    }

}
1;
