#!/bin/bash
#
#  Program:      setup_email.sh
#
#  Description:  This program does post installation configuration to allow
#    the configurator to run properly.
#
#    This setup script installs the EMAIL package.
#
#  History:
#
#

echo "Starting Compaq Configurator setup script...EMAIL Module"

# Make sure that genericsdomain exists
if [ -a /etc/mail/genericsdomain ]; then
    echo "  - Sendmail genericsdomain file found...(This must be an upgrade)"
else
    echo "  - Making genericsdomain file"
    touch /etc/mail/genericsdomain
fi

# Setup the datastore components
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/email.xml ]; then
    echo "  - Datastore already installed...(This must be an upgrade)"    
else
    echo "  - Installing new datastore..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/email.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/*
fi

# Set SUID on custom components
echo "  - Setting SUID on select programs..."
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*

# END OF SCRIPT
echo "** Finished! **"
