package sendmail;
#
#  Package:      sendmail.pm
#
#  Copyright:     COPYRIGHT Compaq Computer Corporation 2001.  All rights reserved.
#
#  Description:  The OS specific routines for changing the system.
#
#    These routines handle SENDMAIL specific changes including:
#
#     - Sendmail masquerade domain
#     - Alias setup
#     - Smart Relay
#     - Anti-spam measures
#
#  History:
#
use strict;

use CGI;
use XML::DOM;
use XML::QL;
use Quota;
use Time::localtime;

use config;
use general;
use datastore;
use message;
use error;


# A sub-rotine to read the sendmail configuration, re-create
# the sendmail.cf configuration file, and cycle the server
sub updateSendmail {

    general::debug( "Updating sendmail");

    my %system = config::system();

    # Read the email configuration file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/email.xml");

    my $masq = eval { $doc->getElementsByTagName("Masquerade")->item(0)->getFirstChild->getData(); } || "";

    $doc->dispose();

    # Re-build the sendmail.cf file - #1 Read in configuration file
    open (FILE, "</etc/mail/sendmail.mc");
    my @lines = <FILE>;
    my $numOfLines = @lines;
    close(FILE);

    my $haveGenericsTable = 0;

    for (my $i=0; $i<$numOfLines; $i++) {

	if ($lines[$i] =~ m/^dnl/) {
	    next;
	}
	elsif ($lines[$i] =~ m/^\s*FEATURE\(\`masquerade_envelope'\)/) {
	    $lines[$i] = "";
	}
	# Update Masquerade
	elsif ($lines[$i] =~ m/\s*MASQUERADE_AS\(.*\)/) {
	    $lines[$i] = "";
	}
	elsif ($lines[$i] =~ m/\s*FEATURE\(\`genericstable\'/) {
	    $haveGenericsTable = 1;
	}

    }

    # Add generics table to the mc file
    if ($haveGenericsTable == 0) {
	# Add generics domain feature
	push (@lines, "FEATURE(`genericstable', `hash -o /etc/mail/genericstable')dnl\n");
	push (@lines, "GENERICS_DOMAIN_FILE(`/etc/mail/genericsdomain')dnl\n");	
    }

    # Add envelope masquerading
    push(@lines,"FEATURE(`masquerade_envelope')dnl\n");
    push(@lines,"MASQUERADE_AS($masq)dnl\n");

    # Write the configuration file back out
    open(FILE, ">/etc/mail/sendmail.mc");

    foreach my $line (@lines) {
	if ($line eq "") {
	    next;
	}
	else {
	    print FILE $line;
	}
    }

    close(FILE);

    # Check for current sendmail.cf file
    my $result = "";
    if (-f "/etc/sendmail.cf") {
	$result = `/bin/cp -f /etc/sendmail.cf /etc/sendmail.cf.backup`;
    }

    # Re-make the .cf file
    $result = `/bin/chown root:root /etc/sendmail.cf`;
    $result = `/bin/chmod 647 /etc/sendmail.cf`;
    my $newcf = `/usr/bin/m4 /etc/mail/sendmail.mc`;

    if(open(CFFILE,">/etc/sendmail.cf")) {
	print CFFILE "$newcf";
	close(CFFILE);
    }
    
    $result = `/bin/chmod 644 /etc/sendmail.cf`;

    # Re-build the local-host-names file
    # Read the email configuration file
    my $parser2 = new XML::DOM::Parser;
    my $doc2 = $parser2->parsefile("$system{'datastore'}/virtualsites.xml");

    general::debug( "   virtualsites file parsed and ready to go");

    # Add masquerade to the local-host-names file
    if (open(FILE, ">/etc/mail/local-host-names")) {

	general::debug( "   **** Updating local-host-names");

	print FILE "$masq\n";

	foreach my $node ($doc2->getElementsByTagName("ServerName")) {

	    my $sitename = $node->getFirstChild->getData();
#	    general::debug( "   Adding localhostname $sitename");
	    print FILE "$sitename\n";

            # Translate off just the domain name for user@domain.com
            my @sections = split('\.', $sitename);
            my $numOfSections = scalar(@sections);
#	    general::debug( "NumOfSections = $numOfSections\n$sections[1] $sections[0]");
	    if ($numOfSections >= 2) {
		print FILE "$sections[$numOfSections-2].$sections[$numOfSections-1]\n";
	    }

	}

	close(FILE);

    }

    $doc2->dispose();

    # Re-start sendmail
    stopSendmail();
    startSendmail();

    # Check to make sure sendmail is running
    my $sendmailcheck = `/bin/ps awux | /bin/grep \"sendmail: accepting connections\"`;

    if ($sendmailcheck eq "") {
	startSendmail();
    }

    return(1);

}

# A sub-routine to update the genericstable file
sub updateSendmailGenericsTable {

    my %system = config::system();

    # Re-build the genericstable file for virtual hosting
    # Read the email configuration file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/users.xml");

    # Add masquerade to the local-host-names file
    if (open(FILE, ">/etc/mail/genericstable")) {

	foreach my $node ($doc->getElementsByTagName("User")) {

	    my $loginname = eval { $node->getElementsByTagName("LoginName")->item(0)->getFirstChild->getData(); } || "";
	    my $email = eval { $node->getElementsByTagName("Email")->item(0)->getFirstChild->getData(); } || "";
	    $email =~ s/ //g;
	    $email =~ s/\n//g;

	    if ($email ne "") {
		print FILE "$loginname\t\t\t$email\n";
	    }

	}

	close(FILE);

    }

    $doc->dispose();

    # Rebuild hash map
    `/usr/bin/makemap hash $system{'root'}/system/reports/genericstable < /etc/mail/genericstable`;

    my @lines = ();
    if (open(NEWFILE, "$system{'root'}/system/reports/genericstable.db")) {
	@lines = <NEWFILE>;
	close(NEWFILE);
    }

    if (open(GENFILE, ">/etc/mail/genericstable.db")) {

	foreach my $line (@lines) {
	    print GENFILE "$line";
	}

	close(GENFILE);
    }

    return(1);

}

# A sub-routine to update the genericsdomain file
sub updateSendmailGenericsDomain {

    my %system = config::system();

    # Re-build the genericstable file for virtual hosting
    # Read the email configuration file
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/virtualsites.xml");

    # Add masquerade to the local-host-names file
    if (open(FILE, ">/etc/mail/genericsdomain")) {

	my $fqdn = `/bin/hostname -f`;

	print FILE "$fqdn";

	foreach my $node ($doc->getElementsByTagName("ServerName")) {

	    my $sitename = eval { $node->getFirstChild->getData(); } || "";

            # Translate off just the domain name for user@domain.com
            my @sections = split('\.', $sitename);
            my $numOfSections = scalar(@sections);
	    if ($numOfSections >= 2) {
		print FILE "$sections[$numOfSections-2].$sections[$numOfSections-1]\n";
	    }

	    if ($sitename ne "") {
		print FILE "$sitename\n";
	    }

	}

	close(FILE);

    }

    $doc->dispose();

    return(1);

}


# A sub-routine to rebuild the email aliases file
sub updateEmailAliases {

    my $configFile = "/etc/aliases";

    my %system = config::system();

    # Read in the current aliases file
    my @lines = ();
    if (open(FILE, "<$configFile")) {
	@lines = <FILE>;
	close(FILE);
    }

    # Read the aliases
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/email.xml");

    # Run through each alias and either add or update the corresponding line
    foreach my $alias ($doc->getElementsByTagName("Alias")) {

	my $name = $alias->getAttribute("name");

	# Calculate member string
	my $members = "";
	foreach my $member ($alias->getElementsByTagName("Member")) {
	    $members .= $member->getFirstChild->getData() . ", ";
	}
	
	# Get rid of the last comma
	$members = substr($members, 0, length($members)-2);

	my $numOfLines = @lines;

	# Run through each line of the file to find alias
	my $foundAlias = 0;
	for (my $i=0; $i<$numOfLines; $i++) {

	    if ($lines[$i] =~ m/#/) {
		next;
	    }
	    # If we found the alias, then update it
	    elsif ($lines[$i] =~ m/^$name:/) {

		$foundAlias = 1;
		$lines[$i] = "$name: $members\n";
	    }
	}

	# Check to see if we need to add this alias
	if ($foundAlias == 0) {
	    push (@lines, "$name: $members\n");
	}
    }

    # Write the file back out
    if (open(FILE, ">$configFile")) {

	foreach my $line (@lines) {
	    print FILE "$line";
	}

	close(FILE);

    }

    # Rebuild aliases
    my $command = "/usr/bin/makemap hash $system{'root'}/system/aliases.db < /etc/aliases";
    my $result = `$command`;

    my @lines = ();
    if (open(ALIASFILE,"<$system{'root'}/system/aliases.db")) {

	binmode(ALIASFILE);

	my $buffer = "";

	# Write out the new aliases file (Binary file)
	if (open(NEWALIAS,">/etc/aliases.db")) {

	    binmode(NEWALIAS);

	    my $bytesread = 0;
	    
	    while ($bytesread = read(ALIASFILE, $buffer, 1024)) {

#		general::debug( "  - Read $bytesread bytes from aliases.db");
		syswrite(NEWALIAS, $buffer, $bytesread);
	    }
	    
	    close(NEWALIAS);
	}

	close(ALIASFILE);
	    
    }


}

# A sub-routine to delete an alias from the email aliases file
sub delEmailAlias {

    my $aliasName = shift || return;

    general::debug( "About to delete an alias of $aliasName");

    my %system = config::system();

    # Read the aliases and update the XML
    my $parser = new XML::DOM::Parser;
    my $doc = $parser->parsefile("$system{'datastore'}/email.xml");

    # Run through each alias and either add or update the corresponding line
    foreach my $alias ($doc->getElementsByTagName("Alias")) {

	my $name = $alias->getAttribute("name");

	general::debug( "Found $name");

	# Remove this alias
	if ($name eq $aliasName) {
	    general::debug( "Removing child");
	    $doc->getFirstChild->removeChild($alias);
	}

    }
    
    $doc->printToFile("$system{'datastore'}/email.xml");

    # Delete the alias from the aliases file
    my $configFile = "/etc/aliases";

    # Read in the current aliases file
    my @lines = ();
    if (open(FILE, "<$configFile")) {
	@lines = <FILE>;
	close(FILE);
    }

    # Write the file back out
    if (open(FILE, ">$configFile")) {

	foreach my $line (@lines) {

	    # If this is not the alias we are getting rid of
	    if (!($line =~ m/^$aliasName:/)) {
		print FILE "$line";
	    }

	}

	close(FILE);

    }

    my $command = "/usr/bin/makemap hash $system{'root'}/system/aliases.db < /etc/aliases";
    my $result = `$command`;

    my @lines = ();
    if (open(ALIASFILE,"<$system{'root'}/system/aliases.db")) {

	binmode(ALIASFILE);

	my $buffer = "";

	# Write out the new aliases file (Binary file)
	if (open(NEWALIAS,">/etc/aliases.db")) {

	    binmode(NEWALIAS);

	    my $bytesread = 0;
	    
	    while ($bytesread = read(ALIASFILE, $buffer, 1024)) {

#		general::debug( "  - Read $bytesread bytes from aliases.db");
		syswrite(NEWALIAS, $buffer, $bytesread);
	    }
	    
	    close(NEWALIAS);
	}

	close(ALIASFILE);
	    
    }

}
# A sub-routine that starts the Sendmail daemon
sub stopSendmail {

    my %system = config::system();

    my $command = "$system{'root'}/system/bin/sendmail stop";
    my $result = `$command`;

    return(1);

}
# A sub-routine that starts the Sendmail daemon
sub startSendmail {

    my %system = config::system();

    my $command = "$system{'root'}/system/bin/sendmail start";
    my $result = `$command`;

    return(1);

}


1;
