#!/bin/bash
#
#  Program:      setup_alerts.sh
#
#  Description:  This program does post installation configuration to allow
#    the configurator to run properly.
#
#    This setup script installs the ALERTS package.
#
#  History:
#
#

echo "Starting Compaq Configurator setup script...ALERTS Module"

echo "  - Setting ownership/permissions on alerts"
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq

# Install the datastore
if [ -a /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/alerts.xml ]; then
    echo "  - Datastore already installed...(This must be an upgrade)"
    echo "    - Upgrading datastore (if necessary)"
    /var/cpqcfg/cgi-bin/CompaqConfigurator/system/checkDatastore.pl
else
    echo "  - Installing new datastore..."
    cp /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/empty/alerts.xml /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore
    chown cpqcfg:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/alerts.xml
    chmod 770 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/datastore/alerts.xml
fi

# Set SUID on custom components
echo "  - Setting SUID on select programs..."
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/custom/custom
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/bin/*
chown root:cpqcfg /var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq
chmod 4550 /var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq

# Schedule alerts to run
echo "  - Scheduling and initializing alerts..."

# Check to see if the alerts are already scheduled
EXISTS=`crontab -l -u cpqcfg | grep "/var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq"`

# Add it only if it isn't already scheduled
if [ "$EXISTS" == "" ]; then

   NEWCRONTAB=`crontab -l -u cpqcfg | grep -v -A 3 "#"`

    echo "$NEWCRONTAB

# Compaq Configurator - Alert Detection System
0-59/15 * * * * /var/cpqcfg/cgi-bin/CompaqConfigurator/system/alerts/alerts.cpq" | /usr/bin/crontab -u cpqcfg -
else
    echo "Alerts already scheduled"
fi

# END OF SCRIPT
echo "** Finished! **"
