package alerts;
#
#  Program:      alerts.pm
#
#  Copyright:    COPYRIGHT 2001 Compaq Computer Corporation. ALL rights reserved.
#
#  Description:  A package to support alerts.
#
#  History:
#
use strict;
use lib qw (
	    /var/cpqcfg/cgi-bin/CompaqConfigurator/system
	    );

use XML::DOM;
use XML::QL;
use Net::IPv4Addr qw( :all);
use Net::SMTP;
use Date::Manip;

use config;
use error;
use message;
use general;
use datastore;
use help;

# A sub-routine to check for critical disk space
sub criticalDiskspace {

    my $alert = shift || return();

    my %system = config::system();
	
    my $status = eval { $alert->getElementsByTagName("Status")->item(0)->getFirstChild->getData(); } || "Inactive";
    my $threshold = eval { $alert->getElementsByTagName("Threshold")->item(0)->getFirstChild->getData(); } || "";
    
    # Split out the individual settings
    my @partitions = split("~", $threshold);

    my $email = eval { $alert->getElementsByTagName("Email")->item(0)->getFirstChild->getData(); } || "";
	
    #Step 1b:  Check diskspace left on home
    #Step 1c:  If diskspace left is >= threshold, send email 
    if ($status eq "Active") {

	my $ipstring = general::IPString();
	my $fqdn = general::FQDN();
	
	# Check each partition
	foreach my $partition (@partitions) {

	    my ($dir,$limit) = split(",", $partition);
	    $limit =~ s/\%//g;
	    
	    my $diskspace = "/bin/df $dir";
	    my $result = `$diskspace`;
	    my @array = split('\n', $result);   
	    my @values = split(' ', $array[1]);
	    my $finalresult = $values[4];
	    my $date = `/bin/date`;
	    
	    if ($finalresult >= $limit) {
		
		my $message = message::throwMessage("DISKSPACE_INFO","ANY",$email,$fqdn,$date,$dir,"$limit\%",$ipstring,$finalresult);
		
		my $smtp = Net::SMTP->new('localhost');
		$smtp->mail("$system{'alert_sender'}\@$fqdn");
		$smtp->to("$email");
		
		$smtp->data();
		$smtp->datasend("$message");
		$smtp->dataend();
		
		$smtp->quit;
		
	    }  
	}
    }  
    
    return();

}

# A sub-routine to check for root login
sub rootLogin {

    my $alert = shift || return();
    
    my %system = config::system();
    
    my $status = eval { $alert->getElementsByTagName("Status")->item(0)->getFirstChild->getData(); } || "Inactive"; 
    my $email = eval { $alert->getElementsByTagName("Email")->item(0)->getFirstChild->getData(); } || "";  

    # If root login happens, send email 
    if ($status eq "Active") {

	my $console = "/usr/bin/last root";
	my $result = `$console`;
	my @newline =split('\n', $result);
	my $date = `/bin/date`;
	
	my $ipstring = general::IPString();
	my $fqdn = general::FQDN();
	
	foreach my $line (@newline) {
	    
	    if ($line =~ m/still logged in/) {
		
		my $message = message::throwMessage("ROOTCONSOLE_INFO","ANY",$email,$fqdn,$date,$line,$ipstring);
		my $smtp = Net::SMTP->new('localhost');
		
		$smtp->mail("$system{'alert_sender'}\@$fqdn");
		$smtp->to("$email");
		
		$smtp->data();
		$smtp->datasend("$message");
		$smtp->dataend();
		
		$smtp->quit;
		
	    }
	}
	
	my @lines = ();
	
	# Open and read log file
	if (open(FILE, "/var/log/messages")) {
	    
	    my @loglines = <FILE>;
	    
	    foreach my $line (@loglines) {
		
		if ($line =~ m/session opened for user root by/) {
		    push (@lines, $line);
		}	
	    }	
	    
	    close(FILE);
	}
	
	foreach my $line (@lines) { 	
	    
	    my @values = split(' ', $line);
	    
	    my $eventDate = shift(@values);
	    $eventDate = $eventDate . ' ' . shift(@values);
	    $eventDate = $eventDate . ' ' . shift(@values);
	    
	    my $logdetail = join(' ', @values);
	    
	    my $date1=&DateCalc('today', '- 15minutes');
	    my $date2=&ParseDate($eventDate);
	    
	    my $flag = &Date_Cmp($date1, $date2);
	    
	    if ($flag <= 0) {
		
		my $message = message::throwMessage("ROOTLOGIN_INFO","ANY",$email,$fqdn,$eventDate,$logdetail,$ipstring);
		
		my $smtp = Net::SMTP->new('localhost');
		$smtp->mail("$system{'alert_sender'}\@$fqdn");
		$smtp->to("$email");
		
		$smtp->data();
		$smtp->datasend("$message");
		$smtp->dataend();
		
		$smtp->quit;
		
		
	    }
	}
    }      
}

# A sub-routine to check for a system reboot
sub systemReboot {

    my $alert = shift || return();

    my %system = config::system();
	
    my $status = eval { $alert->getElementsByTagName("Status")->item(0)->getFirstChild->getData(); } || "Inactive";
    my $email = eval { $alert->getElementsByTagName("Email")->item(0)->getFirstChild->getData(); } || "";  
	
    # If system reboot happens, send email 
    if ($status eq "Active") {
	
	my $date = `/bin/date`;	
	my $result = `/bin/cat /proc/uptime`;
	my ($uptime) = split(" ", $result);
	my $minutes = int($uptime/60);

	my $ipstring = general::IPString();
	my $fqdn = general::FQDN();
	
	# If the uptime has been less than one hour, then send the alert
	if ($uptime < 3600) {
	    
	    my $message = message::throwMessage("SYSTEMREBOOT_INFO","ANY",$email,$fqdn,$date,$ipstring,$minutes);
	    
	    my $smtp = Net::SMTP->new('localhost');
	    $smtp->mail("$system{'alert_sender'}\@$fqdn");
	    $smtp->to("$email");
	    
	    $smtp->data();
	    $smtp->datasend("$message");
	    $smtp->dataend();
	    
	    $smtp->quit;                     
	}    	    
    }  
}

# A sub-routine to check for a core utility change (i.e. "mv", "ls", etc.)    
sub utilityChange {	

    my $alert = shift || return();

    my %system = config::system();
	
    my $status = eval { $alert->getElementsByTagName("Status")->item(0)->getFirstChild->getData(); } || "Inactive";
    my $email = eval { $alert->getElementsByTagName("Email")->item(0)->getFirstChild->getData(); } || "";  
	
    if ($status eq "Active") {
	
	my $ipstring = general::IPString();
	my $fqdn = general::FQDN();
	
	# Step 4c - Get Information about file ('/bin/ls -l $filename')	
	foreach my $file ($alert->getElementsByTagName("Files")->item(0)->getElementsByTagName("File",0)) {

	    # Populate local compare vairables
	    my $filename = eval { $file->getAttribute("name"); } || "";
	    my $owner = eval { $file->getElementsByTagName("Owner",0)->item(0)->getFirstChild->getData(); } || "";
	    my $group = eval { $file->getElementsByTagName("Group",0)->item(0)->getFirstChild->getData(); } || "";
	    my $permissions = eval { $file->getElementsByTagName("Permissions",0)->item(0)->getFirstChild->getData(); } || "";
	    my $size = eval { $file->getElementsByTagName("Size",0)->item(0)->getFirstChild->getData(); } || "";
	    my $datetime = eval { $file->getElementsByTagName("DateTime",0)->item(0)->getFirstChild->getData(); } || "";

	    my $result = `/bin/ls -l $filename`;

	    # Step 4d - Split out permissions, owner, group, size, date/time
	    # Split on spaces
	    my @spaces = split(' ', $result);
	    my $dtcompare = join(' ', ($spaces[5], $spaces[6], $spaces[7]));
	    
	    # Step 4e - Compare values and send alert
	    if ($permissions ne $spaces[0] || $owner ne $spaces[2] || 
		$group ne $spaces[3] || $size ne $spaces[4] || 
		$datetime ne $dtcompare) {
		
		my $date = `/bin/date`;
		
		my $message = message::throwMessage("SYSTEMUTILCHANGE_INFO","ANY",$email,$fqdn,$date,$filename,
						    $spaces[0], $spaces[2], $spaces[3], $spaces[4], $dtcompare, 
						    $permissions, $owner, $group, $size, $datetime, $ipstring);
		
		my $smtp = Net::SMTP->new('localhost');
		$smtp->mail("$system{'alert_sender'}\@$fqdn");
		$smtp->to("$email");
		
		$smtp->data();
		$smtp->datasend("$message");
		$smtp->dataend();
		
		$smtp->quit;
	    }
	} 	
    }
}


# A sub-routine to determine if permissions on config files have changed
sub configFileChange {

    my $alert = shift || return();

    my %system = config::system();

    my $status = eval { $alert->getElementsByTagName("Status")->item(0)->getFirstChild->getData(); } || "Inactive";
    my $email = eval { $alert->getElementsByTagName("Email")->item(0)->getFirstChild->getData(); } || "";  
    
    #Step 5a - determine if active 
    
    if ($status eq "Active") {

	my $ipstring = general::IPString();
	my $fqdn = general::FQDN();

	# Step 4c - Get Information about file ('/bin/ls -l $filename')	
	foreach my $file ($alert->getElementsByTagName("Files")->item(0)->getElementsByTagName("File",0)) {

	    # Populate local compare vairables
	    my $filename = eval { $file->getAttribute("name"); } || "";
	    my $owner = eval { $file->getElementsByTagName("Owner",0)->item(0)->getFirstChild->getData(); } || "";
	    my $group = eval { $file->getElementsByTagName("Group",0)->item(0)->getFirstChild->getData(); } || "";
	    my $permissions = eval { $file->getElementsByTagName("Permissions",0)->item(0)->getFirstChild->getData(); } || "";

	    my $result = `/bin/ls -l $filename`;
	    
	    # Step 4d - Split out permissions, owner and group
	    # Split on spaces
	    my @spaces = split(' ', $result);
	    
	    # Step 4e - Compare values and send alert
	    if ($permissions ne $spaces[0] || $owner ne $spaces[2] || $group ne $spaces[3]) {
		
		my $date = `/bin/date`;
		
		my $message = message::throwMessage("CONFIGFILECHANGE_INFO","ANY",$email,$fqdn,$date,$filename,
						    $spaces[0], $spaces[2], $spaces[3], $permissions, $owner,
						    $group,$ipstring);
		
		my $smtp = Net::SMTP->new('localhost');
		$smtp->mail("$system{'alert_sender'}\@$fqdn");
		$smtp->to("$email");
		
		$smtp->data();
		$smtp->datasend("$message");
		$smtp->dataend();
		
		$smtp->quit;
	    } 
	}
    }

    return();
}


1;
