#!/bin/sh
#### CONFIGURATION
BIOS_NAME="ROMPaq for HP Notebook System BIOS (68DTV ROM)  - Linux-Based"
BIOS_VERSION="F.0A"
FILENAME="sp30500.img"


## SETUP
MY_TEMP=`mktemp -p /tmp -d`
ERROR_CHECK="if [ $? -ne 0 ] ; then echo "exiting..."; exit ; fi"


#### User message
echo ""
echo "$BIOS_NAME, Version $BIOS_VERSION"
echo ""


#### Unpack File
## Extract from this script
SKIP=`awk '/^__ARCHIVE_FOLLOWS__/ { print NR + 1; exit 0; }' $0`
tail +$SKIP $0 > $MY_TEMP/$FILENAME.raw 
eval $ERROR_CHECK


#### Go to our temp directory
cd $MY_TEMP
eval $ERROR_CHECK

#### Unpack File
## bzipped file:
#bzcat $FILENAME.raw > $FILENAME
## gzipped file:
#zcat $FILENAME.raw > $FILENAME
## gzipped Tar file:
#tar x --gzip $FILENAME.raw
## bzipped Tar file:
#tar x --bzip2 $FILENAME.raw
## plain Tar file:
#tar x $FILENAME.raw 
## Not packed:
mv $FILENAME.raw $FILENAME
eval $ERROR_CHECK


#### Make a Bootable ISO image just in case user needs one...
echo "Creating .iso image from $FILENAME..."
mkdir -p iso
cp $FILENAME iso 
mkisofs -b $FILENAME -c boot.catalog -o bios_update.iso iso
eval $ERROR_CHECK
echo "done creating iso image."
echo


#### Copy files from temp directory to /tmp directory
cp $MY_TEMP/$FILENAME /tmp
cp $MY_TEMP/bios_update.iso /tmp


#### Clean up temp directory
if [ -d "$MY_TEMP" ] ; then
    rm -rf $MY_TEMP
fi


#### Print Message
cat <<EOHELP

If you will be using a disk device such as a floppy drive, USB-floppy or other 
USB disk device, use the file:   /tmp/$FILENAME
The command to write the file should look like:

	dd if=/tmp/$FILENAME of=<your-device>


If you will be using a CD-R device, use the file:   /tmp/bios_update.iso
The command to write the file should look like:

    cdrecord -v gracetime=2 dev=<your-device> -dao driveropts=burnfree -eject \\
		-data /tmp/bios_update.iso

If you need help to create a bootable floppy or CD, please contact the support 
resources of your Linux distributor.

EOHELP

exit 0

__ARCHIVE_FOLLOWS__
<(mxyaIHC   @	             )sNO NAME    FAT12   3м |x 67VS>| E|MG>|ry39|t| ||&|||| P|R|I|K|  &||HI|K|  R|P| r r }u
  t}_ 3^DXXXGHH
|2I|K|  PRQ: rذT YZXr  |.|$|I|K|  p 
t) ;|s6|O|36|%|M|ôM|
6O|ʆ$|6%|
Non-System disk or disk error
Replace and press any key when ready
 IO      SYSMSDOS   SYS  U@ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hh                                                                                                                                    (Hhȏ)Ii	ɐ
	)Iiɑ	!)#I%i')+ɒ-/	1)3I5i79;ɓ=?	A)CIEiG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  @ `  	  
   @` ! #@%`')+-/ 1 3@5`79;=? A C@E`GIKMO Q S@U`WY[]_ a c@e`gikmo q s@u`wy{}  @` 	 	@	`				 
 
@
`




  @`  @`ǀɠ 
 
@
`
׀
٠


  @`  @` !Aa	
!Aa!!#A%a')+-/1!3A5a79;=?A!CAEaGIKMOQ!SAUaWY[]_a!cAeagikmoq!sAuawy{}!Aa!Aa!Aa!Aa!Aaǁɡ!Aaׁ١!Aa!Aa " B b  	  
 !"!B!b!!!!!"!""#B"%b"'")"+"-"/#1"#3B#5b#7#9#;#=#?$A"$CB$Eb$G$I$K$M$O%Q"%SB%Ub%W%Y%[%]%_&a"&cB&eb&g&i&k&m&o'q"'sB'ub'w'y'{'}'("(B(b((((()")B)b)))))*"*B*b*****+"+B+b+++++,",B,b,ǂ,ɢ,,,-"-B-b-ׂ-٢---.".B.b...../"/B/b/////0#0C0c00	00
01#1C1c111112!#2#C2%c2'2)2+2-2/31#33C35c37393;3=3?4A#4CC4Ec4G4I4K4M4O5Q#5SC5Uc5W5Y5[5]5_6a#6cC6ec6g6i6k6m6o7q#7sC7uc7w7y7{7}78#8C8c888889#9C9c99999:#:C:c:::::;#;C;c;;;;;<#<C<c<ǃ<ɣ<<<=#=C=c=׃=٣===>#>C>c>>>>>?#?C?c?????@$@D@d@@	@@
@A$ADAdAAAAAB!$B#DB%dB'B)B+B-B/C1$C3DC5dC7C9C;C=C?DA$DCDDEdDGDIDKDMDOEQ$ESDEUdEWEYE[E]E_Fa$FcDFedFgFiFkFmFoGq$GsDGudGwGyG{G}GH$HDHdHHHHHI$IDIdIIIIIJ$JDJdJJJJJK$KDKdKKKKKL$LDLdLǄLɤLLLM$MDMdMׄM٤MMMN$NDNdNNNNNO$ODOdOOOOOP%PEPePP	PP
PQ%QEQeQQQQQR!%R#ER%eR'R)R+R-R/S1%S3ES5eS7S9S;S=S?TA%TCETEeTGTITKTMTOUQ%USEUUeUWUYU[U]U_Va%VcEVeeVgViVkVmVoWq%WsEWueWwWyW{W}WX%XEXeXXXXXY%YEYeYYYYYZ%ZEZeZZZZZ[%[E[e[[[[[\%\E\e\ǅ\ɥ\\\]%]E]e]ׅ]٥]]]^%^E^e^^^^^_%_E_e_____`&`F`f``	``
`a&aFafaaaaab!&b#Fb%fb'b)b+b-b/c1&c3Fc5fc7c9c;c=c?dA&dCFdEfdGdIdKdMdOeQ&eSFeUfeWeYe[e]e_fa&fcFfeffgfifkfmfogq&gsFgufgwgyg{g}gh&hFhfhhhhhi&iFifiiiiij&jFjfjjjjjk&kFkfkkkkkl&lFlflǆlɦlllm&mFmfm׆m٦mmmn&nFnfnnnnno&oFofooooop'pGpgpp	pp
pq'qGqgqqqqqr!'r#Gr%gr'r)r+r-r/s1's3Gs5gs7s9s;s=s?tA'tCGtEgtGtItKtMtOuQ'uSGuUguWuYu[u]u_va'vcGvegvgvivkvmvowq'wsGwugwwwyw{w}wx'xGxgxxxxxy'yGygyyyyyz'zGzgzzzzz{'{G{g{{{{{|'|G|g|Ǉ|ɧ|||}'}G}g}ׇ}٧}}}~'~G~g~~~~~'Gg(Hh	Ȁ
(Hhȁ!(#H%h')+Ȃ-/1(3H5h79;ȃ=?A(CHEhGIKȄMOQ(SHUhWY[ȅ]_a(cHehgikȆmoq(sHuhwy{ȇ}(HhȈ舏(Hh                                                                                                                                    (Hhȏ)Ii	ɐ
	)Iiɑ	!)#I%i')+ɒ-/	1)3I5i79;ɓ=?	A)CIEiG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  IO      SYS' nX$X$  
D "  MSDOS   SYS' NnX$X$  
DL 
  Ac o n f i  g . s y s     CONFIG  SYS  E22  E2 6   Ar o m p a  ?q . e x e     ROMPAQ  EXE  E22  yp2Y  8DTV   BIN  SE22  y2    8DTA   BIN  v-U22  gN2    8DTH   BIN  022  K2    68DTV   BIN  z|22  y2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    6                                                                                                                                                                                                                                                                                                                  .#../.-.61.33Ɏ6x z " x "z |.
|.7|.+|.|.|.|.|.'>&|)u$.8.%|. u |.'"|.)33ێۋ  RPuLu	иJ/±.B+.5B+?PˌȎм3ء|3ۊ
|....).'.+ .+Ã |+Ã 3Ɋ
|P3.
X=r..HH. .67 t\2P.#.	.%..&7.	. HH3.7.	.XP.& 3.7. X@@.H.&-ȸp ؎3.>!2.7..6...>0t@3- 2.7.#.%.	..>!.6p * X.&.!../.-.#.%.8  p  Q.	.P3.6+.
X.6+.++ڋ.96s.6.
P3.6.
X.6
̋.-ƴPW_XYs2Q.-W_YIt{ 2.)t.	. 3ۊ.R.5.0..>.uHR3Z Zu&.FR3I Z&  ..&. u%=sR3  Z&=s.0 PVW..;t4.R3... .	.. 3Z.I;ы_^Xj 23ێ1x D
t
Non-System disk or disk error
Replace and press any key when ready
   p                          5 p  CON     G p  !AUX     Y p PRN     k p 9CLOCK$  { p >     p  !COM1     p LPT1     p LPT2            p LPT3     p  'COM2     p  -COM3    p  3COM4                        Np             	             P̀@ 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 p     @ h  	               (    h 	                NO NAME         FAT12    p    @ h  	               (    h 	                NO NAME         FAT12    zp     @ h  	               (    h 	                NO NAME         FAT12    p     @ h  	               (    h 	                NO NAME         FAT12    	p  P P P P     Pp .p  FAT12    FAT16    NO NAME                     $                   	  
      
                                         !  "  #  $                                                                                                                 	

prstvwT                                                       ; Z x     0N   C K. . . @  ;    4   -  &   0  0 0
 0 G .>
  t
P. .9 Xu..c PVWUS []_^X.>
  tV uE . ..   . . .>
  t! u ː     tPS. [XQVW.6.> _^YPS. [X   >@ t"A حt
=t>
  t0 =SOt..P@ ؠ $<u>
  t X..PQWD  3_YX..             p   P   P   p                  WSP3ǻ /tPW X[_
v   NO NAME     NO NAME       P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12      P                       (                                   NO NAME         FAT12     r
t

t..SQRWP@ t  :u rt  SÎ[ rXP k X&t 
t_ZY[ C H  tH "$?D .E F 
G S\ &GB &G[&v 
&v Ë@ u5B u/ mH t1 r l) uC uhe/ he. he. he. he. hei/ w..rP@ X.  .6.>s..P.. ..3... ..>nv&...n .>mv...m.33. Ê;vF+..6......Q

Y 6 .PQR2ZYXPSQR. s .6. Irw.  rk.   >ud -P ܘ.Øtm.>v.2I.2I..6ZY[X338r.6  r r .6à  
  Ê$
À> w5t>r,>r%>w>w> v>1w	> vÀ>$w>Yw	>Ywù %<
w
wCIuÐ                	(   @    p                       @     @     @       @ @   @ @     @   	    01/10/84   p  	             `	             p  	             	 $          p .6.6U  P3X...QWvؾI
t	   ._Y.. .. L tN T JV d f  u6PSQRW r._ZY[Xr.> t.. 
% u@.x @u33Ҽ QPr u&G.>&G.?
& .>  .>> uf t
PPt			2			2	3Ҏڎ34l n  b   ,.&.>>r+"Y.PS3ێۋ  RPuLu	иJ/[-@ .-@ .Xvu# ws7	v3ء> &;v= u
< > 3Ɏيt..	  	X2u %^ ؁>COu>MPu>AQu r@r]2,	>u==:u r3ɋ= (WRQrx u'	ň6?.:,v,YZ_r
uw >(u>	vTP>Pu	>$t@>t>	u޶.*YZ_ruw P:,v, >x uπ 3E6E4M#u"U}]%>x ux 	M#=6]
tyR.>u>`u grZR>`u  SrsZu6]RS>`u *rs	[Z[Zuـ>%v>`	u
	>w  u>>u#>] t ƾf	 uK &>COuK&>MPuB&>AQu9&=68w.r&=80w!r&=40s->  +>u> .> WA&=_ry 3؉>
p > 3&&&].]&ME&)E&23ߋ:v&s,.@ur_iv.>}t	=uPE=u.>=.&%=Eu.<r .*%r.u .vߢ. 2 r	&>UtWS]UM#E" RƈuZry?MRZrlu&?tbuS&Gt&?t&?t&?u
t:΃uػ&Gu&?t&?t&?u
t΃u.&G&W-  &G&W
s&GE&GE&W
&GUE w=@ rUE3ۊ]P3.)X3ۊ]P3.).)X.>) w|= ww}GuEÌ
̊.NNSP.?t
.?u).u"Y.G
$<u.? u.G
tstX[6X[.2.u.
0u/".0.u
.G,1$t.3.ru.
1r.>t)uW.>^ uOWY.| u#.| u.| uE.DE.DE.D _Q~SY3.Du.D.TtEUEU.\]	+Ã .\]+Ã .\]+Ã 3.LMP3.)X.>) w=r@Q . M# UE.;r
w.;Dv
L.L.TUUEm@u3ۊKCށ}=RU+Z -  }Ã -  E]GUE w} wErEEE  ][_PRV.>t)t1.10u.
0u"Y.| t.D.Dsu.Lm] ^ZX   3>W&]"u>3&Eu&U&ERP&E&eXZP3.)Xt@&E%uV.>tTu@3ҋE%e6e4E/H=rtE- U).&".6"3.6"@E20}' _&=tLØдØа Ê6] t1R\3ƣb?d\r	 ZuÁ&?tu| sw>`EG M#E" bEdE\Eu E&
 w&@r;&w&WUI&O&w\ r
 rA sWS&?t&?t&?tu[_>u r
v&VS6<t4<\]]6^^u `d[^PQRU333Ҵ u u
tE @. V6^]ZYXP.>>u%.>?t.>?s&0  $" XÜSPpqX$pq[ ϜPPpqX$pqXQW.HH..PS.6ދ.@u>R3~ Zu.FR3l Z  ..[Ss؁R3 ? Z^X+u.SRP..Z.+w[_.YPQWV.WP.GX&E	_.;t*.R.+  й .3Z.I;ы^_YX                                                    p .0  GGVPQRWUSv.0 D! &4 &G&g
&O&Wu+  u&W+&W&G.:s,&.Tr.0  G[]_ZYX^	         &)O  \	 Q 
5lttU
 5 Ê&2 
u*t= ru> t<u
t2
u& à 
uM&u>y  t &G t A2u&= ru> t<u t  &G
&G)  t2. 7 u&2/ tu	  tKuG
 uĀuj! P00Xu߀(t
	 uðËQS2㋏[uĀYt&2uY> &}
t
&E&}2㋏<et<Eu&
&
> &}
u&E<et<Eu{ 2
u ô> uX2U 
u" t ts  t tô!   &GĀt
NË!  ð< pȰdȃ  ˃ ђ  ȵ Ę&P> t&&E&E&E &M&U> t
N 63ӹ drdв ҹ< PƫXë2> u2
t B W=XXIAXX 
1XXXkXXX$B>&8Et	&=u &E$t&e#&E#t,&E#u%3>w  t
r6Uu &:Eu( N &wy>w  tþ  &EG+&EIuu>r$vN&%?&E#u#7 
\ r>

 t
>w  t &g
&&OW3&MW&MY K&E@u _&E#t QRS r	u \ ar>w  t&}"uuz     )r`@@uÃ(tɷp&u&}&M&e&E&]&U&E  &E  &E  [ZY
 >
    rK3ۀ>Nit>Nt>Nu1>Pu*c$<u!c<tu>V3.u>X2s[CÊ6[>_a&cdfh>
u r
>w u'À>t)u.Qu&MWw&MYWV yK ^_Yö   r'U &UNsLtD&E#u>8 uP6-D	D	*X>8 uP*6-D	Xs뷲v &mF]À>w  t&E À>w  t&}  t&M &E#uô    s PS&]#!ustn&EW>&8EuS &]#tK&0]#_&]#>z u&} u>&E &.>x uP&E &:Xt&=u_[Xð ߌ7&E&E$uމ"&53у &} t
 u&;Uw6+&;urw&;Uw+&E&U- &6x 6-/&E#u>w  tJ 3&u)-&u1&MP3ҡ))X>) w= w23" M  &E>8 u:,6-DD
d&&+6-&}"uD
2D	'(&E#u/>8 u#P6-+&D'&&&D	&D&d
Xt&E#t
/t) 3&M*12;sPQ
 YX+  &E#tt .2.4& P3&E#t&}Gu&UI
61ʆ62&U&}"t>v t
ttV rv &mF> tRX&E#t/u0?2)"Ȉ1&:Mv162&:ur2362:v u&:mFtu XP su4tX>S2>w  tf
>6u 6  t &E#utt
4 X M "&5X>8 uP(6-&D	X 6-&D	&Eu
77QĢD	 <򮊅 YPt&;UGu&;MIt
 &UG&MIXtM
 i
`@aAbBfFgGhi &
&Gu%< uO$,@.:wF..0 Z. _&E"G&E#% G&E%G2Gu't.0 'ru  _&M#@u|G&E"G&E%G.0 >w  u%% &M#&E#G.0 7&M# Wu&E# t&e# }'&M# }w.0 _O&.0 9&e#t&M#?w;w(.0 GGð _t.0 A&}"u.0  OW.0 t <t<ugRZJ£98;9 Q;97YrQS3ۉ79y[Ys)Z9PQR<uGZYX9uu9  _OGW 329t#
u.
u(&E# t
/ t633ۉ7? 6 ô
   &_&G3&G2&G&O&_	7&59>8tPQYX; &E# tQRFF1&E# t/ t
"ZYìPVP&,6-DdX£"^X ZYⳀ>8thÀwðÊȸ À>9t&E# tL&e#9 ;P&}"t&}"t>7 u;TV 6x D	^&U&e&7QR>9t&2>8u V &6x 6-/&D	^&M%I͆&
M&UVWr3>9t% &6x 6:< &>x &z 829t	t_^ZYP>8u92v XSV8u6P&}" &6x 6-/7&D;&D&D	u&D
X9&U687^[&E>&8Eu&E#  u&=z z  2&E# t&M OP298
tV6:.0 & &6x &z ^X &E } r&>cr>t)u> &u ði &E RB Zr>>cr4>t)u-Wu6 t _? 
 ðWSN3҉+ [_&U
x"&E# u>w u$tsS@ [ _ &E# uG _&e# u&M#  &G
<u `u   _  &U2 r<t
<t<	uGÀ2t1t tt;tyJu P.0 6 6 66  [ZX<s
u<t<t$.0   p .0 .0 >.0 <t<u% u&  u<uK ËtC<u3- t!;v>uxu.0 >u> t>Q  w
 wYYPSWp rb&E# tZ&]%? ;vM
uȀ
2@ƀ &;Ev6R3&]utHZϊ?
_[XÊ>&8Ut	&=uÊ 2
t  p  Ð @ >w  tYS@M[OxRPQʰ1YXtBS.ڀ &[.> t> u-Pp X".0  t>1 up >>tŝr! su
x>w  tS@ [߀	t~uۀ>8tԀ> u2䚗p  2<tSQR  p s	tu 3  t	ZY[SNp [suVWN!_^ơ r;t<tHw/RQSPUӁs *:r6v	 	SNp [SVWN_^݋VQW5&M&E# _t?*Y:sPP%r~X(f:t
*ڊv	Sfu%VWNWK[_^VZr:"SNVC[r"VWN_^[AFt	V][[YZr2U &u w4&E8Du&]#\#&e#ߊ\#&]#<u،D<&&E4:,v,tp QR&U+ɸ J/AtA.S.).
u<2[ZY
Insert diskette for drive A: and press any key when ready

 &}  ?3Zt/Hu+PR&UZXr &8]tPQRZYXt3r- sttr ry v^x(>t)t( t3>^ t r
uF Pu&;EWuw&;EYu3XXڀu5t"rr	xE   þ  K8K@&E# t1&}"t*u%&}"t&}"	t`	0W>&8Uu&	]#&=u_&E#@ &e#&E# RPt r
 XZZZ  RQSPW	 	 _&E&M&E	.&EQ.&M3B3&urD ? t7?tGu Y.3YW	 23_X[YZY^^WVQ	K Y^_WQ	K Y_P3&:EtNX                    H H     P &>ubtX.. X     8       A      N     KB         Y     KB         q     KB              KB              KB        {      KB        c      KB        K      KB        3     KB             KB         1PU.
 .. &F < uQ.. &f&V&n&9F uDŋnЌĎ.n .^ &n &V&f&F  .. ]X<t&F  .;. r&F .. &~  u&F < t<t&F .;. t ؀>ur!桌Ύ޾;Pp Xtp <$t

Internal stack overflow
System halted
$                           2  	                     A:\          
$       Evvv                                                                                                                       vvv                                                          p                                                                                                                                 r u&G.&G.. ؠ. u2ɴ r t

u.3.I3ێ& & &RPu&LuRJ/X;t.IL+ȁ 
p+ȎLP˸p ،L~3.s P.s .q[.)s 
.ؾ0 p+..>.6u.Ȏм2.q....}&.m&E.o&E.y&E.{.s..> tRH!H!.+HشJ!H!H!H&  & RP&
 L &   &   I!.>mr&EEt&E ..&ECS33PX% = t PX% tCC[= u&ED&E .- .A+.W- ..&}&E  &  &M3&&E&E &E  &E  _.p ˃3 &6 P!C$%!> tK=.
tʴ!+ءl...2u9.h.d.+hJ!H&  & SD& @.6m&D	I.h!.>l t.s3.}3 .s.}4  ..11.?4n4p & . t..>luM.>l tn.U.hI!. t%S.^.`J!H&  & SD[.>l tE AE
DRH!H!rCI!+؃+r, =!rH33ҸB!r:   ;r=IR;">!ZOOO K!RH ;Z	H!H!.h.dHMA not available: Loading DOS low
$Fatal Error: Cannot allocate Memory for DOS
$% r	! F .s3.}.l  r.s3.}.l r .9 M 	 .$ .0 p+W.._W.6q[.q+[+.søp-0 . ۋtH!rQ- &!  &( SCWQR.>mOO& ;r'&  É؈     +ˉ - ZY_	!p M uHC/   Ht	=@ r& Hut& 4&> 4uø C/<PSQRVW.>lu_^ZY[X                VDISK  V3.3                        VDISK3.3  @       @3ءd .
f .
H !H&  & SC@d / f 4 
3W   
_                                                                         du.>t	.>	uȋб .l.n ZÌø+Ã+p ؉>
 3؎N   
tؾ 
 3Ɏپ   >m&M 2&M!X6+&u&E  &53.\ ..3Q? t.>u<wYYY| t @ƫث  .A.6m4,A:ttup ؃>/ u/ ..3.,vRPF.	X2.b.d.>m}U.>b&&E;.b .b.333X.2.b.d.>m]U.2]>b&&E;b b.3AQ; &E  &E  &E  Y>t    P..m&n &^ øD!u63&^ úzF
D`!r!FF3ҹ u=v 
&~t&n뮁>  v" > @v
 > v X.m.G?.GA_T2BSL[.> t-=2.bO.dO.O
 .b.22PL fX.>m&M .:s.2&M!.d&E.b&EXI.d.1&5&}B>t> u>sqtj1Sd33ib1p  .b..d. ..&.d.7123۴>! >!CvD=!s3P >!XشE!E!zD3~D3PSRBBBBB &>t
r&G@tBBBBBZ[XPd+h`TX>dǉ>3> b.r0l^0dh^+شJ!H&  & SDH!H!db  +KKJ!H!H!hdI!V3. < t&<
tG. u.
.    .B.F.J.N` &3KB..^sV/2^ .b .&d !.b .&d r &9t	f !&.&33&tFF2L+&FF    
Memory allocation error $2V t?GG  .We .+>Y&
&M
tG.dG
  G.- .b..SR..& %ظJ/u  .dZ[.6&E..&&E &E  &E  PSQRWVU.& & .& .&
 &. &.  & & ؃&> & 3
  &F  &F&F&F &^&/߃. .  ؀>ur3 B    G8 < $ LA E jN R ( &Z t1?t,KBt uR &;ZtQY W j, &Z t1?t,KBt uR &;ZtVq o *0 &Z t1?t,KBt uR &;Zt[  4 &Z t1?t,KBt uR &;Zt`  8 &Z t1?t,KBt uR &;Zte  j&Z t1?t,KBt uR &;Zto  *&Z t1?t,KBt uR &;Ztt   &Z t1?t,KBt uR &;Zty  &Z t1?t,KBt uR &;Zt~j &Z t1?t,KBt uR &;Zt1/*  ؀>u'rp @]^_ZY[X&&DGp &&DE&&\Q.d.&  A& Y.d                                                                                                                                                                      []|<>+=;" .  ..  .  .  .([].*|<.,>+..=;sS&&:s [#.6SWU. uC_r<t7u. u&.AtN.<=u.CHsŬ.CN.6. .&6.</t6.<"t.uT&G2.9s.CC& i. `&G2@&2tCS& [sACC. 4&G2@&2@&2tCS&] [sCC. ]_[...6..P& u..< u u	. P XXUQ&O2t
o	s ..Y]&~  tEE.rJ.&P.+.X.6.< u&.|:u	.	 &? t& u. 	 
P XW&.>&&eP.&EX<u
&U&MZ<u&UP<t<t<u&U><u.@&E&]+&u&MP&Gt	&Gt X&Gt _.1 P&uPSRW.	 [_Z[Xo t.  &.>	uW @t.   .>	u@ t.  .>	u& t.  .>	u  t
.  .>1u.> u.	 XPV.
t<:u
.| u. 	TsFF^XVR.Ar
t .FFZ^<s<ar<<zw8$4SW>#.8tPQRe» !ZYX.].ECC,&_[P..&.<+t
<-u.F XPQRV33S.
tB r92 r,ڋ r r r
Ճ  rF[ [.t
҃ &w&< utF&< t`F.u&;Lr6w&;Tr.&;Lw(r:&;Tw 2&;L|&;T|&;L
|&;T	u. &$.	 .^ZYXÜ.uÝp<0r<9w,0PSRW&&
uL<u?G&	@&@&GG&-2 su. &e&.	 _Z[XPURV.<r<.t
<=u&~ uq.t<:u
&~  u\F\&:F u
tRFE&:F uEF.E&:F u:FE.@t&G  t&~  t"& t<:u	&~  u
< u&~ :t.6^Z]XPWV.>.
t_ u$.1^. _?^. _& u2. )XV.
t- t\sGFGF.. G.>^_X t	PXSQ(	 .:tCAY[PR.
t8r,.|:t& t.| u <ar<zw
,`д?.	 ZXì" tS u. t.At	NNSQ<
t-< t)<
t%&}r3&]&9 t
3&	C&:t<
Y[SQ. .&< t6<	t2<,t1< u< u F:&}r3&Mt C&:t< Y[..u. :.;t
</u</u.@VS.> u'PQRWU3޸ c!]_ZYXt).6..6.< t:r:DwFF[^x;        c                 /X               ;         ON OFF  ;
                         ( ;.      7         H ;P d      Y           m            ;       ;             @                    ;          ;    !! !     /K     /N     /F     /T     /W    4!;<!<!      N!     N!   ^!c!g!k!HIGH LOW UMB NOUMB                                                                                              PROTMAN$          7!ED =!sË33ҸB!V3Ҹ B!V\+Ѓڎ3.V?!PWQuO
+.>VY_XP>!Xr;t,D4!>
s66X6V36Z6	|	r  <
tc	s>s	M	> uw>t>tHt
IuɀWuc뽀Iu변Wu3 X!Sˀ X!X!2PX !X[![X!{Yt
Zt0uZVaBu^ s3ɋ9ssE=t>uuՃ>cvF  Cu83ɋs$=t>u ܴ3!Muq 3ɋs7=t>u   p .>  u/ / qHt/!3ɋKs
=tKUuw%s.6.\..!u6	s.6.?V&<
t<
ttF.!& ^s.! 1.! .>! t#.!Dt.! .!  .! 6|~6!! yrB!!! tk<t!ht;!}!#!!r9!s&< sf+AbrVVV.6!D u.6m| r
^^P ^P.> u.x  .!.z.m..G P ^ XX.mG .x.!.z.!.>! t8.>lu^ $dId^.> t
.  b.!.;!v^.!.>mD t(.r t&U&] t&U&]
 .w
tD
. Ȋ&U vk.vr& E . .|..m&n &~t&n.!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;Ev R.!&V&^ZB.>m&M"&U$.6!&u"&]$.!T^@t..  .>! u=J  /u1 u
.!. .V.d.+ѻ .U.^^HdHQt#.D .!   3ɋs . 9=t4.>u.u. .! VW.6D>_^.> u
RH .>D tDD =!rI.\. .! .d.;wHD< uFF.>yW_.d3s&t.>D tDD.I.s5.\>!= uHHÀFu+# 3ɋus=t
..B .B .hLu+z 3ɋEs=t
.. . .8Pur	`%AKt  3ɋsI =t.u. . .>  t.> r.>  s. .>  t. .> u .	 . .  I. .. ..vSuS.E  DE
t< r,GEr! E< r	GErρE.E <
tzsXu<C 3ɋ s5(=t.u.x .y .x .. 1t  3ɋ s n=t3.> u.,!.>!u.-!.>)!u..!.>,!p u
 .-!.>.! tSR!& [SYuZVC0ttZVN.hH& @.;w...6  q=  t=u@H_ ú@HU RVgH6
t!FdH* ^ZQV6Z&VZYI
 I W
 .=
 r30O0]_2.HtHtHt.! .!.l .l.M t.>! t.! @ ۋ .! .!.>! .! t@ .! V.6!
! ^b!. PQW3&s!&r!&t!&v!&! w! !_YXPSQRO \rA3ҋB&  & u& &  & & & & C<Zu ZY[XøX!&!X !3!X!W t</tN+$<Su &s!<Luo  sN NN_ì<:uJrK rAF <;t] t:M t4</t0<,u! rc ! <;t8 t( t</t Nø NP!&!X< t<
t<
< t<=t<	PSW2&Ƈw! &8v!u&v! _[X<rSWV>v!uv!
t2 &w!
t^_[SWٷ &!_[  .>/uar	fw WÀAr	Fw7À0r	9w0SQ3333./
 &r1
u&LxtXu	./ FF&Fr r
rNY[P.&/rX.&/3XQ蒱YVR!& =t^P& = t=	 t& =SCXQRr/3Ɍ;s(uA&  <Zt& @& ;s3IZY.>/u	=u@PSe[Xv!<u
tPQr7&r!) <t 3As r 
uYXv!SVv!2仇!Ë^[SV2仇!Ë^[&v!Rv!tZPz r!t( u* &  <Zt& @XPs!
X&  &  & HI&
 DD& EN&   P&     & &
 & & XPQR2;3;tHuA&  <Zt& @ZYXSQr933t'tu&; & &  <Zt& @ԎËuY[P2w!
XSQ،&  ;wE&  & & &  M@+H&  &   &   & &
 & & Y[SRt+@r$PW[t;vt	tr	Xu3Ҋ\tZ[Pr u&  <Zt& @XP& = u"& =FRu&
 =OZu& =ENu& =  X&  & FR&
 OZ& EN&   PQR}23uA;tu&  <Zt& @ZYXPSE
 T[XPSR!&G&  <Zt& C=[X2!X!Pr!
uX   &r!  X2!X!Pk r uD &  <Zt& @XP&> u"& =HIu&
 =DDu& =ENu& =  X&     & &
 & & VR!& =t^øX!
uX !.>! t:.>!t r
A ss r.!.!.!.! .d. .!.!.!  .!.!.!.+!uH.;!   SD@.!.!.!û H!tK.9!wC H!rH3.!.!.!WV&  D@& P.6|<:u<\u
u  
t<.t X^_ָ =!r8ظB3ɋ!r$  t	.!.! >!.!.!.!ˎû!K!Ü.!r.! &
tF.!&.!G.!.!  .!.9!v
P.!.> u.;!u.>! tXX.!.!H@+أ .>! t.!.d.b  S.!  .6!.!1 &<SIu"&|ZEu&D	u r.!
 ދ[[&	uF33&
t9
t4P	Xt* r& 
F  u À0r9w0ÀAr	Fw7 r
? r[ u-R!.!C/.!.!.>! u<r.!P.!t.!= uX.! ؎;w&>  Zt\ A+  M    SC&  M&   & CC+&  M&  & & SCG& &. &  M@+؎&  M&  & & SC&  Z&   J& 3.!& &9> t" r r&9> u& A &

À>  Zt @rq+؃&  M&  & & SC&  Z&   J& .! &
$ &3&=Zt& @&. &  M.>! t$S.!.+!.! J!H&  [.>! t!.!&$ &> +r
;t  Z \DBLSPACE.BIN .! .!  9.6|.~.6!.!%@ r.!.!.!r.9!sB .!A r.x  .!.z.!&,.F uA. ...j
 .sK	!t..G h.x .z.!.!   ..+.;!r.). ..!.!.;!B w\.6!.>mB  .w
t?D
2Ȋ&U w$Hr& E .|..m&n &~t&nD C  .!&F.!&F..!.!!&F&F7CC&V S!&F.>m&;EE wU.!&F&^.>m&M"&U$.6!&u"&]$T.!.+Ѹ U .3øJ  /ut tnJ/ .!.! .!  .!.|9.~c.!.!.!.!  .!<3  J/ øJ  /u:,A.6m&tX2VQRJ /ZY^:u&dCX     DBLSBIN$ PSQR3ۊGúzFD
@!p .G t
.G1.F:,v,ZY[X~FP {F|F  G  <
t!<
t=< v</t09 GrrG uG% |FF   VZrQ$<ArK<ZwG6H 7Hu6 G؋ȩ t |r<:usS. . [ 3ÅGu3 tG( t{Ft t~F  tGG3ۊ{F u~F( ㋷"HF G  tGFG@ tGFF>F>Fw=u$߃>Fu	>~FPu$>~F(u">Fu>{F u>FuFF~F&F&FF.V*D33.P t
<
t< v.P QVWME F$u&=
t&=
t
P&Xu_^Y_^YZ`<
u밪.TR<
t<
t</tuNA.>TYtb.>TDt4.>TIt,.>TWt$.>TSt.>T1t  tv[t th BttZ </t[/t]< wW < t<	t<=t<
t*<
t&.R.Q < t<	t<
t
<
t.S.Q <
u& G& G&E <
t ti  tx tZ <"t>< w.>TUu<
t<
u&E .<<
t.><t&E .< [.>P t.P .P&IY.>V.>X3.6Z.>P u0.>Qr(&.8Ru.>Qu&D.8Su&FI<
u</t< t< t<	t
<=t<,t<;7r<
u.QV3<ar	<zw, D^YP.bm.d.b  .d.;s#.tV.6+H& .&^Xú=Ia.!.!.6!.!j.!.!,0r<	wS3rJS
 [À r;{r/< t!<,t<	t.:t</t<
t<
t
u.V.Z[. 3[WPR33Ҹ PrMVD ^u=<u5FL *r'wFFZX_;Du
 t;Tt4FF^Y_T.DT
L  rFFWQVD r}TL B!rȺ  ?!r;uTL B!rV^ 
?!r;uDAAw6 <u&u&uWP.DDX<u	_&E&E^Y_4FFI th<u&= tWPQ&
2YX_QJ&
GG&8t&=t)<uG&}YP B!Yr	33?!V. rFF!A.DD<\t</tO D^P<Ar
<Zw|:uXä| uHdH &
t!F .>Utmô	! srD Ë3D!u>!=!ðMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved NUL CON AUX PRN \CONFIG.SYS A:\COUNTRY.SYS                                                     COUNTRY  \COM.COM                                                        /P                                                                                                                                                                                             BREAKCBUFFERSBCOMMENTYCOUNTRYQDEVICED
DEVICEHIGHUDOSHDRIVPARMPFCBSXFILESFINSTALLIINSTALLHIGHW	LASTDRIVEL
MULTITRACKMREM0SHELLSSTACKSKSWITCHES1    P                                                                                                                                                                                                                                                                                                	      p  	             `	             p  	             @	              	 $          GGGGGGGGG	HFHSTDICN 
Unrecognized command in CONFIG.SYS
$
Bad command or parameters - $
Sector size too large in file $
Bad or missing $Command Interpreter 
Invalid country code or code page
$
Error in COUNTRY command
$
Insufficient memory for COUNTRY.SYS file
$
Configuration too large for memory
$
Too many block devices
$
Invalid STACK parameters
$
Incorrect order in CONFIG.SYS line $Error in CONFIG.SYS line $ONOFFStarting MS-DOS...

 Press any key to continue . . .
$MS-DOS is bypassing your CONFIG.SYS and AUTOEXEC.BAT files.
$MS-DOS will prompt you to confirm each CONFIG.SYS command.
$
  MS-DOS 6.2 Startup Menu
  
$  Enter a choice: $F5=Bypass startup files F8=Confirm each line of CONFIG.SYS and AUTOEXEC.BAT [ ]$ [Y,N]?$YES$NO $Time remaining: $Enter correct name of Command Interpreter (eg, C:\COMMAND.COM)
$Process AUTOEXEC.BAT [Y,N]?$WARNING! Logical drives past Z: exist and will be ignored
$Wrong DBLSPACE.BIN version
$         8e_^ u^ t$e   SVWU+|$F,  kP@4tVe3]_^[ 9~    xCLSS   l$ePe@    teȁ  ;tVe뢋N,9A,uy0 tI4Ve3뀀I4W*  W΃  Ve3[VeGuW +u_^[] 3ۍEP]h(0eW}EPSWAZ  9]t*MM|&VEuS EuSE    3SVWU~ u3N ~~D   ]~ _^[39~v$3ۋF,tUNm u}|=p   89:;<=>?@ABCD
EFGHI	J	K
NOVW
XZ[P\$!efhgl
P
i
TUUUU5TdTQ-R9RUUML\V]^>V]]]WDLLFMHMDDMD]]RV&VLN]];MRHoHHH_JmL5JMb@rMLDLLfJ`B`~` )DSR
[at_,xn^W_@@~MMZJNx&bLKcĩ®D@#M@JKwOwDD?0'GGnL!GU\HoklkHIPIPP*P+A,Bժ箑I+JIO®DDaIP8PPDPSP0QQMQRQDMS DOS Version 6 (C)Copyright 1981-1993 Microsoft Corp Licensed Material - Property of Microsoft All rights reserved <v.=PV72u5Hu+Hu!= ui = u 2> t^X.=0.=0.=
2.2.=XXP66$w܊lwҀ3rtdwtQtbtPtUWVRQSP.=3r0u>!&0<XP&. 0 .=ӎۓ366& 6W6L6J@6X
tYtDw
6>  u7
26:6#6  6"P*X6X  	67tPNX.>6666& .=>  u'!&F X[YZ^_]ϋc ;0u -S.=&X[YZ^_]&&.=&UWVRQSP&6UF].=6 @6!r&Fs6  _rwXVPAD:  *X^s6$2 P.=

X&.= 	

Xr=/6
F3u665t2 Bu&e6
6
6!&&&P.=

X&.= 	

r
6

l83Prgs2= t
$
Xs.&FC t$2 &nE.d2l  }L226$ V
6>J t6$S  ^PS.=$<t	:tt&&<t'<t#[XVQS$=;.<t:t22.:t2[Y^ø .=#u

t ttutFu= Iu4 p .=<u7<u <u<t tw    
r PSQRVW t"
؎3 
  t_^ZY[XTi @1l    1!_^ZYsRVGc !^Z[XA ش>!G1_[X0
RӻWGZ  t >
u'
 PQVW 3 
 _^YX&0 &
 oujuA"\XHRIt6ItLIt4It<IuCH&=Du@&9Eu&E ȋ33 tX 3|L60N&6 VWQ.=<u3  QY
<u3  QY
Y_^.6?.6?PUF]E	.=ðÃt*PR&F
&Vt2ZXt%.=
ËW.=O_PVR.=:
t&V bZ^X
Divide overflow
 You must have the file WINA20.386 in the root of your boot drive
to run Windows in Enhanced Mode
YNyn @M;S<>==?KRRAAtRSTTS
TSSSSSSS&T	WH_.H RP1\D6Vðrww
t
tw} TL2ðs<s<sdsQR 3ҋS=6. 6=[=6. "=2.=Q  
΋ѡQY
P
  VS 3ҋ\=6. <[^;Tt=6s=TVQR3ҹȾ
# s $ 
 QBP ZY^ô ;r+A.=Ru
ƻ
:°rP鸵R
R Ͼ
II IђTVSP 3ҋS<6. <[<6. ;[^T3ҹ @@V2ô <u20@ A\L6$6<t2R_teu*A   r\ u4@*6;\htɋ3۸ /<uu//
tð6\h \# s<t< riu
1< u
FED$<#u"3.:	Ht.:Ht.:
Ht	.:Ht@@룋<!ut
ED<"uE
tDDrx*uThu\j;ThuQ;\juL\HQLJv:tYoY<t  ȋL끃9s&
 2P] /<t빸/< uDH*<u\jTH\T<u3Th /<u'/
t<AuA $&'#뭰^rr29TL\6,6.\L6,6.66Ê ^r666G 1 &\D! &&_6 u6>  u6 3ێÊ
/t<tT$>(&.#|
D\LV*6Dj^
uhD.=DAVPDò ]rr&20L\|TD!TD& Tò B]r">&EDu8IrlD2ððL&
     P /X | u&E wЬȪ2uĪإH3GG&F2&F&F&~
 u2\T
+؃ t&+F
@&F&fr
u=r҃s
.6MH;v&F
&F  &F.=0V
\6 3   64 .=> tM.=3۹ Wr$&Eu&ept>	UW&&GC̋0& 0.= X3Ɏَ¾ 
  & +=v-  +رڣ  =t         P !R 4  6 2  8 : &@ ùf< t<u	F
qðVWP4@@&G(@z@:u
uX_^P@f@
uXP
uXWP2X_  6>r uQ6 Q3YYUS^.8^s^2C^.^[][] .=&>t&EDu&E.=2
K&E;ttt&M&5:
&
ˊ7^6666 W666j
66þ(
.=4D"\$6666666$Ü6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XÜ6>
 tP*XVx?u;6>
 uE2*6>
uPSQR   ZY[X6
22^6
 < u6
Ë<$tЎ2
t܊:v8
t݊J66V6.yc<
u\<t.:HtC<t6<t2<<<
t2<
tD.:
Htk:s6>y u:sFaAq8_uJ
t; 6 
t&E<0r<9v <ar<zvh\^6\9 O
tX &< s<	t<t<tE 6>y u
tNWOΰ Sv	&}	t	6**ˀ[_t Ox sn.H*4 6y :t:t:tF .:Hu*tItWG_u*]j@ _W^6yNv
 
 <tC6>3T!r/u<&M@2&e<S32![r/u*2/S !r\　 u\Gt)[  rP
l<6 ;g/t@Xt\/VW=  tl
Zl
ZЎ؎ _^P XÊ< r\<t6V6 6& ?uP,<XX^6tSV a r!\ǀuÀt L rDt	6   <
t <t'<	u6Qȵ  Y6 q6v< s<	t<t
<t	P^SX@M; rZ;_.t2X.S S Pk;XV^[^; tPR3r%.ZX<t<t<t<t<
t Z D!T#|@st$Ur	
rVT^rV^rӋǋ\u 3PZ  D!T#
tt$2tD6kr&E2P\u6k&ED&ED&E
D&ED&E&M @X>Y&M&= uPMXs<tR>4V'T^Zr6666Trr6>St&EDg3\t[&EuB&ED&E&]
߀
ÈD&ED&ED &E$&
ED
t*&ED&E	D@6 E6+@ S;D[&E$?
ÈD6 @&Eu  6 ø W6>@ &M}&)w&;_&Q.=
u>]>_t>]> >@ &M}Ӌ&
 tN&=tH&E u2'[u->]_
t&9]s&];ʋuu0Q&9Us&U
t9>]u9_tw3]_l
u>]_>&= t]s<t2a.=&>rð#ì7ÊDtyZu	 /
t6:t]ZuP Xr&E$?
 @L
ŀ&M&E6<&E1VWK Fk'_^r&}&E 66&u&]	&E%? VNP&u&]	^rD&ED$
$?&ED$?*&ED&E&E5D&E&t}  W; _+&&EH&EDtP6>@ &8ErE;}6<&9E1u2&= t,Dt1P$<Xu6 r&;]u$?&e?:uËD&;Euè@u \&;]u\&;]	uPSD~[X6>6s`6$r6>66<&E1.=# &K&. &V8ËD!T#@r2ÊD T؊2PR$D ҊŊDZXË<u;Ë\u \UFF Fu N^Ft|FVFF׉FVFF6, tF6,uH3FF3ۉ^9^uFtvsLF  F D&ED&EFV&E&URNrFuEtUV^]r6> t
6 FN&E&ED&EDF3vFFV ;FtFu&EuFt&FV FtFFN+26>,~VFFtFtfFtD!T#|@st$FuDTFt	NLF]ø yjRQP[NXYZs"(PXr*&E VS[^6>sPRX= t=$ uPXiuTVu
6>]6_&&Eu	tMD &E
D&ED&ED&ED3D6>@ &e:DtPXs	:u2ÈD&6 &E>&
VC?ܹMi3WtD
e`[ VQL66<u4:Ms[6,6.,..,s[پ>lt[
u6ìG
 ê>,lt mê 666m 6l <u
6m6lPD
 6,6.,.c.,rV>lt[&!6mLs6,6.,. .,sھ>, VDFF^5 66, 6,6.,.
.,s뫹 &} uOAr<  u| t. &} uO36 Js.='V.=6DC u .=L !W^_ră tO<\uFP
t<t
<\u<u
uX24RWqK_sZ6>zu2JrtZZ8q ,Ks>zu>tTr>&EC  t%WQ|\2WJ^>&EIY_R w&EC u&EC  t&MI>,2oVJ^s6>zuV
 ^vr66QCYuauaaa$c$caabbca
b!bcc
b!b<wP X.7a+Es< &Et
t
t߀ʀ#&U_#2䨀t
#&}&eTDr&Et#&}2K,tPXs:"uƉ tu Dro&Euc#&}#uNuI&E@tB~<|&Et2~W|}.6>6|^ 1u&Et6~
6|36|VW#^6% 	BHrH rC&U6>&EDt AD:  *s &EDt ߉T뮰Cs_&UU u&E@t~t~|36|"6u66> k16$PHGr$2#>&ED&}Eu
#&]&}XrW>&ED_XBu&E@t~<t~
|3|V"^6u6}us/o *~ 6
u<*.u|*t	?? u=.?u=??um$<u Lsu
t ø u> t 
xo&>6ku	Gt2 s*E@u6M@'or&;^
w)rS .rG4s.&F A5r5ot'ktPW>&%A&
21_X7ou=PWPSV6>6߃I/HG6>^[SV e2p%>&E & 5Nr
>&  "N.^[X_ÜVSP662
X[^ÜVWSP66K2
X[_^ÜVSPԾ2
6s/#6>%
  :t 6.6,., p s= u ,."ø 6,Dt6w؀>p uыs  V6,Dt^^ 66~r#
y3 Pv3X>J usX ku>J u
u XWK d5KW k~Bsd.rs>J u*d;/t]@uke6D 3"sTS>`L[>&E@u3&M@@ } rwm rgK >&E@u3&M@V6,Dt^^!r~ r!wYs  @t/.r	 -ì<?uCXs/L su
t ø 
x>u23ۋLT2Du|\t#'& sP/[PLs[
yXX>t
js  : 4>&g&G&E@uV2&M@vRW Ћ_Z21s O6:
g6&:
.=&>cu9&2䨀ut  Pt
 #g>6ut
P./[ P/[&DC t r&MuP/[ r&Mrs
i. RP mt>&%A&
 N,h > ZP.PWĊܰ
fl
SR2$Z[r$
tK
 F
2_X6tP6&	EXL @r+>2&E6u0tP./[  t	t#P/[&DC t	uw:
s u
t 6&:
z   t
x?&Gut/V6L u
рpuL t^^6&:
J s$ > >&E t0&E1&E u&M uHs   QGYs>sânS؀>rupt@w
؀w[ø [s/#R*rA )r96d&N
&Vt;r#3I(ruBCKK&F&N&V)Ë>u/&EC t/ t:
LDs&:
su
t 6&:
ø 
y
Hp>,6,@>,G:
tK&}u&E
 kPHX
x>u:
u	&E|  &=u&6&:
4>,&t/#@<r6>&mE&F v~ L6,K 6kyP.sXXDrsr266
t<?u60&2 QKY9Y/ 6>@ &M}6<&9E1u&  ;3S8[s&=u6<&9E1u6>&9E/u&  C>&] t/p PSdE[XP t  s WVt ^_t D t
&mD6kD&E&M &E6D&ED&ED&ED&ED
&E&G@uf,&O@VL6vR u
|Lt6;t6Z+_rPYIu&
-Ü&HuH&#W&U&U6R\'Zr%2K)r^6>&Mߍ} d_>&] u t/  u @uPS&E&U
3 [Xs/ø njD>q  r= t.>+Vuu63'rw
rr>&E@u*&M@. ..Z.KZ2(rc>M^3҉TTE@u*M@&F ) ZZ.K2y(r>M^^s/R&EC  t&EIL m:
t
&:
 ru;<Ss/
L mB
ru>u	 XXX>+SuuK? 2lrԎ=. uȃ=..uH Jrk=s>J u.rZK2n'r>M[W WPX>&E$<u"xt/&Eu#%#&]>,@tt2  uta60tt 366g״6>]y# 6>l6+l
t<t_6>{_6>l뒌؋3ҋQ Y66tW6>]y_6l <t<t2_6>lu6j6h6]  G<t<
@ 35&G66&G tT
t_<tI&G uG&G&G 66p״& t
t%<tI&G_6>P*X~6>l<
u
<
u3	6" >u	>&e6" u>{t{QW{_Y}<uO
3>&E$< u&Et&Eu=t	/&Eup#r>&E@tQ
Y366[״6>]y 6+l6l
t<tXXl>Ë #&M@&]3,3Ҩ t뎨unuЋ?tQ Y66tkW6>]y~_6l <t
tp_6>l tB6hG6j=t	6]  ⳋ\~Q<ttX+c>6>W uW0rƎދ_Ãw663҃> u&"V&NsȊԀ  %rs׊K2+#rV6L^6K&N&F2R6  QP] XYt ZO t6u  <t<uZ&EtQuI<Ysgs&Et2<s)sQ&f&FS' t6u: <t<uQ&f&FS>v[6l_+6] <uP6p6(6r6*X&u66,t &E&U&Eu<.&^ v&^QAы&"^sNYu&;F
w,s,uH3[át&+F+s3ۣ3&vu &EuQ&M Yu|;s3ɸ! u&E&]+r&u
t ;sts.~rt% Y[3ɸ É> tr> tSrtsrWPSK8.RQ"YZ6r6^ Y[
_s% átSr  sl>+,&Eu&E5&E	&M&U 6>q  t<6ʃ E6&F :Eu;]u;Uw
;uu;Mw
6;>=uPE@t/QRVW+E؍u&N6>6 _^ZYt6;Xus&e&E&E. &^Ru-  ZPRȋt  3X>;>rgt+>	  +rVtGʓ&f&fС+ Ã $s
v3>F +v	3ңXr+t Q@YrBIt{r> t	rtp Ar_ts\rIWP-6.6K8t<'t#6u<t<uY[r Y['tr  cr>u&E&M  atk-  S&^[щ8jr&:r>&E&E  34>&;Us&E  &U&U5r3>&]&]5&]tUPQR.&V ˴ZYX]|rSQ6ʃ &F 6>w  t16:
u*P6
6>
;u;v6w  ;u;s6
  Xv:Eu';]u;Uw;uu;MvE@tE ^=6;>uY[Á uʋЁĊ2Ëȋ3&N2Zk$<u~s '
t:6:&t3Gt6{֎ƋK6>Ku6Ka t(.f sPH;s:&t4,&k䞍tt	t2tt~t.&f ù t&}?táH;t$@_ ;us:wrNsr2ãHÈsH>U6U6 "3$HH%&^S[r&Vt<&FwV:
us^É>2ۈsP^RZ3sH&F&V+¢w  ~ #>}:\t: r.mk#K>׹ < t 6uuk>&]I6;t@;t<:
tBWQtVSD 60
F
;
_r< t[^DY_s
6t.?.rE2Ë׎ǿK	 <.tt
tÃ Ў< u	mk2V>t;>u>&MIЎK  K2<.t
t$<\t <?uS
t<\t
<?uǸɀ_;u V
u>m>k0r
t ^|>KuKWQsY_s >Gu 6>L t&׌_:
t:
t>f
= u Wً:
tڋ>PX=++SPVQuueZr
K2tY^X[s_!=>_
t4G~uN2,_:
t:
t>f

t
h^
mk.3H{HP6k"$XVWQP6K>KuKku"H D tƃ
K t4uюُKXY_^6|66޸  S@3
 ǿaK2U~66v^MDC t 26L΋v,L>U]rn6|IuV66;vu~6>6mU][mvs6663ɈLDI66DC  tLI~6>6~]WV
uF
  =deu- <vu&
u V< umk|^_s_6:
u 6:
u0
66F
;
_rg\6;t]< uQ6k6.m6.k&mYuO66f
ًG6HG	6G66&'6  6ߍu6:
=u6:
 6&:
Ü6:
ty6:
t
6&:
6>f
^SVWQP6>;
E6DEDDHDD	Ã+Ǳ } tV[0
&\XY_^[6:


666 6Dt Du ڌӎێ3ۀu 3ۈ.. |&|.~o6>#x4Ў؀u&Ԁ褽6 =u6 6Ê
<uK6&<u6 
t#tttt DD' 0U  6@6&= 6u6l166,66.66.,l.,6&l
弰&Eug2&E&}u6>vR&e&
&}&Et@ZP
Xઆ&  P) &#yDt<uXX[tDuM&t&t&	u8 rUDt&6n6n6t66v6> t&G"D6x6z6xD6x6xBr2WQPZXP3XઆPëثYX_ZWQP66>w  t!6>luQRVW6n6>\t  'r
6] k66n6+
6
=  uRwM6
6w 6l6j66h66s 6h6u 6j6
6
6
6n6
66
66
6n6
_^ZY6
6:
u66+
6
=  u
6;w sr 6!
6>
 tN66j66h6
 6l 6^uVWRQ31 YZ_^6l 6
  6
grA 6
t56&
6s 6u ڋ6j6>h6
6>j  tfá=tÃ> uËt^r ^ru
rH+Sp[rQPU&V +]XY2&N2QKwsY&N>&MW3s_&E@uW&M@Y ⺡H@ë   󫪰
6D
D«3~PL mKыXs.ut2tu >3ZtHku;
x
uQ&ou$Yu22PQF>VS*sZ[^YXY둰Pt XsrkuPSV)^[XsP>&&E@uQ&M@.&F 5X>3.&PW)_&;[^YXrPSV)^[X.s>J u rr
y -rkt>{ uK 󥤠k3H3W6&D@u&L@.&F PSW>&EuS&]&]	[
_\ [X^sÊ>2
xG3@G
x6Vȭ
y3ȑ3
xDGW&E5_:
t;
DD66DDÃ+Ʊ  ^>U6Ur5&;N
w/+S6RZs[K2r
[rCP>
 t
 W>_X>&]5&Ut$+s3&]rsBAJËsK8Zrt6>>&M}>3s-Î.ۇ 6>]+W&;vr6>m á  ;wr;w2]r. 6G@uTO@w+&;~r6m tt&s&:Fvsr> sRS&F*ѹ  r7Ȁ ;s3C;tK+R&f6ƣXZ+[ Ã+*̈&sQ&NJJ6  
t26
&V6 Y66	s S38>[rQS&^w	&F  C&;^
w^r/u&^ Vr &~t&NڋAr˺4[Yrr9 rtR&V >&]&]5Z&~u[ X+ SRW3ۋ_Z[3r$t"RZru&~t&FHtKr&F VQUy]Y^MrS.[s6N 2Ҩu& G  t3t3󪑫t	 (uF  v<:uF,@vPtXs
6>tFONG ( <.uF6t   6&N vN u6Nt< uI<*u?<?u߀ڰ Nì tN6NKW   2Ъ_z6>Ku6KfffffffffffffffOnDDofS1<ar<zw, <r
,.=P X[SP XP X<~sS.[s$ð</v<\ð\t      6>!tQSVӎÎ666  662 ;6t2^[Y6<u6666  6 ^[Y <u	6>
 t<t 6>X t#6>  u66X6> u(.6XFS3C[rt<u6>
 u2J6S [rW&EtP&/Xs6 P$/X6> u_bgtS3[r2W<t<u6u>>W t&W.=!   &22> u#.P.=

X:X;&2u
:

鴮t

 L.=MᾑG.G.=   662 W&& 6>  u6u86&K66.V d ^×  u
P&F 6"X+R&fZ2&;Vr&;Vs&F
&;Vr6
&u6
&K&F 66.&vv 6>  tl6&6>tV66^6 6!6t)6&&&> u$.&&&Ŏ6&6!6  6.<r>tF<uL6KtD6u6J6"6>uVP666X^6K t6Kt>W t݀>Y u|2
*6Y"/"BYS60ۡ ;t;uP6>|t
U60¼ܼU! "Y 00 &. 蛭P.=

XXXX$P66

P-.=;s2$XV[3^&~
stÃu> &;^
w& r=u&v
r&FP6K<uXu  rҋ5tQY&~
s
 3566D@uL@6>x tPSQ$P 2]Xr>E@uUM@O&~Y[Xx PSQR&~
s3&N uЁ2&FIPRQ  2 YXZrW6|;u7x  B  2 r$6|ZY[3&~
sèXZY[X&m&F vy W&mE&F v
e _ru83HG 2&uE6>< &EDu&;uEu&;]Gu
&EIt&EIX.&F Kv.<u&fZ\]  &FgZ&v>]x2&fv8
u
 
&hyet<U&n&F]t&WK>i*>( u_<tn6>q  t 8EuE@tË=69>u&F 8EuE@uE  =6;>u6>w  t
6:
u6
&~E u r>U36z E]r6j>h&fZ\]  &Fg&v&vZ^R>]x)&F6l&F  6>h&FE&FE2J6>m 6 6>5 _PSV6m ;t ;u6m uDw<u^[X}u6>m ;u
QRٌ;ZY3&F > 6t;Uu
;Mu:Eu o;Uu
;Mu:Eu =6;>uQVRU]Z^6s 268&uJ] VWR6>y  tS6z t[ܴܴ 6>y  t&N靋_Z_^rH6MUm
E&F EE
3t&FE
&FE66  6>6> 6u6>q  t#, e68&"t6tE =6;>u>J uô8et:t:EuE@tPu Xr俉EXø E<t@t 6:"t6
m
]UM6M
26Kt6K EW3SWQP SR6>y  tQ&N6>z YZ[XY_rG[u_P&F6
&F 6
X6q 6>q  t6q 364鉨6  <uYBQU<v6#]kT<t<t<t^FFF V^oN66 2U6 I6& ]rF2frt
 
 F  F  FuTvu60, t?3 2uIxƮuW]^ZYstF3 vN rPtL= uuF=MZt=ZMt+FFtI~&F&EF ^D蝴PUi
]X66 6@uԨ@t6 )F > u> uF=s t@ w  r;wFur;w+r;v؉^>sq ~ t s F Ft	F+F- FFVVRXȋ^2
s^ r)^S^3QYrH;[t+ȁ s;^FuŋN3ɋ^3
sRZrc vt&F7JPQF6666bYX 1Ft-vFc66 6@uب@tԋF3z6t6@tǉ^S[F F3 sñ= v- - P^3ɋ3	Y^3Q^s;uy6 6Fu2F- 66  t 666  6a ^U]Ft:6>? t&V66@&< t6066&@ 6? ^]BV FtH؉FH؉ nQV<.ts2s^YiRv踮Zv&, 66&@ vVt Q\ 3Y^Vt
<󤫫^tɀɊ2e
s2Z
s-tttt&
 & 3؏  6, 606.Ft'66~&]NN&u6&]&E]<666>6> t.= c PP6! ЋVڋ ^UA] S+6 [S60 E[ÜPF	 F XtH؉ vά<:t<\t< u+I66>] t:&
t36>:uGQVPuX&6^YX^Y6>2P6|60s S9[rã X& 1ڱ26&M
6| t6|茠660D26| 6&|64n\3
  6$   0 r=9 u> =Zt 6 =t;sь @&=Mt&=ZtÀ=Ztr&9> u& A &

詮6$ 6 6t6 t6 6 36@6B6DP6 r69> ti6 t6t6 6;$ u	6; =ZtVsXU6>@ t 6$ 6; t6@u6 H[\"-r Z;vR;w6>@ u6@6>B t6B&9 v6B6DR6D +ˌtLюI.36?w6@r6B +ˌ؋t@I & M&&> 60 @[nH  Hasgr Q;v$6 t6>  u6   H'r
&> 	騟
t <t$<t2<t66#6#62S?[w66 $6 trt6 t) r  Z6& 6 u r  M6 P6$ 3&=Ztkr(6 u&=Z;u6 uJr;uXX4磊ɥХץ0TTTb<r<	v\60u6>\6<.62.60P6#鄞3ūS+r#&= t&=t&E u>[C蹫[C6 r6 6 6 r豜\|
DLXV蝜_HV GG^\LT|
Dt\^666rP 
:++ ID|TP%/[r騝6$D
6(D6*D6&D6&#.=&0&;2 r&>4 r&=uS&2 [.=&>* &;]r&+]&=uP; X3r	&=tCP3S[r;&= t&=tC6>&9E/u6<&9E1u&6>&E/6<&E1XX[r+>&=t
&E$<pt &r>鍜铜(r>rh3s 60&2 ;tPw" &6 +ˀ<u?Fw	  St}SہU]rd360 t
YQ
뒰됋2 64 YQ+ʰ60>4  u
U6 ] t4  4   6 2 [뮰r-r&As6>6&E t666,66. ֏.,sʋ뫋QYÎ؃6,6.þEt s<v
6#<r
w&U&M&E&U裙T&Eu
&U&M&Eu&E% =@ t=0 u޸!/s<s@u r
u&M
&URLT &M
&U36 &e&M @6#밋orW^ r
蹿&SQ[XrP60t36>&;E/Xuð<u&P^Xr|E t<uLC @dC <tP/[r	66& t	:ttP6>&EC  ,@68F r6HPA:&&E\ &MD@+&EI&EK&EOXVr&uE&]G^XP,Xrt-<v<6#6 
L 3i6 6P/Zs rV66DC  ^t6
u66@HV6#6rt!PW66A&EC @_Xt rDC @u
66#^6:G rSP66< X666X[UW~6l 6m 软t
D6m6lVr*z Vt^_v? tU ]s]26L6q6z6>6 6rt5r*]8r6qt6>E_6#/s)PRMu:uX
t:ߪu êX< uPU  ]Xs6re6r /蓣'/rVW[_^rV66\O rO\&8EtO^ u
ttN
t\S r>6uDt&= tG6>63qt,>&EC u
1KìQu;sN38u&}:u\ĪtQ r&=.t&=..u
O+ r uҬ u;sȪtN멊
t;rO&uðÃVWU.:ut:uWuR2vGv;vt?6ru6 z-u
t/vK~
W耱_IN;N s~ u]_^I6Z tj6666V_3rKDC  tW t_&= u6Lu_ 6x+6< u\膡66366|E6>6VWQY_^s.=2< tӀ|:uͭ ,`uư@:/IuPDkt&uXìouX2]yjP6r66>6s 6>666&Q<[66r
6>ztPX3ɉLL3yju	t$ WV_躺_QY6r 	L66 6.=W u[  66Y66>$%u
QMi6m'PQYXr3>zu*m,rt#rRD닋JrQ[Yr6>zu 観rذQR>1666^Yr6>zuQYr>zr662kr*t66 rQjP$AXuU
t mNV^^u3O&EEt\~Uȗ]~2VNU]s<Pt<u6>$At
6>$St]rw}6ru6m66   uE t>w6w.66>66666666֋Y^
  t666& 6>ur6> t
6  Ǒ6 u'r6> t6 6u[6 R6rts26> t= u6 u^666`rM6 6> t6 Pԏ6DX6[P6>u66s`X  <wWs_6#ؽV NYNv ըu&Et
/ sɡ麐&Et
/  SP X[sݜKuWQ! K. &VbY_<t.=>  Wu K. &V)_<t Q >3&E3QYs
\sYËD tD L
D66bD uVt,=^D6&@ 6> t D6 D u6 6c 3!`3C73 "fPQ YfXX̸gX.f  .f6  .f  .f6  RQf&YZ[fPfSfQfRfZfYf[fX[`  af`fas v    	     ϴ ״  &>  s"&>  uP &9 u&9 u&9$ tXSQRVWU&  F u! EN&  a
 ptk et ~~ }sH r@W &}QuOBz 
_&}Yu&EF&EW  [~ rBvW   _^S   _^F&D&E &D
&EFi r,	V  ^uW 	 q _ ƴ	 d ~ hv'. rW ڴ F _^_ ޴ J ]_^ZY[XËN7WJ uWwWA ^u
+r;GwW^ 
 [ ~Q~Y~ð骋+- ÿ Q+AVWQY_^tGY&6* 
 u
 u
&<.uN 0N&8d +؎ W G_X+tڃ+s+3Ҏڇu۬NF$<u<ul󤒨tÌ+؎  G+ t	+Ўڃt	+ЎÌH؎  GH t
+Ўځt
+ЎÌH؎  GH t	+Ўڃt	+ЎNF$<u<uk¨ 6SÁv[PQVWs 6> &=RBt l u$6> (D  N rf  v  uDŷ2 D  x sŷD  Gu rW 󤸐H 󤫃K 8t : u0	2 B  N: r H 󤪃K _^YX[þK  t	&}VuWu6> ˋ3&_;u      @    PSQRVW
 
 uJ&  =\rA=w<u7&  &   t uЫʃ_^ZY[XÉ&HLJ   >CSu->sDPu%>Fu>$ uu u6 
p  RVWø %Ȏ.b& 3j_^Z>@B.=...F&؎м 	::a :B<s:bȣ
J 6H V  ^3ظa ȣ 7V  ȫ2ëƫث3H@
  ^L662 64 4Dt66. 60 j6.& 6( 4t{D u6g2L
6F 26 F V6l7CC&V &vSQR&F6;6 v66 ! &F&F&FZY[^&v&^V؃!^~!FF!1л FR

:
Z3؎ 6
E   p @	    D6
   @ @ A    B |C ݡRB033 Fd 3 , (
&D&D&: m &68 Z.&$   Z   6F+H   (
Bں=a-=6&66Z6[ 6\ 6]  SPZwX[P C/<uSRC/.=ceZ[XX .= =  uM.> ur b	 = r-r(rka + <u
- .˜S33PX% = t PX% tCC[3Ɏ &     & SP 
 t&;u*\O\T\Y\^ \c0
>
t	
;LuDX[3&       & & & & & & & & ÊPV[ .<^X                                 B                                          

NUL                                                      D  D  D  D  D  D  D  D  D  D  D  D  D  D  D                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /                  



                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           d                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 EAAEEEIIIOOUUYAIOU EAAEEEIIIOOUUYAIOU     ."/\[]:|<>+=;,                          	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~CUEAAAACEEEIIIAAEAAOOOUUYOU$$$$$AIOUNN?!""S                  <s,S
[           Ȧȥȥȥ&   *   P  P                                                  l
                                                                         NO NAME     &O               	
	
	
P 
!
TVR2	UW	S
$&'Z

 
!
"2	#$
"                                                                                                                                                                                                                                                                                                                      "    2            "              !>  c:\wina20.386     6 u66X(>  u7
    p  @  A  B  |C  ݡ  D  @  @       ..b ..f ..j ..n ..r ..v ..z ..~            ..#y ....$e ..([ ? .! ЋVڋ' !&F X[YZ^_]SP.cX[        QVW.6g.>k t_^YSP..&Ȏм.ct..&X[˴<t22<$t	 p      "    2          " p        Q Y                   \COUNTRY.SYS                                                     
  /        &    $    , . - :     ,           
A20 Hardware Error
$666t萐666tQW)_YQ<t.~.|ˎ3P6&;E/X3666״6>	 tG
t<t_6>6_<$t  ː7eu@   p3_^ 9pu@3t$w@et=   u@   p3=  t ete%  
  3랸 뗋;AuIx t
Pe_^3x6e|Wjve  )junh@eub\tbuffers = 20
files   = 15
shell= a:\rompaq.exe /! 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ByڠۺTa+菝ڠۺTڠۺTڠۺT,*/\'YVl]ce*xݐv[C2EIX7 _w;(Xw@s{_q)q{ߪ~pM}YٛvO\^We2FE7kԄr;,fkl1)̏.IVmJk)!m-nJ`Cxv"C</ރǉc'AybMKz{ٲ(WzxK^DGFJ֪ &c&ɘuD fq[̞-Iy0TIdm2Հ1qwlWYWmŀ)pQr`nNPE`>9BѲ6zOu\Z=A"bԔX<7qtӤSnx͒;kH#E&vm
TS_=p2>䡉nӔn%բL$.Yi&?Nt=@}TT_\5^mTU	"+AI+U?51i,&?3ZOR*dIuQ#cB[=mTNʳܯEeҏ~[Md"q7j@](j3~C>r[v86ڽ?
Z_a5<i" 9Ifs͘FF	t*
̞h%seB%.La<'ȋ.PT,qC9Ӊܥ/s#3Q,l?e3C,#dtP0b%$1e%[MLViqHPE-uN*d1Q4HAm`	5q
.hNC؉	0@XU˲lkH#E&-FST$;$7b䦇Y"h.9IvKSߓO po(RF]%.#'t{-AAȱ
D#R/8?p
dxLNCe";({9gb,?eWP^#dtP hf{u%Xɗg\0A3:FҘ7DqHPE-@C(dXwc
ԩ<m+#1)ΫIhQRq׻q H+YBA'kH#E&F.PBv|ӲV^-	竕nȼEPkc!aԃ{$߯L	BQ蹝mmKhn f6UE<tJ~%BLj.D9S~uqC*&Qg^V5涕&GmW	MJjVn$Bw=B׈)toռMWlVCk'W11`AϠؕȴSOAt=s_vu;)a$#)?nD[A{CqD2Q7qf0.rSjd9ו wApR%cpecBHD0q~>iXuMVyg,&x0NeS5/`;fQ
O1=,,'v/M* #Kag4|Po-Z)D4"kJF;,YKpאLC;qČ"1
8l Sr5
bcEW~BP>S%$,}h{k0JuKVaAV<wiYH1Zj;mHW85D7CQ?Uo?Wݟ
ށV! 86pW:?myGh
n훱nx?慯G$@,a1PwNJaD.fK"lǊe`Sէ3jj|3sY#o$tb*zցVl8HG듃{
z{	e%0=i`Ϗq/)sa
F:XBll*(R:ZUzYn/Dc#FyezuX(q/jpZ%>K: k&ފxELd+vNڕ-9^ʁk틸-HӾbO\VT_<+Y3պLGlʥO.|儐WɗX9j*sֆҁ	
&dl9ߜjCs"@%*OWT>N0`MMr$wۇ6;O˚ې5{e
SX3t/
8J ~񋡍Hyp['k$.t)Ct֢?w.
/YNعd,7`wox{G2o1q!?Yy8ލVUy~30}0X	/~)8fw0 gy+2u6 3r

Slv,!X@#!B":xṚBqUܪPpzɶxۊ	oxJnJK', BW٣x2CG*ctVp/1gSP<Kn =P^OkEze;`k))v,1?#?mzyӯΠ-j\2~hA?Wә'ËoZd*Vq;L(#~n022dk[>ViJS-O1UZ1Ba bEͅkG]]թq(j99t<Wpz?ut#n&D5𫦰8vCdE'߅L
${+8 Jnt$	Z#
d*aV֨R&Sii\能}wUuc35N-t]bP38{6;##ڸ8Ͼdʋ_#A4b%
\p L[KA>W
]d>TtRh
re}^1{}XCHl@<Zۚߵ	R40H|Wr۪R'u #4LsV<Q^SFPбy$R$o@K*U( ,3O)'h\	_z72ORǳDvb{q)";	l[=5LD5LD5LD5LD`RN"H!KT7H`!*\-`񻑡`)-)9=P6; I6BƓRPQ5LD5LD5LD5LDN-3AR>P9&(9r$J>P9ִ>4>P9ִ>4>P9nN&.>P9 xP>֏>P9O&f<5>P9s!is!is!is!iִ>4>P9v3Џ>P9nN&.>P9>CUz>P9>Eh>P9s!is!is!is!i.-O8DLl%@Ѯ`
od/(?
N
͵l<`V+{L^*5}DtC=+gQP;2uynq<"%Hd:XO2+K6-YAds!٫"};)-,7jӪ`E{uu@}9~/I#׫Ͽ~*${Ddi
w +ZkdMfq!T.60
'6COF`vJ5M s_f*|NQT0&%9R]jk	e|K%
e˰)1ã^n9RG_c5k].ab:Q*AUީf\F~ϡySn ǂa$ 89q&msyi5ϥ?eɢ"\%eO+cļmaRڅUaE6)@'!v~iS+ڒ
Owi7Q4b~kO)BzDs59v`{omK^WH1y33 i}9{F	LiH'#ASd}hTp0jf&bbH)>ߪexnްj)e.+6#bO;
625 gfmLw2Mp{Ѷ׮n
Th0y@U	YQJG8߆gF"f\^wts6CJ4Ch}3CHwyD8h׆>F'A^n  }͟#rM-ȉD4TAS vLHK9(
j7ΕFWaMA68߆w@2y1;mhāy:d{0H1	;'3C$*fyC"ki'(9PZOo;~x+.b Y/F5dSz)Xؖ9om7ÿI%heyq#t
?Jy'\1d{C=vy'IIݎ"rۣ_p57o&s]dVW͐
y'\1dllA )S:/&a}RiƋ:!G=.O~6nڣDFm+_Vb3C*Ps`
ĖIÖqguv503DHS*$9=A(XjLBzn͖䢮m-'%ϓdj	&6X!l
M@<n uPuCPGeplv}W=s_Cx4 ާa%z*UCoec-@okSxZ't;FmFh!N[k`w/w]`´oa@ϥxʰzŐ!FUka{"Wrn9ԶB-=owjiA4rSRւ"	qkLҖ&\SƗ%XwsziWִ"[턤4F
L1JN䭟h"C&I4ٲ0!su0CL+'+ؙ~~>[B\|{ڧqs(52+,ŔxʱoSEm37;
oCpQrP&l7Sڇj!Eδ|~`O ,H%-=yl
SU}e^ Mrî_:K:}35HW{h}Mb/. q[sgԞJC.\g&%)%12l3S^ɞx7LMJ,7֫"z\9@GH!*g9`;yo x-
W"\PކAk<|o&2Tyi?9=TIn욋99ĈТ
Qbƻ Ϧ3XG5_^"cN۝'ʦ^ܿçE(2Gr	X@5E᷇&?3k\,U(h0'ϬycVV~MiMrc
2GiHv3	ar`~P/M9֒aONp댮SaW钇Bi}:\իӔ~xx8ôʁPvߠvg|
YFP(@#3 Z!j%VoT0չ(4%yr4J{q!ǽ,Sqk@ugeNIÏhqO	C%6wfa;
X
_l(Q*c !sd>倅(zI(]g+jk]yVecS:Ge,j?{BNwoն_l@1a2̭EVZi'tBqԲ;'xuvGkstS D7H'@
3I	|ǤohU~Eo(}t]D OU/z.B$Rq!7˙uxUws`ψpoĽr{#vhYS<PʡnS>O a{8r6-~ѓ}*EɺP͑]>~3dLDB:I%pEFs`R[0:<_y4$Bl2Oх86Y#l0//A`[$>]lO:vUsQ7ȑ Q`lC7w
*:hАdӕM@3iaH^k)sq@ȠE/($ٜrޫ~ښUHqF@eΠkŚˆjbTՑQ|ZV֤I2@4Zao5j$+2JEQ-{ы=.U%=& $0dhɋsxJaNX~iI?M?]vɒ`U($;07!|#)%
  x3ⴹ@	;NnT3L!y2.prH1M;;zӑ r;T@r\J8qe ք0@kٚ>?pC UвaG5RpBkIqX7x-Ut[ime@5嚞Ss^	5,@uuGSR!Mm0n&Ge­PFYZchwhsr<YC$
/?d[%1qDE \P;olP+
VzCI&qfh<kL=~=JbO_5^I/ؓHEKLHi _BLL>wcYY|?V Q/ni&XR";\_jw;>,h
꤬=ۂӯtW3@ݔz{g(	iLfx	J`.5CyF DʔFEHĠЊ8Wf
ih3)lʻ3tmbK\P_]r/]3>l('%´Ƴ	@IC1'$co#ęH6Fōܒ?Wx4_?~ykC8?=WL3UGuvLYPZ
 
?#Wm0$q{G\|YyCˢ7ª5l:=
#6lJ'mL% UL6)W\B<xع¥zW9gUYxy7Q^馲{䏉Waj#?8dãeR@2=dhi4Ѵa '(^-@Y&f {g6H7	f6co0uP%|114̕kmk:H`0K?,$y:$hws.y䦱L{ xDHDDv;VT"a[PTaRqWrNt|͛m<\jqUdn)>ץ˯*v-9r_tĪ=YC(QvPBԾ4oIMOx|0.N6"{e[`eS
`dJ'uFBZxn=J{ie
Y_8fK_8SlWc6$ܸ Eqwy0OMJ}:Jmvt&_9"(xhG~pYxF6oLBY]gMjtԷ;,ER^6	6+?[o2U;C1qS$ p   `      POST  f   f.V .X <  
 f.d ` j  I     '       8    POST3 | * F ʧ Y { G Α	 pt
 ) 0| )
 I| } )   Z )    3 3 V3 3   M{ Ǒ t v u  ! " A,# $ r,% & 1{' O( ) \*	+ , - 9. w8/ Z0 11 2  3 ^4 )5 6 ~7 P8 7u9 ,:  ; ,< ԧ= ,> ? 0@ ,A GZB NZC ,D ?{E F uG H I :)J YK w|L )M pwN 4_ )P ҧQ pR #,S T ,U GV W X *Y@Z t[ Y\ 9] H^ |_ ` Ya f3" f" @ ؠ   ؎  f{  3 q 3    U QVW.D7 PX' hX@s .X=X@u
_^rYʜPPSظ hcO [X /<t
PW lf&E1_X  fPfSfQfRAfGenu fnteluxfineIuofP%=  rYfa2f   uI!؀ ߰UhjBt/f00tf  
 p0fZfYf[f
  PRWfQ
u5p (t'@^Rf0@
u߿ ho8ufY_ZXSQW< os1
2
3_Y[ABCDEx} U"RVWfFf^fNfVЎ.< t ~.FuN._^Q	
H/@
		! &
%s
> h}3hp0 0t  Ãu
.(u	u/RPVF	` u tR	k@.)t^~u 8	t/} t^6
5
^Xf{QW~
,?  _fP	$S 9#0;r#Lt<
tw
u!ο ƿ	/_^p	65WfV*p#)6S
F f[tҋ3ff^ff[f`K.fa= ApCfVWU@ t  f7hD%3 tkfAߋh6 ߋPy'Q20O7
rg>Ut2gFYPQ+5X\Pf3ɕX f	]_f^Nf`Sfff@=_ hR3>+f;r[@ Wp
2h_
 WX
_: r
gN1
gw?r @99 \AVWfgfFfgf;PCIRu-g{ u	gf;KugCufQgKf3ۋf	ffY_QU/tg^H2N@?]" h fΑR   4]hQRWV^NV vq6Q3qI4GYGʫΕI^_Z!3Q'M0 pC8 YfWV3ff"1
mIfPS. ,.(F(  f(0p^
#N~u!h
s.  GFuQVsuR?
`ۀO2ۊ~f@xk:P`?tWuf@ f.(|ftf!f.@# <
uF8Fuf_ts^ÑGVR.>(s$0q	.k6(.(z

ZF(Pnw2
F0(FPPv2PqN~ t4vf2&fz10辽
FNNI.(HfQvPu@f(.;(s0e ~ ˁ ;u
t`g#t@Ѵ 8^rf(  _^ZY eWQ3.>(2 .ǅ .ƅ" ` P@hDW.(w `s$' ip3.(lhV o.N /p\wFk@"~ 
N~f.?$=6@.(2ɠf0/tl)u4.B$f<t؅fG  `b$< F. 
1wq3V@~r F F;F F2u~w
`M3~f1 kЖ lt
fN}qu
ffsfF^PB4)FQ*
*q4rF$<u&jFF .# ~ă$w/p` *.p< O<uIO8q^`V@;(@..(;(^V0&0
9t@-2x@2
E/^S 65^35#>'uBX:NЎu=P:
t3S9)&u=8N0;_^WV\SVR`Ffn *J[*!ffAyRfߋfP%߀`2fpʰKf;w
2|.fPRfPt#f3~!fD`XfffNL$ss4
tP7}u+q%
u	~AfFaJfୀf^Z6Waf F݉^~K"8ueffFՋN_MQtcV@hvbm!F;pI{*3ϋ~+c:tsRVRfQF;F8u p? kv@kF:`pb$$@K*@3frD` w;=< ur,.;D$<uπ r0	 @BvFfYZt4}VWv Ђfq|~|URd
t"tO_t ǔ@DvP }PkQ9SV ޾R3; t	 r^00kRː_#Aq[%S ^Y@j(*pt@;v7h!1k~o@st 1;FtFk^% Bk^cՊRa 3҃  V3k`[
*R;FuR*3]ft7w-k	%)	# a
@S
+FHu
4uGrvFvVBs0;~HVWξtS03ދ[^NuV}p 3ҋ0e_&61-Dr<lF(k_HpBHP)A(7oZE &0}V  ~1|\0PN~ tKv0YFA.Qz$ x
fpO3g FfyN@P@ 
0K SQh(	 \P,Q23If.` tf.&!. .8(tьL$QVW
fvUFp"`F^ߔ^F  FψF
fgFF ^_Veb"^`L`ЧZ!ɱ ``Nf~ tF?t'f`e 9Fv@f0
FfHf;F{yQr@-րi`bbbfC<W4RVFъF8F^ pVF0 NU$ &5(,ytN!!fqsШtE $rts@CA9FCvG 3r%if.(NͿ  `N0ƺ0 
t
F%  .p >fg}~ t(i'i_f^z e{u
 v@aQI8t%  ֝tu Qw  vfIft'fAff#a fp~Њ=rSnf.6 G                                                                                                              /                                                                                                                                              y e<	4@ @iQPQRa&hjc $`Ȱ hrZYXSQWa$a$a  h h >5_Y[2揺 TCwA6  @A Q C@@ @;uYð!桟$p ߴh
f`  诔 hv$f4gf&`   fa.-h
 
o
hsfPfW@&'_fX`j
.h	-t$b/hS[bO   &  pf=hs7,h3S@ ؀ K&}uu hl2"3d 
  % ]~V5߸W?-e'$@#h~Cff
qÀtf%afhC֔su h<+,Ⱥ: @p 3ȰS- @uSh3/hk  "` ܹ 
hb%R1` 'úvø ffPSf1DIV .P1
2]k[@趬%]  G й ~E`3%%aP R: }" h(? t
 4aPQ) @ PQ= `t
3f3p	@fYX _>ðd`5d  UP@ !eF  #ؿ
Et&0@ uM9NwN#uӃ~ t"F= wt%   +G`BXh.-   !	  : a `hW"M0t*u eJ<uQ>tPRfZXD(~f./~ ACf` f   `9G#V1SfQfRfI  f\%=uf?a2 ffZfYf[FSQRfWf_ZPC)af) 
) f  g&O @ fq$<s
hE}_  &8PA	<]@$f@e#M׃WGjE sFfTwf>@
 F R'hX ;s(Ǻ$ fޭ f^fWߧ0$
 $
ذvB
)$ w'`$L )f_Ah%!s^+df{f`)`)r) 6s0 hvfYrsg  T|
UlNmfa't5<t1(rf tX@  
Æ B<  C< $ # Q R ST/VW3 } @<D0=
` sdc_f鑉vU ǈуtR&2iRbb_^&tS    >  A  T h M e _M A@ 9 Y .   n SA ǀaʀGwc (
]р? @b+b{!@c N2 P f{3!~0f62f6|2D  3s |pRP 6p2>xT.wh5ӜPS $<t4r [! Ѝԋh33  k f`4 S  y6fh%h3n   D 3y "r< tpFs.2Ϫ"rsp.m .-r-. r%@.-&5&D&ENh.Aa
phHR2z ߿.pt~V|M/V,/~^ 
8
3
~3
_/^=ޭ
/ }m/Fq&@ U$=u&k/f= =u 8&{/&y/&w/)
, fgh  0 pqr  <ABCDE xyz{|}   )VV S#
fb1{x1|5 r&/&/6 ro
&   6x" /|fX@XCf߸  f5fx&PV3
Ê^0(.'t%.FuN.Pq. _XUSW! Q,fv߿ hS  R&~22!IN܀3d	^
u
t_NA&>-_[]f^_ PV&=;u&&~4u&^P
P<q +&~& 1E&DpSVߠ h@^[_þ 8`[WЗ?  <_\F10=ROM Based Setup  En?tering@8 `. u  C8 \K yt.߀@8 9 Sup)!`- W  i8p 	1A	A@8 1Au8qVrJp &@8tFò  Ut
.>	tλ.nP(*1t h;P?XhHrF12=Networkrvice BootWake On LANAttemptto %  ht8 09 r	 A9uo 91IQ	t ˽tvsR QP.9$<0+( 9]BEB"9! wds@C	%24ؾK<^s 7OD%ݷ VRynKkNF K3؁K?	uCFG~N0tG; hջrawKpvfhZ^`òP*Notebook hard drive MultiBay"DoKck!:b<#b (top)b?ottom)leftf	Floppk  US9BCD-!F :HDis/SuperN#IC*
!1	23                         t=P  	 
@
>(P 
F md @-r  pqlectZDeb]  ͹U8 and _mo@=the highl@ tp`your chob.  Press3w1bose.Seconds until au;atic defa A start: P?|?(?$P ?'@;S A;Zip.F`u߳ hs d0ô0.@ӌ (t8@< A VK3K؊' tA<v<st1X?& 2آ؍;2t=Q#YAr	 > P @.T?
*}V? @V?+jjj(Pj.:  @ `T?? z    )@a R 2җ
   t03X?2Ɋ F8tFޣhK $ Zbqqp URVQo.,.L.T^Y_^Z]S,.V?*[ݡQSVW/ s&Q3@.<.-00?00.Y_^[YQr? u hN = Dt0= t+= Ht.=Ht)= Pt4=Pt/=
t=t
=
tu;w`2҂ Xʱ@
T???r
;w2pT?Jơ}gFYô.*V?<ͽu2K0h3ޙ hh7d hb<u`B J qW5 QWhsfgf&2_Yf= TKStc.>C G, @ f  G0f G, u
hEG,f",f_fbo    ? o H  rRqphv$5`-0
g&Fg&Fg&F"t7g&F0a 1 2G޾D׎Ǎ~}ؠ9{ rsD	 k ל QRVDTQF r&e^ZYDffLo (]{L рYPVUfQWbo
@x
K&@
C' C$C]$ Frx  q#౑#详 r]" tsrg r70K:k;WQT rQ GC""Y_r
E@t]^f[XQ &C"u `"!3u!#,*ABM  f.FPS [XAu.6Ff.FIDNU.FSfV#CP#^35%gf@)3u
u \r5t!q!} "нW3 hAn [ ++hr3%5Ycf_\`= vG ߀OAG aP hj2$@<@XfPOfXPR ZX@ `.>G t.G.G@`GSQRWh@r_ZP;P TC r99 r/ u @ t@XR1$tut?Z 2 VV$ f3hFSWQR YuʀZPpq4=B XZY_T TZу< @3ɹ2 uhXdn#QT)¼ P% = @uXu%)4g&@ MxHRQfPuf  g&?t9g VR%f <u @^%?f[#   f{@"f<tf Q	 f !pfa d^ZY )V$fVL/
/ZGP@t


 
"
f^ff? wD Pf+%Ѐ
!
nf[4H2kq 3r 4 5R0@p <4	Q$  P`x E  O  LPy@`@"	  	P  	yitp  k & Atf &f0&b0@ p dp 3Wf$'Br"rst$ uf*jc>f0 tuc ~rh^
&o0p=C<thHRp}}0  Gi11?}4 Q < t&0Gf>&I
3f30 2ɴ*f&f0 uf
ffK1&
1&1fC0&1*"21p
115RfVWf D3ffCf[fKfS܃fF0r0а K I+r/_;Zf5SQVWϾ u3__^С Š_	!BKsV 
R3
t<^f~
w/vưN0f@;k۽d`affwt@`[^ɳ{VQWfv h#G-F&1F&{p & &P&&0&&&&1`^y Uȡf  ѧrX)Tu'P hlޓ" hhgaX`a؀atif]PRqQ  t%  sS feQ ffff>aQ?fh	 Jg&;  Qu70W)f)fY~/u! /{u/u/u	g&t8tx3	[rnf!ǂ Z  ;po	1/u`~/t r߀!}	 u;nQ5?A-                                                               10Ufpf.\Q`Q?u hNrW2rRrM`Qtf0fw 0R| Wb t#Cr"t p ; (PJR  ZR ڍf]L@V0r*6^  R ZrG9	Ku ezdB rC\A w3?Xy8E tyEG 	UgSm r	S>eQ	tClkQkpbAƥcPW rt r
  GC_SR밞A0Zt$oؤM$]WP  _W}  sp  a!`P
߰@S P  	ð D v S8 3 e WR	Ǥ!
gR'
//&QQWjuptPX_Yù
 d h9Cx1迬s y
2P -C<u4-u qRR바aR12e< ugZ#ȴ$ t	J  U
	a!"Df@[@KpG&^whZhaßhr$T/h 'JhkuWva { r PQW 0> 3_YXI9hbc=.G X>E$hars	g? KE   ! $!f` T hj"@u' t` h* h" tff%f
˟ ffa0vP[F? X\`L &>K&DEP&D >Ku dǙ ˙j@ tK}
 -}	 >K 33SPd[tS[@? 2[sDy3 t^h#ʊYs
JhO#QaàhLǈD
ϰ<DuL
p
E$<u D
@Q3Csd
{rSi&pS]@` uL
 6 6K u  (X6 &uhT
	\

u.0   ND&}?u
 t&Eb t

&E^D
&Ef߀w>Bt6j t.&t	&  t"& xu	\	PS   ? 6P'>K_3& ?! W>K	_[XB
t+# P xt  t  w\DPV!$!"桾tKh10&,@ &  ^X  hC!r!L	vTt
v`WU$z/! $<v_@a`n3  v
p
u$"<uP>ȷX\PRt P:1thE]!&ă=0ZXx` 22PEǿK&PCt5K=KtOu570: u	At!s96 u5 .]s
t!\&q s   a
׃/_3m cbs{&=  V P;Lu 0< ^  3f4G - Mf_  }0 U!    
M&egWʃO&MuO OqfGtM!tߴ$Ot, t"OGr ǾJM0oOg&$M/` 2%
<t29o21_kרt O<uLDHD =_7_D D	 d
z=1:B]tSpprG&}	r??23P3t`h߇a&ES$`	&Mo&]AH`.'	@[%# r`S UϠRnb0ZW&= uAF:%I)
hJ
 m_XP
pt   U!w#w !#`ފ|unhS0 Cc.-.MSNv=tI! //(rJMc.58v@Mu% @BS߿B 0h¥h aW!$
"1D ho3
hYp@[X_Ë
`PS@e![X SϲWH<vLR
 Z,<u(Rfffġf,ZJ vGu

W jS1 6у[Qa$= ;@aÁf3Ұfh!<`b8 {	4`֎ސw0h#u73۹ F
t):u%9dD	& hSK & 	 h3K3Ga!3 
3 @  K SٹuTu " / [J rGQw> r;fQ  w.<t*tR&' t&A+  ˹'z
z'+Q}!@s& 0RV|Z`|tpk hв YQ@@?zP^[Wr4fHq(u% = tR_0Y V*Q
@_HS3K+6 
HHǋwE&AE 1, @r \ \hpӼxxf1  ,VA @p$P<PtReZDAA]O  ZG>pZ^a/\WV 0  PhX@ 02)7
C@)2ƀưҀ?!C@u?r@yDt5. ׊u,u1 
@a

+&C323&v@t } %
t&
0 迪 5  O"   ( 
uӴ: 7/b!	^"	? Aw ^sPRWAC&A{ &]&U 
t ۀAi] _ZXr#3һ -wv2C.{E/N#h&_ '߸^ Y      >u  '3W c[ n0_4kYf#`Zf3fcu 3 Q>AK`[C:
(uBE&8Uu8p]
R +B&U
ZK!ؾ4kZ6fYB)%q_r hʊ {;1	Q(t06
  5Ãha~p8.
<t0Z`ێûPV#
@F^fǠ  XAKED
ByC I 8o
qqUf`` Fwqm. fafSfQf.kmf fff#fYf[2VftGf   ^mIg@f;t&f \	F $f^`2ۂۈfaf`3߀pfaPP3_X.>`m+ . P	_TACO Fr>  
!	& .\m ԓG%s<F	^m fFf.km  cmF.omf.>km;E.om@  tam߃ttYpbmtONp  D@SIVfB.f$;Vr?T%W B!Z\ܐ	i %Qf2$fP'fffgf"'r. p \m%sf@c .ffHpcfXfdf3ۃ!u+`so?I
s*"/S"Vf+f;wfffþ33RۿREgmVo4^q4'r44z$.7<10ɐp08333Ҹ  QW>% _F
3}5u'JE#a0 t~ 1o10 't
t} tWM_ } ,   F EF^V/ SV^F uhkQ`  &t Y&  
 < tr&\]p &\U  
&kN!d K
SR[u 	F@&ߊ $F^[_bF FY2p߀TV'}PVW}ًذо' KO! _^Y[XWfQSg跁 Zf{at
  [fY_` t =$PpnPu2MtaË6!s } tp( ` j &&E`?SRUQj@6^]Z V` jsČD^XP
~*?F
  t# b Q`l{F @Fxq d3duhXKu`<Uu߿ùd `hc4d & Xtû   h;ͻ& h<PhE'`X!$!   °rs} O
eh7F   tt 4  hIc` {tKu& &  
 ` h,s@<t<uuТ 
0u?1*7`P	h# 7Xht % P5 'D[%ys%aP?Xw$# ) )th`($} f.`?G  dm3 UDm@7G    ; Z x     0N@`^~#bhX1fF3.w% r 
\0ވBFuр~2wFd-00
<2wd8F w(8F wY NF ;t
 u@mF^Kہãw.~r@V» 㐂ÿ< f ff @ffRfP'f!N
 ffFf3fvZfFsfBf〶fЩ1 r9spf3ɰpǿmfAP  fafPVa3v޸rF3X

S,0<	v	,$y.[W ߈D`

LVb f s  f 
T
TT p s 	 
Sf_fp ЎfvPU#ړYP, P:Fp
uf^fNfVO_f^pP̹Rp*fΐVA6:ǈF@20hvC@ Ϣ
 ff  fffffXChq p  `90z P9{" 6 a*P*h{lcP, %ofPRh廒K2R ߺZP 캿 (Q * 4ff:aD0  f2MMShm   hoCɀhhSZ?;PSS@찋pq$ q!̰Āu!A stðvntt<1w(<vvPlEoh3_ ;P&
0
3q 33ҊtW/g.&;u;@s.ont)@)hPmt^؀a`2G@t03@ @u Ý 3[
u93Q2,;8ӉN 

P-j1rX?03Qr |X@{Y4SQ2P5'a&& &0hYC hsu}ɰ hS;
t[ Ȱ t
嘪ŀv#t̰j,5~-PXv8v&> Ϳ㟸`t`_P3 u? $hóV
#RV貸 `s} uu22hSgu]EuXP&
wL2 }Q޻ hNu= Dt= tYԀ'
Y#Yй.^Ze[1XP #@]U  Pf^ ]  `rr	 t(afOLPH      @6P0;V(e
u^V- ^"(P*^  2oMqSP( 22 pX[úB  $@7R  Z`7              |zKtP( % $ 0rxfL+  ك%rSr$rF!f+Df+\ r*Kr3w r@ .hG4Wfa2 PR3W0 Z@AR `&Fd??uhP&Xh$ r.>.puO 	AїQRo.@h f3f%  f`YURQSWF^
D= F\ ^F \މ^t
;v F;F
 < uWP  <0ȭ22 IF t «若~u{빠% 8t
` `uPj Ѓ;}
+V 
N JZ=uANc
50:_[YZ]`P 2&X&}0`PQ0^ kPY@vUkPk~PR]]]/?              $?`ރ6.u;v` Ql0 >h *Y`"QwLQ`f&YCC7`K (   P3YaPSRP3@mn?[`H@4$&%<?GPV 	 oپL <BMtf35ԲP2W X`? VFr
JRU3 fGenuuhfineIu_fnteluV=sL=r=vStNp f   =   	tŀ   
{ f@3t# %t5ubfDqa $<@tS<tO`NBH$_u>f=Pۊf@+rCtq Bt#Bt	ݱ?]P0f
af_f6` YL 6(h1ރ tu6(f.ff;`hĽr<fA^ r \W3tt_ ;`l`D trr	ЀRW h3P1t Z
xx ~؎P P.BB <t BB2J &ݾX   8u!@`23
ShUSt0` y aut0i at]U U[aSR  4h}p
 hcpZ[`-1Pٻ  h:	 ht
 "B𖀺PaԀa$8uXRP<u;Z~QrtwvYu0ѹ }R0wZhEU2<U p\2Úq u
3Ҹ[ EF۸)v upQstyT % 9 
7( Pf. UfQfRfUfVf@Hhv$: rsNrL3f. ff_<f^fq=Yf.>fMgffgf_ uUYKU q\ u, P3	fgf CpkIfAgalf.#f9kuppfY'd0    /tp ];7h 8( Z9* APQ hòo  h߳" ųeЪ } QV3r@t z4;F ;
V3"/fUi &g3  f% '"ӧ #WFfF^fa1eV p @Z  O
^dq[3[< 﫾  p DTDw R Po 0 ȳhް  1   l ߾( Pb @0 W HL P`A T W Xb, `z
`! p@pؾPx o A0
|\D`QWhC3 ?3_p 0 PQ_= `tq1 @0YX 05SPp
& p  ff& X[@a@"&    ir  v1~~@Q  Je+O fQQEhv#2 .w/ۀ  Dߥ <t l~ܥ tq.ri."D.|u.:DtSI  wD:r5+s&zv
uAm
c1PQRfWT3^S
fXÑ2a`2	  "	f 2f@0f@R %  3f3fPaX Ah lUv ڗ fpb #&f fa dD 	h}W"ϻ (;sQSf  r/`
 t޳
2f'ƃ	40q!a
 Q[ffY+vf[Wf+_f t%ȡH+f@`h0Qpgڱ- f@kf`0z q_L2_&Uȃ uZ=PrUf%к uCf*f=`  t0  t( fu{f
1"0"fph2%/$_!"
 \\-f g&%~޻f2@t
 <t+p} g1~wf&f   , Xup Lr}fɬBt<rwfa&'?rfh԰QՀÉ_F?7<ܣqP
  
"xa	Ub	~p@2BOuE1ɲrcAމF &Ff{ t@sf @{f;~t	uɁ~qNїV&<##`WfVfPXfXcr<wf.Ǘ0ճа_Ѱcf@&tg&TfVR3g&Pf0 `&fnu=жtsaNu(g&fVffA>"Ȁ.f+E)^f^uS2u  w & PPܰ0Xt'vt
t@0r % r/o h<>u 0ohrst-3&>}rqrRPzsRܑuthX$uul	r` 	 +Zjj b6uPS`` FF ph rou
@ Ѕ&f  ؀>t !$!f$< uRC  
N<2<Ɓ	"3]A'y@h[u TYP=t 
u2Ɋ،в3`t<u
E< tȵE$<u&w ï$tRV[L  ߡN L Nڰu û` t  P[2u
@j jiY!(!!2(<!1ʰe$ h5u$0tߝ$~.#K,.t4&^ t<r&Pw 3.\  5!.\e@.d b    W	x .|h_DuQ&~% ߃t P讪Xӹ
 t.:t
 ._
vXP%8Xr6%_ȸfc4;La    PJNL p      QKOMp @Kt  Jt P(.DGֿH h2h fQ߂ h҅ hE Б?E^  ` f  Cp m& OE 
v %&Mt&:
&;r"`p$t1^TKub 
HM` `(q p" sr#	cdp&3a wC 	H ]r5r`2gpjh!/vZaVRQShY4Thks4J.`B68u,2
t&62@t2 sk ޝ[YZ^Sû Ph3UX<?tFhHRUujjjj P.: &h}#w\ h)w$vbwt = ;t= Dt
hEsp[w@WVS$`́$
[? @n< u"*׿OطhNt`-->J=Ot1 0_ tyr Wrh  S^x1  0 hL PͲ5[ ?  :N2?Aq%  	
   VFPgbǋVW 2_2µzt"@uG2 
u
2š ϡ
 o2E2&&ߋ&EA &e?
td&E&&E E &E<r&}	r@ VW^2۠^2*à
&}vPu߶haVRPRQ3f 
%*t,AYZXRPSQY[XZh?tuO	pp }Є> qQ 5~rXYj-: t
z*֮hCRL&&  t8t' u a,& nWHq00r6$^$ Z& && ;`Z@ `dde`P`  X#U @>
ڹ  .笋PB B把8uG` A ; 5䋀/䉮)@#;BS 76VŜPX
 a@WA@ B C W   ÜFtV$𻰂%Ȱ%<;weċ X؊<wM3ɆQ#"XR߹<  YыƊȊĴ3ЇуsE pY8@C0	 FWYuF5<uz`s0Df&	2
pu8f߻hNePӀk{ 'BԬ@. ,".  &k ~!< uf& b$
r wAu%1uhk2$ݡs}Pf  f#f#f#f#f#f#f#RJfPfSfQfRVWҁh^KfKff
f\h$\f3f3ɹ f \f0m f+f\ ! Ku*آ'3ہEsV4C\`b a^_^fZfYf[}fv3hI 5U{`2K> 揀L0s< |&	3ytvou4PPs 6-t
s#AQ}KBC Kernel: xx.xx
 `$ pK    t?  .`\3۸ 2ҹ%&@GaaÍ6lhygpVWal/z_^pk` hΫ$h  uP$<X5&sf @  t<   4 |r	.$<u
 f3hh.  
d]XiJ	h==  tdbw_3s.> Nwfm tghtC	
A!U2 u@? o > ?`c 3Fd@ e f Fc~ce@7~e uQ@C9?  h}`5
P	߬~hQBFe:Ffu1r,
 h
 Fdt;   	:  <g hƿt5Lhsh`!af`7UPKhu>fBpSCA[t$û N hD&Ng r hPf0̾   F^P XSĻ  y ,    hb-[t(t@t,Vj Pj,>" ' À thtZdúߋw."J**ED/.EqEq+Ë؀d/VU2NfQa dYF :uE]Àg33t
t
u
1t#u
tN`2t"FF0u3! :5tFFdz ulmb9p`F:_ uYeb +u"<6FO1 ep0Fff`Fup  0j(j	R"	aURhT2   1 h:rZ]ÓoR+Zr@!  toCgRQ QK.YsY2$
 !u$0dU|Z f`3 ; 3uW fIu.&"^f  9Chv#B%
>C ƀu8u.> 1fa
ZURtLޱUHhlxk:Yn Yp to(tq ;CPZi@"gހ  squ4@VfRfs恎h󊿋(%0;^f[r]8" [ZbhTr s 6Sj@ 2P s? rG{Z5'_UqWqW`.uQK$<u:ߺ`pr"&  t  tt> tAt $uPq9T(
ː

 K`XSQ 3u,S?H[rE	ˡ-ͿY[C& <ff<Ѫ`00xx00`{||	>>.r tr~ (ЃrL]CX̀'tCVG =`zQ<Q7WO &TZs6C  E 7ц߆ԆrB vzuN! D $/u 0/)0/Wf#-&A ;q5 F -7f&/pR0W aU쿃fV3vCDPDQƇD 7@4f^]&߰໠QPZЂ wPduXd@I(a@ `O` ͟/////- "  @f%wp$к FACSPZ DBGP4BHP  0934 A!  8 ? APICZOK	ma	q
@  		`
  MCFG<	P	     :@(@
 2!~ RSDT(  (	f`h;{hG%ćif  fhзpfp  gfFgf  FPTR ff0Wg߈FpfL.0p^$f3.;.8f.4fgfN0~$f+@hpJv$~3ffgf&f.>f(.9t822@_~( N g&F	f P  rgfffff+f+.{<
a@M.>0f
$$X#DPXff-qAFV3g&fFgY[@ff=TDSDt3 St+Pt#SBStf=CIPAtf=PGBDtf=GFCMt@HбQr< uBONRUfQъ̓2 tPpx@rAr} v; tg&P)XfY8]VfWfV*f& fP&]ؐ@(#f"fP)6Ȁ$ 4 
Ȱ ּ
ff	Ohcp (fq t { hhs~fPW EfX3 vdZ$v~c g r+
h2<pFpg&h&P_g  PSV89 ; <4Yt >Gu	<C-h : uDb& @ uޠ  D` ^ RW D ho}ɰ _Z!PSWtSǲfP3h f&L (f( B{W(`#L fX`	(ߴh-" 03fpep&?   6Lu    DOG Mfۉ3{ pG   U!   $M>
M&geE E puMPM~LGfEtXAt$Ot3 t)O$fM
rþQpmMe&$Maxs|U  r.P]h2.<fko;   k} ݳ ktmWp_f
Pǀh#6k0kf$ttӿ& t E'뭿o 5(PL)io_ԜVΎގE^3f`FF  hw }ur hS  $g(,0w4'8  s7Ã9FtFfNA9F> h4:ɭuh(fa`󃿿
Ew13ɊMh$ӯt

hRp;r#uazc5WF ^SCf/ fN^Nf.9ߗi1u m1tc` rfߺQPH_Erf;^uf;Nt;ft) @ 
tF~U_Nս MfOV t;6).<t1!QQh:,_,  ^_U00 u,h..D+hXك/ p1_fqtAﰑ"   u
3   t'0gf GhECG$L<LDCOMPAQ PC Card Smart ReaderLGEMPLUS GPR400LPSCR CQLB REFLEX 20Q241 PCMCIAVReflex v.2$cr$HP
  a@Z!g&O@ y?Gd `P ߳ rLfK s该nr>G	 .D
A O@.d.D4f_ PQW¹  
G.g&:uG Y.  _YXQ8t *~F 
v⡤fW
"
@
@Bzg"

%Qf_V`bSh=0Gu#{  euu .u = Ў~ 1rp&tj  t_& rT  r&= us}0=6>
r/6r4.ߎ؋V@< t ^Jv 
w x y   h:Sh<~z n%ZꕒhCasia
qTrPqtI	f| ?e
u ߳
!tQ&p;s	GYV
}  ,`؍vfD   ,AfLs-<t(<#@06~ h	L^PRU32t
t
u
5# t u9<0r<9w/tM>ư~7SQ Y[t>"$,0>*SQLiE;f 	tu]ZXf`v3Ҡ&&h#G֎fv*`%h#Ýgf9kt0Xa` 2 ߳  0 thbq egf@ Vff3f"gfǹ F fxf!o
!޾S3: 8tCRP #ܨt rv1hf uf@q  00i{? 0    0     q'  ' D 
 Y/ b%bk`oS@GY k6Y1PS_.痛xVW ׎Ǎ~Qr&} uBr	:= v_^d>r5r!"r\E@&=u	+#PHr&E$7uZ5Ýʿ]1¯Yӆa
cr7&a)rI DTtr&eY`4o5Z0
T3
+@Ua4S1r#@itct  t$BffL  	] 	6WQ
Rn3q
]
ö˿e1i+W!z Pjr8u`_QY_ þaL[ r&UþGN>L螳`
Pw4$X` $2L nB}0<tH`8u6
uBp & DBlTt
aP 3 r/) r%BsB!J@ s
; 05 aù<t

B J{ 2@u8{` BŅI2۬2Pu+BTl&2]Q8uC\u rq@m ri~ racñ  tAc rF n r:i r5&D@u-&a$vQ> Yr	2/Qd'YB@Aq BrM^	 fMpb3׾S_ @ P`ңPA\SX} 03  _YPSWQ3 VSVt
KVt2Y_Q f`j hb  H hS7iwk hÔf% ff= @u [jh nc Sjjjj P.: g\ h)[cuq?j&Ҧ^$b vtQ= ;tbu= <t/Eݳ9 hZt耱VjfaÐ     tH{!uu):p0< u}{up@ z`}3pr! grπ DƆ    rZ ׃-߄Z1pg$Wp_ǀ uu' 3a re+o tg	%  .f  f tΠp-Y[}r_s3hƴ \ڻ Vڻ> Pڻ{e F  ~f i `] tIU6r=? ~ t@@t0(5(@ MF t w0ɓ3N !F ~ tٳ	e>e0ﰦ
SZAt9A`jEf` Wf3Q fY@ I\xL"
 /2uJp2:!&= t: I r l0VQ&Uq
LsY^D^
UNf"A	
fpq
&:!& :X.ۋ I߰hBB 
D?5@ (3 ?;  A{-sC"7ups1+u[	q	1D|!IFt$a3; 2 + fB \	(Nf@2Bt1Qr$!$$
7R< !*ZKt'>
QVJPf^DUYwR.&++t'H"`Xtut.a:``s; 6sb3ad_p_pkod6m(ooo#e'qooao
foacםa  SAMSUNG
 LTN154U1-L02
 I1
Col?or LCDO4X3@154P  Hitachi
TX39D99VC1FA
TMDISPLAY#D EZ0CGPhilipsLP	W02-B1K
QUoANTA
Q0T 
OW01-A3K
              @Ȏ؎6+Ѱre>o  >؀ 6@3Ҁ1ABK k 8u+!&E
u
- M 8u
At	3ҋʸhlkPW
 
t_   @ك
_X7 
  I    SETU ˸ @؎&м  x r' hW@ P& u_SV  GG0G hc    Gu Fu t3  hC) 
hkBt & ^[SO
&hj" <[U샿VWƿF F@     [ F`D2ED2E
 2E 2E  2    D(2E($
f&EvPXuafa!tE/e.a ƅ @	<qt	dR>t <tjjjj3P.: '.wj5g$<t.<@t$t = ;t= DP hEJ 揿  77FF~ t#^FLr
F FQ  ~ wt: ] ?f
 h<=\2%PFAx~ t
F`_^Q
h8ss.&udu   hb,$?wط h*"h| lB/f_01Fh˗B%..  @  Y(`p3WVe1E0E.WV .^_UP)UIQS6(6*`e1E0eEE.U s@ m2a h4$e57;$!<$:a3qr  utw
t1w
tQCPSQW33۹ G&./N__Y[X   sc1@> @ p^ B~  (xsqUmf* %  < ! 1C  3	 +QVW?u% p u 4  | = <tڀ ;@C
 )(_^Yq?RWQ` Ê uUCrr3ɺ ڑ܋%ZAB rN _Z1SAWIpIyI
WROujvzKMJ; DE<@ ;<<݀!<3aRu BMEM0Nt
Mm[VfPfSfQmPnf3f3nPn<nXfffDDG(	Dh fYf[fX^@t#*IgO GoxnQRpA3ۊ9 r Cs7wB`s@zfDf3ۋfË\` 	
C  T U S V 	#	7	K	Y	`hvh  h	 h#	 h7	 hK	 hY	 avv.L.< t)F.6%3.PF.h\[+V..^̋] zDF. P .h<"XhQ ؃4R  16W  0"Xa Y Z #[  
\a a _nBA]a f g'^a b ` `hcij!k qp10G pppQWĀ>tk		 u	k	.s	_7   O 4a9Rһ -w C.=慏/E2VPm?n8o7@W3۸  =_f^߸^6_>QRrPS[Xfh)(ȁ`fЍԋh
3     p     KBC  [m( Vn   Q LGB=   0{+&!	!$07/26/04 Copyright 2003 by Hewlett-Packard mpany @ !`t` T`   'p~}P >""!'DTTutu0ptwt0tWtA"# d~p=PDD`
=t
@t	0!`#hTDS>0[ts"rD@(tbbD	T'T?DD d	%
m"pttptD
uү1""#$%%#$"P&d*&&Ô
@%%p$"2` {`ЂЃ u up3 2 
Txu. B/q >$4 `Op" 4{ 6{6(
"  "z|y}~ }𣮂s
 `3 @Cp2`t   +,-.p...-0-p,,+P+   +" ~}|}^p"{ z}!tuƄ t,} |tl$E%P '%($('&$"!&3&7@&%ӔP&`ӔP%/3d@$d	p?1%u(w %p&u* )**)p)N`.(('''PTuP%&$ Q
!0_
	Q
A!D @1((s[mcx2 8 @A,0 QM" qt~ 33B]p MIA	=#". #"!>q v"ST"uPu4"%$N4,tʎ"0"
pXp"0"_d   .5t1Tt U[5"++/ÞP.%@] Sp`A@Y1͹{m{ +u.!-..}3-N`I0
,3 
	,BSe,`C"d`"}7ti8"@q           	t ;	U   09/10zC04/28/05 kLitSe  {-1|4?|6|.TU"x#T[T0	ϣT@ 
t/{3" 2xev$ÔdPx>0@Z˨"2""Pf("bx xd} @Suu u	`	]^@)!T$3TD ȃ@VF @~`T?0	Tb`T%`@pcłŃ 瀾xD¯01uү0d01"xt}ി
~0"x]vvuu˰x!Du(u)u*) + 56FJGFuu!
kүx00PVl)}Dxe``
$`$p

xb_
xx txDESxxxxfD@/s}oy}}r k ;H}d`xGBF5&x}DoQ¯00xtxtyuup
*~w}iQb}ps ~aU}wc+{*")+xjD0m0q x^Dx_T_xcD 
T e p# ) ,1_U
-&0{!I	P1Tx"p2xp3T0/}/א}@!T^ ^$ u!`	T`#8 )mI04`hb	рP	;G	¯"+u+$4?iq}T+}'ï7+p (++Ô@]Gg,+G
H
0%1vP7",`]e0/}@j.@ /1@'"  "+7x0&x+7x_`t 7"6}

P} }	!	  @UA
xPxt"xd}<}?!" * /}AZ#/00x )xh`xi  p~ 0S+;.TB+x+¯0))0b 9P4.+10Bd+`xN	+ xTx !
+:DTBKPFp y+YP>

pB [Tdp+$!$P+-` 9
Q'` ~Ô2@VD0¯xx7x8r x008`6%06 @T߀G`	p>4UOm49A@#ZRZh120)4"@W@W# KWQx,pTxtx0x,Q?OC0xT?Tx*W-tx+XZ >?TxYYL)^ZLL&	Y]Wj`q!j0Qux^_DND0= +>=  U/>bgxdp&b]	:<Z~?h@jQ@*ARx-	+_SRNx*SMx+` Kh `R0 
0oeQ`
 RWS5PP1 03X 0Q]pd GX7WxZAYAXNSXGW> }X$R0Yhp^qZ1ZTpL[Z1±
Y'Z[l0c1\\T=0Q\
r[	\S2A}; A}A ",A~L B~N  5A~M uuҌВ">4"7x'D
 X /7d`!7g33TT7?O`C`|`07`'`2`=`HpQx] 6uuuu0k uu0 u_u5ˏʿO$ƨpN`0T`
0100@A"| }(x]@C"+,,E+p  +C,,+ +,+x,+0@qx!,,,++x_,,"-.T0㧠L721t
!Mt&Ipd `1g	11![txU!Ҍ(0響/0mp/l`
/0d@TpyE2A.-/0|" *xc"+xt`
o3x70x8W7tP}0h"[ZY
YcrdѴYZ\]x," -DtF)AG;qs=1v8:Bp#$W@23;"xy> !
C9./0H*5,7jU?4c~J;V~Po|ZQM}_%]	`
eI(i[&b'g>d\af|X6h+l>}	

!%)-26:>BKS[dlt|     & % . 6 = > F E N U j f 
   $ - , 5 < C D M T [ ] X   # + 4 3 ; B K L RZ  a  " ! * 2 1 : A I J Q Y  ? ) >Wg d  FApqIkli/ur}z'tw l k i h Ju s r p 9 t z q { y m Zc v v       
  	 x O  ~@ 2 Y	J @ | @ s   ww ~~ r  "8x4D` T ` D)tX@Dx2t?x1tI-&%[0& &xpvv ?&xp[CSxr#$ % % "2x1 	  ¯0 $"@K@3w#b0"	Mx3C
r beJ"xqF`V0 p1#" &	x30$0%<T{`P#"xr`bfp
0"$""tT.4} 
xr$3z 
`Hp`p$S$ yrp 1pxnv"x~0	D0$ 6Ӕ@Tx~y}D"0p4hsxlx}@ DT 0s
 pcpB"pxt1xux|"xtx}xuxx|	"xw#xmvPxyvxwf`Ӏp'xw ( Qu}B@
"-`a"-Zt %-uo00ptU0/0b/R0X0n..~A/U0`O	U/`!!.-[/0/0u/ u/0/-.P/0!d0 @"120! 
0
0!

"0!U H U`p$UP	<0
`Tb" ! ҿR0 0 _ZP!112n!1¯Fpox1"u FT@""3453М/:-N+"3554!_Q0"0!xno`xaT`1͓xm@)n柵v@ *r 3}TOp0@0 0 
]):!00*/[mP*'2B`P`CӀ!7 "0a T?2u$407S0!{z}yD2378
u8 7+
`8608606@2$Mh'ѫÔ@]o`p4Ң

$Y	0
	@À{0-$`
$`$p"Daބ"܀V4#߀K0! :0!@À-0s
   is	!i~2!
2xnf Yo0*2d?|p06SU{zy c xov@W-%_`gK6P2 ( 	4  =B p;H	5345q3`~	t%5544}r	@ :0	h0"06`	2A[06< Lr@1pk 
  
 *90 B 6, 
j6	" !!`BQ
p0( 6g"B^ @
-NU
]D7U 6.
j'	
pbG+6,y ,y=f-e2pO7)0	LoP85p
y&0y		ay	0
E ":"0y8;ofpOd:!/c)P3
(.Cxm`qe`?0}D h,g,!a,a b}e"4xMNOpxD Pe4`^}R Vp0
T4d`$"4#p~}e4x_d@ 3 0
3 $`3`3$`e$`1$%4$`9$`$`})3H$pvA?T ࣫nq2c1[0TxvF>&`!	0,0)%j pDx Z30a 3\P)6P 	@R核?&g¯4`@` pGTQ`xj  N*~0/.9xv
xD}O}&e0{^`
}iT?Dt?8`PUpY9T~:ywOq"[@`T`M	0676$``$p``1e7`tg7"r((b)(0'0)a a
Td`x0dp#  xF 0TÔP
P*~xFt p[xBB~xNNw}^wxJqJpȏ:;_<t/?=(x ү!:%$t=t=;2(0 (=$Px`vT"` 2'<x"ү3y:; 0( ;:@ p0 xv6QxV86}'p p 7  %76o(F7  ""88Ô@0p/p0 
(0 /..d`
&~r7(TP5O( 4 #)4 040@O453``/`@$pN54&:I&duP2);P [x 
33oppG*L2Z>gp1 ';P"ސT~ +׵?T#>үd`pxHo 8@22P65b3e1@d>"01h/ 
m
`,O0xA%30 B1
@
 0E00
TDT@5q0	 3:@a_ AP}Nt
 u2P2bt߀l@
D0.
@	  r1l0dpe`30!DxF105@2`e bC7xnu30 0u3r2+(t1123|#.1}p<0 $32  a<0 }
1pAR ErpM"^p  d..BS)x0,u`2:E,`e4 2UU.X5%.?,*؀ 2732pha,
$,PO!% *R5 }
Q'x`S+0	+_P L-R	++@@s@`p7v@}	 `@~A0y!T``;Y_` VWy
7pDxp/)~LDy}?N%@k53.Eop;OCD./qXċTQϠu:93: !p	S31B3dUA`hy%%Ovtu0QON@pH R/ N9
d.0
`_0kX6Fp0X-64Fx0570`5#O0]c6e`	S8@1
!b-1ÀI%P/;u1
p< u1a1P߉*C{p4z5z5
3z*+yuv {| A+ 90& n`AT0 +	al:epd010upov6o,/-.rpF}}0
~P/.-rdct%,f Wu tq70YS 8S;_"W4쑔p1BŐ}BT_0=+_<I?_`$<p:T0Oő78e`pYלBxfSTAx`%daz0  87>P$4q"W¥A3	``"uqq
r	1Q`{0
+}
9ȷ"rdP9$$P6"{ 2^F}&e
'AChS4Iq}a X@apR`pLxpG3p?u]1$U^#5_`@TU`#v@|T kx{}Lxzp R{xy PxxPQxwMxv0Cxuxlxtxa{xs`xrxqxxpx`{x|Lx{`RxzPxy@QxxRxw Cxvxlxup&xtPxsxrxxqxxp"pxjv00,pTxfL@" -4j0-TkxfQf/^p0ᒝP -^ ##-{---Εi C?",u/=212B`0T-21Կ^ L.P.W 'q,Đ/$=7,T{AO-.`\۷pGJQN.E[.NJP70p0Y)p'y0h&
P5
Ps|?`d7]k}OPn,rt7ar[4Ng0`a2Еf
p1
P

Q "u- w09r"l  },n1vg9_,  A3.0Q2O.pM=1s0D@[dT0uǀ`zP;kDS,c,u.B.t` 2 p0`u.Ta2C
.%TO]лQN]03p	 `` 9a : b H$ :_)NӔ@6S ? x0!  x60HQq7prrqxvWU	Xu

		0
  `
7P"q P
G1opTJrAL`>M)60.T`@}~w}S?AP33TBDWD  Axj6"]@t7 C9xVxYFdҢX\`T`HTǯ
PM>@C!3"x)"U\]@0Qqڢ97F 03tv`
pUr )J'' 'BpP_P` qmw0P `	qPa"NO.eB"TO=EN Є1n`=G젊=9A=9aYpo0:BP e0!J.I$:1PJ+1,F;KҠF	D0c
^"CO`@"HIOv30aA!Idp l@0tt A2bIBdJ``JIxnvHI<T"xFExGFxEGxFt@0( FT.`xFF0xG@Ft"("߭F?3 0 G=h"xUB!C!A!B/)B*( #UNA
OA
MA
N/I
N+)D
J*aKaIaJ/iJK
I
cJKLMd`NPT&` v0uK K@ 
?MLtS QPHKJ}i}p}~}wEAMI!9..Cc Ô@"TxD[T손TAkp {@%$0*E;@B}@RT`HpC}N(UAYASAGA1A%A@@@@@@@@@@@l  AeBR[ HpH"pbbrAt"xbo o o"CD )p3	K0Np#q! * 	Z\9V NXVo$`RQB/b I$B^Uo@UOaůUP0	xnZÀӒ }?U`#`5`2$pCx@% D4SS [CxaUUT`͓xms'KYq 
xiu GÔ@π<PT~xiCq@`Bpxr
Tr" Pt`ixo aav+xmv25rwt4}pѷt  tn}D
 "YCA?=;<XdDB@>)Ye8*pZfq,[g.- \h9/!]i10#"^jr2$	_k3%
`l45&'ams(t
bn:6u+cvUVwxyz{|O}KG~oRSPLMHEWNQJ7IFTATAAAD!@b*>!Eb $wFм0U`Ud`0)uUADDDDDDDE
EE)E<EGEVEeEmEAEނ9D potNA8`pC,D
 ȆmT  g ۗ@KL7 &T F57#T9Rx@ZElQ
ha>W P A7{O0D=Dd
`#p`(`0<`PdP`d`U0يU09NN!ǈt@td	QRxtx xXx\x]txat"xbtr}xJxFxBxtx(tbxx%t &x)xxxxxxtxtxtxxtox x#x> x=tp x@t	0xTВ
}@%x"Ttx!TTTaD	x?D@xwTpT@=TT	Tx= Q
@TxDp?=DDTxjv0}Ct QdMdR eP`eLO;H"x0xJ8"xg/L"B S?/?@>"ޡ$"tO>Q$-"T_Ô
P~0~7%UUdTT7%TT{ z yT H H+H3H4H6H7H8H9H:H;H<  H氊TY$1	 Q
 I`A @tR1~5HT& 8 `;cuTuTK0T"$`($_`*`-w/rp4
TmB @CMb Q P"RLT$```$$`(`7`F$cpH[8	A]}g@
:3
2 *}0P6 `#'/A``,`003`G`[$ap]Tp]f"T e dpF]n0$ks `!DaWTwwq/!$ Thp U "$pR_,PLQd`PEQxgQÔ PQGHaq@P
pKPx7gv@KKKKKK/KQKUKpKKKKKKKLLL L%L*L/L4L9LILoLLLLLLL  L0
`2v"xMNO`uRPRۭRsx }e  x  "%j"0RZ
R;Ip;@x"} HG}0"uS@	0SSST
0TS0CSz庠 A0P 0@4xwatgvUa5QP0jxTxjD0F{x`ǋH_xb`>x"x@$xx"x`}K}IF	
Q@PM0""3 H+xT| } ~ J4Q_/*N QRR &NM((sMMMSN\NkNvNNNMrMzMMNNN!NNNNN.?AÔ`P/."T? }} 00xe "QfSQѰJ10pV	 p50Tπ;/uQ0)H 7010)c	0PS":C$p
;]!/0Qp,"xdP  eA3"~}e 0?I@R3AP>2IQbkbt0M}E@JWC`X .YNZ Q mT0"ɑ ɒɑ Od0#`0xD Tx~Ph!1?xxhvtР7T` AABـ11u32}'  $31T3322@"O0  "(FW "   p}"/*~O0//pC0S00P200 "
xp0 "{x ɰ♎2345&h@"(t?3t 2Ox325R4U5B| UaxQxQD=Qx␖Q  096x0S^nS CSɐQLCQpQQR;5 SQSySSS6x
/0~!x
tP/P
0/Px
  x
Q{Pox
! $60#t #T %Qxs	}T~Bxr0xrßP2Pd0 p%@$T$$ߞPxr߀`Ӎ1 	^O1^I,-up. <Tү$`& p<Pxx}_ @p% fBx.-,6	%xxsӔ@v $(xrvyrxsP!  P&0 	r6
p`xov 6xa`r
qfP 0	,xx
xR!x	06SЀ)^7P$3p 06d2S T T
TTT'TT	U
  UI{pwfD4 D@ @B@"xDbU$P``3@TO1d [#X  +D "z:eTph`/AzE@E *@@CEkp7i O~@p w 33TEOB $  @@200"p<1Û`p}T``- ,*,, F5=S, ް iS,`xevS,,"+,/0,Vk@VHx	` }wNPIVHu0 u1SSS0S3u2 u42U03U1Np1%10304440}P-5xp7x	410a^_55,ӔO@xA=- X60c
+p00Ӕ@@607,	`	 VVWW$WDWWWWWWXXX$XF$X`%Xl&Xu+X,X-  X,6S	XQxu/@xB![-.![P
.-`Y	
x3 t?e.pt e-``l	clQrl"	`Ax@}}t&܀
-J   bt^,Qev  q} pQ t u vAO}	}c5!`N)q Q!q6]j"P/|0 ,+ߨ"_2ZQXXYY
YYY"Y:	YAYHYOYVY`YjYwY~YYZ+3ZA  {Z<PXZAXUs  S1
tt)ŵx#	ʓ
pp& D lTQ@ST0BQ
b:Zl0À'SP$ ZP  cmZP`!!I0~GJt(ಚDuc4rKrgQ
x)1O`D1P,1P
QJCS[ "gD `E -Pc80.u,,L,Sÿ@ _.",."x xxЋP#t .u`
T/Ӕ@"" 
u/$ -$U@"x}"5}E0524 \sհ2z[[[['[/[@[I\J\
K\N\Z\[  \"  _41
xk 0/_" 3Ґ 0/ U6uq(Q a  " 0f33%_e2pG2U640!+u4d	`f
4Cg"anvS"1P44$`$`2$`B$`J`[$Wpk^[QP S0/V_Q\R
D	qv34A@jG4ppU
kr
`D""""r  Й]]]]]]]]^^  ^Cu2#_^Fu22b ! G0![QcPyA=r!
C\b 6r2UDE.Pu8QZ/0!oHQ R 0 32"0"x%0T~t@" 8@P@@-	T3" Oxaq~ d "0ǐ}t0	6k^;x0x!TT`DϏpT!D`q!T1 7a\xDӀ@&?q]"  :	;
/123B=>C	D
WX`~x`!ÔP ^`_b"
%F`7 0x+ +axqa*+s+QI `C0/+xT 6} 2p.5[ DT_`Y epTT`40	61 aS 
0cx	+$```9@=axv 0z q DxT"ҎxStTTH_+xS+<x,{ 6,@C`$p#*xSwx+	x060/EA
~
0_ "0.-@-ӔwPq @
Q{PQ/-$q$cp50/NC.I}.  9VP`@\D}kT ]P-Bp}} cC.˯.sb^b@ $~SSN`R$dp[..3".4 dpD!0ӀÒ/ ݣ.qݡq xk..TP"-.{{ 7i"0#"x7"ႀ 	ӛP	W0@  Þɴd`PÝ@ӛ@*0ڴÝP:;<u Ft/tƀ"/01234u5Pu<$t}5}/[cddqddddЉddde<eVeVeyeyeeef]f]ffffgXgXg{g{gggggghhhLhLhhhhhѹhѺhhiii(i(iKiKimimimimii  iŐ~K0~ %~ p0% pC3/}u: u; u<3{b4i܁T330P_66
~ 6`  fR3`075u3@u:u;}u<{xu{{X$::;<{&5hg0  rh)g

J-Ky>,@1E` 
} P0C3+R#~ 0`| }` @^_IN#`##U(
"&J

5P)*)Np<Id @(
c# 111{!7(+(/**81,/,h3/1/5H13JG1O/w|@T1)RBA$__TWB1 u2d I'8B=9='8FGɪXCWCIˈEEL͸GGVUo`VII#M0V6_P!}Vbh\Q/"qV πu3///\Cq/4"$y`p!SPpnz @@ "@A~G`jPj$k1`T}V%A`"`"xs@}}T}կ U  VxpBBxsPBQ0$70#?"Ap
 _"%@AOr+ 	U 	U		V 
 
W
Bxs		 ے":0dx>T=@Q
38T>?~`dkP?>IIPw0=p/1;P8j } P' 8@
ఐ| $ >Dr HS0
0kZd Ep6"}o`~I }pQ Vl
#@b!p1Pg0ڐ}P@ HTTnY Y~t
#߹DpFВ0Pu+r++/0
~IС2!_$uQIuT~l@&p0tyjpP 
41oll"14Pmu}g1xe@606
 0ǅ\@760'Qk}|}pp
T?T`4"4" u2<0n0`~~^z0^kTODt001p3252]* u1AD00 	3PhP08PQ@`2PD{2B32ӷp087fPc`&RP@P}`"aR3"0PT_O"\
070% p03_3@,pe0`01?2_Vbep0ovP3ఊ1!n10~
  c`FJg: 	1DcSA&F@T3`02`;:+"45675E4`546P
(4`i77$pTo`MӐ4}`TM=`` `'p->T
=r D D i0$CBDf0Wq BݿÔZ	6*u1au0)<'2u0p
1}}]34Rӝp2u2u0@O*> $3@P20' ac@'
L`1`2^pEl;8002`BTTT%%ON>xEpM0>3`D
` 
p	o0d`0a1\Q]T?`<@7!?$p*23tT)9)	 #c H@0ғ1	a=2`fO"c"Mc#EN$'NTRtn٪$	ߊ??
o)$	6
?b?u)txdd7eU"}{zycWj7uZdj12uZ04<tr`u/'P~ s./ds5%t#\vh~@_[t^Qrt|0p{pT0qN`۔L=2t[	ÔPtǿ  q䑘o``z45Ӽ@0Р/Gk4373 vS((svww(wCwhwxfy yAy{.||}}t}~	~*~K~l~~	{ z y4k&	5?P4F w
 QhST{lS:ph1
3D,t~5{u4`u5g 	]4T`pd` Q:?
p0
PF$u	r	uQzLoBmP[|w| axa[}}} pmiiiPKß
Np&V$0/C餙iz (
r67dk6 N6@_7"PnRPJd0,v e5p4l`
&{Jqw!8*8EU| >`z {E` @\]Lvv899988ӓ9p#!#f58`9#
		`					@45q0F 3t[c98(}d`픜!PDA-0/1* 
E0
jZk<ÐI莐IP2SU~doLpt@#aM`M8@_ɫ1mpl`T@
`r/@;ňqdNpt/,V+/XPՏYP7[ZNp7>	bUodppNCWWriҞ/'P#^/i S4(?Jdn&pf)1h<Aj=Q Vv>afx?*Mr i}v,KD|T-`M0980,P78+3 7v@3"27傐}頱-3+P A| 3$`A`yc $g~ 2ࣁgu3#uxor77 dER t8u@`
_Ô|		q@ro9TT NpQ @  @B2RP};®4u3tu!	K	(pe3`3s7p1`04Âx0_Š_1@  `o5e ?31E߄z ADW?ρ1pБ2҇}`фh?2"u0XƯ03}Z%Ɛ~N0
q:>F2pP#u2f	op;`8
0YA
``&ӕ11;?100q! xeT`&}$3pdtP2"u}`q 
"""4ߐ}tȰt P
3U02	~HTD"LION x9pP
 DT{":p
"a~ d˒ ׀Ӳ  0d"0oӀñ 7p8`0@
D x
~,֠T e8 h@p 21"1,"`"x0 `P5"5q"px \
q&s>q>~ 0 oPn`dx"7@мu8X`g,7bP| `  Pnp=	84zgk8$bM"89F;u<98~NR9P8lpe;9E8 `vk@@~+P"~{_
0oȡ<0&x33 d ::Ӕ@q:@bx#,	: ,Y=x@A-:Q 0W<p ;@f
ڰ|0`^=<>?u@`"H P/A(p??p>?
>{+@55@@	x&Tp/"%T~ ۀO7&@"`"!F"x!To`	TTp5723o`012D"C
xCOpx6p>A4ra/T(--,r e,p,`,~Me,`,W,|21G3>d$-t"u;2A&8<9@Ju;;;`P9:@}l56x>F?M
 p|b?b6655	d` 
GF~G6C"¯ DAJf7pO*q_+,U
,, +,+@^@T`| OFG$&^Ixt
 T0xT1T4TDx!CD@PVp
0g1dpa23%33+2u32p@
4k6`V4c[N(%%q
OkPZ`a00*6OT@eT		|ҸTY!~L` #Aq""	F	 >	m@2xpdPX LƀԀi@o3ڀʀ3ł 
`	_"3/$ ̈$ P ##EN``#sB"P""):"P%0 Q"b``"  )"u/33@p " 3@P"Ø"ſ(p p8

r𣾁
		
tQ
X
	


 *f2ް	1	"t 
""BBE"""ЃПP  ts6 s$ŃŃ1" "%Π5pbpp
s@h`1p1 1@I~1v1@n1 b1V1J*1eP1111 p0p0ꀽ0p000#s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0  =     MESS,uh=t-M_sS
4d/FZyOk{-	^	p									


N
^
d
i
n
w



!c
A







,ADHKS[`gnt}Dg	$  @cQ1 203-Memory Address Error 
Non-System disk or e
replace and strik y key when ready
}
602-D ette Boot RecordH0`5e  Run 4Configuration Utility1720-SMART HaDrive detects imminent failure (F ing Attr: ??)

Please back up the co{nts ofhdrun
HDD Self Test in F10tup 1800-Tempe
Alert  7{A proc~ has beSed as n@orQC7MOS13- s aAby POST o1155Boa?Comm P6 Assignmlic611-Prima" Flopp obnz2-S nd01W#tGrol`)5G%sType+17A83'` 9)	v0C0'E0f& 1	&8	3XP7
60-Fix"	doe"sup" wBlo,Mod%117'r[! Ao$1s73_{	DMA53?5?@5Idp@ify=mAmKl4O >	xParamKr TableWBI>tRXHalpB c 52PX[ap5.UpdRNXbB>!M$4A... Invalid elRronic serial _numbeRX1`8I/O ROMZ%39K93dF:3047deUnitgLoad_all -_h4cMonochromT 164%lSiz%@_
4xZ'bYInst0network ]rv`F2Act%_No &cach116M#rOp*istQ`  j Che`e2  PCI BusA|eL10-Ex n`StoragLeviuJpHPF1kupX#PQl#71O7[23,3b2 0[j|## g5YIOCHECK a#@ l`3-{Ti`& DaЃ O X    Powe{r-0Pass0d	XOKpDo youallz apto p`ss? [Y/N]
V
Adi@a ڏ	R orqhip8n!p; (ABO = 'C_trl +Ѕt` Del'18-11@#k: tchanged2: f*mBqne!p+*3/: VideoH-4z:rruppfZ5_i *8]6_ancp0aexpansbĩ  Turn!!ej fs})<F1>:G AbAs
qb^Ҝrmal820UZ muP#3giDwa,6#+B k1.(Strg+Un/tbr,I0  n%Tfowa$o$P6PuWtomc4uhed: +s ToX miX: KbytVcksum0k,N fauP/kulcqWNext? EtticExfʠKs/ssaeA7cceP'=  F10 0 OF2 C SS I B pinue mpu} C Maiance!c
 Hyt6.<swi@sӾ usmodu+4ngme$+requires.  opc.d.% 2L!BЇU7MpibOOay1__2_]re`excee@ !1յb1a|PvCircuvLUnw lqn$dy.. (	.0irS@Ԡ!aAppp2kEcQ퀀1Z 
In rHSh{ut2downe 	)]6Pe0 7~PIN: [
]N⥱%left+0D1DB< 2pu`Q́k@
|#vZoat `|,Vba@ uOPQeedHгcuRochip!be1 PE|pmFoldNew_ upq`_F
!|be`$r"-h !du8.t![0#AcF JWa
 affiH@a,0b@mak5tзunusAPRItEon1g`6@en! 
@f=Y%uYlJrec2E`󁀿paSFAF2f._ERRORYhQm <!!goneebyBla.MIpx (MSGIDX)    K   P DSDTDSDT~  wHP  nc8200   MSFTC000
 [L\._PR_ 1  2
 L_CST p\/_SB3P456`p
1I{7
 `8
  Up@9  AUBsrCCw GU@ QDYDYDYDPDp
UEEEz!E8qDEq9?
 QD y 

BAG  |D
BIG
W&
!C;9ߊ
d\`F2
0 
1 
2 
3 
4 
5 
6 
7 
8 
9 
A 
B 
C 
D 
E 
F 710ph`p
 gpid#d
 {`
apa bsbgcpcgz`
`vdgD1phg	gi
 $12g 3 phpi p
 f"`'fg`f b 3f cufbc``~45E
Microsoft Windows ?ME: Millennium Editions NT C> 6F
`,p\_OS_`pga.ag)`B5
bra/14ua
 6
} s %[/I` 
u	P:13214416p0145_INI 6H8
fpig
f 9i` g9hrgfata
apa`r
ahha `a u
 bbi@ ibub`{\a@[K
#9_HIDAJ	_CRSR A)
&3	F1
  GEG 02
 p(D  )Et6F C020C 1pyF22pB1t#21A̑G23% 24 5 @6 r `8"4([9   
,[9\12AB4[
 CD	6O
[	 EAF30Q 1 2z 3Y34 35H36
8?@[Gk37!8"39'6 ABX3CQ D`
3E FV Z40Q 1 2 s43A07 4` 5a4U6Q 7 8 9A}AB0 @ CqDEF  @!50 Mn@,52
E!P`pua43a}aoiapa ib{ab[O@103E'
_C _7ADRl&  n_STAi `	P	4p
56`57
T
C[)57tqr 6 Dm80 858Uo58Er2u59& @? < A@#5A [#BKvu5CeD`p` wp`bt58e Ze` ap dpy40cCdc
{at
_ b`zdx5D!{b?btd
q6puP@2dcrdZ59` dza
aa{
N `awfuff aOdu`['A
2Ja
FL

 pG]
qEDws `xH d2??y '&}} 3[B B@61pibpkdrd
?edA
d hb @brb

bhUb2  34Dj`a6U2SE 3K662crc64BbN05!warj5Fab ]b][`@]
]
buq]atb
bP c^a%
`bac `/$66S SK]Z5F
62 }6Y4c)637P=aacq`n\67@1F~'_S3p 4@evL68U< W

X6X @4[ pA [B%@ 
"@6C
K6C>a@{^.Qh2BADDEF@[gG:H 
F
`
[D$F7071Q 2 3^74taAW7AW77T78AG7Pq A pg7B ̐!^7D!^7F C080 q81F#82 H83 l84

Rl848^86j87 
<[=   @ 8a89- 8A8 1C   g8Dk 08Am8Fq90`
[  1	 9 	@@3W  P9@UD@95
6
n679e8 
!
W98 
f99pg~9AgqB3C
g[! P	D99F AA1GA2[#\_GL_bp
`{ʔ[!
dv`J`9FaA0`{ht pjp
p
Hr" `"a0_A1bV[ Kp	rya
c}cbaa13 (_8` A4x0 A5=Chi q`y`j0vA6
9h1+F: 3!,E+Ca!)g811W(@wA7`qi5p@rm7BPFbA
izAEF38C&$r9D[}jA81:GDF:zBA9
@
[+l PAA0ABQ 5CRA$AE6F CB0
sA`qB`C
	P  z{` za 0 
bw
t
	rabCR
 11
`` )RU{b0!v"OL@B1
pI6'BB2
y
rw iH2AD`Fa{ ` 
p{z1 wi1{a`  sbB1ob AzC13	_B`pDw
h nc } s    AA3
ccF@B4
l
fPB5  B6 7p
&upe {ky
rpB5e} e A`j
6a{`Y!Pxq7@p #`b}e
e/r !`ؽ	e z`e$}`@@dAy4{ks
 	`;}qC
  AwC yЉ~!-Cp?d1 q6Ad AA"B B7e@ |B8qfBp5p dyce@
QT! BAhif"f
j
9@
Ebd_B	!ba'cz!Dby[
PMTU6CTHPCIBWb(p`Ab	s@bD/cyacaADw'E`EF߀e  dBbW[FBGQGGGFD{BC |#BD
@BBQBF-_PSW	B`k (!`AF[(C0C06 C1 2
c	Cl	V o	o	o	o	o	o	i	dRc	o	o	o	 o	o	o	D.ҙo	o	o	o	o	o	$N!6#%[AM 7#xQ9s
cASC3".
[@C~   /2CE
P
[0CE U CK DвVзD1 DO oD3  D4D53D q@~  D7OT 982Q
 0D=:
c 	9
  A DBLDCA!D4U/RD(D/T//F 'F//f!e!( .G!G!@(C E3(@UN rE1G E1//M E2@ #F  // A eA !A N  A GA "A  "$VU/#4(4/T/.5`03'5//a0%1a0%1a0 n0a0G1a0G1a0@1ʒEtJ  HE7	E8	
#  'y  E h`и``
`p`apa!@E8NEB	@	V`Q	``mEC` ua'*D	 *Eq С	vA`v[ODPHIDA_UID
`|EB^^04`0!_7DISECx)_SRSED}h_CRS!7Wa1r)H$^+b!2 r)4;c13r)`C EFM 	hA 4r)F0}[(iQ(5r) `k0ja06r)H$p{8kq87@r)73>8D[U!a52[F41F5
r 6
 <7 [#"GPBuZ[@KF48Iv1(W AO5 -G F	QkFB
,  FC Ԃ@LDE :_REG30QMFC`pPFA A_S3D
jp 4p oFFR({C100
k h砱47 ` 6J]1c8C0_KP2
49`
{	h`{`h~49{i @
46$ q\._SB_3ts._DOSq	5
` a![^4bb ha[a7 
CPPpDCR^/FF
 G1_n SShsrR!S** %$
 
h 9E~	8hfp
` {w\/003#AO9A
0y1`90D  7 Q   P  Cohip~8E@h{`>@}`  @E\=\/f	F3]7 A8|8H1N+A
i;C0A6hj	 7hijCqa.52hR94s 3 2pm
p9591s 1 F)C
^/Ǵ0kl3vV+D 9A` 2a{04aa`0`fBϠZ DV	_GPE	
PWQ
Gb bGf f@y N10EnN10F!E11P<# 1 2
W
p`3115`
`6u/cD(PDpipp16
 a	ia`117[J  @9@ p!18@419p # A!B)CAD 11Pr20Q 1&2@324P.25Q 6 j7s 8c912ABC UDEFPs30Q  132 U3A45R3373819 As B@f/3C3EF C1400
442 3 q4Vq46718349Q 
4B4 Q4E_INI U4F ԑqFK5151[  Iސ2 @@Y53:4	wh
@axa
db`t
@`TP
a
 @}a`*
y`0`}`a@805] !azw`
d`xr`
  
@bau .a	6
	7s 8

9#
!B 0qD
EB|15FA-60
Unknown 
NiMH 
LiIon Np6P}P}>1
  a |,Qjq0E/1(`0EP59
a
aD0m13
721A<@g5A@`	9Qυ}ha{a
/58}Q956!
 
p^Qw!7!7Da161a	ՀNP AB"2q	QaBp
P?{`~`JI863
[)h`pA0`
csc
  dzir`a[)a_bsdb1/2*(P~ccC4	hg3
~m62g
oU65F/{`g##5 $ЋC N 23a7pa - 12A w"Daxra
c 
dcbpbbI,Er	73C`a Da$(`aࡔ-:6g!$ IX68
I+Ep/
  W ~	ip
q:/79"2Dc.Fc3m1 c6@0 f{``	{2``EF@5C84  9H2ccdp e_eez
cpe'cpci7%4?s 5qp}
g5Dp
IBE`p
7`D5D!k!25C-'AvG@+yN)21Q-  
qu>
>6  P2pzo
 5Wap%*!7"(B+BC@F`*se(a9h)030	54Bata7
!e
b@zch!
 

6Eaa38
@ ra 9PQ_ paupaHf:baAh68
8>BB*2;2CR=3c3r?44 [
06BrAч
HP   a3E
Sp
SIMPLOySMp
MOTOROLA a`wRC~6C
p'
 
Ajr> (_Q03':Q{BA B4u13b
4p
az4a2
bBaPQ05TZ6D! E['cTZ3-_J
6pn
Jp na6F
VPR1p2A 
 1_2 N8Et# 3
B70^V`#9n(O1169(_0316

,
{ (i280i$ŐS[ׂCЀ2E
>73
N 75F7 75 760   q |!A FUBCADEB7F80Q 188384
[  њ818688889188Blא8C҆891Ua 
<A
!89MQa8CҚa` 7C`
D>
k 8DpOpi8F90rA ằ`cFbaEc3gP81b pa:0A83c1}9P ya
 d
b
 bdpdS c
 c
Нc
Dޠ90B`918Cp`kaʕa
v2C albab`b
vbyb 7B17Fp`E7E'9q !?81#!AdDzj
a20z8W8D=2#'Aqbb	˓aq bۤbQ93P
8C*6897`604
766" 86"0
q5
{C03A
`{  ia` `ۡ!Ehp!
`!K96	C)haF0$b cU0CabcA@'K97 p^^`)8cIX99LE
!+A

Gy 19	C A	D/ P99pqd8A[L%0EF_C  _DDN
oCOM1!9FA06
30Uw"    }8y `NS  A0I_STA v3w8pC086f0F0
3{\/"U003h4C0A0p
w`5
0` IS Ρ?3+1 {Do039P9Á
QF_SRS\Bh
7A17`EqA1rpl)"9F@
_C~A

A`E B`c
u$qS!_"X"A[mA2   
rG3
_ON_&4_OFF`#PR0fA2%`nA3kM%$C
_V#G 0" *
$~0b(['u52K
DA4 A5DB?^,0v6A xA12=1A]X
I A * 
 	A9
r
;P/!)4!9"Js"5x""u"49#2j[
QAm$i$!P%`$ $AА:HBmACp`>  0=QJD
."-2g`B>AtAAE%NH
1 Gxx&x?x"q){x)xx~) #*o r^r_ _u\MX2XQAERQ t%QQTQ=E5Q1QN?3?303?<RQV3rR<nKEGm3O *o3qbvAF44 B04?V4V55 X50|>Q}xp
Aw]лB0 rQ88!]QBQ1=]75]0]&2]qCqqX:B1)B2 p\/0s({w(gq`{fxИ !r@z[O0dd$B `d PB6`  `ɔBBv
G``Gppd P+CB7
q 8`7B5B59B5B9[6@BAU#~ ^"  y sB0w@ @ "-[
A55
 
 tPz
     *"-Cta a Uy -/D
0 p Gr r " ƣ` }`0Gd d"l[IBF>
" 0C[0 ")EzC0aҘ  C0C1&aO.
Rk    [+@
   
 
@DDC068C0ADR   C4
D
[)C45 БINI	5[C%6u7D D[@Q8-≰a 3 Sa=XPr:}d%8 0C #PRW
	
[N cC9"#|LC 9`{` SjCD@F`>CB p[ GGPE_L1A`D
C0D:	P/PP
@a0
0?
	_RMV O*_EJD @BY.AP C4Q 0 -1 CDQ E; )C- D * 1 (%4S	cp>1
C0;S3D
p6S4Pp A)JCpC@Nra[AA
s*(
D"`OB ,E!BC/Ob QOOOOOEG6C0A8PD9!NЧD XB#C*N_GTM p
4 `d@D  DE 2FE0 iE1 B0 }3AE1{t=2$E
;DD!7PD
 
P1
xpEs0}10EDFEe0F
CѯMhT
hT
hT
hT
hS
Fߓi  `_p
w02`a:` PA` bwb
bw`
cib ac  rblL rc u`4abw2cE3bcaơ:6 !{ f3I
L-A##M
GjoomjfjockoaCaME$C  ,FK 6a/OBEt3N
_'PS0 3 Ox2P_BAU99a	
#  }A:AODmBODCOEFOF0OF1Lp_\_PICвhB\/'eD8O`T O xD8G
gQ5R  QY
cCD RG Q		 G?C#
 q	1a
 

	
	
q F1
!	A	
a	5x53C3@"cB0#68ME Sa  t  G !Aa[67@	F
R  nd
d
Primary 
10  
LIon 
Hewlett-Pack?ard Ey?Traveloka	6~v@ j5-5p|L ķ64	~0064h`/`%
 
~
" 
 
]\67hEеKAA8A1  a1v8p ޡ8ha`6hЦ7 
_UID O=2
_BI0\Q  ST @CL\`[G070;6$ `)VD ЃocrcJ6
ACPI3	G	eR/006`D@59 $:ǀa#` Mp&q]PRq]0282ϡ`Ó`z"Eg[:6
 LI֝A` #2
	/1?5?@SX%aN13jbC ED 
`E` `Pkwk`h`piaFa?Q`# a{`
gs }apap`k
  pap  1Fz QE 4 1  &F0u "v

]   w `2` zhp}
yj  e  )>!1h)h`!	` ibpbasabcpcau`a[D}1P>F2! a a3J/
4iaF5 ВF6 7 F8C	Åp5   p
`

S P   r
` aP9 A8ee[0wre
 
Bq02CpFAILrpapMF5SECUp,{AAA6A7^CbLwrD}ERF]200-3c1P
cp@{1cp
W`B
#A3ޡ7
  sQF2t
\-A	 22П0D2]R2\D$6	74B  ju|%a%SIMWa67208&O  b;2JT7ɡC0  `10PASSA'Q33$asOAC0  p ` 4Dap	ޑ aQ4F> ES?; 2CC+abb`a~B b ub T2Xqy20q `_WDG?
<4_c,E=DAAyB{M4C~ !f )AB0tWMAA0tF4ij3=10trR]p{B 7T@rI3{h
`}7045
$`6 k048c5F9
,*m049K	
 5cFD @T  , Aq3E=#
lS992) #/*t*q*uC:Fm;{v
8A pC;2P	6	K72F!h67BAh	"P{_WEDs!('~WQABNFOM$  5:  DS }TK B"!,8.@YP!O : SANDЫ L
(@ tKDĀtb7lBQ4(	*A
<i`Xu@%g:W:%$A8cY4='9ǐqx"kXu1jHـQjԖ(84B @hlgE<R$("Cca;8	<#=)A<~v/`G)L(U<
<)TB!A+RAB.[G
P{>[;Gmg5gPCÝ!2@O;~oh@Ǘ6?QV̐&X)xx52
׃9x&B'	6=9C#GrBx`ާLFpq!z|| !Y~GGS t.zR4:Np1N䧌W9B#?U>2Fpz7G	A>|=󀌟h4/~:zH8P̴9ˡc@1b9ȧ0Oa tԁ0	Y6Mm{;pc#Q޶^ 1G~bb8 =ᩜD&3/>"8495H'*uL^aFYƧJc^I}1THE}y1z|P
PÄ#C
@pt4sd
u(GqG!`?
dPBBTȧg_~"CBP(Ġ^|7ȑG!&((  GMQw> 0;
E=W'a^2]8O.m (.ܣ?! vB G/ 	Ag!3z`q^zB|b/xa
Y`,q:c;$?\FBo3wc~xdGM<0	ޓb`QȠ"Lg!j:,g!ag
ߣ:cU	^la HC|@N$Z(F23(}s j/9`_l|
 t00bP`p1. ?\]`u32A}P s H0ь0*)'XFw6bL	=X|gMsb31/~[A70x9ګ->O#/, Zk&]5w
=t5k`w
hW*kl\6 m2aT	SO.q ^6=67o1ma
wF`U
@1Fş0 
n`/

s l .
H\I@Q`PC ?;L0Y<͟{$a|lCAGI!340Ѓ{AwJ`Иlp$&{HYC z--B;CF`AbEyf7B^y <(hP݇_}E=<vAk@M,=9WqÐ
LذWyWr24	;wpQvY#{|exuH#D#Ĝo0CY C>gLq`8jx;3vgp4>!ss5R3zg8v8<>V'GN?>
`A86}j4jՠL2
jԘt<
ț@ B#qb/XE h 825cP>@  K{-B 4&B?bn  z@? ,4l 1;aDqJK7jbA4$hR" '{R	9At X>9/ D@N	Dh?! gy!>bqj'[ЋB J03[Bl[#\_GL_yh0pipjҹkEޑ050\3hv50l['{['`[C

[jAC1DAEF a1011 BFgphFeEE1F p{zh` EC221h7	D 20 1C 4
10i	
+105F{1	P[ED22829 A BC D|0q2E  WF rA3002F
[ 31@(q23223 h
33@ 34 50 `UyA
	`rh``vqmF36q31acdp
aJac
`rd
  b}y   baya
a0apaceraye
	 evepeAc ucdcM
 7r6cpc  bpbgC	bdp apbe)ece ffg
fape`pfafgvdueA`bAG` gT `$b pg12agg7ag`dM 8,0540 p0`c+`bQB +C`Qy2 0DpC  E "h Ah H
bhxc `r +Ecada
g
e,2D-adft`f	ru'adSuc2ftd gPr:`d4bA 7([9 F2EF&-@A%738`P&2DaqD2Ea
_INI,9BC061pibhb-Ap0<3Arb
DB
jB/B"p5C"ߤbF@2D w6
arC01Aabpb.0+bab`babuaaPo `buap_/_CRS7EQ71A`v2-D`T`_STA t
`}``6 9XD!

o	     y q3p@=[K\/F23=FmHH
Y40F
RGGP   @  -  sԀ3	0	  1	 40[C\/*242}Q [198F
rG G$ $ GN N 
P P Gc c Ge e g gt t    P A~-\/[	B3a


W!4p
`q ^^.C1727\_S0_O
 !  3 )   4  5   H\_PTSph%_38Ch
 0pB112

`Nh
?06v2\d1E 8F&\_WAcK~ 434A '110@98k6 rTZ`w44 TZ1_
 2 :A`16
a9p5469bS
O3acbc_c$#5a
:c~	6F
1>+PR1>1p>21 
 vb59j9A8C1DA
 `C0BC-C3.4N5n6
 0D\qG5G,<

Qn
h

[
 [3 qP@
.P7
QQ80IQw9
1RA
RaB3`SӜ4EF>C250 1G2W Q2Т9DpX16E
53
1{({!h !L!02imGm54
лp
?*3$R``Ipi_Rhp	D5
hm52p
`pi`?`
p
rg#ip`OBBp56@`phah.A{51ilr@
!! #7i ` a 6&RF
;O iN16pKHABQp\R
   qul0A2
0
	
 t!&
axa

`br0
>Bbtb? .sPR
 R
a!e
.!H 48	B
]C n`cPV0į4/of[p{V44`p9{b
 bbwb

araMpL3aoo1Rraq}4B s )a1Fh 130 @b4 /y
hFI	{NHb  6h@ a`%  G@4E<`s<qC4D4p !AR9`hz3_
cb !Q7K
@9h `t`03`x`fA@fI{tff 1tq7cbyb7b&8baFbbߠD
i

ep
d@V%;EDd*Eef$G#i03t
`a|'AT	R04CarVa[MkA@@i
$_ON_U%0R[2ra}4R_OFFb5@B
8Q
	C	
	7	Q	
uD
vQ
{[5E봷 `025A["ЂDHBB6Q0܆CC1}D[H_ALE 1@AL2	AL3 1_A#C0 "1& "B2FPb3fPSVЦSgLɔGC62qzEDSxӠ(,E6G7pj1E40p
,/4A$ZASQQ9_TSP
dp C~q 2CRTP0TMP5)[GDf64

,"*3@0/$ J\_GPEJ_L004AoE19 `tD{{`w {b  {`
/a 1ٕEb !@sca `D a *BzOK1 oI{

68pA   I@CDC0Do}AD0["
dҐ> `f`6`34OI!9 gHOH2*_¿o5S/o3B6p5RCSD?EA_L17 783?`} 7@3E~@0
Ic9AЪ8
=7C~˥172C191]/*?041C9@ BC1Ej5 EF@:P\{&5
G
b#1F1GC20]P
)A?8EA65h66 3D`pE9 O9A`Nd@65uMrPC_RPPG 83.A8?C1D9q9+tA0$D83Zb[4!0q/a}E_  `p`EB I
P/F p>FA`EP$.`""	<`
`
1O#O#E#HL
/	$$h`w099bIcנ@mpX5 C+{a|*яc{bQ%38
AÐcpzCWCF}Co	lmSSDTqsVHP ~ HPQPpct  MSFT L47@	f1    &   #3__T3	_w 
_	O`8wj
ara
a]35a9P]A69Pija A  Ah/2Fd130 26B_26C!B$@"1 J132yKj\
3g4=j9PD
Epgbוb`h67a bub 1Baq210h 1⟤E24rFy5AE,
b+1 y= U  VaF'*[7@hPDC{h 70PCT 
16Fq E	_PPC ѿS6D7Yc7NLP7x9_EJ0mCGA@A !p _      	 OSBI_BM_  p ( _ }0    C % $  3@ b  ]5     F ! 
 Celeron(R) M  ^  j  R V B X @4@ 11}O@ ?ܯBo_o/o")oa`	@1ADDA	o  wuXUw| V`     t
ww  !d @ |*  ǀc  m a ` k*B  | H c a	A
	a!
 %O#
|
!a cԥ 	OEE
OOG
'h

eS~"bHc !d Ǡ'ς#"$Ba&|"%&`'b!~*@*+AaC)-35;a6.A3 A7436c4#5V
3*0+4OO@<@  &X,MS$OB5$
AaQ6 4C`H!1co1C/5oHef^$ C
@% U1`\& A ]/@`^E"`@b+1 bg%aHk b? Qd? R d f X?!@hTa?@rQ
@( W!/ OaO`pR@ 5A.QrD*T!
ANk	AhGvRuO	+k
NVU?"`a?bl#
_Q&!. fQe_8$G  C
Cb$
ENvQ!W6 wA(|Ayw1 ,A@23'
&$A&"kR*B$ !O!@c5}nA/bcAࠢ2 !+3!.  T@ !@5_7 C;a7+:.<@= #"#`_`OH@ ; F+'a;?DA!8I@%`_
A"/O4@1ol0 JbGD
gB_ Y'5Q QbA$!J
L_Y/?"Roae(aJo%B.	@"?b@ǀQ ːQ#  7BJUH,%Y@[ eODAa'U0V:?O)^aeEVF!NzaMฃ6 ҂PW !0E;_$._db?"# U! ݡDiO"D]d
cMkŀjnRbcie_T!hD' 
NOBc#P/oTc8}E" (av@ 
G2&Cf~/kԌd|w`]op`h4 ~a,o`!t@9uAh" UgHaN t!v x`!'%`?`B z*K E#ɡ/\!d2/ "r	AgDE렁"NEuE+ (]bK6k  #5ఠ%
k  %
#a&k믃k@!!`@+ R  @.D D?2@	U0Ko  ~ T ~Tkb^n     ^   @	 OSBP_BM  p ( _ }0  . C % 3  \   G? uf O  ! 
 Pentium(R) M ? ^  o o o o  H 
 @ e "02 j`n2#=-,#` - Ҫ"  *"l 

nA.k

d
  @P      
  iD]``P# A @ c`#A
7O' !	$AOG	H
bGANaOJ $ *
MO
A!AD	@A ///hbAOKAf
"@(' # $@	$(a&+A#OB-+E'-AO`j$0 1@!UDpS%b , @UC2oN`X, @98+ 5OPA6NTa&`. @
!V,A1_O  \ Z@?   2_.AA@EN*!<AGNf(Ԁ=2 M&&"jN
ND&$΅JaN$	>@KO"d"!@NBN#-Of :$L
"Qh	N A(*,@QA@@SGSBO@`Y
Q@N/`cUNG!6`R 42JDC !U\a7(bX* A.ȡZZf|BDc!D'b^@U4<a` \B	@ `D(AiEaA"J B8<`CCI0#g"	a bA@
H w#l	rOP'"lAxDFaS",ABO$Q`-!{@p!u	xaay*BAac[@""b6#C bB!O` C @ j(C.#c!{A  6$3?dI"`R ib@<# cH!!! O@0Da-f&3IBwcxAHES B1AS!CBeV b.@L ;WO0a!SHgCa!^@a!b`@"1@|Z%AAU"`~OD haB#aE+`bOg"I`n B%@j%@(@?OnBMHs@kN,BuNPD qx PUq0sZG4AAJ8.	V  ΦYX| X@ @^"`       `	 OSBC_BM  p ( k }0  P  C % ???  |E L  ʼ  jD 3  F ! 
 Pentium(R) M  @3߀5% %< pH$C B#BE j a b  o  
   ]" ` !̢U͠ ` !܂  @b `h@
B+@Bk			ܪ 
ܪ@
 k 
 O A` \L
߈
U@
@ 5  @ݤ
	act  A%a 	  # Hl((<A&!%$&B&!% $(r	 &*a
@*)#Rc*D! $
+ ."`# !	!1	 2#32$-p 1
	C3`5(o
>3O!98A7A,
̢@B3!BC 34>D
&<e :"F "U8&6bH`*(31 H *3.4,3/2 .0҅ `.C0`	 #23>,E#4*$8O3( 4 :&d	<3S$ 
"> 
@  @@[B 
 D BDC]D## "@ "b!;2@M?U@?`XCB ! 4R@ ZG3?EbA&BbwBO]  	A  B ^*/ +> 	 B c @a!		`!c
 
/$"1
&
` PA	_"i#b	aD"	 *Jcb!1"a
1%#" 1
A!X> > jU>tO/ 
" !a!]"#u1oDC$bFrG4 !aG"2aO# $%$1`?# !U# <1D;D <O
 EL?I /  NJbA	` DBH * K!DB"#6.k$DOk(
Ufgwa@Ofwx@xH|hJ	xL	Oh a M
veUfw:ox@y_@M@4 N f`_h0`_&h 	xx. 	@o,	O`x@W#*`w R`	D,`6g$ 7hA _c@`eXҁ"g`_Wxa  %[!xB _ VX_o@g _a `@eAX 	oW uV!UW"
oh o 
eB$`hUuMobw@&e$e_)o"o@%_
!hA "o*!(# @U 	%g%'e.XW@'@(!
-k)VRB@.!@*vC_o 2 !5@q"l&g)w -a.4_X-tb !31a
@$+xA.ex$/3X(!7a42oI9!'U6ah 3&~h=U9e !3X,(WJ -U`>Ua: 3&.W9 =b9_'C@w"?iw
7u!JQVEa@	_F`5u# xA#X ` Na	Ö8K3c@X`,+v@E`*e#WoDgFuHZVwGfL/o CZ       	 ATIF_BM  vp (  0  n #.C % O O  !   n r	`v      = @/ `)`   ܀   
 ( 
@
`oo@)g`	&	Ϡ!
ϞA#ecA OOOi/
gh)Oc&Poof b%a& Dʠ7@3O,p:(/#..,/%4OI0`@7=a8">~i?2C
 `*C DjAj3OO OOOOOOOOOOOOO(&
' @ Jc  Ga^`[ `\A! )``OL!YybY)A+#:P @\΂ Qa.OK ,A_ &BZO
NA
bdT  (j`
gB
@Q`u#l!_!rooG soo ?\oo
Ayoof 
d/
o,Ho/ހi fb[ "bOW  }e d  @-a F k .5 @@O`@WP@@@AUASb`i"!hA iS"$CP è aV`akY$#a/k&$("Dtt`(y Ga  /OOOOO OOOOOOOOOOOj)~O L&AB2a"(!¡bAa ay@ Alay Cbw[
afv}B_`	DaBAza!1"eFbD & 
 `
? 1C ¤!
`@ bBḤ ""JC!a!bC)# FAA !MA ".H&a(+ -4`d03-'2b\2+9 ΀ԁ!Tr	@
p@-      t     ROMEG  T  ^TI{ jp P  R I  oIBs W v D }PO  q Bs W QD  PIBmp Wr D oOB q Wr D CDM!MD ?#ME 
%p F h& S bq M{  C !'0K (U  j*R  |DR p SR  CR PB  BLs P BC BE BD p TS 6.TC p RS .H  /?s DBG,0WIN[0OP *0GCR-)SDLG  > ^ Error
          @ P r    Press Enter to continue  (CTRL-ZQabort)    N^EAX N^`  p L   O^A B^  C{^B J^ECJ^`  p K{^CF^ED`F^`  p aG^DcEB !6^ESI 6^`  2 2^`  :P w:^ > >^`  R^EIR^`  V^CS
0^Drq .@,^SQw*^F(^G1Z^F 
r^DR0 vp 1 z 2 ~P3 4 {05 6 7^K^Cfp Pj PnPPQsXsp q_Qp 1##`p 
_
___		_l___ѳٳͪճݳ_^GDT ^Iq ^L ^Tp:!_rp Ps~wN^N a&wB^S J^XDF^]
A(6^b2^g$:{^lZ^" "V^:,R^  C,^D>F0^q".^u *^yD(^}"O	!2 1= P+P C D SI Q BP= D]S1= F G CS:IpSS:P+FLAqVNVO
PUND	IDIELPGNZNRZANCAOPEP CNYCrw^=v^B z^GD~^L^Q^V$^[^`^e>^p^xDAv`1
R1Q 2 3 4A567p!Limit= , Base=1Ra"d^^Tf^j^
n^X4`h4  #_###
_#M_#	_#%& U& & & &%_%%&%Fy_(b+^-^ ^'^%!_V_VVlX6= 6= 6= TR=Z}     0>  ?  ////-** Divide eInvalid opcode2NMI (previous instruction)"Break on SMI2Debug hotkey ssedS dbg0invoked via callr	POST tab}l
ntry 
Tracepoint
 							

*
?
EXEC WRITE` Rp  _ACCExqCdA BYORD
RD @rq MONLY 0  NO?TRACE 4q ހ Disd _RealMOnlyEnCNO  INT34 0c POT TEMP Q " OFFSONUISABL`	EN  LOC  SERI1  CONSO
RERs 3 5 CP1CT0A A]LSLI335c    2lȎ؎.V` |   tP  .>t:o$>U U#uG6JB qs
G≠} u7 V" "$r;sc۰$ 	 PSQRp.^	c(f.^f.f  j AnAr
u, 
^ t$.^tN^ u% ;t	.^ urt.^.9V^t!`	c.		!w?vp} a P0urotib aa
uj. .>_0u+.^t
 ut-Bt.{_ ;3΅u'u2".K  d` &.ZY[XfP.^P1_af`~"r">"e"
w B$? 8 b ",  %" L faù   Ptu
t>%Ά)u	{`,Ò!h	N
	 :twUq cs脿  gfPf&@1a}1q	21 -6U`<u f.R^=fu<=upfffDf.
f.@#(R^fC  f. ./`c .3pk!>/_d /_8d A9
uf3Јp;ZYf[PSVW>< t"<\u <nuFm<~u sJZ_^ !PS>:FsI>%=s@>a4s7>(r;< u<~ <A<uB
VM5W^P'  Cycles(uSec= ) ???BfQfRVI^ u\P@@??r6aftf+fx`Bvfu	6Aff33-f.x'h^fZf . CZ^<7 &Z^KkJ PQtނSc ۄr	KtY`Q`sV2' !	 詄s
ۃ`?r_^QW<;t=ހ  ?A Ts?urwT.Ws_b>蹃tT!yu譃uP	pX
C=cur:f s20W%t r#t-6-0/o
r\afb    
   P0t-*u袄r,$t
>r.d.NWa JJaXW\lWt5@"7.R^.;I`uf.;K`t J^\ o`96XR	r n6S` p2ft<guX<t<t<guLpr
t@8.T`><pV3`i!<1?1_?(/_?pÍ7:@!4`AG `Vdc1a%ea ÑЁtI.> rÍrD輁> H$r5} uf~!u%$ "PufP 
t	 R|]MS?e [ 6[ QCP
[}ߺ++_s+Bhp2u;(C'ť0fP@A0\fW7O"PװffGGt
S_9 [Vwb:8^f;t]wpaGQI
b@YSb@HfVf3Ѐ?t-SfGfsG s  fsEXMemory, I/O andBb!˂s must use hardware (0-3P>Yr#2].^.@N>Fr=.6l_mrDP[	  {tr@  ^.QPpP f T G@  >i
 rG@  /h !0
 G W'r{W
fv`GG ~r u6ЬП.O>
 rGG s'~td r#G  |6f}bMQ}~r0fu!`A~Fue`f10^<1pkY!\/U[[P'0	Y r'%3]pp@b ^ B~r2Qt   9rFA%]r
}r:1#Ga}r$#1r}r^ؒ0	^}`~{r s
]usB}u P?XYR
 &ies_/numb~ PQc bS6{P g t"@Qz6z.^W{|~BP#     Eype= Lengt?h= Bas BytTrac| NVW~  vzz{wukG>!t {6oRz M27`Az108J 
G6>}zfG螑tk{[9zGz:.
~z]"z4c{"=-8E 6	7 @yLaldy active. Do you wa`Nto repl  i@OY/N)? RVWUА kt`@.b 6ͷPpEr^w
f[Gff.!!^ At`	PRB ^Owf`fm3
G
GcH?^]_^dW؍ 
2; @ T_oS
Hg7 sI &Q AAAr<s8f f
up^c0Soft=jnovailq..
aGwfw
`VVQ@ u
D- u+@T rp] u62iwP>&	 EXOAM!~vAV6@
 A5|t/fTfpdc[./_D.kGIu^`!4.Da9O`u.S`f)_a-_a` &	>!VWQ- Y^_.^@aPPR^ !Cr=0 r	f9Ou .s SP# PX1m (
 #0b`"_.&^An$ ù p    \ PQ1.E`..{F`ô rGGA`wr8k ~5`f}u`uup~MuvOOF9zA:A0 r,P;A5`pvt"	r=`wvr
l1WKvts
 u	rcf=  w[3TwrR wJvtCwr>w8vt.wr)0w#
؀j	vrutfwrtz_A Bu, Deviqe, FunWon= 
  x0 x1 x2 x3 x4 x5 x6 x78 x9 xA xB xC xD xE xF ** ErrorZading from PCI
    Qut+xt`C 8utw Du߂    u  +3R0E`F`fA`!  [s02!^s] E!t?.. ȰV ঀ;t  E

`t#C vu0<ro!
 12Ui^Nx ~@v r^aA`+
us>srvrs9s.,!, ssB;Vr'swAɡ`L ]rߴr6Pr$ @$rP{X" i . 
 A`zsuzisu#P# f֐"Ћ޴ ui
@)@"<#f.# #֐v` !vf :Ц3Sp/"f2bZ{p-_.9ud@VW/`u^/_ ptR-)w.#
t0 +Y0#p"#"E..VW."Oqp 
f=8s6q0<qr@Ӎ6E$p  >#o0!.#pLr.	qCkr!
VA4s: m|0;q$$E@0 ."  %?="/_pq'oߍqo opW> %Xq_rh߀< u
Pp PtQjrpψ1@+rp6%VoGf." $P$r胿p" .s{9ojp|}6o8=oC*yo oRpHdFouat physical addre_ss  N fpC ðSms`rkPI_,tB0xBls` u2 `u6;&nn07!q~noV&U>~ o {+@MemocompsuccpfulpW/'@9	x``>ף&?|F K*Puf6'ϵm]b>`+nf@O}mD`maQ1`	#|!!`mnlt `fHt2}.'Qr8HtgIt[ntYrTK. LU>eAJx1/P6|` r`sUuI3ɍ>`/ntA<'tp,"u`(8t$ s&Ant 评ort~Checksum= k r[ecFE s&&&wt(lr%lFm@^~0N^ 
\Q&dmtvv rqBBEmtT rp+9rFB"ym<Lu4Fwm"d r`adv.?*#tud0~]SWf.>r<:ufF	[nrfF>	 r[SRir$lr%} u   
fnrZ[s   >lr<*r>*!Ds<$ 0t`.R^j6VV.0 4*=B* ku  тKa.B*?ޢr`0*wH4* l02kBr&`j r..*.5
8q>*#R9 	v~g	P`;D*zFp !8*PF* sQжec`c||*|qgF!
Hh>J*~.6H*@G@J* yaDH*@F*.4`98*w
.B*PD*oN@qws2Dt@Pp1`  .};uf.;u>-߃(swh.Af,  5p مq	tPuI` 9t3..>l 
uh. lV~	dhm '''"~ "

I`P.;K`t2IK`fCQ @c3Ú;	!>Sq@K`.,6S`%3@(.,@~R^FkXPW\@J  aCPU Time Stamp display= Speed= Must set sA to enable tsrhtJjr@de=@h.vVhuʨ^&>rN _<uFv%0.f2.^0-f. g6-fQv3?sggR"
c ter =   uSec	gt
ir!6.ECx!1.1fÍ>`gtG
SrS 
<t.p&`~gt#>/r/.`< uhgt">r.`Z
u
#l&W{
*Targpis@rt . R  manually if fails 6i/}eq9P=died^V6WeiF auЗP65e6.e ^D!e PQW> Ue>U gg_YX|ft2,r05 papPnr.p Gfu.  .D;& $Ahr 2w,<r(.y됲 #rCF YXA*	_ @p>&
蝿dw@zibu	1PhWi.Àr p#rTR.D V hRQh_NdS4jXoh0x I vIKJV  @OAL"q$ecYQ*h 1h
`Pcɝ
q.LO
(g.
`0U+g``	dy'g0
  &}[Eø s[>`tFr6`>jrG          ??? fRfVfWfU֡a2@b6m222o0 's 6c3>2e͸2Qɺ2 +C԰ͺ?2Хһ2 uj.2amaк2a ݯawb.2qa
 .+ s`@Ub6p`Qe+Ȓ>p2`$9bbZ
!Ҡf!2f]f_f^fZ*02 3<dDgw,d P$<&Xu
 $	,<w .	272N.2Q`J<uFN$<t
`RÃ? t#;Ot끽YQRWSVwd^C2.;~0t
|/2 >22։EG.2.2fEfG 2E
G
.2f$ r-/te   @ -@.2 tP=? @ ?Xth5P[G_ZYrepe  ` np VW>#3 tPo5c5ycqc6 z& 2 2ѣ>2}p	, 5' #X	&M';c_^ cER}6PfPǋfEEE
EEfpHQVW0G"u-6jS@0t6S 6!TuC_^Y[VW02
 `F
  fPf$FfX o l2 EA@ ; fQfPD$ us+ؠ% si}
uFD4/ E}t#uS uN@fD'  620( iQu K
Au#*
p	rg`1g
 /u,	 ߾1q/, fXfp5 !Asps0Y+5 <蜽 7`Ռbga5rӇq_ie@ aȋ`o$s"s1fEZ0!`D1S
Æ	!fo+B>sQ@"@*#@%>dޠD@@ᾁRS`rfe  #wbV+?^	sFN+R!%Dp	D
9MRu
HaI I7`&!5 6^<;us
(رN3AaNs@OA
Na裹 Q5Q5XQ"3"+ɶ8Qs
1oD1 F$)-R&d
*fs.:a	qmncVt@;f%$Pr
蓽.@qFbb$)7+ɠwPH_+KgD5VF`^q65PKAj5FFo<^P9d)?w76sP9N; ސnV@Ai8sR176sA묂N1*B<p fgF^Ë @t@t@ܼ$#7!/Bw)|CP{u
<s
>`uF@F2	E TE̼DDˢd%=upb5AIaR-df$0	К(=(t`o	
v+Ұ=uruQ2$rStY0< 	("rU@>!
R"+C J g'S ÈZ"b#SN1Ns`qC|0^ e2fedwcD'dS 
pedQeb41>"
S~0 : `ka[X449Bnp^@2G= uE _f(ts e
0)alcldlblahchdhbhaxcxdxbxspbpsidip kQsrte{F@0r?gOCf_2`0#escsssdsfs_gsfWP? vyB6X
6TA]qAAܕ ݳ@tޙD ߌ  + *2+*4+*8+f5c|-u sMȁU|Єu@ftsPørcp d
q t ?P~a slc#fEst a1u`6`%["	
 Kѧ]&rbpBb
Fbx+si *` d` p p P" MASAYA_AeAhAkAnA uAcA sE
WV6qAg4FW^_W t 	p!	
  	M
fw_ord db q tbyte AAAAA" Q ptry  WV.t"Ü6B:s6B,6B&ps#! BpR6W6B_?.W^P2 fXPľBXP $0<9~Farb !Ò  s봰+   1$ פ s뀐e+s-!sfR8    R8 `}9@  c      re d  (    $  ' R( r, / 0 4 $7 %8 < 4? 3	 @ R/ H  P0dX ` R'?a  b R69@ c Rg> h ; i R<` l  S !m  n 	eo p Sc9rq  r es t "u %uv )%w -x 0y 35z 7{ :| >E} A~ E	 YIS
8&8 ` f l (0 8  LS%  Q   VSr/  p:     ZS00'8 0n= ^#2  bS>, f  jS:Q+ oe tS#, z  us 33  ׹;99   S%<3    4   u   e 
  H:\
8 S8 Ķ ȶf (v8# _ S:rð T t  ]#81 S;9 %˰ t/ SBFͲ b8w  % T98
,
 
b


r
QL T5??   ,Fw T5  w !e &  +T;Z .  (#  2%T  )`$ f;B` } 6	  ;  Ae F Jc87r NT޲c8R  Vf(R0ZV8^s0ZcEw g k	w oU
 s w0^D8j}S jSY>c 28(2Te0@9 {T>s  (V> ;u ztn TPb    e ' V 	  `d$ T$=  re   E Tܐj	   ݱe @ WA  B eC D E "uF )%G 0H 6I <5J CK IL PEM VN ]	O dT
8 T>8( 0f8Te W  E|e y5 y  yd y$ y yt y$I y y y4 y y$ yD y y	 yT
3 
1 
2 u0 $8 T	? ȵ  e   u %   5  w UD 
 w e   Wc8 j  r< ! $e  E U9  8#E(wrW -02 7v m;&@ E JvO& S(Xɧ]Ueb gflmqvv{&뉆쏶6mF	V
¶fm

v&660S
 es "f(.5uVr|<VrB@ EdJV8 NVUsf(U 0[f8cjp t`z 7 50툶 8۾(<V8w8E   (f08t
VуȬ ؅ྲྀs'8 $ $`$0 $ 0& ˶ f%ڻ% %08  `8  f!  CC%D\DEFiGHadd push pop or adc sbb and daa sub ss x cmp s inc decaa bouParpl imuP nsbQ  out a  jo jn@ cp @ z @ be ja jjp0@ l jglg test xchg mov lea n cbw cwd call_ waitf/f sa lQ 0ss stos/ lod cP
bbb b rol@ r rc cr shil@  a@et`ente"f`tA o iave`md x;la@oop q c xzQ jlockpn}ea e hltP=c t ne div iQ clVtc i
i d@d"xzxW lf0gpsPl@`hrd bsf@ r btr0 sp  c i 
x!seP 0 P b zbb p""epprb F`et gpUr 	l	diQ }l msw l`Usssss	verR w f fchs fkabP t "fxofld1Q l2q e1piBg2nr z f2xmyl2x fptan` as r}extrac
.s0
f`/ ]psqrs01^%frndq f &+q
ucompPendisn0	clein+!fQTf /esc
env
cst   fre0Q /r(Afb
ibC

;  ?	A	 r=fi2a (~ wbinv%wa ::ob @? 6 s zs 0@F:@s s AlBA CgQIA 8@=puid rdm-rdp 4rdt`rsm u_d2 wrxO .  f  yz` {|}F}.sx33~	t.dG
{U.
EaF,(-)*d.V)PS [XFe$U<v$tU	&;$!!{w'E t$$$I4芥"轘$Q(',fU$-

}E%$0_c<5r1<" t3"${v74&)6+t06-U0E#3$6Q9uF;m>'A0Dt+=Fw&_<JF8L?Nt!@PE,S<$VuBXU&[UD]` b,cf1i*lވ
nޕ+q#*vu
UJxL%{E}G/{'0߅#dP}POOQߌIϐ$ToT<(YUWeCC'jIC<U&@'tN^{86tH`߾&@  6W f3 t3Vv^
ꖿs rP %p R R  A
     <   P                                                                                                                  s
C`aq BIOScope
  - Skipping POST breakpoint
vFt  /֐ 0wQ Zw;Px\@by        lD` q	                                                                JDBEXEPTNŠDBWAITCMRDCPUREG(^6RDwDBG r^SwCTR ^^MEMBUF)_ɠ CMRSP`IO?PORT5`aT ISPTEXTd̮/INSTCODEI`*	SMMG^dESETARGЦ/0UMEޣwWRWRQ
/`]{RQ	A`^WR 2Ds`/1]{WRy	 	T Tp  !!EOP
                                                                < VWσ    -$  rtˌȎ  v$.UpfP.>Ap uWP.^Gp f3.UpW.H@ I O UM N@EB}C ^.@ W^   ApXfX`fSRoP.Bp3ug u_tT.Tp$ ^t?$.^ 0r'pEpD 4#r	
XZfy[`Mp0Np PS tatCu?L7hc t-u$ظP hh Lpr 	uI[Xˠ}C'Pe
.>^ t
P ZXPw Xr$$
0
^^5 _r?_x   hP~ Γ	ruX0rPhBfP f"wC 
 f.|p!VQ6'f6e  Y^PSQfR_V0*U0*,&\f&Tf	 ^fZY[XP3ێϹ  s ˜W0   # Uq	t a*u'W 4,4^ u.>. u.8 t.9  g JPqGp } y}rsng#c\XQM}F3B;	70,%C
!}S
 f`B* >(^6.>^0A6f.R^6D.V^ffX QZ^ Пfj / 
uf.R^>r^>^^)1 ^ p Z^ P3r^# v Ȫ z Ѐ~!f%#6 .,^.>>^66
0 6.ffaJ f)!f%@UPJR1f{-pTf  K 0UP
_.QpX`0^fZtV
^0T <^f%'f
  TPV!	.Qp~w

.+RR
.^.GPW^S >^^ 0 MSZ.&Z^Q< .Gpu
@_e!QJu)``EKX!a @aI	`b  .S	k!k@%"k
kf8.6V^.6I`wf#RAK`f6O`f3ffS`kArkM3$tA^`.u	DVQ
6ed dTpt	6eU j j} 4
tY=).V0#g&;B*R^'Z^=u EVW>d!bk& _^FVW +>`Pdr6`>_^HPx pfLfVfWw>p64l /t 3ҋ? f1@
ߋG` 
t O
twQ	= ? _ 68) <R 5se>puf_fq&Yp_p 3 p fr<+u<-uPR+2ZUR-( Qȵ$0<:|
uYXφP >E ߍ  {F>l@
>lǿ  u
lr3- w|_HroQO
8rK<?prDuqr)W.9Pu$e r$?q:lVWލwP <r:D9Gu-D
9G
u"LAt.Ws r_^ToRVߋր? t  %u
3y^RrWU3 hr<
t
<
t	:tuEF]_AAr r r
ê<fw<ar,W<Fw<A 7<9w<M0`00AQ1wf3aB3`w-.-_nB6/`A)_A/_"G2k-YE.p"PG>qmBHr
x6ta >|`.s`<u=0>` <u  <u}0Pvr).ka>PNÀs`~s`DQ` w?Q%B>@
 Q0s`?^P2>`BkYѓzJހJg&IO%M 9}qWGJ@6TMr,	fNfOfAg&@ ?S2fffXPt aBA@i} f.;i}w- AZ r%&Q0PPY tfGɰ
>A_W r,f 2mWT)bd@ r@f؀ffFgfd# 
 '.႐S3a `t
.~݌ffVpzxpvp"  u7 $P.~$qQnfU.E`.9`.w.F .:`0kG`;5A1>5`ŋf  t265` uuuf0=/Rk@f]anQn90P:`P;`65`1.=`Q[ fDJR RQ T
T

 ZW Z\$=
fX ZsSf3[ff$P  fff'f%$pߋ'RC%  ffC*** Please restart the system manually.
 .`<t$
  
$!$W$0AD?Ok2撰撍6ŀҘ2ҘӯPu@> ݚQ1Q ػf?tuPRPǟ^ ү ntJpfpa p6Tf W^FpOpPptO@X >TYßYfPQUGPF >J~Mu
,2 6  PpOpX]0qUf ]Qσ0ϐ^@Gbؾff&pf&  G>^ fG`GQaQ6^VfWf>f!_f!Q С ffD4$fOЬV 6ҧffP ȡ r ஀h%r$Ph X[õ ރ3@$<sAl r.ˠUrOp ` ԣA (tD_rq XPנ"Q!f0ѣ!ES  gf /tu}
> up[P}& / cB`&Xq!g= BxxwB 86{yx@ ߀ #                                                                                                                                 S .2ℷ[S[W>  t> _`W} v	0EAC r3ۉe_`?2St]AM][Q_ϔ &
`9P
PR鮐<w. [SrġzP @1234567890-=	qwertyuiop[]
asdfghjkl;'`\zxcvbnm,./* !@#$%^&*()_+	QWERTYUIOP{}
ASDFGHJKL:"~|ZXCVBNM<>?:` o t	3f<u.cxZ.cQ<
uc E<
u.b.:g 4 `s+.b" .&hbar1TaP<u< <up. .:.~p .c>`2p .?>b:P	wd.e> e,@p ˀu 8rۊ fg[ø0
.a.&bp1p.mX@E2@g.*f v&.f&˸ Laap7^*c.C3`0b  ϊŴ* # PQW`
 _YXR.iߎ
 Z k@@ZÆ;BB PV<a~^QR 3du tCl`$<6t<*t` u.q

y"P%q
x߻<Cwp.qu#rp t
ArZwG Z}YS2
d0 PR7 r  dI r`.pr`@ d`QR	 .p`qQ
t
QhEYus33`8u" f`Ph @F F@ &} tC t;k߹0Tta30h &&E pظ@ P ^ X Wu-  ap;PfatQ@  YeQRW.. {w#&.!
tff./.A_0Yu..nf. cQ󞙚R'@lmcǏڏː{?Qvڢdߢ1>+ r.W觳  cPPJ <t<t<
)SQVWێÍ-<t<wPXrs<v\.> &_[^Yy3	0		Q z@~Y!<8t	 `<P_Vt=EIAc
<
t0FXAP QpRt @Q$0<:|u꾐FP ff Pff?XV	 Xi
Pj}^Vf3
f^  Z  f`
Qf
*  >"Orf0f3ftY "++x fa
߰
E    1C< tN< XÀ Ttu7A!Vu`U<0rp<Zw<As<9wA;t^p<ar<zw, <~w< s.^ Error
 QV+AU6^YR3A_ _!]SVW3Ɋ1rKt	s<<t<p; <
t+,<Pu	& u`< r 
A`< u4_ _P&mϕOIVN 0QVSQWU3t!;wOQ
G:Yu
;t} t]_0rfi s ZYf% r?}sP r
<:uft_Wf33ɋ1 r	f
؟ANp:~  uf3w0<fw,W<Fw<A 70,0Ü@r
WfU-f!*fP3 fXpfAN u#
%f]@TQ b<'u"p{<'t	}A
Nt<Yt
<NtNP3t8tNXPL9p*HHHì
uÊG O?À=/ 3EPVWuu0_U UUJ V?c!0W4#W)%Xs'@Y#)Y+PT P G WIN @BDF8U$<w%.JGu0
t;wP
Ȱ
 3]8QW C  1 [n6f.Ƿ)ۻ0IQjY f.>)R[ 8svp $h 'Qv t?7H485 26_r SHz ueaJ2  UuQK7|e	$ <C} EuA{m"' ;l  Xc3PQfR1[3 Bf>@Q AB CPDöހQ@RmSABC DpPOP R S~ c?[ QSWP).X. uF0	P2" <r<w,@.``  .>
  <  <;u@À
s b$ b ,0 Pq͏
 Y.l<?uf. &[u
f.&)R<[ ]Orp^?pu18x f;tuG2p _1Sf鲝a u<] Pɰf   `4gB00t  t tw !Ѵrer> ZfAA Uta	$`<`ut
*B5
u0
t		 u
l. + ( @
r?.

ZE"R@r r}0MpdZrЂB B|U
|a" r"<۰ tP w  "
 B$<  wuS0p@ "8t2kTuNuF;J t>/ @ u.SutΑյ "1ֶ
 " h^v.'u ˟                              |x KJII`BC8uĀuBJu*@u
Dgٻ0/JQL @tgB/AJJ] 7솀HĴJ!R:_$ su#@G@6J B3tB  DECB@CЭZNpBD r0`1	$ D[m rPf j qbA$<+`mb+
cJ$<u	f  rZPpc\ ?B읱[ h*:I:s r p 
 R  O O 	  ߝ hor@῀ h6B؎zЍԋh3 o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          F000VQ    PP a @;t
YY ^NV^$TBL$PCI     "  $CLM    4$fp$ qf+BPfSfQfRf3f f3fg.}1/@2fƀnuonZfYf[fXp	Uu%	  	6r]dt 2
#
C2
EG2
RXYjcA 5QPP(Yݹ  vù G V  .:u.n^$fQ;!Y!fQRfCPt
' " v
"2ɵ  W t"
ǆTPc@؊2fl  2oQW!#w	t
2 _YôA3f@@ S' [P   X.
tذÀu@u[?f
4p#"gf8 3&Rff@'%fذ  +;w"Z" 2$Ue <u
203<U   $4|<0%=^ 0q<%Q f<	&ka[<u
@'P<']E<(q:<
P)!/1f= uffX<z+&<+}V 0(]fW9 f2 & uf_QRfVfWSft,fff`,r!f A;tftfNᴃwn [ff_f^ZYс; BIAf 蔾E;uQ
P"ֽ0 P	  s.E:R,(oSfRPF1fXfZO[_P 4Jvb6Wl_=8KQ_`	/f	:@TUf s#(  sf t s	  t
 @\QVWf&? f&@ﴉQ).fSP&Gf&_fXf[^<}P`L _^YSQR"fPw&fd2b@RbPbf;t
fXRva09WKAF
ffff_f#f ff#t c  f_0$0F iPSd߀M bQVfuG PÒWf  "8s2ہ`ZaDSfWoE`-y qt#uP{!r )Xtġ_ɐ/[USf<t;D3~` t
}-fu
utǳPQ[`{qY3NaPf ?X1P{$PIR    A&ch i j b c ac_` a d    <    0F00	rvY	h
`a;@;Wff . ip
蕠 EϊfQff
f aVWIB,S@*(_W赢s;_t[s)`)FO[_^aW>f` f wsup7fffGofY܂ho S1Xfߊ$
)ff  A	S22+?Qr'~!% uf 8s֊ҊʠXQ<RP
_t0_r#YPY  uf auTf|UPfPfXZ+ ]f0*ff]rffm`f#n {= srscB
Cb誾_ 1?f^ ɉ߃w @tr;x }*f@Jkw  C)ѓu6ѪȢ+f;q%N?f fBsg  uV0^Íp.RfJyZRUQf fuffVfKr=XfuNVFYZu F1LMuY ^Y]Pg>!f0sRg'QSVfNVFfL~ {^[YrfqXftA3PXQM購} N Ow蛂PRA` X{PiWU豐Ԁ_PԀ̡ A1\е 謱 m]eXÀ-pߋ_P^Z`W f} mp_p0                                                                             8o%  @8sUv V ufu`vQ2=fA<t1 u!ϱ n #r.V sfYZ]fTf{;Pf;fZWf!r@mrf+Br
c`|s
wua

<1GM	jrrBanP蜗XPQqr Pp$SOs[OBMIE{/{J8O 0p`XE)t fat/+f %#fSfQ< t1FQ2" aҥUt?$7 3#t`c֦i[0
ð-@_MȯWV@ ~WB Q Y_W
t^9lnst6]V! <5u G	F^B^= ts.
<5 = 
u>9r  Xf[2P
X^#WfVf桕0t
P E
r&< u P B S f^cô P\Xs #̊#$$¥$PS)
u $ސS C'ð) e1U
 ? 2$
Ǌ4D O $ $
rs) 3+ \tA		SYu ð÷Q3r+3&蠽QtF!tt	*tEPRQRS&dR"
ǆkR[yRPR <t<!t
<P	<*^!`R

	`ZQRs݇`-P [ZYpt 
k ) SVP֎vS<_	 SoX2 F^a ð!; ")VfW< u tr
D@-Y m`7i^H3K|
u|	  (t0  $<<q<
z^À3 t" PQ ؊% ȑ"؋~*QZu pAXðLQoVWP 
K4X_^YaQKYP2bO PB2|ʁCqmސ]
P'"4#f1*WRp)W521	RO5 +S,ðT,ժ Y9@ZB:. Ur&U;0   @ <ۃTPQQ`RP }SǨXp <u
s귄3ɺZQ2P.
X `.afV}`UZpg	r r" s Tz @\ 	@V~Alaf^#`^*2Pl$ԉNT@׿Ǎ~W@fF$
&FG &U_ؠ
	 1^a`4SR,غ*3% Z[W  t2_1R Z؀ˀ$0Z`  |ـt
 p A  PQRVȎذ56	f  T 쨀t D^Z1 Ӵ2%r$<ø ؎ffoR
 b c{&d p0ff#f' \Of 'f.4 tf}f                                   0ؾ +>&   36a Á.6B0wRZLJF@SAJ"fV$
Ѐ
tOf`JTJW"TII4%fffX0!n0Pg&?tgf&Gff୐f6f p  f  6<	g&GR uf#rYfXQf ԁ*K!!V""""!.øJK bUfQ ufVKJrMfXfu gfm@ N V F u(gfFffff_MufY f]Ë<`3R+fQSfVffLfTfDfLwJf^[fYrXt	A3PXføMRJøNKp ODJqR
WfPlJCIt3   fRfZXJP7_f]P^YPfW1J tItQ0UЗ请XY   a  YXt
 t$HtQ!  v| nIPX(RfVOt ͒ >O( Vow#t 'r{#r	@ qf^l; QWV #wy^_Y %V3۬
Ê^pS {/u e &  rV1fffa.6{/fff;w	rf;w %5S.- "}  u f%3ӎ/aBRE@u$Pý 軽ذ1E0E= <r}PO<3f
ffʝ ff> f-   f1W@~>Eܑ3&G;r_SQ`ϐ%" ࿹ S q  t	t`Q@fR0  f	@` uf@qf⚠4Z4f4f  ,A[fWg&>wtq r 	r
  u f_bUS^@$f tt,$
g&"Fg&
FPI*$
g&#Fg&F`	wfPY#F	YP
`VvR	t#1
t.
wt9twtt&u&UR2
~	t
t11tFt`
t~g&`
g&-@
p
 
u
g& 	TA1 h a3Rfn`\&^q\uQUa}LL))")():)@)  Y)))))q****a+)O,,O,P-WK.}.:(tL u% 	(t>JrS
M.[t $M.[u =
(t(t_M_EfUv"v t Ar MG !(.V PXF
 Yh@ &A !j@!
Ṵ \r\ôVĂ
	=VL(._6(# (.`<.I.
Lj@s& { |0u ^SV#D.d.$ʋд^[
|	ã3j0rcOt` 	OtOtLtDLt
LtLtLܑ

1(u	聑.<胑.}hw $ BÁUu	Ugq fR#?G rp
\ߌZU fP<r|wfDN u
 sup^BVWUuP؎&Br& XL(,L>( ..>(~@`O߽(Pa 3PB &Gݾ&G $ $PC &I`(US`*B>F &g0&G1&O2$ 2&GAX]_|sa`s@ \`b 
 (EGfE  A(ff@1 3@WP~޲ 
ra贫	(E][^LuRE<sfQ@M}3  />
M%M.  EGǿ ./17p;[Ü
_Z[Ў.g(u4tG uFr=ގ.EP .&$M>AK@A%50Y\讎 @Ɏ?6
MP̀C{SRt5ێËS.q&Gf. M`÷_f&_ - pY2 (Z[fUвBSsQS9?f]ò..(.@ h.q . .0 /P _/ e/a /& @ 0 /0	 80 I@ Z0Q @  
1 "@ 71
 D1G @ 1 1    	=Hewlett-Packard 68DTV Ver. F.0A 04/28/o2005@ +
]  Z q l ~aq oKBC
sion XX.XX@
 
  p_ 	o~A#  @  A  1 U10 Intel(R)  1rnal L1 Cachea bi2e	
   6PC CARD-Slot 0  
  	 www.hp.com;
 `   
 


 DIMM #1('28"
~K"RVpb Œ"ۓ@],N_o bat y'+"
/s_t$W^3p_T*u	  
yjt)Ӏut&  `5& A)߀u&uu#
u! À8W|@e_ AU RtY pvMuG	0bu< u3uOQtru1 tWa0> S:u@8*6R:EFu E0 } jQtTtt߀EtH710F )t%> t:& tSuEu饵3T ߖ t TE>I q u	PXuP3 t	X랓tS%yE utQ 0#)	&2!q =E3*x3;r.Dv+W+Xu4n32#*u!.7ð-*1!	 2,<Gr<Sv Ê,G߻.#]C%J u$
<.r!Lu24$`.Ƭ2K#/虱rPA)<.t<+u
0 uθN<- " uJ,0r& 
P56 ;6 %10   EAX= EBQ C D P@SI Q S CS= D@ E S I1xcept1t4 - Overflow!5Bounds Check6@Invalid Opcode7 Device N hAvailablJ8Aou` Fault9Pu Reserved	10TSS1SegmentPr n12AtЏ V
3Gener`xProtecErrorq  1 =  System Ha!Pz&
 t
-XÜPRL&<w tZ fVfR6A6FupY6诇/vzu6pcP6 ύ66{
6tfÍ66j 66`fX/6T ō66J`6#6A0Ǎ6(67XY_WQP6=6$Q-6Q16p56
6966_7F
06t6]&6x
7_na17WJ`Q7o@b	[eQ GI; 1`Ғ(0X[S	m 6z7 p C8BBaaB_a$at@0 UFfFɷ͋N
~fE F Nu3׺ '7ȷn ]
 cRQP~
XÊܹ /FFYNZ1A`QjY`Њ  aÇًP;"ԃ ; & G(; .&9'@'dQR Z
  c }Z 
G XYZð
< 
7 SQR  ZS r  `؋  p 9`]  K Q!
 	`issa@ ؀ `
UЋ؎ ]_a	@]3G
AF `P= C0[q$9SR`` $<u 3 0ؾ   fa3S fK\Q< VQ=3AUAY^` 
aËf3RQ3ɋff tfaf3fRAыf;v+R'TYX0P@YP\UfWfހ&и`1fW`~]=~f_ff_]p_f`ffWgf{#Eg ِˉ^PܺAͯvT2gfސgƃg u	f@w1  f@f@f_gf1 gffgf0	a	fQ@;gg&fGfXf7;wf+f1 f7gggfb	fפ #fgf&fa
t@@P	3
y
ff0
gf3  P
@r@
A
@  gf3fS̓ wff#b ffyZ?'wf3f30n,;wfoPf#~4ܼbf[gfM p2
ffPT	c	g
{
fA"AXAP
 #W!fكs À +SfVQp g46f?FCYQ  Y`@.f^\ g&GCffT[(PS *"
ǆ*[X0Q2ϡa ѡY`CuW߀t=u2
f)e)f)e)20 ))膡a VRtxSR ڊZ[  Z[K kSEu?{ Ƞ1*t% 0x
udrAZ^`au=vu8>qB 
ً@Šp 2 讠0URu<,u7Gt)ngotڱ

Z]PGbXU 
 s ]`K:.KxSYYڼM M>rQ4Ys\ P( 3Z[x0"'`"yP3
ݸH RٸG JS QL -QK %S
 pN qM ,'c'
(<Pd4DaDDDD(EcEEPޑ&` XW<r2  .C_Swt 
' t r
2[e u0^r!<u	rr&; 08Qs" r2.C2& r $`s  r 9q	8 r 	&& rr	@ôQSs+&' @>'  sa䡯$YsQ
u>[ Wr%p$S r rq	A9 f" $ ӀpQ@	Pm ;X߀ u#t s@tVSadt`bpt t
@uQY``
 ةXr`QPPPtSXdYwQPR0 	`̢DXd$!<!tRRR  q&@tPGpXP (`<u
 @&   >!@t]A AuqP#@u  , & XV߁  0`O  r
 P<Fu u5s	 	uA
w fu	 X RtGTtu`6FtEuU0rPRtKxGr t& 0R] Z$&Duh8 [ h 
XuhT:rX&  U 0u@ Uϡt@Q!	 Crr
trr^ d P dx @$& 8t   0zQX uSQ^ `b+PH o`*C: E8m01Y  @=@X@3@*L+Y,lrams\j&D
V &Dt [@l 
B Flr!0rnlsukF. uk'kI$krOlsJ)ʊKZ Skkrlr
kr{;a?kyoiZ2
 0
FFt N fF" B]@ BF(	r2BB2ۀ~ t`{  t3ҸK3 ;wu;sbFVFF"F
F)t r4F$
Ft+ F P   !VPX_V@"WPR u	ZX__PRARZX ֠  0 " p	- lFpoypOIEMAG  IZ P    	
  `# HDA-L  HDBs A-E r Cu 0USB-FLr CD Hs LS Intnl  PCI-As B C  % eO   H	P 	/` <M {L` c!LF	L aL ?nLCD001EL TORITO SPECIFICATION N4NBN+Np " * Gxx  x y 1 "Ϡ *
x"x 0~  	 s w_X _y\[8y y  lb éAL^T ËEtذE
U qt
/r0 t
rÀkÀxf`i2`tW &  d_&E3tB&U
&]@ &E`o t ûNu}0&E@ !2 @ @,B C OEPTPPPwOOg]l tg}
3lgE

OU uO[l 3M    SQ>u5 Fô% 華r!<83ɸ  3 3Y[fPfSRVk&kXAotEt#? 2>Ҡ<t<tƝ< t 3ɿ^Zf[fX_V ֐uۇ P	ir
- ZtQ[Q =c
u"k2kgu
#p d&.}PfdfBd@!pbs dMd5 d	 J V-d&.d<d;]ttd|d]^  R 3
' ' FǠ  F/\Q3 .;v+GuBG
`_F/ {@8% 	pXvNuQ
 	߀0ʕ NY%'
r0123456789ABCDEFS 8R׆[p$PIR    AݼUi j b c j` a k     1  0\00zrq^h
`3. W@:;p
蒣_ϊ~`/1p aVWRS;t St[
D[_^RW3`  Qբu t`GY-h /$_ZaSQV.R A6`R.R^Y[XÀw*VR | 拴  t.5TZ^ATrTTiTUeUP .UBBX$JJ2J쯊BMP舀aUtJ MXu` oLSQ V tA&q JZ  C@A  u*uP= ]Xruŀ̀2	wR
  (8SQ2<

2ۆU.
$2rvqdX<w0
u@ð  2` 0      GU uPpuXd]<t3 r
tVd4d8D^uqRWu'Es T^u0# `|3&
yt,ـp&t&M1&G&aee`{eLAAA]ea+Íu 2<ytȃtm
 Q ܈$FKuðÀQ
u	ۍY;Y0uS؀uu)4e  6 u  pt @f߿$f
f@# аvRWS22f0 r, u  8s܊[_ZsfQWRfP
t)@dcr ff  u Þ8ufXZ_fYP rǞP3辞r: 蓞t+a4 v w
tM茞8t	
uY0	g&;t4g&Ct,g&Cf4\<v{f@ f٠
t
g&:#tfC1	fSfWfVf޴r7fg& 	f`r!f`Gag&O@` Nb O q,f^f_f[ûpI2p n_ l C  Ơ #  Ȱ 2ð
@%,pߊp$zґø
 а	2s s	2  |0zs{ l	 eP{2U2 	NÀ8 tN :4ހ4-&
$ 
$0 B$2
åXXX Y@YsYYY.Kt'} ߈<u 2謈h: [ h; k1qqswks>t_os
2 \"r  |  hkp.D.DS~ ``࣎Z&&D a0 м tj &&E  燜3Լ{1?ՇQPTP !1XY`.\.T	ώǍ>.L` ``a.D`}`aQPƌPXXɎ6aÂVVVV @@ "HU-R~BG  {  *[%A	|`0 Gd d ", hGa  }O 
p 7Gr rrs sq]
ws "  
0q@ b6r@`r	 
Jr
 " `q u #` $t$?ah@ &o r 3u^.\^3!' $< uȠLQI<u	.\ u<P܃ H$\   tu vu	V $
s4 q}S@ u7|`P:<uip@UNNNïO Oطo$#Qc#jU fBJMONՆ# FfdjâJf>B@uf  F J>J t&r9_Vu`vRiW0fof+0vQf׸@
YrfǳA$@h^fzm>uIfs@
L
f6Ǿ0 uLtrr
>L SWAs!o`1`?`(`  Mo  1`?  " *;00 *
rB~68y Ay boc é uaU]EU  ʋUо"*r t
r ff`tJRQW %  d_̺&UY U &E! t &]@ PaU&faa
  u(<sW.`_.}0"29P0=XsaQZPru..&+.	pZ@ t^P.&u @ u42..
t _wPUU*P*о&u XY`-3P A3.{G@
X԰PY *.YrPWȎYY_ vbbbbbbbbbccccccVS3м.:0wbu01b0K`"@[^* UFPtb2SF۹ S.9bF[C`N[QF?tEbsF2~ tY@ ø7
 `  _ ÿ8	 d`d@=65A匰`0ތ6 3`6$ $ddd d/dBdYdud`d$!<!uy!!`& t"&& x<u&  V<t @}K!D8t( 2 '2233pgcf>"  tq" P a2ۊ࠿( Ҋp ) ǊȊ&)  * ߊ* >+b#1 d>,ߎ0.- &) r..PR u<t;60n6 6 $3
t,=

"=
 
0I5w<t<u FÀ? t< ` s
Ê& 
<uaw\wWQu& ` u4趟`!A &
Ø3Y6_ FF;t2ø g}
3gE
 t "6KD  [gu@6sU I~2KK  
$t@U&E
3`    F˪	^>]>
 SQfuVF! s^(2۹  `F  +^D_!8uP3?f^WVQCuKEE! !0w $I^:u:\!u Ur¼z@Y[_S  [<gK.+pY@ &&o@[l0C !mEu}u @y$
W`&caAo7`M-faRМ5tP($t7  wȋ@xZuS1av)|$ #$t SQN<tt	fP} P B `Y`X! p+-hw2YQu[ AY<u,fCISGu%f» f f f .>,h .,hQSWf@/ r)vb!ufPs Xtā_[Sf<t;f3f` t	f 7 
utǳf0lf0`
 3oafP㈊ Of0#g#/;{#(?$#C"$)	eC"VS"4"m
5"!^Z!R!!'k!!z$ $p>ˢfaZ2fPS pl@ f.CjjO[
;.Cjf`uh [ h  iuh凲aúB   $.CjϜp$ q| q 3Ҵ0 ./@32ƀnuo n;rp'R |@  $q-uﴀô Ө S3ێۻr?4߰t WO lf`1O_QuXûuuTf`0D Pfft;  Qf3虊Y,65 !wqO LNðɆt w ZYJBI"<t$ YAJ_BqpvBМfUfPPP9XZ+ f]8fŝf]rPm@n `m/g omi &  跂
d@F/U_SYSID_  m _UU  
 r
R3҄ /tZfl f@f=  uFp fl Ý                                                                                                                                                                                                                                                                                          @     Z   ?
    S    -%  DX' p Jā݁2L\ `ar(D
@ JvArHvA.EsNfj@&t FN aR3V.KZr# Mu 6AKr pt 2rXĠ	 u v thr&3&E0r" r2vRs ÆUu
FUF ߴ	 lq`	 ӥ/2	r@el		p脀'^F&?s߻  s& p  &G&w&G  OD
 &	G!fPfR.Mf.u E	ffPEEabgVfQSjf[[fA1fY^f& u#f&G}P Wf   4WfZfXP'F#~r .>	(t7 
 /{r?`. t8 ( t] t  2SrߊV ʿs`,K	p K~t$` t u/~ǉ~ %"NV 1	s^Í6
M.|uL>R..K`>AK .:UtaKaPWQSMن? t0.}u.:Mw#.;]	w.:uwPw.;w	@w)[Y_0? tl>ـ?r.u|
Պ Ѐ ʿ.E;v j'fVfv=`$dD @؊f
@NP.eXfa ȋP	rs$
2

	fX!9
dDfUv]f^PRBU@    ZXRPXuUW:>_]s*r  ZP$< - r!P@Xup>q ݪ@<@0P  *sX切Xty_>Wc >* BQ	?Q	 QV  PRW> P@   XFrr#r^rT:rOt :DvL*Dȱ f umfm4
u
rPbl
u2 VWrd ?_^ q QP&:Ev&M!&*E9aVBoCoz<@,rFAnr;A@uQBu< r
tr&wtptu
ZB\r rR$!Xt24 uu@uu`  u2&?fPS `00v[fXPSpsq`D
>X`?D<PƋ4a`t} a1t!$!"q1&2PQwȎ`SJr#SMwO "t >
`P2:Tt
a YXÀuOuQ,9a"   <s& ? `P93 >
M}u   Kt| KKVW_<uW<
uu(F ><@g2<t.$S[M[|u|
`g|`it\_^FS`}
u}	 !.ϱbπ}@a`pO1uD}a1 #%D0QV 3۬+^YD$f郃fA~ff?ffJf\c
bPZ#f F PXpZfP~Đ=wr0&pw)Efpun fau}Cu~s3SV|t` t t
^[PfQ
 0 <~ @f	t` vaif`ffQf i Б   fQHff#f+ִ f;wfg3g&Sg&c
uff+ffa1
fP4SR%Z=Q<$ o0 P@AfppffXMRAZru}A4Zr
pf>`P2ǜo4XZ[fWt u:
rrw`Ua `B a p 0`chSQVfՙfPh  KU@PP  p^Y[Wu(PUFP| ^	u<V_f
EoQ ` QpLP	r=^ uS@]#^[u"

 
 ^~u.t Uj@w`V	_L
 B8`.߀
u&* +u_A·0$_<SfQfV Á=Ut<p*MPTh˗ [ &Ep` `&ufރ1}   \f^fYfkSUh &]S^ σ] $!&ݷ&DDV& OfȡA\AL
^ρr fW@VЎݾ &0 f`t۹@i0Kʃ^0 P P&t_ 'f=@i'+za¡f;;M E ~p  Wf/.ɒ`	Zg&G_E!#3crR-uPTPf.ɒ^Q,f_utf`@]StQY f{qK׬fp,  !ft !8f# ,=;1!U
UEG &E"rifa{Ñ 'rnOGw{|P_@0Ъ`Pm~ %؎`1#w0舑 \<t+Q!Y<%H
f߀u f` 3` p?t^и	Y 6.WM"fxNf.g
7 *-""#:tqOOP9DrQ99: Lp;.9r()uxD>(uf.ɒp ͒- r=.b*VQ$$D
 V&Ta<^3Csry9
lY^rBG0 ~50ԩ80"B1EvQf7 *}(AODϣKs(d8P9VWPWNTP
DP EDLDrna
fMt7JWAM ;n?f: vM9^_OTrNe?:ffGWfQ@Q4T=M1
e ULKL@BLR G`G^OWXVXXFPW)G@i(WPcWV	P&	3
5O`f$Op%UOaaoؾ:!P	Qbq`#SS襧(S8Q@q	)UfhR`e_W3n  {Dku_z1nhQfhthVhphgpmN`)rpPjYj|t?= aYi,V`{A
1$pf[iPQR B}ȣuPRS$0<:rd uꝠ߆P P H ` = Ўr q& sVV:gfFtXRyZÜSt	tv
 vt[1 Ѝԋh3 VVVV  A	  " y y y @   D  *O VO UЍUsU U	 Y
 U UטUABC  PP PQ UR  QS UT}QU %QV_ )QWXUYAZ[\1]^_  e` ea eb Mfc pfd!eqf i\\\[[\4\[81Mbߞ_Q
! YQ 8  ` PRS%` +}ð ;w[ SRW*OIr 2 3_Q,ԴAs` Y r3O:=3qRQWSP b	+찂X Q쨀t_Y3l !`@ sX Jt	u}RX( V_`m 7	XAP)?[_YZà2<UuX
8
DYJ݊Bƃ   brT;
!uP P2
XS@
u	 =  *ê?<BVWQPvDt!WQ:t
Tu8v
Y_ԠY_XY_^ _SM?_ P_DMI_ (.  #9u  2XPUv F t	F !Ff@]X"X
W8 Ѹ tx"i &g +  pa
u
f_N@  ]ϰ2ðq  S\8&G &[G G []  P!@  ]  R@@\&\p F0 ]
..c3 и( и-  2P
C@@ XWP/<w3t u*p O $9F& ._@P ${X2$31   ߞ pR6۳4!fβ ufQ8fYgBZfY[0|<c3]Ou r 2fPS=Au@u;p u39 u+ f?wuf_P@u BXu
_ff`< t``%Qb{At{N|So{_ k@Q  ~{{ o{[KǠ !qO C{D{{`{Q   A{h{opyRfW. uwmp3g ff=SCAFtV1G tPfff Wu_f(#3tfPf
fXZr_32 p  
` tODu (ɽ$
觽`,a葽ô%臽´+}蓽sfaPKМzJt*m u]$t}0P$< ȋKf`a
%D	-	
߸ %` +$fa r<<
%	*P'z @TO xOy er$DIsL U]tf r.]èlݢ N|	r.f%f UCESsf3Aq 3ThP pi1f!u%f#f  [sLr`]p s` u `aW	ff#f *;֊0l	rf /Q<t2f3Cr6
+	f `u g> tt r(>2 t QY-^zfR
E=4? 1t?t
$r``fZ 8~-t(or!1u/t
J?t:R!4g&? kt0c*`QfR88t , tu
@u$߀2(H)@t'@u'-*tp(Wt
`!- o t> {f u2B[S 3q 
t@  t}[QfXri/p/B/RZ/rGU/Z3tt@t$
ðzyŰ,d$t  |sZ
fVQ!} 0fF3Yf^ 0!(7ŷ   $	i2fĢķ@G$
  (  SfPF4fXం	ش  [fV~W _ W
t<5t^ufr ~ീf^PrѕQRV3P'û   FKt
`ۋ J8u^ZQfVWf 5  f_ЎmE|Dw@t0	_f^߀uEuPPu譵uZPPE EPP runtime BIOS - Version 1.1  
 ٧٨#Mréϩҩ
wUd Pd]@Jw.\_.\ bߵr R.\ ц
ZpQR߆)Pt<rt2[5$ԁ !Ȁp
_ -"  S`5	$  ?p f		uR &xuR] SUU.Vf	`&n ^C^Oߩ CW8V	al _Z0mߧ
 J Us PSRj<3
 j ?G] 
ty ).> . 
蕛   3R߃3ɀuABw$ԡ 3ZP1 4 W>b
/sNP^RWf;r{f``' uus'1f qr({D<u`} up p faUQU@DF @ E] < t<t
 ? %xY]Ѓ43O0bLv2~ x ^7~wR0%RMwrgf`	x vt@- _ Ztk	[ ai09B]K+^=s^  "#@ c@]Qw 
 N3u
PBxvp0af3g yPo xtԳ$4PPgfffۋڠ ^v3&fPQXLYqcv)Ya=P'уa`` ;vP!8a	-vf<S`  u#fhv`cAvPufa@䠄t"
   ௨u$! !?p &k Xa{{ݯށ *q밻ݰ JIIs@P+FF
]X `j . pDv
)Mf.N. ktI4~H@5p3^)tuw t&Du .⭋^^;Za.@t&ڃã.^2Ȏڀ36t6^2~. @ PSFg
t'.:t	tX._0``P荻
Xu!P肻<Xu @Putwa`
 PP?3@C3aP2Xr-s(@rH rr
 PRVvF\r:Gs5&DC Hrfy苡_FÉF(t S^$:u [r
F&F$%&=vHH&
D0&d̠u rcwu
	A	πϠ&DB êǪAT0	VcH Urp评蟁s `-su fqt
E$藀Eab&G 
V 蚷Nh8Kr>u rG mPo3F) r\ {r=H r8QWss#

Rr
3 s@M1 |#k F("r#Qlr@rk20!0pn0×!r"~!F( Q'&d&K0#V&Ơf)&t N.rfPS^ۋ^&t` $ueG&uFtt0b](  ߎм  pKgGa1Kr dt
t4t p掊h2PO W校F X @F$$<r$:u s
jútA$좌 
   @  $tVrF.^ࠍuDF&?D F%~)u*&tv&V$`
V'&LЀ E 6F u(@$3'E&f$`p¢F f%R$PG- ;B(FGq1ø fF" PXN8NwN 4o2N0(`00s/ mlpR
 r
fQmr$f_Y_/̡+U+Ñ &ku btb@q? _VQB  BY^	G }$s
3
P&u3` 0r
%u@,àt <q6(V&TЕup 
* &u^ô  胻  ŅQPXuN%&:L * r$ P @uP<ut.@   ; E q2s2p$o<@t22P !$!信$qXw [[ĺ".Pù[K<P  = sffP SQ  !>Y[$~p
C?Ff 
۰N8tSFt f% f @ W t0    "   t  t	@fX
`RV s Z!
J
8
(1
ҿ$g4 Nff`4eA fu4fafFD fP2f tfFP ǈ^DPm fu
fWzf=3#"fF$QiF,0 As{rBrf-1fv,v0h,-(X(@$иPN$fFfV fNuf2N t
ffFDlf3fׁ1	f  N xfWր  pp#f#ffá0 fHfVPf#f@f+f;FLvLfFPf)FL%	넀ffvwAfI| )@HvHwf*ݸff
fA{N
Xf%	3G-WfA d!`
;Vt
fAP
Q
ĳ6"P  f%~" f%  @"	 "f'F0002F%R) !.PSQR30? ;ffJDfZÝ:PQRWSӶft"X  :
;[_ZYXS[  QW ~:߀@: _Y[a:pû z
  5u
 @ @Üu8 0  ;P1 F4;+@H0P ߈>%F5 N0Mt(BR'9ETDHP  SIMPLOiMO?TOROLAVPVS\~ЎHf1P-s@^s˻ʆ~ >I1` >K1W M1N O1EQ1<@S13 SR &
 3-&Z[>U1W1﷟	\1 & t
@~Ph+؋cY1~ ^1ð`1@b1d1﷫`w1؎&3&M<St<Mt6 6{ 
6^VO D_*>U  ՘RPUqh@	_	V`
jM
D)+ 
r)>1&~X^ád43ð4窊    SQuP s"$@XuY"@A`"p"Xe<"$C"SHtu
I4
<RVWpi1.1Vtf&KcQ<VV<WpU  mT `aۣ0bb>bf F6!s >up3J@i2>F@a`@lBPbBJ肫0чFdoOifBrF .J>J u芫 &R"qui`a !؀~ !aK@ u
_^Z2  ^QWVV_b=L^_YÌa>. `br@" u   ߀3r%[UPR  r.zfZfY]Áāza /  b%ہ݁Ġ
T!@BѤK K()g5?`IEcOYhgh]}Td# ޒD	ߒ 
(@ ķfW 3sA<uf,u#89p f3gf&ff=SCAFޑ2f_U< y
 	<! F ]  <w&< t'V3ɊȈ[CF`  ^P  рVV<v^.
t" ؋B^Ur t }]UP XTs.V Ou*]llA ! Ϥ؅ g lff뙡"M Pݍ(p8gW#l fڿ<|Òf߿Ql:r2"S"脥*~ O _ hbr["2ɵ"\TYX .63uRV@ ۃx  tcPtt>@ KXSB$x$PXr$qQu!$
BB<JJq4HX1j3ɍ6K.Lu.:Ls&3.D}.L~s` 2`r2`wu 2Pӡ Ad K{^t
`3ht t
de
u! ޣT3ұ gu Iú tm>
M.|` .$M u}} P J}uL߿   u3p߀uv`bW_tURQpPUK2YZ6	u>^
 .D t+ t#VL^ 
.L{ ]Å Q3|vYs. uJ	 t	&Uu"r ώ |  Êöhk.f.|f@  3.|4߿\PQW 3ۍK#_,`Kp1(r  `3ա$߆ޡ &?t+aP`)}
t 	
t>AK .:UǀV tMRZ| $p$u$$<t}Y^^ Q3䆊!*Vh 
M| ^t
.uQPcs)t!JRڢFu3ێێZ
t	'u
u
 quP@s+XPt oڰ`izG@t"Ĩ@t  p 
 ް  XPJXSPR .+. s#. sXP&   &X[ó5P϶'->@Ɵ/HAC  I@ σD
 uj@ t%v lv t ArMv .sN-f-p̡&A F'N- aύ6& 	_!
tr ^	
F (|r
 	u뿋^'Ât %轲1+	d1*515r0/5Mrr[o[
u< r<0s<"N@PQN \
󧐡
`' 
$nvf<00
ݠss>L.u.
I.
M.}tj@&u |t
  ^!N%V#~F`S2 ;r0Os s6< s
	OtE""Lt*$Ot"#Ot%" 2!)A
 ۊ؀	.EF C
r]wsms1I9  <$u2 *<#"<@v<%ހp!2`p ]
F!UǟF% &F4~R=or&@mvp8F'P^S^!S&EF'U&]rQ[P@ [fZsSQr^Ë^6L~	Aؠrf;	DE蠺⻀~(LuTMs0]fPf}3ȿfXr1Q}%M.  .GTAf f "./pp3V#:Ttv<~'t9r0l졂EE&$Mq<DD@ % 5߹I~6
M 6u0fPfS&Mf. Mf&]f&} 
M[!
0'Qf*  r}﮵rxLt=rl`x5rdPtZ+cr@ H u~ (um-VƎދo?^@tffmݵru蠡 Y荵r)8r$c耵rre	rjPTPQX rpw
uߴ `fSfRWBt:ـ?f.EffffAUffsP-EMF F
tSuNff3fp fV
M0WP*f8f'w*f'F'*2t*܊f
VvfVv 4_PFsQU n E]YRPXtUW:>_]s#ro  ZRPR跶2_B@ ǀ ZXȌً goAp?B``QK0% [ mo h謀 Bt Z^Nrot
r`a r[v"/>L fKf L, 3S5<s-
MO8L9
t" >LG<P#<Q$s@ dL PQX h   t޲rzvru3rij`wNrWu
p`dع 
!ʲr.Ǵ%a@tt t	tCHq% su~rt	 2P{RZ"F sH<t<)t<(u;ь>A u/WU>ӽ~`x]_3ﲱr0Cyq`_^a靠'c`&PSR 2Z[`ÉRFtN+P X7D	F
+CIH@FEF
t

`$PXfS~ t=~^f~^^~7^~FF
>FFF  f[fQ
tW 8vNC؈^~nNfnNfˈNnfN߈n"~*Ċ^
^QEfYSQKfPv j 8rC8sfZRfXfP8FfCF VvuKQfXr+tðP@P3 G& tff   Rf+IYL@VEu$ CΎk2t
.	(Q^G fF! PXG t<"u<"tlV3޾x 4Q&?s0  s& p  &G` ` G`  в&O _&O`uRp`?f&G`Pa  AWQb b Z Wsa,ZX7RQVW:WgtNuu .!6a u/AŠ ?L	
 t,6pNoAOGA&&d&D&t&D\3p;_^V
} " uRP$M
  ^  Z q Z `Sl[PS3y[
$Xha!hsɄ3ɺrQ
1]!1 3t_X fPAMSUߋmVW  Ў؀  苠m  u
  
a 	˻ʆ 茓rr^ɍvcF0`& O@a
 30&O՝ˁ+FU %n	x_]v
` u_^@mw 1
Ip  MB RW 
$\. D -&= jL.&FGvu.v .p c0ku#' / y/&m` 
;kub/wf3ɐ  Snuf00&
 3@_ZGF< u  u2D@ PsN~ t
SP[ɿ=Nu0tut

qܑކfQW h f`f8h  `  f  º H  $p`| flw f
@艐ā rMf[5f{ 0@f% ;tf ff w 0efXA_YRfx ffú J4Z`PXfZhc``d f@u
f<~fQɲQRef%0

 iaDplZB_B3EA169!ns`f ft~ " QBY ffѿhfaqvfQq_ 0o3ff`tf 퀸Ou1rWyryA_tp@12g@c@rQ@L G B = 8 3 . ) $     1_Q
&Gy';=MQ1?؎^h(7 [ 6^ذw8Du2f3YDP  y赌6;.Fz2c txqf8220f9Du} 2 L! "
f6DgfFfP f$ {E 9PqgxfX A@:E Ɇ  艠ffad :ú,:3éð P<I<t  =	ߵS  A  G " y 0\  w8y auR é&uD ËEtذEK
!urcv0PPur߰v2t+W   d_̺ &U&]@ &E} u`3P3Ҏ¿x ȫXR芊Z(C)Copyright Compaqr uter rporation 1982-2000-All s reserved.*578F'()+3457 u  i5u t
&  `
x_t^t]t\7utF5R3< v
<ar5<{s1$PɎ Xu20tr2հѾr9_2.Skq G$!u@t0<zw,  
tզ

	t
w
 b2]kSJ, E ?G@2q)Pı
 t"< t[r0r	
2 y vPQ+s	} W	fE쀥HPPRuaa@uXXZXp! / KYPX  Ü= srsu
0{ _ ?߸^ 0<SQwt͇.Ӈ ! !$諐 oc1QjQb;PQN 3۸ K PV'!C G yC `@ D"F?u>$q>{r>==== =;ra(    K P300дW%,Y.s 8 0ff#g&'f   Z= 	_\`fﰖ@`$0Z'<t#<tNcN T M_ {H<u 5  k% 
 Ta(#AVW3xu@ G?	u1d  (@WV 510t׏ Sa X{#^_S/RS$	ppqu_KAgpX H $tu;2$P @  vD	0ggAzAiiBBpBBMlHl s@0 *VVVV%Qz   Pz  IG  "z! ,@;b lQ.FF.:$tF.Y26-qwertyuiop[]
asdfghjkl\zxcvbnm* !@#$%^&*()_+ {}
':(")~+|3<4>5?9 789-456+1230.
 GwIKsMtOuQvHJLNPRS 
+
 GHIKMOPQRSPkXu3_uCN@*Sf  fVվ@ ބuP|t|t u3N@f6 VS|u^ u{N| "|@N`R\p Sh|tE |0{G u{t!1|vi
,  
]]f^e  	       0AG$ $  GNa P P  Gh pGt1$  0G   
G   \$    П    %.]r 4;VET]                                                                    mS fA  h  O IYOO 2	bvPtF X .	˸ f&q && "  иߋf3 ffi._f.]p >` 6ma  !ŀ.P f.""""" ! a
#
Ƚ 
 f3ۻgf+С} fP s fX   QRfl f@f=  u0p fl >@  t@&?   Д%TՀ u!uOǿ<2{f]
 N] d `5dPQ3 2W7y4rdr
` r`f<	4WV/.GF^_rس׿s rD.\RǊAP|Z!R Ȋ̱9|ऋR źZRU  Boi|R밇8AS؀u
RRp	 X E%
cE%cX< $ZT
 
#?
t`VWt_wZwU
uQ6rEt> r2
tC rͲ  r  P O
2    {_^a2
u[rVeĥisCr"trS ';Wr6"Qr
Er Gޥ)߫e  
 `     tK\	\p*P')0\;#$ rIW("  k_!P(B O่5B< t0@@r4;3r!-8 ,-BF3ɰDx@D+ȳLDGwADP̓QPʂ ~<蓰< l<0c<%Z<	P;Q<
QH<pi?<~ 6<
-P= uX<<p<p XL]WfPCI 2au_fQf7fSt$fѻ"r   f;р:tN紃 f[_^fZfYff r } fu
N`ou A s r 2fSRfPPc`ȝ?fXZf[A`i`ff\H`F)`5	
`ff s"s t s0+  QVW&= & s fPf&Ef XR \ _^ bTPwpR`;t
X2 *W 
_ #t_C[X S`~HsRQK_уuf   fPffpff P8s2fYZ]Ð"s* UӞ.:f tdu.V.f]$PMM wm $PnP!     P fPff  @ fXtfUfp  -P2fVfWg]?rdd?f_f,@Xf[f]ge333\rVd4Ad^;sgu` 
_3 i\s M tAt<Vl\rdDg}
^` VWd_^gEdTg}\
}	}gEKo tr	 	t}d8tW<ytu@D7[
`PfUf]3
t P/u ' d.;Gt ._
uSfg6$+' +k5~~~~l|8 w8| 8|8||  <<    <fBBf< Ù}x<fff<~?3?00pcccgZ<<Z >>`~~<pff f { >c8ll8x
~~p Q pp		 0``0{q,ff$0+T50xx00 0 lllbll  l 0|x0f 8l8vv ``0```0 @  0<<f0 0  || 0p0  x8`̃ <l 8`;p  x@ |pH `a
 
|x  ff|ff ll bhxhb `f> @p x p
pflxlf bf   8ll8` x|xpᴃ$ x0  Px ƌ2z xp``x  xa"x -0Qx|`` p 8l`0
O v!`lvf0 x  `b  @SG  !T vf' 0|004-!)*`2
6 	p&0d 00001B  0 v
/ uf SvN .Z2[]SWQ tу?Y_  P,غ:3%  ZPa ThAE eMA9Y.nSSK  Awc( p`
`3Ҵqu N <tD/nQYR"nr8r
nr
2:6 vm a P f@r~ 01 ISA@s#+T DV03COMPAQꊙ 04/28/05  j9     F10_  m؎g ЋJ_g+3f  m L!$F10fPfSfQfRfVfWUfUCES>"c  fB  fdc   tc  t MstpU@p o@t-P u@d@`tڰ 	f   t
Q @@  Afdfe	 3ua 6d< tf3
@d>Sd  0 g>0;e `ef3A3w@!t
    F2 1@b3@Pa@f00;tf pߨ tQEpYV ^ `]f_f^fZfYf[foXfVP3>Jf t
	RC &JffXf^PVW 3W __t
r
>
d_^X \ɰޯ۾ݷاб?m,c-DD(|1 8     I50  ``6~ "k!A8>8  B9 @'Yar:  @;@?i<@ &3?$	?	I!!
0T!A>q

( )))**LLH#Eo$$E~B ~B
y$$$@ $
  >""ZFYdld  #<r sM` hx"'y(PQ<R!2

	" g %8 0 pV	

$$D81 dZI 
!e$F   A4'?((DD@%)0P(&A +C!Rs[^̃ZbgAvijwt@CVXeɊւ\܃fBNۑݒ肩畜ĂHHo׎ߕύXIAOԃeLǗ҃phdo@\Lu͍폜}JT|FؖcInI`Fڏڍ׌߃Os\gpjځBȉymGł񂪓rݏOڕKvxmȂ튮xtԍÃ_FsʌxƂׂ쐬݉}֎~HS\zԕzfmQ{ǑV͈vdǂь`YilWǉE십ċNԐUiTivIىe^qlӔC~tE֖ؑ{pKrWoYMߏϏ[xb - @t  ސS   0 ` R 	iy D  Q @' 'D ?'@$C" 
 P '1!!#"& pc
~|u m ?0
Fq% pt? ߘ  ! x % )  Ef	! ( 02 S   `00m) BFLXp0@t  0dEg!<"F p0lpY.$`"08 D(#ds$A|   UP W F  >"6>?0-@  ޣ?~!BC ""!B'  /!B#b&2 //`    &2$-aLX'>9p1@@@a!!: ' ( <'Bft,?0<<` *0`  x?qt2pC Bg ? @~00 H$@"@ 
	`0 P $&# DK8 o &  | D~D D<  B f<,$$0$l=   M@ 3` B?"#!O!  8@ `: 	4H 8	  6 a@)1p?pp" `$!3pHBQ0@S` P0ZT@L@\D2"##(RY@>B&Z" Nk=bN@-A |a  %rm  2c Q " $!2xa2SNa  1$Q$$aQyH ! {HHK` x d $+Ph` @@` 0!cc1 $2&f# `\0;@lxx0a1 
c
AZxAp0!
g
  p!rE  @>>@@`)X0$x|pTT? T8PcCQa- : Db0 B`$c  N $484(d(lD*&1< ?! ?&!<? !!# f4c{ijv+ dDs?|e0v0a !"s 6`S!cS,t. T8$9`0opGy 4g @ dt>$B<' @}""" c px% `\vdnIi&0WP?v3$fv$d
  ]@^@.*  @#2Bb"6T$-`0|p(x3 OV@@k` F0Vpq]@ 0ua4`m|sGXm|%o38"5U QHU' &@'a! 3?! @( !d(!3#\2b" '?1`		
	`21"`n{9$i$	$	`  "33a0k' l?HzM8 0#$ !"*22eHi)""?"!  f '  <p$P$%)*$ $ '` ,!## DEB`@].A^! ^nxRK)t ?` ?0!g t$ U\7 ga  9 "} 8F `8R)C)E+D:<  = ~P< { b <$  '  |D!  D|? d%4 >!d??$C @ 1bp#1{8 < ~ < a   <$$$= ??d)),??4+fIAp'0p6( g!}@ @Fq?6pբǀ66@ƀy9@0ya؈  >`%,#?% p$'!G@x pwc 1$&? l@ 2?$?$?b S< @$<b _=$! <`0b64~
*  hH"e g * ~  <@ {D=a<$" AL`5' '-恴pp^  ) 
8hRF qpà2q2DRD" T@""z" ""s,bn0 CF`  ||~ ނIE`<?aBzd, %}IHT! 㡬aeE@AjD0p 
 .:23V!& ~   B5I@  `2"R`   @!  0`'|Cd p5D ( H ʐH  0
DP6Oe  /$?$ˑq , 1 FD @@1#f~(3H2~RHH~HH `~ ""6O 6q"c  2"&	$  c?2`."b4'?e +"@P,  b
WBF0L 02?$&""  0p	 x 	#`4 c$}R S SPpP !
a(#?@@DDD@"D0τ!c 7=E u0DL|(0<t ` O='4КQ0i#!M0 `  ?!#3"$$!?!#! ! ?Rydws7  H 4?b2C"cyH@QnMx<0	`Z8 ̀7( (`C2)v&^N?0JbW8l>/&23
b21#n0  ~!#$ #L`,!3p$?Aq%$"h| "  1  A q }    &o <"rV&#0 I  81 c QQR0S"PC 8`A a ˀ4 usn# 8ٳBY 
 Pw]IYf   0b\9@>@"@">#"D"l>("8""8>(l6c ? " ?! 1g ?Da,?=%$>ǒ)jP|D52D"DvDTDD6 # a|b,ހ  1рp#\  7ajė=  4a8	  6 P>tTڅ  ptL D@~@Bf$,892Ok&arg@eP 1 WpxPX	 ^x! 3"&,0@J[D% 6PU<x @P8|	(9H ;)*;*$*%+8 ?TT5VdB"pa&b F ł(x 9%`6U0` . `09H~ ܁ց 	 d~@_*H  ~K6cNCc48x F?~!BC  G#" e `QP060o!  8!` "***" /"$'$&*"$"? CJ0``]0?~$BdB  a B
BB~15,"&D$(-jB ,!.	,HO
 =I H<H$H$I$=Շ@ @v 4R$ze bU?S R P|7 8y0 ;6@
bPgA[aq! 3 ?$$$5d$Dd<? ~   ݀Z  $D$y= *XGJA\! 2F<o GQ/$y,(8p(lqD?  /"?(/(/(hOX lW{C %#H	TTWD? {? pw 0,0  ""bp $ & "9  q?2@G_
i-_ nF:@e$  a  @
#]](00]V?$P?			?R" N8S8

 ek| 0@	! y g	 	 ! ~o>""	& u">fCv,`D= D~ =  , < % ,8= @|D< !!"!"="`?;@BF\p8@h!@A  Cb	HHHd,$|$$$TdTDT C
$>?  '$!$34, g A#A <8S`hO `&#f!~b6@2~Z*\*jI0 Bn5	G x RRptF H0	 ;   	  a |$# '!!b[aa{ap 2zasR0A: <  B F>lxPXHL0Fw`Cu@;0` 200b64~
**hH$lH UIHUH~HHQHU~{HA  C!a`Q8 2lb)) ?()()~?H!!!aG@#t40G zRs	"`7 `C  `rL(  fMQp" "7>a}>>b 2 "&"cb@	"00P oG  A` xz   Vj_<@` <1p0?O3?"a?4 (! ~I	))iIx	1!c@ ;>~""#"gb>2П>A A1A  ? `: ? ?$DX0b)+*{I#F(evbb (^"eX?"#
 1pxbzC|  80 S#Q8#C'~8_<
S`' `  > "~&%,(l)$ -PQ@ 2!;VR!q #  j   "**~*B  h b~B$fiBFD0@ @`@.AY`M`  I2R2RR 0Bb.	o4d0.t ""p bBƿ ?}~b
(LA0%ɧgUE``AC}}8@Tl@l$5?b5d >qcQ"tdaxR4䣄	(	)	) ( )H	p ^c 5] 1 aA#?~"! "2&460baÀ0"` @"{D1 X8|@ @0 P` !bF! ~°?(HD>!"? |?" p?.a ee   	 `p13_"fd Bi|"@Acp>@$	,	(	88(2l"FfV@@`'$pzBp03
D(zo

@ 
{t~<$4 7 a  p ߬}#@B"4&0PPP`@   p   uUp cuU`  U`	 e`0 ..d1S.b1lp `1  [<u.d1 b`uVʊ8r
8s8t>8t: t3-v(8r*<rw.Z1` a2P SP!bRV^Zu
`R\ts 2ƃǡ G
}a!O sENjpW1
wts2a
 4<
t<
tD<tY<t P  VPP t	| tL^fat PwDXMCÀt	F¹. u 2 󥪪4.>i1u . 2 13 `.Z1&1 u2CQ2P Y*2Ȱ&P} aj RDr
.j1.k1PSR  && Z[X ` Op@kp
oo.6W1FF!.WtOT_G-p
QR.6`1ʊP ZY[]X  \"2S2OsP2 sP
XÃ <r<0 <rp1@l1  n1.&@E0u'2!n13[!a01.>ߔ1P20X2$CFAPQRW ((_ZYX. 2.9 t.l_1BA	#+D<uo<RaN<P<S<0<{<<<<`< T<@<.>f1 t3ػ@ .d1G.f11O#0.d1.f1pd`X@Y 0..1.ό10;Pp2  X:XUFN
ȋNu	F] S܁ f
 [ SVF
u038ȋ^V`WFr;Vwr;FvN3Җ^ d  WV>	 M
> tj6hjF_c&  hEWu}>u`RIWB2o1c% = ۘb	?g	@v	B#q
$s
|
JAfaffпfrNcӜcmqfw>
dQjut$UQ1E	`	$	c	,	A	
WТaUf	D@Īx"E
w2C
5M
HRx
R'#r
SF "+U~QcېFB b,1-,gPi*s0|0~}"py$O
z&&.x6(
{F*<c_t;j9= ==VQj>l;!"cjQd$W"!fh  nA{ tBt>dt	fh jnd$/GS
d_tfh1LbG" >tShet3~ tE>R6jhRdfjhIp>c t%j hc+D1t2>e {tefhQ!f t+6f *$f3f
ō~f PFPh Wwhf" !YQh}m!3F``H+>=#2hd轴h dod V0P-2&~	hej?ƀB%Fog/gAra	tAIfcfcjFBhaFPs6@ . jh!Ѐa
	`#eh!fE(0?YI 6S7h]c84
S]c~O^0=S5%hK01!1
0! V)E~*hmhTE)HO	PBD	QB^_ 2FFTf^ F&<
uI) u&*_&8hftFFP9 1FOuÀыٹ F FIu}F\)1 F*+҉FV2g+;u;u3g% ;Fu	;V@á2gVG2@4A996g% 
Ð7L*	6
 WP!y
@P@B6'@,\ f f`/2gc/v 9&a&cjLfP!r FPfj hHE']PV=ut_ V{%#xGF|_ X]028|Wj h &p F GP	FNuFG0u?7 
yǕOl(HF ˿as(tFR3v2 1p j!vQ>
Ibf?RT3@6#"q~r	Հv	$b2&c% 1_c orUaZ

9=FPmu+&c53q3ȉHp/cab`R	 	2&a% +1a1aj_Rv3p%2c%  [c1jAsT 	aSNF2`h~Ѕ3cjD
 ZE

C @	H B	Na(gt31 jibU	|&jSU(
 U@Xcj~%&ccr
x
x^tt1!_"q_Fwt@c t#Qy"F	R@zp'cq{B-&ccjTʡ? &?c@w _&@6 =Oq:"_& &O wg frh  `dQūW h◾0J
a Af@o)od t}qJP`F; ==a|  Ђ^PѢF2g^F  ^F&F~
r"1,e?&"e &h` &d^gP@ f~@ cRde  ve# rʧ
/Q!@S`E  p  V60^aF@t)td Z*tT +uN&,e"e _he r,9ʀt"Pt 탐ס 
+%@@4
		!A Qt:8O
duUԲ+~2@$_&0dW&  (!g*d !r΀&d"cu[oltD @9".SFr{Y0@  ߀&dw.j !`j ;	S'vB +#r}Fz@T
-,_B&f(&
g &fy5&{ +&C!&.&Ƈfd r<|ehJ *MRcK~K@>de&eeFVD.Afc02ae4d	s$6UB8aT :K<]c;rvt)1u1de CܺeeF)#@tڥ#`j$	cDjg%Z	؁ de$ < u @<@/""r¸ g1 kPwya 94>14!f׎@4L(v5a2 eǐ0 u
t%rPЋF^Nr-~#tp St  u^    %  W 0@㴀ω^@  ~u +ËFV VF7Ƃ 7~ r~t` t uF~"fv
Q1V,IuquSI@^0^[t

^ ^^!pAܸL~  f#} FB F~P|v^ K0F{ NFFߌV~ 00OHt@HtcH} P )n-pg0p$6^F&? uq/<cv萡8>rd|mhxcΐ3RacVA<4.cvf.cm`
NN]F`-ev膑{@%F!9?gFF7PjR?g_S^ /GFPv4F?gFmP@c~aP!b?:!ZdB_&@ 116`b`~2|FtFr(}QW^
4~4	b-2O _`-0+FVFQC94%~ t;F4.FҔ0
z u WV~vN^p??S
A0@
^_C
"j(c
lj`


[t ,md(|WVvԋCNsODpRHAA~(|W~FIt_~@u"2Fw#}HFB^F&WN} 
 
%.AU!u@##Y KWDiaҶ
%%		 	F*Pg	}`	
g<d-UWVv<~P F
&GFq;&'$i*V~oʋv!^PFG>Iub: ^&^&8t #^^?}۲h!#ù
 0GF N% }ۋp,-Ar  ~s԰ NFN<+;u0g03ɋF tAFWC&PfSp ~0gЋsG^AaQFހp ~
韋vЂ@xa|0r
CVV,GV~^&wFIa&a81^qFQ2c%Vc>BIebf?RHP3!3#"+!
= r	v	$ba2% 59"~@
oP_B#j`#	2&aW% i!2c% c1cjAI j	a)! (!Q023ޓ޷cjDE
	C
@Hp

Nm#SN
	 U.	@g
3s1 jiQS,py~r]Uyzpxr$P#0
7
{2
Lc26&ccfqf   df	 e 0 g .fc𸿢m؃2-@Bᔢ T Kc]cFrᾐ4s᣼p VWҊ@3lzFRQ7RSzBs
3~Qs392 2ޑ31> j6hJjFc QUheR]>:b]Ic!?@~#c,R V!
$+9WoyR3Et}j`faf	ff؃?	fcPXBAz@@TA V\a$AZDxUE$
C4
?
AgwHH_ 2
N1BUac۷B %	SpF o"4)gPLƲi)p+2~0P442F2ͱ  8jh!螰YҠLWVv1ǋދ~ &F<t<w
b3rtF*;a}7a~y~tF&8tFu|t<r21DVp^u	A(|NÐ ~Pfh#  x0pF;rF f?* F P F*N*ȁ vFܾP0'BvPJ
u+Tf^F  FOuE	fdf &dfvctffq0@  &3g22`% u"2g$<22g%2g14g}u84q= +ɉN32{g33 kЉ  au6g$<u~6g% bPu&7
u]f2 % D0	u 
uB
w )
u/Au#aa68g%FOr TfUfVf WfXf	YfZf[f
\f]f^f_f`fafbfXALö f3/ f 2ƨ9J_ujvĿRPjk- J_FB~2|Ը1~ĀF  p ~ uF{dm
 {e jtWqV J_FRvquF@ b*J*p
NvQWVqoFFP
|F؊f- Ӿh ڴm
'F܊f h F֊ft@ t؉FjRvvYuh 0-~St` suP0M2mu됿hLh @h FފfPAnFof juIp:=F0F1F2F3F4F5F6F7 8F9FAFBFCFDFEFF~ƹp^؊RQTPƆ0[\@ 'PO&1aPj?+*`
- e)@0hC NmVZZG@|\\\<\劆2d$0   PtQ$mj)!f@r 
CoeeQ@2gЎvf@0;)!"*- t*-} t94!R13q$RFVa2 O&EdObo5L<F im0#"7g
1(P  GEtt/ 3|
/@+F+PR1w6\pd eqa"$1 v2gب kaa1jLFPћ$1Bj)"#2#"#AD/]LDE WV3o Wp^&@RFG|P3u86 2 R& FWbqq`' rL7<"JW>
d ۖdQaa6  &=  t@M~[_ Ft 0y 
p"Tf
#-//

	
A@yu	( LpĴ &&TVP{S~ t'jPFI n t/ u#'jfyGqt= tA:? >u
,e&he""e2he% P-he  t?&,e 1`ul À&l yfdxfmegfe0ee{e>gdaPaQaWdUdqu[h hJP~h Z^菢p:r@juBzh[NA4R 	'z"			

ސ 
H		 	̢	r	B		RaD_F&? t5(u%&|Rup )u&DP_ƋV@pFF" cӐfjfh 
 fh ` w 	     8Eq~  A u ˀ&c F B>`)tf0j j Tw3= H/=
td-
t]-! - ; - p  r= M - -  -PW Q   8>ۋ  &9w&EU 6`  VV 6Eˠ   9~ [H  ;p̠! 
f
>~ KĀv&@u?uPM`/^; v״ 3|fjth <Њp L_  "f pvV>B   vV*r_F^ ɀCP% 
Pp h
 h  RaNF
+F{@0F!vvo 	FL_NF@ hbj a^0CFPNQ=`*P`VW  p 3_^=e #L_ @SᄊF`
FgLBqF.
%
;F|!%} F@P!y]!Vvm`NP`rF^Dt&@A$0#FlAQ@Pu< t (F7 PF@5
 f `(* yBub~9v*VA7Ɛ2xƊ*} ufU  ߋVn'] ᚃ> t`ur3NFّ\ ]NZ&8tG[ vNً! ؉^GF
&Ft^ 3G +tp
V^% = @ʃ@A3t`߰@!A;wⰀ>
 u31&A *;t{r1A 
*FD0F
tҕ t" ؾ`fp0;
V=O`2P.B@?Vu	T.SEHDMa!E'(E zrVu`5 3
l	#5d7RP3>>Q XZ~38tC8 uo31~^
AߋF:߽G
uɋN3~(~ {u j  F;S|;pUD  fUVNVv<%tF` u DD^
0NÈ ؏u0+b1WQPWVFX3^tQrJ;v~ F^F&uF$=IW\qQb]R}  P+΋э8sYdvva!V0N&8 uN = tp&@* 0&At߱_m !
`f/+IQ@kqCTN`_
ʐ kj ##vF_j&F3v~Bv0Q&ğ 0b;~ANuv 0dFA  
`feP{0VV -cPQ  F ~ ~
~h3ҋ P{W t4>gPǰvdPq 	|ptGW5^o"p j9Fu
q_sPK0 vv#5+PFV 00NvD"F9F}+F- uP@!b' ɒq YF{F`V%"{ nT\QPEP)DPAjEP:P! fh p39> ~jy/0 *9>u	A
@0
A/\&76I%'@2)
߃
G;|2*& /P c`z8(F
A
j Q/j V@VRPy=AQda'P? p<n@]c E +FFVda#
0UcSpbyf 0aDPdQ虡xQ	5Q`,+F+Ѡ`M*2X R 3Rg@=PDI=ӁF3@**A;}Rvs`V6rqyg*@F;vwPST4C
sR14+

uSK#aQCgPedD&A84	PeV輡VPɖ!~&-24hQRptY~AS;}`=y#DȰdf&D&T030`~
м  q &Fި@u[] ᐡFtdF;@Ɛ]q<ЁN b®PO;v}vǑa<GF;F+F-	@pFF&Ev;v~Qm~ $	;FF	_F|	} t~0Vg~PtOC~ tG\'F
t/* F T9F}\LF ;F~AZM
~~2G+F50%&L
q DFF ^0 ) `IϠf@`	PXhf@PF^U^EAgT`X2s|Pxb<FA@ŀ[0H&v7QvFv;FՍ\Pɒ #R@~'U 3'tsF+FJFHfh iR( tTT4v .9~4aWFO^6,+F!}=pu.trpSq &OC@ +σQk._+ǀ
0|ctj[|Qu

FB.=Q j]>| LnW0!L# ' OKCA& !!ypa2#$QBC}PPCfzfpL@>zf|fj qWw 
Ht8-t-9t- 	t "f 	`!QF~ tfFfzf?F  F
Pj   v
u}1Aju >PHPV`
Ϲ!&_wc¯_FtB$zP
Q|иN	VV2F
t!@D% QD:
莡Q
VQ6 B tDu遌Ǡ
!_؋!bGv C `uDPk*.e H!MbB되9>u	w r =`Gg	%R4O1miDu(+Huu @uqt j	j/fh	m<	"	PV^FPqf~
 t

>axQEPzU@ ]FY m DVVjvvұ{xX s6G ]3?#PS0N02XPr~CwWF0B@UJP1qE~
%G jR[807+$ }p  9]tl ##J/E=/`J/F_FP9 \ dpg
p; ;NNNQP[ @C7 򠽋= K = ;  -Pp-߄--xАW^p'Fj  k >f`{ Pi;v1!;vFPVW>FP~FPG;~~P1% - D- *{-ࠁ#- " e= Pk'K-
|5. G@6- ;sFc?atU tP` cFa~9Fu
VVIVF]v9vu@PNPN  PNNRF ~9~};V 9vu< u}N0빋v T|` 3P Ppo & !VN;
u_逐xA^F;~maiXS `
$~Du6f| b;|qT/QN;v}O;6VQ9~ uFApL怰9v|GI0Đ0%9F| ~'A^&+^& 'FK'302F u!ihj@vVt ;tt D@gx3|f4Whyl
 _rz/~[I>mFWV  Gc de td@ U@ l tee
|t*ATD\[u0}Y;F~ ZpӁrջN@uOp0
DK*=Np>d u)>e tl>g tt >fc t|cx yhVb?0 Whp.u"jhahN_ݠ
j(h!fh`_eh_ j _h]ch_K^ _T _}B g_m#N_ak%` !fBz"	 e% jes%^ ]cc%	 KcS%
 TcC% Bc3#+(`+(^_Epm= Ht.- t'`tF-4tc@UHt- t4AT/Q#HjhНp߶t1rtI߀DODpU*䊇>AvuA*HWvAPVt0<@p& }5*5446524I5r6597h4@mE@ jpPVCpWVh
	 !V3j hD	~^DXր`HtHt#h !    C wt^ f	{$F HtHtHgHt$" @ $Ѻ&&G<P jh	G+P舐X}
G>7x@n _^a׉GP0v&ƀ ~RrjV6 fP)3P Ы>~X F`~|ְ"®s}vI@x	&8 trƾ
9GPu   >p~q9	uarf   ^f~ t  |֊Fþ!	eMA	<L0#	Ka c 	=3$i0(`(?h跽pa^p3&~/tC&  v&8 u*C;^|ckF0^P9PP`^? tvN~}"v`<1
޿~ u0fDFG&9 u7~WRrm0~F Z= ?-
 -ׄ Ү<5 1 ;uJ< tCBtZPU-
tKŐtHtL- t<17@t0- tOAJ_j*Q`
0 R~D@F	 0 % t"} uNj pG貁F  Bܲ u
gށMN3~*^
7ފ 8&8u	F;|,Bdn
eP $
Pڋq PC 
Cc!
d$~  *8fudg"^uQ/	tP3_0F |n FPf@
t)f3fn @Hpf}h 륐j h2`h` 4$u }@3?l3 1/`F*A;HtϠ5= t	d@ &d> .dQu鉀&
:v	@
ʠ
 &
&
hЏ
h ?AA7B 
@
@ -*

@5q&
 3/F! "&d&d JfkJf!B"  _FP~H| AKN
3aV`#\'"U%2$:GBHF_^`^EZ2 č&Íu,3F
46 x$dh0dj(j 9
P8
PPfsVS
bW&*_)@&` 2 d t&<
 <#)뀖 _x
Q$ %'@q`
! Ovhdj  %cbN0Tff3	諠_%  Piр`RB/
?
$*H0/^$&40/04TRTR"3_RVdsp%W
$
aH*=	- I- 9t7-
 wqrMt%
- Ktq-wMtr` MYnp= d.ʚ֚(6{,2@0`  8&_0'zuR!"Ր,W20`  0PXu/1V hRh/ ST  9YۂYݺYހ
Y&"0Zd 蜊a=	_[Q["
@4 |
U!@ _d_da0y@ Vfh0/h y Pc@t&
 
U@ UACCUC΁!#!
@d_d_{
Ɛ
r4(搐 + (#+-+tp*tcmKt
- 7tu] &3& tGv 1vhh
h P!wu
j8%AW&A
G-C@#'$'a'a{ߐj3؁ ڰ @o&
)3bPf n
0>{+^>>G>d'>nu!>/>f'>< Ћ5Ph$pD D:E4(89JR4"" :L%9
5Bδ2hh Vq2^Du+!{ 5 31;ut~&_㑮S7AA@A@tR_!P!_!
@>R`O? 6~`L.ࡠAL&_R`~<!Q"Q Q*|3m &Arh3OE@=QpJns@	XrQUUtD3{,i
; YKR`mrDFv!
oroVv0%@tx$P!.D$$`
*P#wBf~x0%YAǁK=2͞D=H=yMoR`;Ա;
fhZ K" [B+Gb %^m
tн
]
ct,W*@t>/tq *``(@ak@1)@4AET`ŏmƏxCQ MM# ғ,b$ $5 ǆ0U@0Tp@
%@U$R~2U6Պ2`T`ҟlB	U`vuv}VUP74	b
A
 0z58i$ _  	 Th|¤ޤ
ѥ H1p c AЗ! 0U`0uU`1}b"뤁Wab 눋T` 2w 1 릀G5r1p {"(9@( f~ fcEW  Z 
Ffh  y h#oة*TSu(u$fcfT`.@&ct$&6EPՀ&.W6%;> >a<FdFj =NN ffAcu
nvSu-
um$tuuu	V@ V ,ߋV`|_rhܣ4ܑcv1ʋF8FPVh@0{`Qv
/WV 
Z` bHtHtt-L7XF+ D3!!BCA
@Öت趑Pqh %^Q' =@rE4QG``Pe~TQyg=.tQW G

5
,~b++fF@ ؀  F}FF_FFp^pq~txD>== P  -  -tRP   - -*t:-~@ٽ ߐ=`+-aF] G- Ht}Qxz$Ht?/Ht:HbC 6 0ߢ ( `!`"!13 R%" (A
Fy
t)j UPTPfsVttP ;pa&;f"]F Fp *HFL~* f fFa^vfvvFPv蜐5FPu63F@,˃~%v슅a :uFzG;F :<~ t
&x xP ~@&Up!  p!qq _t&AÃ:@Ќ?"Ht)3Ã?@! Rb̀&X qV>Z` uC}uHj 
&3v0 RheX`ff^`f_ ` ~ ՞ބ 9FhDׂ R
X`he3@8-9t- 	t b`R
  *Xf?jj a
 5	0u.#JN轲uh P>` tuDsP	~-NRQ}>~ `6
Lh45ЦhB6#3`,a& ~ ( F |b r0PմScA >p#u>p\t&el6Z`觽 +륃h\p`te3.a13
>^*u	> 0!jj243t;Be'kJ0 t'{80:2R%4;~44Z
`bph j pp@!FA@[$
[u$42Q*tTS?=<=5
5
#`Kh@a	@Ba	p fh=+rD-q*p~p$1ߐ#;$ %^/0(aRd*a,ac.awhe@P"r ) c%  = $Kmef1 *L2 Rb
b
~c
Rْ
֣ }g
Pg
 

 yGwءd Dt,-
t%-.t,-	 tE-
tYt- t/0C DͣZ`:~B~b y_ }л  oU&WViet,eu& rietu
Pz0tWheU@U U -ƾ@ut} p;>}`  Pr%hⰲrjtXя60cHtHt `t' Q ^hpڅsu
^_ WV3ɀ> N3һ BrZґ@ߋFPWp~Xv訐
NpDt  & Q !FV^tF&'ud,,,,,,,p+,,.J>uh hmh h j 
 c/"@ts 3҉65P@;@)}F~
r݋F 
7ha΢	
Jg	
ZcX
5#W<B6f
 ~Ĳfdf v3ɉNv~FV
tut9v~O|~*~Pӈf0a^3
GF&/F 	 u^*ۍF؊F%'Fn"	[6FV N; 3V~&Év ؋9t
G;|FCċFvBF  ы3$uMG

41t%I6%|bpf<afff?y&X  
<at߀&
S
 Pة t	s`p` ^3

tF^&ߊF!u	 |03$ F#@
^EP22a
nGW^rF*f+= 0=a -tX-  - 9B m= M - t!Eh-@  Or= E.^ȸ/ /  p- 2&=a% +11>a <a<a@ 3 ֐j5B jh
@AE
 C
4>H/ /  (YP)@ wj}Q'3
^'G`ho2g5؎GS.aAX0a2g, <a7a$ a
0o&
c
]Q 
@DM
F@fyо
fh0V" !UB
p,pfh*+`()&' $%h#(b\rc t
Kc eu
M0  O hEw `F<tF "hȷ"B?y_F -FC|ߊFoà@aGïVA@aBaa!J/"PFdq`slLsH If`OeO KI*RD
B
ET4PTˡĊ⪡70SdB
H
<U{F \XtJ_G
	Rt
R[Ǡ[B2A `U eephhj$t&%l}4"S65n\D22FEp;T
B1 !\,B`C`LB`fB`-
@- `
- Kt <_Pc_|`d$_@U_V|ξܾ$4D^ht߿̿4,2"5^@^Ba  ab AB  z!" 8- 2&Adcldzt] dw@TĀDa?-  3 @O+- b	uic] )#@댉  
#jq/v 3p wb{4<F{ނď@ʣ"Lcfcf@cpp@ta axxz` `&CADRPt &hDǎ&? t
&ؐ
`@T# 
U
C	@U


A C	 @砚c:Qq@t&fhށvЬ@{n~fhzh]
5}o4z25tfh:}89h7[J2
z/с08Rv?=>_h< @
`	BAhؽmdWVde$ < u@a@<@u"d s@utm;>`  *r$ h$p1@66Ha 4u%///)Ha/R+3 (-A֐P%@u'$F P=c= 0Ht
q j r j詞6|@uf4G;F~ 9 ʃbrջ|N@uOphhzB[WV 6Wp 
nrvPƐdt
Q &"F Fdt &Ͽce7$οKA8J&PAD@T%V%? _%T%&rhh }$ 'Fc"JaH_& *JaPeA u$2,<7 hdrh:<9  t~@ rb` zj~=  TP薰0 jP,Jazp0u.&bPjj`ޤ&rz"pq|wOFr0 #0000J0W00!!&kVfvfhI
 薈2u @mh bFb:tF&<:u-FF
*0N&$  
uL3Q@C7 ~ uF	 F
  
 
 <  C
v`
Pjq<L^P{
RPn
? 0
~ `~ tgh,v&~ tD}`E=(=u5 z
`
 ^3 FPPP EFF9Fr= :% -
 0v v sd ƨu = wѧȐ,8DP\htɋ~FP.achy ~ t 4Fa    R F  : {.E "  e
Q.p~dzt'/ ƂOFZIZ#3^ \L 1hV$.t}Cq u^ GCauK  K .g"ŁWI Nr@~u_t W    I t@FqqFV~!F^=uF6v2N'22g+@]WV6۫KhhRy*y) fy(u}oy_Dt4H-H4HSHUugHHH7I2ycFIP9Az"CLzDzPza
"zj &z<f+fF@ ^  ^V=^KFP6a> Lv3+Q OY  l`- t$ fFf~ sA,Guhܷڠd fQVȡaڙRPSQfXfYf3fffPfv@fF fh  bUw̶1g߂ Fvh |FQP d Pq$wT!"_!TpʑyyAE  p 4  V6rNq		% 6|aD6Pf\ 6Lf|<`y襤^
P]0?Ð3Ð8 o MHz` KBSIMPLO  MOTOROLA  HP  1.14Adrive?lock   B Computer Setup  <F1=Help> File`ystem Information  Disp_lay siSave to floppyconfigur diskette Restore fromE(defaults.
  Ign2hanges and exit EP  s! withouaving
o Securit@Administ or passwor5Cose a/"Power-OnWGp ?DevicedeDgJbD$L $s mart Card%G
s?upportEmbedde0&f
taA!e'etr*ac',p(s$`*authenticS+e
credal Auto2cH%Tools Ba /0Calib( @(`'lectb HDD:lf-T2 op8s Activ O Mem
Chep? r s: l)l=mb 	>ȥ>uA@Ad_vanceaL`4guagaC lDt7  of grayq6field Boow1b..Pres=y keyI I ue F10=
, EoSC=Cl  9RAccep/=YesSNo D, AoZ$r=MN <W  UsSarrow
 o? highl@ *he appropriQmenu iYqKp"<ENTER> Xbegi)WK%#.follow@M%Z&:fpc->  KSPACE = NexBR3c-BAC9K@vio"Fg0hTABE3i?SHIFT+&*lF2@&10`
v[J #'9 Er This60cann)b`mU;d An; e ocH@G whs6c.pde 0x01% e@ondApGPu@p0{6C>requi yayE`d~jba@%mu0C
movP:y e4k/MEU)hQ1& ilAl//J+2SDcleOsu06ssfulManu<Zqr  N0
d:Prottsyp@speItepp+CacVize (L1/L2)SQ ROM dd fgamiaseP8l nupi 	Viwdeovis"KeybooFr\06verDb1<ed2$e3bg4`1qa<ownNPhip<(TAdG
W
O3O 	*	Ĩtafdai5u%BS)NZC*D$ 1
2
3	ME$
C

V


4T!V
o
Do
So! ྶ: tD.   %FPA2d!J#bisFapWalRXS0s&1&H} Addlinqe4 AlHXn.%F$oWarn: rk Tpll0o  zshfTreKa /vր, lef ea 
waba002 A: 
de` waqt@tҰ_)Vu @rnInv ȍP
)!	Ayou̔ wa@|to  ?m  ioa	  0o`b+-c(Quick`n22 (Cvre@sʅ3 (S.M.A.R.T.) EP1p3exim@s ): 30¾# g¶30%@v}} ty ho#0#FuprХ:13't4	f-Unknkp{il䑬WR!mSer9vReaPS)doџ47࿸`?a}ribp	:0`exP9 'b`G H  Olp New Vfyc nY7Enc8Off O  ɥA La66#%AKroE   `p dV
Ad1 ݰU@ҭ5Ocpcaus7p(@GAH"h` A&فOpoOwer-.A S΁Qa?U=> loss  (:dYAhou  nlcof aQgoH04)ev`ۢ?[YDocHis9hR`ed?!0f]Dddi1al JJe HP`"UTool Cr.@%oF8IL` Bk g Uмn qpm`@jtWSN !arv0s /UcwcOP2"O	nj* e:Z%%% F@%԰#D
n -f  TndĠfӰunuR?*$n)tartBQK`fsra Par1yNs Spdl?ot CD-Q & vb$۠@yU@	11` aGbourzph҂ u2W!?1 bUSER"MAST xApanPO9`cRR%Tkeep i2acIewph#ysD`<phhaR  7mpp`r. I62?R>
,ҚnRVun *"gFOxOAutoOQcEdp ptY55)0?#O N;
O[?k RziC,b_pur?t \22th@Pqsow k ebdiPerpJa@naff+bdata, ]ssiblma8!aKpkigi0d!V I0sWPl r mmAM @| Tu@yl,lreplap[vo o/*  y4y Xr" |t,CoHA= Wy|'qu{me`1r, @M6h`*p0uibty. IfRdo4Ǆw8`!ESCs.!
T V ͲtypB'>'nђ@F10"q0rm,bShxt+  E$@ MiBjQ  Orpr: U ay OPXrDCgDLb! (left@/hUSB t 1HQbSu K wZipoFirۢo!F`thifp Sixa h ENh`ASwap Fn/Ctrls KTU.S`aslegac`kC>is`7)n0=Pr@riy Vpo  d NTSC`AL6 -J -M+rt
Bid`EPP ECPd2size 32 MB 64a F@pAlwaynPPi0AC3 gWLAN{ D Radi ViBluet h /rS :chHAӡ  SgB@1rᱠNtЖ Ed (%+n,2())+P z+f1Ebqn7)e 1҂23TokRAHp
kP	M3Uniqu/e Id!fD`&pep   (tu    S`KCalibP!6N@sP D KA.Xb 0B H wO
ELi MEU k'g'MRoN/G/U[:1 :s C0@g . N% ] /C le2  yc 1`dik-d3	s
H

,
* A @5>M(o!ylsSp` @hnologygYadapAPXE ?RPL Exc"Popupz(`@0 10  U2@ 3 4 5 6@7F1=2z5 15`@ 3 "MnB `o_uchpaPuSNon`<F1=Hilfei> piYin[OnzeigpfҠPpweict  KaKguaobVwiePxnLveinun	-hkz
.iKgnepd`t*nt nehP78/%Set#SRheitsfGunk:n`ɉtoa u
nBlt-KuO] Gertesp/--ID FO`t耉7	Usttz !@ 0Qz#  be7im 3st

ng!KAЀr`5nHsvorrq##7..zurck z9
B .p,
Pf_g{ms>ThEx)`Akku)kr_eK tpBsgewhlDD-Selbss@´ItivS9#LtIp;r 3g 0: tppllTL
PZ`OS
q@ PErw :%SpraQ 1a;n!4:#U"gran Fel{dsrt-O& O9!86")Ke SePMbqTa@0, um p_3fahB@i=A, ESC=GAbb!#`WBkze!TJasN0\ , Ja	=Meqh`m VeZ
zpMarkė"sy!*!'MenS% dPfeilt!
^dxQgabe2RmOq>ko?9 c`s.	folj
Bn 
sg:@)-> 0r LeGQ ?= Nch A\pd<-RBc?hritt-`VowA(GTaGbul!fs+ Holl+gedOx F2@
38= {gy EscLhlrLi@<PK kan~Lt we YeiffMgy16P=`?rgetrЮn.:Dc 01 L`fitM B kqcQFY+<W\selnomvPorB]er0ilXW^qDeskU-KsBhmu f 3asÃbzw=.2MobiޯZbgtz%.` Qz qh4Bi///"2f!
}[KAlgrѫ ab>	chlos@`F-M`ll Proz yprtt`wig!60a"Ca`-i-Gre (L1/L2kkapazitOMdPm"Famik Sp; ummU Graf/ik-R0sa@Q "f]r-Con "
A   a?7J	b31O m2O 3O 4d0qV si H>(F ` 	o	o
o1
L
2aSe
krET*  L$ƍ"D%'$b-!3Kc(1  WalkZero-T\<One EdA(`@PnO`D+: bX7 stqbislwnKp  ZEucQN-/aWB _leQb s AteAi#CP0&ILp`ak A:nfdC6
lW$ge`KR/+Pglp%ɏ53 L  8	/  M0$wirkQh"vQM?`|3, daᱭ
l^ie0w QPocF\Lˤ01 ( anH12 (UmfUafdIGc$fhrxdauP(Min.):G 30ZБdS`@0% cgt̯59wuwm #HoPuy p%ubr`"w: ؑH	ԑUnbeaaMTHC52^'rvo-L 5.
32@lhafAttoribu0FID 2u"LS.M.A.R.T.˒XXMs K`kwp eus~1L Dea  JaQ`eD/t Fal8geb e
U	ңBU5Ip dminIoz Dur1@`'@z`|  mg1i@eFN1s
gd,E.@"< ttifiz eq s{0yrt.@s Zu@1`0LzO 9p袓enl@~.Ajb s0Q!Qnp'PlsAviceTa s ,ܠF$0@ h`$pSga|F	 :	 JZΰtfa@npWUm Fun)S7O, m3e\Wn HP{tectToolsP=c^ty MaGnagпUo-- cڑ}- k QuickLock6Subnd$Fr#q\M#"e$bi sϢnchutz  f_-?1dԨ@imd& "+a A)N+ *W"$B><#, lp8$meh1A #I Nk>"ʠo3f`ot-Parpen}imCD-ҏ&g1M!UP:an3A7m$"rive&Ftpla`t9;XPcJs E-=\s mU8unbrapjb'ar.IpT
:b,ҋbewB>SD!sTD,d {¼ !C&&0,	I, 2.8\v%,    H2i<nc4z@ N󝀞}Begriff0diautomLs O75@:ohl<? i Q֩g`yp #ps\V*f ~
T'U!!´!mU"n# OP o"e o )lnYy#OBzs瓡58c<sQy:Sn@ iQ.) r`uM(qS!|qs mh!ac%Cw Pr qғ+`I o0  6qurn׳zhE . Escdrr empf`/qS	 d?zu!тRO`x t.  󉡛  f.МY@ұF&1 2 B 7 b-B`ntra tAdant!Whj`!@Esc-&VlȠ>m kW'p'p`\ F10 `esh:
x3fg`gL sbD} m  ܡ@MM]uBay&m ̀)bBtgk`-EQb(links (1tUSB-b#-2؆ƢSu`1Zip 1`234 5`678 9`QFn/Strg!Pt  ų dEaCГ (USApfN-ZeP]}B`iebss"unabhngB`  cAIAn Grafik?-ContrPrimSek% VideoQ- rnԿBidireba?l GrP |us Lfa`iCb0tzbB
d}r WLAN-Gf0Bluetoot%h9UnU/a Eg{paAggr e_%7(&.(o)u -E`t# 12P3Y5ToRR aC :=A q1t v^Q1I0NqkBoF AkCkuN  `PtaA   x a~  Kalib(  M`k`O  NƘiual_ !  O  k   O DO,rOTra-?6. .O .L84obi!q p9OO5"R!P 	EgnOOf`.[цrІ 1 :. % ]!ablo(2Entl ho3Pp1 
m* 2
 GS-2'@su' `RadaQp0aBPmbƀzA}ExpA-!-Popup ( .) =W0edau Qt0Pd2 (eZ@  Ke`~Compropstn@ <F1=Hjlp>Atoplsys!pVisúne G0til !Akonf@b[GwendPfraMqzp@QrU
J`gnorndr =o&fslu r ,1 u*t`gBOtne k)hed AdministoradAsko KP aodA7 fo% ˇhE"djeG-iSq		 *	v*
J	Sm-k	God0d7elsf 7do_dbycggPGOds -&2	 Nu@00fakis l2 Uag
s)9FHk@\HF Ba.@ġV  cb"dvalg b&HDD-seliv\tPr HukoQA.ainPQ2h OGH omv	Ir/ Avancq Sprog Vl1?s @mo2nedtt felOC4+'/#5l5!Tryk pP7 tas<G0=tZO^=A, ESC=OAnnuaFsp!3=JaNej "J, A!R=MGb Brug pr
NA`RP70we~  releP %menup(,1Wt<ENTE'R> bqec>A)et. saf pPr'f!f~7: -> e!& MELLEMRUM = Nl<-TILOBAGEr!JTAB&2$KIFT++ԻF2@	:*~= Acce1h0!hk>{sf#ej 8A3ku1id0gs 2dodQ)!FF1n. Fg01BRnoVD-p% qpla`9G!krvNvek`EnJJ
i db!?zs flyMsÈn/McEUqoO5 bp* uvetzbrud 2JI,nemfB J@`  Prc c~@or-typ hBigH  ztr`7Crcache (L1/L2HVROM-d@ famOiliei;\AWdeo#f0pds:@Xr-cs]D-ba`si`9e2o`%3o&4Z&at-ta`ofej1E("Wat)	O3OWEw ex{%Ipsr4E$ TyPy%xy l=ydes!Bmis 0'bvD1I'j`Qeje var0: DB1! se  alt@P02[hold a@ poPdqt`/b Bb-ɊBdqduw5,&pr Pk
kEuGrBA:ރTETf DF%Ugyldig/
t-  <@ngivuİ,vAi av٦,?# i#K?@ $1 (Hur P)%Omf`) sl(`{ (): 30˄2j  `1x0% f3rpudZ44b2@DR 	8cq: KuB+"UApyCS'z$ervWdLsribut: IDxl#ZS.M.A.R.T.5ܐpyCD@F8Ny  Be@}ft nDeae Fra@l !e@+ń 4PR@{	s0FC		ƈ 4D
&KE  beviвB7 9!Cfd~es, f.. <ramG261A PoRR.`RVuAj@me+tabWata. Du bup$AM flAX:Ը viGcehCa D[@G @ߒ[&?0r !,ci HP tectToolo9"jK Quickp;au`LsQmP SkrAp!0rKvt%#k|qX)/sa1-$$ HvisatՀ `w@x6r,
di u.pbilK2;p+1ol p@~frard )x  Cd-rom- cU?:Bg Ho2A%:e@AuΑ5Huhu,;̠ Dq .  bOBRUGER-s OVEDADGANGSKODEN,22QՉLU albtga9`s  n Be  ne]d op@Ia0X'edS T#
{	aMD Clj Ђ D_aBAQ>Nhjlp eutom`oK, D,ZAbyg !iWj?5B^.k permaf@an`Pig`v2n:j fys dsk5 2 rbppc(On @O"k	v A .cBna
  @ucW"EKm/, somءмa ckx@
ҚTut. Ur8d}U pbz(@oPc/cÀ pikoSӴ`@.P  |бbefalkrafǓP apx 'A1쀽@"pl . PAXu	u
׈q  &cO. q#m"J"4,Q/pd i`$HuA0˗ 0.a.j2`:@ENtrA!5ESC. 奘% orPx 'F':ge@F10 FYӄMsf
i/hPcD+su  !Dk Ossrf'lgm vDRRenAHPskm yDSP-bas MultiBay (K0/$hjUSB-?floppy%#{cc{2|wbsqu SbAzip~Fr@aVTr7edj Fj ސe SjSyvRV O Ni \ ȃ Skimѩm Fn/CtrQl E`lPv(a@i`sk)8  UegeUstt!
u@PnPAQ֠ߑrm-cr Prim@Se`d V@o Out ParaX  TjStrCL`ohukoЙ Bqld t 6nr compu 10P0^trm
gAt WLAN-!spioBluet hK/A (trdllo|netr0U|c!mstyApփ&(x(top1*b*Ethqft 1K23KToJR aYHL	pe+	 	Ent 5gt id-nu 2 0ı@  S@   Z 7b/ JKalibB' nndaigO  x 9p6  @WNMH KO OM2[b o  O  O#0 OOOO6$HAgs  1 1O O
1VSi mo`gPa(MEU)J=K= OOGOqOO  OOO[ TPq 1 : O 9. `% ].UgAmt2 AfFH5L)zO3@	Genos	
k

, *  J/X 4%G)g `hB`At `r`bpop{upsink(sek.!HH025f-1T@bgpP`pA Konfigu!2mas   <F1=Hjelp> ilDwin0jons sypLa@3$ak")Hefra6#:p`di!opQ	:k@'Pg avslu!A ,l BDE;sprograpt STt ZpWass@ a/&$OpFA0`:|U'yrse|i!vsfunkur!tif @ԃ%@%-
vn Sm4 |#godkj0RƐ!neby3Pi%it"ot5sTilbake@l#3fabP@PBQ`g
i
 C7;avL`Srkty & valg !AlPP 65;vt AkL MbT !#[SS;G@$π*
`H!4v prlg 6  Dem75bM @ZdtJIel[3
.5E6o%<}5TorykkC taJqLL&pg _=, ESC=Avbrya bBʯAPpJaCNei rP, T\Rer=Mbb `kYneRopilr@Ot<ENTER> hv ddu ve 'Vt. Brukqdn%l':  -> e$ MELLOMROM = NQ&86  <-TILBAKEPvrig*TAB&"HIFT++F2@	)}= Go  f#l`bWsfeF`  SPk0`pZmno&p@5 PS M0|m kjresvYe!@m d,;@i pp 9!osbaRaflysbc^ 0dS  w}a`1A|rv full1z. kode 02Io|"Produ _t Nopablookk-mll  {typ h@igv&-ga zvAӄbuffN(L1/L2Meng`	Q	Nenu V@wo-ЏTjrNtroUSW,kobgRiJ,oK51 qNi 223"40,p( E
,9(Q`
oa
`oA
o,
NEkg#Iml۔$Eo%Hq ok!i*ps("Walp9g 0s"-h1jH( Adss e7"~e PRnAd 4~: DsA#.s@QtisdlSCholp`@DH[aQ "/he-  &d, rnP}u1p3 sakl<k`nn02A:%ڲO b@Ҽreg1i%HUgylGdig#DSR`	F
	#NE"h0mtEb`?̀{]F igno\3t_te?-  HN 1 (R @nsl؀XbP (): 30A3gg3r 0$s0%[Lv\st!vhF_f!_: Ka"qut``QUÓ5$SQ&eGtt To(Lesb'1Du+q vr{ib: ID301rs<pS.M.A.R.T.-f^C0CC  G#Npu  Bekreoft njAv`l	 ePcᰔ1qrEّjv}likt aDu!0o@C2Ѽ	aXokag3ogs.ror dmpel&! Tp}?ّ.rPa(A=pph. `bkYu  amK࠯#0vice.0u	la?eD(s aݢI 0"~H i HP ptectTools3curityo Man0`r.'-RN%lq  ēlanppa0usG L@$AOmpEr`i!gi$eu beCska u"-U+/- +ӂWE%q  '. tgl`rh,v@=$ڀPŶ. K$RmEep! rfrard- Parll+vSq1   CD- )FsU1ut H)o $-:Be5B`Dhpu
g hh!3@bBRUKERHOVED-T5 BI Ryumu0B@EQ
 n0]*RDCbe!1KP P
0P v@@" 2Va"! #
6R,ARZ`P< 	!؆ 5)pp  t~I@HOM @ automPYpD!wLock	3c<byggZ`)b0`  @]smaPqilg ]Kge0.S kx_[h fysAad $0GmqW l#= 	|u!m:fnd1]VsQs Ѻdda g }u%x. U⿲g omd@N1| 0/e XG)0zanq
` uPbVnbefat 31 G	A|q.1XA=w A0k1 E5ϓ  fhP_!R!'Y}I7MT֐s w-QVflans NPBv
,2ʰEGSC-yL @΢`rb'fDy'J F10h$ZCb#e:hf$ nd  .Nor iFGO%re  MultiBayPG]y "Q'nn(ve!e)pPko.ngsb9ahhyOBUSBA||w Zip-U

A A0AaFn/Ctrle EAVd(USA)GekeenAeAla	jZtroA2deo@!"pTvisrr0`2FViA7tiࢀ0mFgradi/@trdl |t
WLAN) OFBluetooth /-PbftQ`mbQ҅7 Agss`B	'styQ'1_"&2o! (	v"*b/!1 Eth ?@	)	3	 R(@NsA'ooo/
8ni> gtifikhOC&\=B6riQG( Ht@  4  3ymbo KalibPa2K B!es- 1IA09plХal ,-N	 O	I	O	O	51 O	O	O	O	8ksp._O	O	O	`lnd 4oO	O	
%O	O	_Cs mob. ^
H.\L. \O	!zo
{{O	B.[ TAO: Lar. % ]!fullC2Fa{i$3
QiBn/h* Oy  (o J/D
Birpk)mA sin hurtig _(sekuPr<F12- f1.Sepute P pConfiguracie la Com`adora <F1=Ayuda> ?rchivo  m%l Sma`pGu isco flexic1pٻ Ra`&sA^valop
f@dobPay Ignambio7s y`li a A{  g3 @'Ln@epidadAse
'  ' Aj0iciof%0posIi@s_SIc)$ +5 `*KskSm!=C S)oqPe*cP#x<) Sectyincor% E 0e" 30/c`VP>6fbrI
aBVc!3nci@])?AutomaHerrami aC2}H`er 8P(8 ;prueba HDDKc 'EOGVЇ&M?emoria2ad*mp.l`1@JNKRMu0G`SG#
s
 AvanzX`ESvVDD
W? Fampr)co0N gr0<1o?)<UOprim'q;uitec0g2) Pbm=, ESC=Ca06la==Acep u=SSNK1"Y, Co2	=M y p UyB$dchDha6@alP}  alem o apropiu=@[*<INTRO> z qx:N1n.Fs{3pkTY :@Esp~o o -> ?= PrxcRetroces<-{0@a.ؼTAB S	S'aMays+b#C(/`F2!-910`rXp"b"uErr06F  No@8 @AiWGSP=rjo u@QRA6K. CdК`01Bhoay nunw>LэqubRnYD2@AC1+>b1 r(Rp[corUD)JН@ebook/MEU ?IXQP\@2pO`0ple~0Vxitosa4e Fak T1ytil TisOp7,Vc*lGpuWXTamauZ_0h (L1/L12Oc FAAwROM mil@cNmerD}rqibvisU!v@ j6r g-l@yo!!
/#j1l2n3p4 EOtiqurA!sI2Ve4FK (ga`Woo.o3oopoi B(	Esn!*J8T 5:Z$  ProbU%bssfactcXJ$ǔ =ll4Reo 0poX@1'	lnedi$l@z,
(HCE|`oD"F%Ad :vH uir-  eap. PrehP#/, 0WcqscpY2cuA:'p, Uu c l@Qas ' Ӣ,Фhp9tegAң
S^@vlQI$\e'vaPPa)00٠o(a) 8!@%`c	Za?`gnޗod ilO(g)-ф:1 (Rp);2 (CwF3 (S.M.A.R.T.) Clcunvtieej 2( s): 300go B0%&~Db  EaH0 _^`ipalGirumq
 :
 s,pu10@ qIQ{`3nh7Servof 44apoya atr{ib0: IDp#@exs G
X0YA`seaـKHnuevL@)Df ApkagE ndq9CS@gOB".Xt		@e voc"	k"alpa 
0 Lstnad ;`fR n"]e#թ9 A*# \A<Q, (02o,vA`bs (R6% E  WciR|LLB hrpinR3 SIBf_ ol:9al ol`X#A!vu	jvip.AoQ  '{Ùv?@%(֠WapaAuydAn14n HPctTool@O)%!!&  QuickLockSuspen Blo`^Թ\rat S 6""t mej`eO@`?:0d++-y	(BI	( !)(rALlRt0,"D,0X&upizQ,.`xHvOre Pu°nP+rojo%q>lWS9rMICD-(
Eec%'WPi:XUsio:Mpu;NmediriveA'0 tzUSUARIO2I PRINCIPALь joe c&s UnaJmanT p< w. Anp2} y gu #8 lug3\bP  p_jz.p-%H @d\Wc@GS1
!Qbb; vaYp=Omc}7PJ67EБor1ܯ?b9
 4: @G:iR u(?s  , fs`m1$ 겞 RhArQOoc,G"o~  /]y"<:Xo!u d/aap{MsRcu2bRt£B! ?1 0#zda$kosaՇg а6Se 0wo0enf 8d lic㡖Ӣ@reaz. L?k дu "`#PZҝ4=ԬainO}  acjTBBfi t8Z`
`ri01pons2>敩Y_, i0҅? ESC. BP1alaub'Fd'  ,F10:lFRrfG@ǋ7cT/Esp?aol OӗtMultiBaNQPa DiFPsi`$3-pAA ;]Sfb梑co+d(iz"a(@jec!h@-5 cB b  a01ЇpSuwkrZ3ipcpmeaaeTer Jo CR`5t `x SSO v3No0 DPƀCAs Fn/Ă`T@ncIngls (EE_.UU.)s1 (mfSo}"leA$1nt!Ac@ G|C0eo Mod"y!  Bidi0 Tam&mempI2i#	si0ȣfu0{ BXP޳ICA RxՀk*WLANy{-Blueto_oth IA@ zQyyQ̱hoвergRsGCp-oos3B_-PF8(s)ior)pEthet, N0boao S 1/,2/L3/TokR@bOO`P23 IPtifd Exclus`pᑅAJa@4 `  !,a*ۂC~d`*-NX0S#ӏo ATr)3Vh!, o	o	k	o	h	s0bhn	o	o	ehao	 o	o	 ao	o	<%MEU 6}o	.o	o	o	o	U bo	o	o	o	B8[ 1 :rgR. c% ] /{Am	2 c44-Clē3	0k",'* r  9ODJ)o!Ѥoh ~aБAbbl"ۑ @zArr#an@pٓc#uXDᎰ01gEx!`F12QTAmbTouchPad`uo N`ubaub  <F1=Ajuda>rInfovȇsobo Sd E@i ?5m!DbβМR$!0
r t@7padr0
3r  Ign`air@A	
sPs'&_A1nanJ4aPOaDr%&U' _`#Ɠb!X _d#!
*
SPtSd!܂]8liz/p@O
(I 0✀!ԇs@/R Q*?g%Ϡsbr
autD<n 4dcЬealhea@o`Ma (QFeOmPasg1=i`CP8$!leROpT`HDD A1)r  VR#Le Mem@A< 4tatu S`Mu W^G[⩨' Av8S%,io Qa^d; camppJcinAz"o?CA9`esse qlr wcи'tinug=' SC=CelaAce imNK!S, Q%oyu=Maikg Uti0: s C	qqn'	da o i  apGrop@w *u@Tt#<ENTER;> t5meRez[@o.Tgu@n9 ^r utb:  ->
PAO = PrxiK\<-QBACKC	ExaQE06TABo$S_HIFT+C%* F2 	*:`=kSC8# 9nErrrOAX@Q@na0WoQpڃmRHE.? CdigTGo 01  NP#hG`,`:o `̱+)  s@ viKCAc A	bMev
;nsf`ZWotebook/C[(RWS mGsTe2_DKKXqmBm xitonN  Ti0Hۀ3VpcS_\ Tahcache (L1/L2੦FX a` ROM FamlY  N 3sri
Revi=sSvde@̠_aJroQLa 
Al!D	Ob a(i34`Rti
ep	JIO!eu6(]){ 7on) oo.Oo$alS~ƕS?ecunda'$ 1rcC% vfoi
"gv@!mO al  Walk  0e g1i	a lien!M! oc0I@Advert: 0[Aqo vae!djقWcqP/,!i@um  gravvuu:e)E<ӎA: n@A%dc NS@3 >B^hOz!QtegiEa	c]
v!l0IyI= kT@ctez0eja $,C? iN >?ý1 (Rp b2 (A@ng!qf3 (S.M.A.R.T.ax`=_(.): 30<`х`ѡ0@CT =4Q0%?1$bucedeA,qAhostDCrom1
: Iss-P$Eg
Ch`Ӂƫ(*erPmec  ` `6Q3sM tri!bߒLD`AМexa@s wQUUig:Tgrg`alPSLs    qL rB+ۤiPArrfDigpcis gҐSAdP)PPЉ:xacmod!CsާB! fazA@ArE8r@a,Πer dfoCrm!r3Dn,Pja0ّ.@eHCsHfbrcausadQerF. TbZ Q[ ea 㷑2krvio 	Iy0rqX)QT?%0Р ur@r0k
ad`pis0S,B,QuickLock!Suspenso Blo0ktB #u@aSM%8` mabnb1IY  @k,$$al#.2P4sa eiSib0RPuseu sEExigU`re*PbM0Q+ &per#me@$1lp즅p+!CD-"$gGP$qme:PDusua: VocÈ@gp4ؐ@a0vr2utzooDriSve& t@$RUSURIOBG@ESTRE_FSC% ɑ7q<Vapaz:@I. AaN4P@9de-ФrMiAsPJEB>p"}\@. NNv ݰp[֣'6Ve ,V`(_K` 0+bu:*Ƥa !Ede]D.Hf``7/{s1!Bi屧O7T>WDIAV
l`9w9o  sumǛEf`lo,al Af Caa_erf
a`uuz΂oT :adq(˂40  oqur<@ǵx@Fkg4U yaf0T  y 2y, p;) F `3B;or nal|pF`a-t
A^ 0ˢtEܴsubtuCd C{ ?@ *hR)ppapptA-l VJ/qrWL !8Z  Lembre ՚	vqMac`Pasa8
"quAi_sye`R ESC@]ŉ9Šq3lav'f'rF10. r`r:MrʷT!Ac]D ugus Op1k: Mult/ibayQYNc`ƍisi reAFpBa baФcopld(RP ditzBĢ	Rc"zipcPrimeir"rc QtRӂO]v@N Ղc@aqAs Fn/CtrlIngls (E.UV`ыx"S[hp1troahvdeA/cund a@hMo#aGPadrBiQTaPhBmemO"s;em fu0bw>zec10+CA.#RPa 0RlmWLAN)`` &Bl0oothkAn2πڐ(a/l Eomenerga  ere*a!gBC/*1w62b,2oo-'0suЁ`/0Et#netg	O p
/*3/CToken RingOOboId
!fDPPb 3araT qUSt sPSڼCBbQGP_tgemNSrl1Csr|NWDuplo&	ted/	)	 E/	fONOOO'as7A XjO/	kC/	cIAlЏ O O/	Ojb{MEU/	/	-/	G9Dq	/	/	/	O6[ Etp 1:rreg. З% ]@Oc3l 2:cv`N3:ɀM* 
 o9ay CJm*O"(s䡟flex QSc`xrydap R쇕 i3Popup޴ Exǐ ~'F12( "ߢ dQZs Vsarava N-u`Ti k yktukP  <F1=Ohje><PaJrj`PtQt Nytt v0`tu kP Tallenna le?vykkee !Zdk@onoePPuVtF?Fo0ej'nsW OhN mupA lopQ4Lr  ttt7fXTpou؝@aurlisuinvojan ssaPMritoKynyk La tyl	
 P usnume p
o$-
~t lykiu '
,(oPnu kiG
/!(et@ F0.t13	t fsBg5*tehd 6OG" t!"$jڊ;A)ma`*in Tykalu`A: oK < Ki3vyt?5OA9 @p6( Mu Ok("@ a6nɀD;m@.DHILishie#liOIk aec  harlAl10p>  H3gQO3'SB3$*3&oJatkinjot  nWpppA^=d, ESC=Per G=Hyvksy=KyllEi N, Jok	uL= UYa`} fnuoli
mip_k b`h,%@
sidsN <ENTER>[ m@t
epb,.I Lgn C0ss seuraavU:A ->PYi VLINPPIN =[s  <-bASKELPALAUTEdf"2!ARKA+!hTVAIHTO+0', F2@
)_!~= we@!<virh`wAkkua e=oi`?da.?: Rvdi 01*ka@c1pt~ a0I3rtPTm pVeytke`"6ko`>@	siPpRlaks`qpssX` kaCtqlaa8@Q@_TikkI)>skeytyi Fn
i(0P2nL_oPhecaGm|j}Ę~1?i eB tOyyppiIn :gapll!VlisQ (L1/L2UA  ROM-Sb@nΐkohA	tuotepe"ɠsarr|W@^`si ?stoh3jab T;{	!1:"#2$o L3o`M4mJ`LtaAIon7(j \oa)



X\	\J䑷kA'ra- DqQACu$#:D$ (9a%dz|' lpi!iEމepoӟi Walking 0 -[1Yloso Vaihtoe8@ :Puvi7a us: Tm'Aat0nhp . Jplt luo`ŕpus-  n,ir1jRonc<!KA: L"X AYhkФu VV3beFAG8p_Cpa 
H&koa]Wi !`zn? Բ`  H?,iF`%(N92R`3p.M.A.R.T.Arp$[n (min): 30s p2y0%cL dv0 Is,pysi- H4iVgR
{8fb%untq'c{K)jServomoottj
Lu!5ÂvtuQj	k@FtotribPti2 ЗŽy@a 6eqKxe nGG9 UuVahv2u x P>! PCda}A"+2 s@a	,-ãPAJ!꠴n4-okkpDBad`5aCn 	nDP -e@7p$RmysbaH
`kh@` ЁeT@	dE	ZEY2i0Xj\ [!K unQnawby:p\veapahtuam"b@^id FLaJ4|ftii l| <HP PrpctTools`cuQ`Pger -apuД큶.f(-/U i` n QuickLockfga hlu 5qf,V "0@PraZ&-Q,:*sek m #o$j$it)a{d||}yh' PP`0#UCc.7>uu	SApor InfrPnR%n CD- -!fl~QԌV"s8 łPANjUWAioqt;"nn DEe"(1o")Jlla.    KY?TTJNI9! PSSANAN,0IBfw.la"q| %sily1MƐgur R7qg  gri^PfaZt]r
f$VVI-`$U,Ap  iwLLA Q0<ѨWZ&C OAMA  Q	ops ) V4 suE=:d,#tu @>x	_4`o'l N
E U7lE r
pRw%y iC. Nyky3b`+0mPezsv6Ar
t  N.. Tmtt S`|q$ihveip=uperRU$<eh ? IPa*?-@l@wp[tЋHtaP1U]=c zAo<jAaiemlV|tp.  Anm " P$PtTV @UG.2!`ZX2qїaF_Qy#А ekrm@o#\Xd,|aT0ESC-n"0sR;n,%
'e'> F10 ŴYF4aaqw:	o! .cVQ ll`QݠtmiA$ys u"bn MultiBa@Opc&J/lakoiu (enA/$oiP) USB $@)ZipEnsimm AKoelj }Vi@}KieiYt@Ka0ks Y Kymai Fn//Ctrl"mhAEng(7USA@UsP=s#inla!ǀB-RsఠS$ Rn1 jPBsi PPs Volh̙t|\Vakio0s2sNb#I̐guuQH Dpl verkko
W_LAN-ro'wBlu`VothE @/HE@h^H@sV&@Qs s`9l@@(Ǝ|+1`i<H9.2v+-p	+ (ylosp*OG COr5EtherPn1E Yoeo3o8To@ p#g Oo(@workQ#%G <lH1liv3 AkkuR < TAJq 0ѿ rjolib
r@du c`d W\ual^- OO OI OK<b_OO  O O NrO$O$`O$tva_  O1 O1` OMЩaanusBk ODO OOM"OOOO
OI[ e`i:r
a;da n . Э% ] `ODP$W2l ur00&OE -O
3
F GoMOH*  j , 9 ƠаBk 1vuC!P` ɐiư  (se n A@S`: OF12:ٴi@P%3tappi>koskePPP 'mmaK  Ei mn Configurati3ordPteur  <F1=Ap> Fichier? Infor m Aff age Sauvegarder sur disqc R@a*r 'une.H_DHeals dfauow du'Ign=o%modi T&pqu S$?e l'in`p$@@reg om	\ Scuritia%
e ssLdS"#j@e sous te 8Ion.D
 priphP %J	a sE&IDy'As
Dr`<Lockq
Smp(C0 Br131r3  'heP5G  ,b#a <gre taR,)+5p7am''us3;),;rfren!cM =``t"#Ou@[ !@lonnLb`beriZ slecqSn@psQs AIATA BFoV,mmoir `hcBDX C0ZZaFB_V A0c`oLang4 ChoistPJ Ul3Ind)|!5_mps g!X 5ePMd.rpa `k2Z}:~z? AppuyDfnatouqpo@gezu@l v=Ser, ECH/AP=AlHAccep| S0=OuiuN*#Q3V, N/'impp_e``D
=0aw  UPzi3
s Mf'heM
mox!04ecle hmenuucer8@r0wbri2qh@z!y <E?NTREE>2nj+W	ss	sui@/fa  !/ :-> ou BARRE ESPACE = PBe`1-$IE?preced@S.TAB`CA*'MAJ+ix F2=1p"w-$!S( rr`@P<TJ Ily FA%ssibdcQ7L U cs'Jprod{endp#B$P. Coa<'401c5CntP@-1 emplace(L' D SaQre @}C'y
GJ 
s}^ccueoil dн "4 itzaxsmobia``
W 
u` B!OOOF2BfCX+)a ru Fa0;cq0M\ GTyp0osBVpwDb KTa@rcaa(L1/L2) Volu`e!gD  ROMOamR Numrqo#p	Rev`cndo erS2ItrQcl#avpoLA} ud@;n+/Zp/zr3/t4n"3inv!/Qzi&<5 #priF:!L( Ute)O OoOOOBV'ed6A Eo MT֍ :$/.   %ErF4 !SUPc;Walking 0ᥒ81lig'ad`auZC	od  al0i5fAtip1SRC[a=e@ptruA ieЪvPR! /簹r,  z{ nr1o°c	HcY0]A}jDL_v
 t;ro Pa
s
TX	  _[Rvj!a"`dH.ORn m:YfP S 0"Ӏf   +-vaPC 
lp  ߚV ? Igno7 +| z? Enregeo#=1 (rap`)#>2 (coet)u`|VpimA(z) Bc30堿s pAnU0% nv$D9ʈl'hA+bF  `:˗	AsmGinpnu#d'+,`v`t
$.Lu( pG3ip 5A`ib!<O: IDP00@"s S.M.A.R{.TAbanG2WpW AIBY`/se N!=apYeAÐ?/@;saұ#A Mar uin KS;A, eecoac	;mme, vK*ad11POobPbatCs	eS¢d4D	 pe>a1a`(`ih s4[	,p@s蒵 `Ug"  f'ormQg-hHq#xѼsJ.)ArmQފb	 hJU0`
1AJ	.6zT"`QDP~aR avoupR!AfrCww7 A^	 	zYR`(p"}ffQd  k;l2TcgNq`rHP P`o Tool:e^Ry Mar 	O4K8CF!/  QuickLockUsus A|$cp!ri 9 س<S&ol'S+C)re!cB!
`K)!nk:,   v qi4//;  / L'(a'Ha
S$ud!v
 KP
dra+D hn8 4`ExiZAudP `2  4raQ8llƙۗX׏ CD-'EǞVpal JX
¡:!5pr5Sfe DriveA). SS@@@Adez deux"(UTILISATEURPRINCIPAL) @!D犵	Ъ"ar R䊳N N:z?I`!@~`E"Q!qhsr @+lfe/"celu&MsDordi`Bb. AW	z(@oDNU(Co `cn U@fet#q xI+}M"+t"	~"asW""qmoeP: :""t qD)<Z=Ianiq45#'Oǅ#!2/r,"c̓û!pk!  3PߍIXH!! ܐ!! {e ZQM7j]%uelП21d`̰܂T :H,g" ""o }a8kE
O' fW'!b_^w# ,d'origi-nIl2v`O"$2Cwa B	u
vqSa@PAQy9)Pt0M`
5dj)abvps{$s`Pze*-$݁WQa0prs0`Ta aon: top@TP B2a3440pab0yt3ץk'
1uj, appuy
`  ?ECHAP.  @@ OTzR'o', pui`CrDF10 TapXc 1xCxY^u}	U:/QFrana
OgvACJiMu?ltiBayulBphA 1!3D,xsouca%(ga)OOFRz) Ux[8V USBfQr
jZiprP: Dhi@s QuaQCin`NSwixi Se Α  Hud NeuvCD`Perm/r(s F?n/Ctrl`s= AnglpSA) Popm1`s A@stanPhnROd'ad`n el!trul3' Uich1&uer&mr`
Ұ*d :i@7idÂoAѫa˭Bid`Ԃ 0 mSmVlb@jEK!al , R o!=ril WLAN (rseil)Agr쀈Bloot!h7S/?1   ;o`! g`N loc
 9G ``!WnX-b61abP-!n o82ooypu9	3ccujodogB& Ep!t F 1a"23TokRingooU/IdBuT6*ao aX  /      h lEl` n!Hre0/ x Ab!AC.!f*Duph*/@)///tb /////* *-/p//Jngn$ , /,/ /e s` BtexЯsqbmo P//7/ //,@///7[qRpe 1 : Char. %C ]A.  
2D` GiPcM*n3@	R kio.
* T  @@/M.$oOAg$Á4Amor1cFe"5 RetardBTexp `O) Dгa  F12tposf[iP+Au_x  PatqbAKw ucu'n I@z!Nl1 <F1=Ai0>`nfo0gema	l p'Salval floppy%APttoRip}rPina dm@Thifap`i Ignor`daed ?esci EP a
'l'iI?z`ciBnPtup iczza sswo!%e am C0rato gPccsP
`_QC*vos7v% IDs
Ҥ&gDriveLock	Pr`ǃ)S t C7 Sup;  c30 gHQg/ o+:,i fabbrP
4=i	/.nzi[؆Oco
rui Cb5<bBae9E`lrFOpa@t2;o rigidAtaA'Vxâ,a mepT W`<HKhMiM;A>oಞ !Ava*=t Lu!O; l$Dim"& q6ca X ss=o eviQc g	vv!'#o*62wH8Premi q_siasicsXperQVu L  @i=f, ES?C=Annu P,aA Etpo]eo=SiSN1T,altr
o#	=A bj Us"SchiavI frecc'!i1`voycu ap`=f"_`<INVIO>  \k\'e.i&pYgui  un%: -> o SPAZIO = xsuWss`0  <-pBACKCE`c<ؽTKAB@C%o"MAIUSC+)XF2	>-= m "AC"IErriS0D  Qu A87npupvse@t"Vi  v@u4T|XJ. C{'01 Npu0F>9a0 Doggiao Lk`IP'00  Q>re0
4Es"@agga%FvpSAcғ  npabook"RQzespajT:\ Zf.atp1_
2o{briuPrf uduA ND  Ti"+0<PS^pVeloIStepp@YMis1ca(L1/L2 d&dDbROMIamiglk N@o0H`(	RP[3[oxi#qSroll TsjrAer H~i1OFk2m3n4ࡐ7w PVSTeP)DE(d)8
	2
3
4摭xFonda
 ,o:EV$ Tr%$OupyP!gTpŒ@lliASprB:bits 0t 1ИRindirip	i]  `|@'uFAЎso:5X%? gger `|vpAhAre!0M/rѧ, `1favi PPb`iVYXA:'mU[A:"maconou`Ah(_ IISɁQritVa] Nsv@dp RlIQOyളSe3 `voPga ?AF0bb iQfre?@?: Aɐ51 (Rap)62 (Complet"2tio }(): 30>0%Q5"rƤ6ar0䠈'hD5|:s *Щ-@
 ֤(aD୆%aerv|")LċAPLA'	rib i0gol: IaD$Ban`de@z قi S.M.A.R'.T.!ޱuTx0U _word9c(nuo!i&2 pDs c(Ui%LH?bq+d`ᗑ {â"Znd?՛O .A7Tcq^B&
Am AVf! B;YECr	t>J&2fum y3"CePe<B #Eu _t0s!1a.Q]ՒbdFo!erqdPКatiwEff+Jizso@in  ca@2ivEvPgaζOdesХ @Jm9Yy HP tectTools Od.ZRV2+ ickLockspen`3B05EY. mou`s8 MM d?#<#,p  gra@p'!oe -!e$C-))`v!pKsm@]H0x!! b	,'URar i "lі@NR(@@|ГV|a infraQ)p y)o CD-" Se$PDFVp:W <!SRQ#3ęwusanD: e1&. D6AF$<P @@b}W'UTENTEPRINCIP?ALE  r@*रa m3an4fu`o. AnPV:FcP0r о a!eQB<p0b:0.l@d0AAuULTkZs,^h	Q[m2H sabR; 3reDV\b.ALN = Q_o0%54 dE h=>Ё`@
 >rea,@q  d (`8t rOD r luogo DF T!B'     #h$ f@ER#:,!vE</ sI"I@5-"̿WpClv {s"k mP0!R/DaB  /$BH @xQE~a(  ٰa~DA'Pa gQ#}QAi  	Pktat{fa+ ueY/ cdO::ly&.2nPCqu_{9㐓!. Y)qA`YE	snOP䮅@K1'56h,mP邆эo ESCƚM9'Ý)dovQr 'n'pom!nF10. !n!k KWyĴ_6\%גPt qIP(i 3G  OA:D0@ $d5m MiBay ba1.ggas$Z) ogC}hi USBژ]$Suk\bC
ZipBP6o ;Terz `OЁvN% ec AН" Fn/?Ctrl TIngl  (OUSA) Yi u`2O mp!l 01aЃ`R7pl Aaп 0Mo@eQנ Bid0HCapa memqX5eImbs"Fl@DQ2'c/wNPs (WLAN){oBluetoothCommu5/ U(j)@sm energZphT1$0&1 N*'2HB*Cad6*(0@o)ol,sp Eth0etW V123e Token RingOE3 IahbyC@B@
taI   aov  CP/b// TD zS^oo  YHiPDuPT  / o  6 / o ,o // ooba c   / o `uY\mo 9S//-o oooų ///oo[ PAs 1 :: 
ro . @% ]ocomp#2S '4,n6E3`
ij* 
 /JoXaX/3i 'o
   FloppybUAİIAd c`Ƭ@(sec.)C velP`F12b 2pz@amb(`Nu up <F1=Hjlp>@rkiv Sya|infot 0sv~ S pk%kigu @1( stll frnl1Zn@ard Annuaa nd` ochsl  anȑ S'ker0 dPR?trslpD'  K!aOB@rt-OaE
n ss	(b -ID
S aoТ
`tPd-Std frutQ !av 7K
byggd 
 usBi=*abrikP+ .J
sbeh #DEsktsrktyg 9Km +r vڐ6 S`;vt0HDD Ak_V Minnes: $@01q5`?@An'@#B
Q  oVljrD;cBnedttlD!v(C-j+eTryQI fri Dg@q nr? du viJPst0x X=, ESC=AvbryNaFDA/ccepaF, V=Mer X JvI pil	c	/pCa yEt
<RETUR> oqm6
YRtt .ie,lj`SeferI  : -> MELLANSLAGSTANGENTEN = N1S@<-BACKSTEG FregeyK TABf#OKIFT+H& F2``+?z=  'fO @%Aoi?Cfel 3t gqL` kA@t h+AO` ~Dstod uGen. Felk0197 AsgF{P|plat  NtPhm krv3?A @`pbygm0 fly5s t6 -dato;r/r ex$(|0YtiGdigooi2-@kl`TA UkN4,  Pr Pr, t{yp
hast^hg0Ca-	rlek (L1/L2)Yd ROM,tum  familjrenummn0Ddeo,`r !Y ttNb ~pqyrQ!]H' 1.z2#)3$4rbinvp ˦3+ (bZ)g	1[


Sek# xIrq.$4$@gaxr#q%Ex!z=ok!ŎvidClmissl l.s Walk0s S- ~P f1jH Add0s li7Aet nVar! D@/ѹ  7neh g"Ccuskapay /G-t!ڱxiƱ=k b!h$2AA:1R K>#Rh	i{wIBB?skyddad
ag

   E҇A!^Ԉ  |? ig?D܇j`Ga- 1nabb8f@րn`X9UWk>`ad k$pQd (0): 30@npan 2?0%bX A4Pp/]pp01vridAjatPo:,t	!قGOk%S(|x ervo-LzB!i @(f%ttrib?ut: IDpx?grobsr.M.A.R.T.->5 GammqN u7 ifin@ D> LܰQ R4d% pm}v~lika mǄ  0'InE?kan orsa@3i ЈP9aHSsNypPO@COm=<s1A1lo. |'Na om =hglmnabtj@Deh ;else- @^uQuayVqΦ >fun 0`ʎperl^7!i HP tec?tTools%R-6-Quicka"q`tel?ge Lp׌mPs Hgk
gppb*_- &q2@&!џ!!r ngo"pKF5bli`X!a<ot. Kж7AompHi )p@1f   Pk`anCD-pP"Vt N
"4oSq HuvudG@x@H: D`+@luAhrdsd D`}e. .Ч#`a]r AN}VSHUVUD!{@Pmaqt W.[  !q>`KՠQ@ild fr0!+A
 GOha0w L l1փ'l GSWN.
X (oF XإAd/bbycgg05P0 g`2///dY5- FbW:o	mC eB
07(b!>=  >Dq8asB1GcgCZ@ktu0ai`Qږafanpkhp@.Fut!L#\tg`Rs p]Vo,sqursprung_cJXJ. Vi  reko@ޡt2F	B}c	Vrй`+D,ps`_b@}. A`K4ɡ ˄3w_Bg  &Ӄg`!(g}AyO-kbeflse qm ihђޖflj1ens. Trp  >ESC-QBS RVPw#`'Z'R-WsedMtaGF10@cVi3Fa:+dD1}shxE ASve a 1: N?, MiB;ayCrut@!}opBP5vi B1a 0G (Pyr (h aSB G Zip-=PW As1Fj!Б1. utto NT VxPFn?-/Ctrle j E@ls(USAbmYkd !AA b`nrmstrorx+,f hbbelorlekhPeo2ne Flk paLPaiIfEsio"trqtK ?(WLAN)Bluetooth p/() f-v@ANѾϔmbe Aggгs`hahE%-21,2v[,p$Neyd Eth)& 0	3n To!|RQN"|Unik '@$<QiD K @tus İ     S"b|o Kalib o dp{  F:DualQ.O
o  

 
9
 Fo 
E 
D0!j1s
Aoo
E
Htag *o@ 
* 
VCy emol]A*5 ooe
DI OOKood
PD?[Ne _ : Lapr 9. 0% ]
^klar2u j253omFjOF* &V@1 >I*O! DgOߧ̀U«br@4sadap@$lg rdrjQsnabb0 (seck. F1 Bd StyrPTguen!he 0ae/ \`P}Op e@slaan ConfiguPpo<anafpvt ardQ3!/  scy	WiojzigS%ne@" programma @٠0Soetup  zr w ؃ svei !Behee rswachtwoo1څ
 $X. A=p aatbOgl$$ ID's  	Sm4CP p 	Oau3P$PEcR%mj+p%O
Ge0`g3 gvssvzie2"Fabrieks.Cugz7/);Vref.s:nieuawB8ONc  ExtAcc)uwB ZeN geselec Ea  es ~ zelftGa -schijfeai`AcAt PXvG0u?1I R! a/ 4UBgDAUcg@7n ,DP=0%_
 w 9ʠaKc!: alaal =r/em 	rijsgemaak el;o" /;09
8ukAZ@ ]0ayMLg]@f=S, ESC=Annul"EbDG0=!emJacNee fslui@Q, AQ-f`=MNHulppijltjkp`gebrui0d )jui~Pwnukeuzk@ark^<ENTER> ind 
cr]be8Zo !vol%@@01  0aiX:  -> of SPATIEBALK =>{<-BACKCEVorigl)TABb	#>EHIFT+%%ܺ2+Kq= ykp=t#<B~fouta6r4k p It w_3ge15 F0Mv0reqatijasFen. AcoZ01b`a0.i1ZCu  we   Netv3oe are0#F0MPNp diVbas`e3
 t n0 notebook-pcI/P @.istNOQb;ep*igdooh2L	MЛa\ft NmpALyp6roce;ssnel3Q̷ pp OmPЂP}e (L1/L2`Zapac?i VH^aROM @ -es!fS<mm <E  Hebvrgav_0ideokp&p;b  bpM	m	ra1b2rd3ďe4ahis(gI t}.jne C(_B(ЉwMdzQ%) 
  `D#/SecuibE.aw~~$DFtb%)҆2!dHU2L53Hac-0-*1Tho~_adresrlafwi}snd pao=LTop: zPt<ts e'ge t3 PSBbeЉif  s d1 A:og-  /ޖ"x0zbLe6`NoffaG1Y\f_dقڑD@`ѱ

bo
gAt
wXOC'We nu duъ"N
wil?oݩ""a? Ox
Zl"+1 (b),2G (U0Y ) Аpqwrpn (min.): 30aee&p:L0%Qtoo 4;q{hqo:5broAD):]eeqx/nb!p$32#kvo-IPsEI"
2ހ"qk:J S.M.A.R.Tc.-af@0APP@udh "/Blo!  A  I-7B4kXqc rlpSX8
 Vr!a1&\ is bBsAYohCf#/k, T=m]lijk0pUKQߛ zoFik` dvors:ka?0QH fQeksKPug/zet,r lorZ@¶ZOb$ uswb sqwYfur9h7oud'Hi`!  AQ`R`T`R@&BѴ񡘾 vuaYߐHP Pr@ctTools(*%/D k  p?gsp0p`b TWmE h#M"g$rgβ9b   ~e!rX#W>,P.o(h( o( S("7'EAJb"f }k otraakP)5w sXb tK;?ݳ ]Qʢŉ p1׀frapd  Par౤ˊ Cd-!r 7HN񸆆Hoofd8UG8r@JD  UQ0w`fbia DB1LC5!;i0zow)HOOFD-"RGEBRUIKERS^K  pf"an< SSC  hbwACI t fykgcompS$ajsLQ}0ZP$t d 0Bb&qӜ. @XPpQ~^zA/utompJc4@9	yT `r:ZcY<<|7t7 O!V)?!9NP sN! !. MoWdLioNTCb,p@  #i RS8pò̀QU nt@@Odq K8/ # `hui,H50d@wұ?was to/!wk wgeaГ. PWVA?nvloeC~XkhWSs0n@Pܩ׍zYUdTr!ra=8	2 torH/)К Bget. /o
 s  vBn. O
m2un
1]ѝA&`3fe*& gol q. Aܹ_ӱ_,@cdtabҔh ! Dcㅻp3ruk3!ESC- (A9н0@2i Rb'k'tyUbkn F10@`T*Z lusTB r`V4  Neplg g MultiBayjVzkd@\base; (ks)re  USB	-Մ cb+z6p- ER #we瑟V V@{Zes >Z$>Aa8NFn/Ctrl `Owiss/@p`SStaMcW3MijsappOU e% 0 nĳlBi5j V o-1PF@A/A뜂0d`{dition  G`vgp<uqVpilatE?Bvp neVd$Radioj W/LAN-aoe_Blueth
/oG`rgieм@ qYI1L[,(b!)0ۏ`Et@0 1
2
3,fTozRa/ -OMom@023 UUrtcu!G< 4us     Sa~Gekali@!тOK"r2
NQc ual P\JOOO  EWOOO[B['O0OO H{ap!ң
O$O"Lpier-MUE-$J$O C$Pn+OpO+O  [jp 1 : Bo. % ]A/&p[лd2knte ~l/{	3	# 
fohl/)b* Jt  ;>.C,$ VęçaդXadap Fpr(0sec.)Cpop-up bij sno F12i )Kbb@ cursorytuyEasyP}o-muisG Rs[^̃ZbgA` viSETUPj <F1=wv> t@CVXe߀ ɿւa\w܂tsfBNɕۑ  ݒOCOF畜>Ăg&f 
H
g  Hꏟo׎ <
ɖE	ύXɏI e `AȌԻ܃@ea L(eA`LCǗW҃p h/do'o "X yf@\̗L/cE%ID&ID: h (uN XBSA$폜eX} 0g J8 23T|OH, @v".eI*"%ɀ;FX
 ؖ>'f
cA>oAe̒  II(f:nA%e> pCeBI;vC"F@ `}F  H D%Jc9J; ڍc R5BM NP$߂Ad%E@U`U:O tB!#sNu %.37($b74L[BR af=~!AEsc=Cq@bsAS60=͂
  <aRAg)gjq5\{ 3gp] jkڂQ %iA@gp>[Ex]  e=ȉ#wA̀r_->Epy`tOo[ = ET  <-SG[BackSpace] xa%[Tab!AG#[Shift]+eF2!,,,10nmF/[%  !CG[  @DBCś}@BD?rp o 01 yNF`+@~3a
ACOk ~ڑKv@&eb~ rO x1X
Mp!mQ^0fGdMEU		?Ȃ2󋽵e`	уɰ   ۾  xï  ށiL1/L2|"`OM οOM̧Fرٔԍ  ޵ ޼ޮ ް ۰ׂ{ްޯ ްir? ޯ*#2.3N4h	? pŰch3(ÂC)FE-3N4(JkvJ" _!nFw 3XcopF?1$qv 䠇sxП6!̼;LsV+W7alk0s?A-1B/Z hѢp^`OD4ߌx:2B}tƁACN %C颴 ׂĎDa/ŗp>쐬AFA:/݉ b>#}v!hү F FSPl	NXWM~@YqZo s/9@y(c  ցB	!H #ċ g Oog'`,گЯ1iNp`2iS3p.M.A.R.T \zsԁij: 30Bpײ>v0% bj!c OK z43 eB~ 'f{:x@	{em`Q1kTz {ǂݨUעfIFIDP. Ba"R`R AFfV!'/i `¢k@@dAJg(B(a ͈DAJhvٓB"̏߼ /  Ǘ7߽@{R@ȄrRVdNJǂ̂*p4u`@ȂaU@C	 !]ţF"^
Yꍇcxei!ݡ£	8龂 ÉƂ`Ƣa7df!f
`?"dHP ProtectToolsh}lWŒTBq#j, .qB4УMmUNu<"T҂ h8' k){-E`O'@OH&J8-.))Tی?D<yD%蕴` g4`dt!(!ċN<b8v"񊰔Q Ԋ'O GPu CD-pu$(3H\@}@^ 7Q: axUKߑ #iC^"c. t%``y 
x7"	3@9>+ VAT:!eN,Bi	.	i	 A!!F	͎2R qĐR`s~񽂩痣HSCۊ"o"F`pAF/'@Aefw`6W 1E<r@߰ XPۏ؊ԓ "łbͯL |ił`Ȩk)/)%)!?ƈ UX3oNu@"*fBBFa(`o(e|~!@#$'m8`X ( IO)F)u
 ((?(9(.㜨gDsЯ}Dv#<43ɑqƈ	{MS f=e|^`Fa)F1j 8fcB  BgB<b{aȑOB%
O#&@H2ef̯ "8먎ߨql`Ӕ5C aU$/g'"wEE[Egsc]1 쉟`}ȍ~elaӫ`m⛡TN?DriveLock ߤt['F10at MS   y_97`E!O: ESxtkGb`ÓO xXioiEcUSB Xp H Zip1Ԗګ 2b 3 4"567B8910r Fn/Ctrl%̐ `{`\p (USA) `Ӄ|*B#fo+X
KAV&Ws
v C\g @}ZJ@_ rIso`̢ Wo% тACY Oڑ͏̧泵al"Ni!LANj%MdBluetoot/cj<!`ߓd p
 2Intel  Execution Disable-@++1d)2)++odhEth_ernetX 123 g! p
AOKO3 O >H!O Dj' ID 4b`K AM      ϰp`@f@R?k ejZ o \(@%*nP/h/!!!MEUt $)o zoooD2s!5bv1 : [d 9. % ]O^<2 !gO7v3		) J*   5`$>s'pmj&vSpeedStep@ technologAy
u'"( 	_Ħް Ӱ # px(b) ܰ3F12Q?ԁiby a ^`PbZB   @d                                                                                                                                                                                                                                                         i  ` a b c d e f gt" L            	 
    ܑ  
         <    .    r             F     / 0 h  3 4  5 6 p  ( )   , -   * +   mp
 N 	 % @.   mmU $ + 1 U8>E K ]RXm U`@E<BB<U> FبE0`8l v x|v||p0p7c   c 0A   = ~ 
=$$$<   DDD    O aƄe  i  o䔕 u  y ֡$n%Ap E%!IC&O   U A'Y'N( ~ `' ^    )y z ~{ [ ] } \ @ ~ 2 V1!2"34$5%6&7/	8(
9)0=?
zZ+*'()+#',yY3,;4.:5-_V<>1( ) +)#/!'?
({[)|+}][{]}'@ (#jod^Q()\|+-y~ z# {{ |[ }| ~ \ ^ @ ] } !a&12"3'4(5-67	_8
90)aA`$qQ'mM(%) +*,wW2,?3;.4:/5!@ z {VROM+*'(

C$~: |  sډ+'()+'* &8F3&

OO
\()|O276'6 -=
^~+]}@`)  ';+(:*[{s\_}\|      ^g|mA  _m^@  &.@  bm@ EUD @n}.mL@@ I mp  ?q@TrArBrCsDsOuFTuGuHTvP Ja 7 
m9 rdmxcmRa em?gm@@p < f+m@W{Xt|dU Zt}[}#L  ]~&  W_t`$itVaV!
	$
| 	 
U`	
 `
U`
fabUcDdeDf4Ph(>{&_N_m`@  U  @ڀ
 jް( 
( 
r lR0 |n }o : *ݖR  	?m$ $ 9 0
 VF10 Setup Image_SETUP  !D	Sq  ; 	d *v@BJäb"P a|`j 6
&$`ZԩC ؄ TUԫTԠU*<g!"$Dcz: T'ᴳ4㴴U4崵d紶U4D8b_ : (m
6W  ($))U$**$++U$,,$--W9 -gW  0	`
9 
E#8Ui3jG@ Ƕ#!" #" #" 
8 RMNLNOO 8 @
:	 
@      /	&WP  b" :   %u    N'U'!(( )UO)P*Q*R+US+T,U,V-W-X.3V
Wmd-dh.hU1dii2dj3jU6dk;kdlIlUYdm@mCdnDnUJdoEFdpGpHdq5 ajmUfoq$HrHs $[b{̪{`{|`|$|`|`}}ઠ{L`}8}B}.* ~X`~tuK wxU~z{  }RH kv 
44(3)]BxU`o2您T$\` *䇧0L'\Ut ;U
敇d N@9 ڠGxTnaLR@ \ b v @ L@ @ X z @ @L@ . H T j@~ ( ̀ L8@ R r  @ @L,@ L `  @ @@ B Z t @ @L:@ ^ j  @̀L2@ T f  @즀@ V zJ  @} 	L@ U& : N Z@Udp @U @_
L*@ B UV n @U @}L @ U@ `  @5  @ U@ `  @5 
CU  . J@bUv @ LU@ < ^ ~ U@ S@ H \ z@ƪ ր@L$@ 4 L ` @j @%@ > T h @ @@  " & *@.6P h@ @$ -@ d   @L0@ Z   @Ȁ @ ,@ Z j  @@1@ 4 B P ^@fr~ @ @6@ N x  @LD@ ^ j  @UB p @̀M8@ f Ր  @T7@ Z   @C@    @@,@  0 F Z@x @ʪ @j @ @H@    .@8@F `@t @ @Ā j@
@>R@  J6 R@Ur @Ѐ  T)@ F ^ v U@ M@!@,@ H Ul  @S"@U@ n  5 @# 5@ Uj   @S$R@ f  5 @%@W@ UL b  @ AB&@T@ > N `R r@A1 U@ʀ @'TL@ 
   %@A2 48<@V \@fv`h|* @ S(d@ p  5 @)A@ UJ `  @U @S*W@ H ^ U @ĀS+]@ Z   @,T@[@ > d t U@ M@ -@r@   U0 N ^@|ծ @.Tf@ B P V Ր@ʀ/Tf@ h   0i@ r A	 @1@W@ ~  2R@ dR x @U @S3h@ 8 D UZ j@5 @ 4]@ U( @ Z t@U @
5 k@ hhhhA@@Vp @j  6"U$ F f @վ 7}@ X % j@؀8 f@ J d @* @hS9@ l ~ ՜ @
:T@ 6 J z U@̀ M@;@m@ . U2 6 :@@UJh @M <@ d Ր  @(=T@    >@m@ 4 h^@z @? @  j  @@T@ hB Z t@U @M
A@ N Uv  @S B@ t  M C@ z 5  D@ Մ   ET @ z   SF@   M G@n@ z հ  @H@ f hr @ @I{@ D T b t@x| @ @ @Ȁؚ J@@ > H 
hV hv$h@h վ K(@@ 	hJ@vhդ @LT@v@ p   M@M@  5  @NW@ 5  4O j@ 5  $P@ 5   Q@@ 5  R@ Ր   ST@ ^   e@AB T*@ B R ~ hA1 @Āh@hh&Uh
hF@Xh^T@fx @U @M V@@ :@ Ub ~  @5W@ UN t  @ծ 
X@ D d x@ Y@ V b v @ Z@ P ZR ` nU @ڀS [ @ R l U| @5 @"\@ UZ   @M]@@ ` Ur  @S^@ l  e @_U   4 D@U`x @U @S ` @ , B UX l@~U @̀
 a@@ hhhA(@Jd~ @ "Rb @ f  U @܀c%8 P d t@ j@ d@R@ 2 F b@U @Me@@ * : P@ @J @hM f @ H U~  @Sg @ j  M h @ 2 )V Ђ@5@
i J@ UH |  @j@ . <T JVd U~@ 5@k@@ Ub   @MlT@ Z Ն  @mT @ b   M@n@ j Ֆ  @$oT@    SpF@ Z  ծ @q$@@ \ f Uz @5r@ U( 4 < B@UJRX `@Uhpx @h @̚sv@ $ 
 6@Щ> \ j@t8@ 	,@Hd |@j @u @ < `  ܦ@vF@  ڦ w@   (x @   &y@   .z@2@   8{K@ x   @Q|@@ ABJ \ n@~A15؀} @ "8 h\DhJ~Ж@~ @ʀ@~T*@ B b x զ@ĀTN@ J `  U@ M@&@G@ d Ux  @ȀM @ N n  @hj @* *@ R f  @ ֚@@=@ F d z @ @ @ H h  @ր@S@ ^ T h@SI@ z  Rh@ ST@ ( @ V hd| @ @ e@ 8 N h @J @hhhh	hA (@>Lb t@R "؀S6@ b  % @h%M@@@ < U`  @ @h 8 ^@l @ʪ @@@ f x R @h AR hh@ҀMr@ X Մ  @TR@ f   5@]@ UF n | @ը T D@ \   U@؀ &h@ * hU> L@\5 @@}@ U^   @M @ ^ Պ  @T@b@ b   5@* @ ~   T@ l   M@f@ ^ U  @S@  2 UN ^@zU @ j hhhh@*0* >@PbhIz
ЄМ@Ф о@ @ P jT Ђ@M  7@ > U\ z @M M@ L t  @ T@@ h   M@(@  5  $@ Հ   T@ x   S@ : b U @Ā&	h
@ : 	hX| hhDhh@h
@ h >@JRj @ @ r   @@O@ H ^ ~ @ )@ D \ U@ S@@ V ~ U @ƀS@j@ > v U @Ȁ5 @ @ UL f  @5Ҁ@ U< J P ~@ծ T@ \ ~  5@@@ U@   @S@@ Z   ؀ @ B f | @j @Ī@ ^ ~  @@ T z  @
@ hhhPA4@RUl @ƀ5 .@ Up   @M@ R U  @S@@ H l U @ M@@@ & U: P ~@5  @ UT n @ո @T@ < H P MX@&f Ur@ S@ V  5 @@ U   @F @ d U|@ S@ z  U @@ D ` l @̦  @ \ j  @@ ~   @ @ l j  @"?@     @@ J t  @ @@ n   @(@ d R  ЀM @ l U  @5 M@ U  & ,@U4<D L@Ufnv @U @
h@@ & h4@P x@ Q @ 	P@zU @S@@ f  զ @ހʪh: f  К@4ˀ@ j   (@:@    ( .@    "@/@ v   @I@ F ABf Ux@ TA1 @, hhXDhht@J @д @ T@@ 8 X x U@ S&Ҁ@ j t U @M  @ Z n  @Aʚ  @ J r  @Ꚁ@8@ L v  @2 g @H@ U  B Z ~@ hF@@ hL UR |@M ؀U@ V Uv  @S ,@ @ n Պ @ 2@ j  hU @M@@ 2 UB ^ p@պ @T@@ N r  5@ H@ R ~  h@hh@5Ā ހ@ U4 J ` @ծ T >@ 8 X j Ք@@@ P A%^ @  @@ : P f @j @I@ ^ v  j@ր Ԫ@ @ L b l@t~ @ Ԧ@
 @ L t  @T C@    @ @ hU8 N@x5 @A@ Ut   @Āh @@r@ 0 > P ~@逦@ j  Ě @$Z@ zj   @\@ j   ڦ@Y@ F r  @$@}@    ,@M@     s@ NJ r  h @$d@ f ht hh@Th@ j @ < ZJ d p@
Ѐ% Юhʁ@@ hJ   hM @ j U  @S
@ R p  @؀ ;@ d   @$@@ j   @ t   @ l  К @"@ \   @V CB 2 R b@zA1*h 1h h
hI8@h\k j@r @ @  @ 4 F l @ @ 0 V j @К @
@ 8T ^ @ն @TQ@ ^ h z @  \U@ : R ^ Ul@r U@ _\$@ > UV p @U @_\0@ F Un  @S@ d v Ւ @̀W\@@ v    @ \@ . D X f@ @"\8@ N d z @ @\*@ J
 \ f hhhPAp @U I 
@ 8 "^ U@ }@ 	\@ %@ \ %~@U @ր
 @  0 H X@hx @ހ
\&@ H ` v @j  @ 2 @ X h@v @ Ծ@
\4@ R ~  @, (@    @K\(@ < b@Uz @S@ v   @ T-  * B UX@`n զ@΀T@+@ l   M@$@ P Ux  @S (@ t   @$\UT@    S@7@ h  } ,\L@ |   T'@ P j  Ш @@9@ N \ TI U@z @ @ª @A@ * H* ^ l@z
h @h AQAC@ @ R j@ 
@"@ Z  j @9@ v   M@׀4@   8@   @ @M@  !@C@  Ȧ "1@  ̦ #@@    $F@ Tj   
T̀d>dN e`@ehA1@%P@ @ hjDhВJ @ހh S&:@  * UJ d@M 
'5@ b 5   (@@@ U& P r @պ )T@B@ N b  հ@ހ*T@e@ \   5@+@a@ UN x  @ʀ ,O\ Ȁ 6 UL p@5 @-@H@ UF t  @5 .:@ U^   @S/ G@ ^  5 @0j@ |   1e@ n  @ @
2 @   < L n@ @3P@ R p  @ր)4@m@ V j h@hhA~U @΀M 5_@ L "j @6@X@ N r  @7@U@ f  j  8U, X n ~@SL @M9>@ J Ub | @5 :@z@ U> T v @U @U @S2;E@ v  M < @ | 5  "= g@ Uj   @h>@@ ` rj  @0?@    2@h @ @ U&  i: T@t 
AT@r@ h   S B @ l  5 @$C@@ Ո   DTd@ |   S E@ V  5 @F@@ Վ   (GT@    @(Hl@ b x @ҦI @ P fT v@U @U @Ҁ5 @J@ U B j @
Ю ؒhƀ@L A K{@ r   hހL@@ `   @M@@ X r j @ҀN@@    2O@   &P@ @ ؀ Q@    <R@   &S@ d z  @ЀVTCB. P r @ eA15@U@D@ ". hNDhf R@ж @\ VT@ T j  5@ W@ UN t ~ @5Ā X^@ U> J d x@U @MY @ Z U~  @M
Z @ L Un  @Ȁ [\U@ & Z l U@ S\ @ : J Up |@5 @$]@@ UZ   @M^@@ J t  @_@   
`T@`@ 6 L X Uj@z U@Ȁ M@
a @ P Uf  @5 b@@ UT t  @5ڀchhh	A 6@Zx j@Ѐdߪ@ R v  @e@ F l  @L f @ 6 UR f |@ U @hg @ J X r @К h@@ F d  @ @fi@ &  >@\j @jЪ@ b   @2k@ t * @@րSl@ L ^ 5 @
m@ Ux   @ƀ @n@ $ 6 d @o@@ t    p @ V   @q @ z  ަ r@M@ r    s@@ `j    t˪@  @ Ԁ u @ n |  @v ( F l*@g @Ù @LL @wT@@  ( 2 U<@Jn @A к$ hԀAЙ h,x@@ zJ   Ԁ5 "y @ U\ z  @5րz@@ J d  uL@{@@  M (| N@  M <} Q@ Ā S
~#@   S@   S.@   5 @ @ Z x AB@j hA1B N b@DИ@hдDh зL  & ,@>Vh @j @ T t  @  @ 2 < R* f@@T@5@ V r  }@bYL5 @@ L ` ~ LД @Ā  3@ T n l[ @܃L @$@B@ \  ƚ @"@    @$b@ p   @^L*U@ L ^ Un@ U@Ȁ @C 4 L d |@ @y@ A`L
B ahhhATA f@ @@ "U> b @վ @@@ 8 %Z vT   * HJ Z j@ЀU @؀S@Y@ F T Ud p@Sf\@Su@ {6;GeL"U*D `@մ @T@ h   M@@@ N Jhz @и 5@ @@ U\   @  * 8 L@Rbp @ & @ h  j @ڀ@ Z   ئ@@@ R |  @)@ n  AM@ @  ՞  @&T@ p   @ @@ J fj  r@TI( @BrLR @ @̪ @@ " 6J{L>@ zL
hI>Z hhRh~Т @E@ F U^ v@5 @ q@ UR r  @5΀@ Ղ   ,@@   T@    S* )@   S
@ ~  M ( @ b Ux  @̀
CB* <* L \@hA1@L  h
"DThBPV b@jB R@px @ @@ f   @k@ 0 R d @ @@ X r  @ހ@ T |  @@ P |  @Āښ @t@ 6 F b @ @@@ $ H p @Ȁ@ J h  @ @ n  ƚ @@@ `T t ~@U @M@ 8 U\ z @ @T@ \   @ހ@ 8 hhhШADf @F @ "N Ur @5 @@@ h % @j  U0 \ p@ h@@ L d  @ @0 @ r   @* @h @T@ p   M@@ p 5  @@ B j Ж@ @@ F   @@ t*   @Е @6@@ < f  @܀ @ Z   @0@ xj   @ l   @ŀ@ ~   @ dj   @6@ t    @ H n  ЮzqWL@Ъ@ 6 B  T@bjr x@ R@i @̀ T @ > F L *
Z@r|IТ@AS  @ B X Ѐr 4 L@@ D f  @Ā @ T x  @@ `  j @$π@ r   @ @ Z   @(@ v  4 AB@ 1(D A1T cJA@h hDhhЀXUkL\@@ U * 6 @@UNp @MЀԀ@ H U^  @M @ < UX n @5 
 A @N r @ @@@ , < Z @ @ @ ( X n @j  ݪ@ 4 N h ~@ Ԛ@@ H j  @ܦ$ m@ h t  @ڀ
@ r   @̀j @@ ( 2 : B@Tbz @ j@ހ@ 8 J \ n*@ h@hhA 5@0@ U@ `  @j"  @ l   Z@"%H )h A%@%e @%m@ P l  @ @ C@ N b x @К @ $ 6 N T@Z`f l@tz @ I@ \ h @6@    @
@@ T d v @К ,C@    @2h a@ U. B H \@UpZ@ ΀ S\ 5  @ Uv   @S*퀠@   @@@@    ABB +@ n   @*@ j    @ R ` j 0Ђ 4@
@ U. 4 : @@UFLR X@U^dl ~@U @Ԁ 
*h@.4hI<hR@AQtU @Ai@ B \  @ @ Z ~  @ހ$@@ ~   d@ ^   @ P@ j   @@ v   @ w@ T x * @ҀABS Q@ 2 D X l@A1J @̀@hDhT {@ : H b ~h$PnPm/  /      /    
 SMM2                                                                                                                                                                                                                                                                                                                                                                                                 <pA -   iW 
 &  

		8  (
08@HPX
8
h 9i  !`G=i  >  χ      <     PSQRй Us# hNfP u	fXc  h UZY[Xg&ۅF ;9   Ã tfPfS
u	p  Vf[f}XRg&u-g&
pAgf&A"f,  ,ftvg&Ƴ,9g&PESWVfW&O*f%,g&D= $ <vD# D| u:t'_^
QRfU

}0tR>tK-tE$fu
0t0t	dpp  f]ZYPSRi u-@Sr-&-sG tu0< 0
g'fA$. +"(wZ "P  u
P! 3 t
 SQV3Ҡ---  :-tzffKf- AƜ(Y)9wfP98$Њ;`	PdX,)r(Ku2^Yf[PR 
 Z0R"-"-/ޜr-q0-11.S66"Sz
 9!v.>8A0AfžEf`5_f29RCxfW誙3aq!3fG E fQD$
,D$ f|u6_^YEAfQfLVffbXtf8z|t 	dD u0 rfP%QBKP	V, -ff@EFt!hXUgvuN>tO6f뿢, Lf 7:f^fX=V  ^#Q  \QXq7LYߊT% ,SA _,# XA	u-->r&BZ" `BAW%$T]f,""u'@` fR@%90tbQRV&>	>W&N N BU@_))FbfDf% ffDg^Z# j00f 4sp*2{ÀD6^U^nBn@& B7i({Pfpsf
  @WXfffL:0[3`'E8q4ж3U? L؇PgOS?NYYYYrZ1q\~YZ ЍSpk< w 			;/eE1`eR#tZVoQ`C F%frQfRV-u/(` !	q
~>  wP   8=hV,( BQ w  f3۹ fbdTt ` t0Q ?\8ZFfCPŧ@sw$<yk{s>
p"o
d
\KuO@S1y?"踡5`,~KuZO苆FFDKu FQ$߰P-$G^f  @s, nH^D	%ÉD	f:"-fp<v PfUJf@KfffQ$f6f> f	>fBf0+ff]X t p,̐Pԁf,_z0R0Ӄf3 Z`R҃>_ t5  A @@!`0Tӳ
@AԟGRV&H:f;tff) F#$Aq$e$ sqSf qgfÈ>  fù f{AB;tݿ)gf+ C kBwPEZW`)Mk ӒHGPV  ^ h2 ;uБ; ;b 6P6UXfۋ.0XQ0. !"#$%&21/-,	
9
++'()345:;<=>?@ABCDWXF E7JNOPQKLMGHIRSV      Z *8۝6ܟT  	1f  !a
  	   ! ## U .    " ݣ2 r	 _.>  B
   ,!   p      K   S)+P-&-1!Bru
>- 4\  >  t--->--u ,"_< tC2`r-Bb,-,-HQ	z`PxB`
e3ۊ؀`,&-,-g3 M-pVSP@t	V,[^@QV, "0ՈX,P,Wf uuqS1L,T,,?-[^0ufU_>,-S>->-G&- t(
ߠ,R,D,[QpQxVt>-- r14,w%0r<,&,6|0}S, E g6bdhE߁U!U)H 8`@yQ	胢|p%t14,h[3- @r-&-], a-6@RVqp7p	* #*   , &,{g&&@v@ '1&s0 ,J>,zy $	3@ % u> &
ڣ'
u$uvatue&u^\uMu:
8FPu)t]tfpF
= I_L^!X08! u	g&AFtF@s|S$,9ϧ ~SRV,W^_ߊ»,rQ@1Z,`,h,p,x,_,,5.rtvl,aP%W>=,SRC<v
2-,-`,ʀ 7,G!^(r ))4KKұNS	,$$,,,:,w/\,g
O	߄cЦd
	,Prg&17tt,7}Wr| Pdr!"d,Kr
 JtIx Ztĳ,=2oN13
}	ugPaF$н0]oX]Zf,`]`]c,_4<, r+bSQ <-f3fRγa-ff3 \0|pF E *  <Fu-3t	 Dt<Hut26t6 W2$u tPzXv- 1- uB<Ft<Tt<et<t<t<Rw*<Ir&-
2tt 6>0u#6MPqurqVCVWpքtAQ ft(P:-u 
  gXfCYv q9~ w2-_kt&-8r >tѠw=
$_@,-X-2 ,f?} t<C<tSQ0ذ&Y[Pu
lq.x  @  	`j zWP  88 4!W !;Ł @ i[\\oZ';S;BBRST4U=;{; UWRQSPV 
rw8t ur6ffWRfP0 eXhNlfZf_]>8 y8-aPS9 pu8@88W8/88D[XF f sf@ׁtof@P-[YZ_]e È88 Q 8Pj0fdQu!8! !ddfod԰  >P6Sd dПdP (Ľ88 fU t= T=f]t,>@u%ttt t	tfN tF !r]@u_al!s
 1Qh 6(LuFvk 08u$(
SfQVWێeS 0uLrt(ـ?PfD`*f{ f0T fffXs "qy#upELe8 ` 8PuYkfP$ fe8
MfWpe*&88fw*fF*2t*܊e&8fXfY[ëf`a@l'mn!(n8  ݅ޭy BĀu!Ѹv8W t8!ZWfaSQVWU&- t ((i]_^Y[LS-120Z?IP 250:*1:2:22PKw
 z
\5	8)MϦs!Org;<tV< uWQ4=f<P\g&:D=FfG(:* (X!X  ѧJA`u 8ا-888w880 RW1h
K}0E>4(/_M-Sys   Dis?kOnKey 1 #aB-u @  f<x fP f}0Q>"|= 2r 0w"1s sU3IH t˂R ff@fPuLwst6Lu2rځ	uYabc\,f_ PA rLT(f<?QRRVPeF5Qome}E2(
(߆;;? t0hl$t@ u^u#3 Af?LcfH@p 
fXu׫?D0 @0B0*B0B0B0G05F6F 	 ?((&3FPRrcok3W~1>#>;!2>
1_Yh|Ph`p& 4  h+<_ ZW+ 1s!$?
u$
˄[          ,X @xKdY rTBB!״h@  i|X  t-   	bhG%ofHffBfohPJf&Kdh/\ufKdw&fu  ffBfP  _Bf%ꣀ% @ BBf  z6f
Cf=A&  `  fAVfC`Df=߀%t 5{t;@3tZ0tZDfX$0g]~C  BIBSf@ t|~PB"sƑ tDf  f qCB<Cf>B u ` _D  2ft.h@P ^#rfu$B@s11 >B@!Rn0B'r"b"0 f!<1VC@f,S	  tX	ʧ"rH'	"	0 
%9 uf-%tq0ұ0 P3B*P  	PB-tK '	B -  rf 
 BpQDP؊*C@6%f>	CgGf	gOg{G]`0db>,d"3	0	n`6@#Du	%&hf6	Cf	f CfIng^g׊~W!
*t4 0A		0		  FFh/hJ<t
 &G5"p+u
 "؃ CG&G_C&GqN&-hbLҠ6%@( Bf (f? 42a3ufBW  bfvt0awSgff9Bu gF9Bu 9Bu
gF9CtgNXfFWCzr=БC=m0rxi?GsVfS'`c(gF'	Bg^ g"G0gFֱ V*	 /e*emd&b&g&g&G
G
 d0Gd*PGg&Gg&{G
 G 3gn FpBq	f AkGF^ 0\PfV csf@ܲmdf p^fIf!B&BB+B(B  B < tB  ;vȉBqv  f@
BqygfgG p ,gG
	q?Gfup"a ?Hf%ofE@ !gG!&BB t@(bk!f#pBfwcn`_OâT'PR<7з[f{S
f385f$fӃ\Qfp<#{-  !Siy 99KAtW ````a`b	`c	0]	0^	  
		 
							
 0hfWQf`!Yf_`QD=f8D=8IMD
$>8%
ĈD
8r% ߀>8b1AS_Ys)M8|rI`d
Qjr7R@|= USBSug&|= t t
U	 	}`8 T} 8ѡ p arQßr Ce0i % =P`yM`2P>8t Qzr?It2QfF`AdYPr>Sf1fM^z!WA@MH\
؀ne܉\bJ
prA
x @
`	N!?
0
"sTq
aWa'" xQ# iD=qp*W.?43'PT}2' oZ(Z
2/(
_7
_=/%t9' R$RS$2Q	@ ?R@RP2 3* >(Lu ᠅ T=
XS<(fT= & y#j688~ r}fPQtA3`>88p+` pta^Vu6 8 +.Rf.6ROPpYfX`RI|G<8 fa}9?,B3U+*/G/%QfPfph`1@YfXY"N0\̝ՐJ?;׸G7/Osc`sMoDABA<e=S$l=38%rpp8Lt| Lt Lt8D$
ƈDFP!r r
9rYԹ /p%tFPtt=tT= t2:t+u:u hNodty(u~(诚rt{^@L=@tL=tL=`	tL= Lh)6`oXaPSV88dtd}*Ѡr$рoѾ88DtD$PQIMPhРd^[XSQ)MO	8t`g	G	Y[ - i8   N`  80 h
   0p    
		
							
 

  "@6/a5 o8688hsRoI
YR&n8e 15s {fg&|tEBu m1Wll	 	m	MbWOAW`{zX&m8rm{soeÖXQoXp8O RasQHS r`QQQQ-QQ&p\W3
	#[_rgAೝt⹞԰ÛYc[5ϴjrjstx6bDtq=g[cc[tOtc[sfh~  W~~	~	f~~~F
}}}T `͹? !sJ%?tdooy%"o:u2;qqq!(~rgpppp2opQVpWL	;t	ʐ?mʶozX=^YpZWpp"I 0   0    Ro {d    n  A` r 0_0 3`  
& Aa t%  	B%
0 #
*a
| 
3`@8& <a` E@@ 
b
	CF
? ? a	 " d  qa	!? H% %@%
 +3F	
+  (E+
3$ 4̂ C8$+( 3+-E-(C -0294- ( `(E E3 . c+! 0
 @/9@F. 7'GC@<6 A6D
!:7' "J ",A!E?9B@,3
O<bJ@# 
 S<R"G 3D%M TVaX CJ UK8'(XAIc  WI B^eef]ggMhCopyright (c) 2001 Intel Corporationf`@ f.C<t<t$<tc<tK<߅tSKdf&Kdh sfKd   uh   uRfADf3w80=ISGuђ s
g]Od!t f6[d	gftcRa tpt5Hh @u  u u0 ߰# 2  u
P f%3 
f>CfDt	u)fC;Cwuf@ffh/hUtf3ۊOf"Qt
0fs
B  4v@#tz21!<ug


7	u\	Q	'hZ/%_CKf6	C	g u%S FB s@[%;u!,Of=4R0	ff4	)ffp	Q(f	Of@f[aSfSfQfRf}V*sWh15 uBT tApNC6g88fI4g^f3f@70}@7f^fZfYf[fP"Vf0Bf=`Bt"f=Ё &f= P/f=0 3f=@+=t8t34 , 't"#
ttfh0 rfFP0fXURf.  fXr  	 Qf}ufQD8@M TR2@(2Of2f0LcBZ{RO>V\3h/V,( BQ w uȷf3`_fbDf6E { Z<tatG@]_ToKg<u		upWJ$< t<0t$u RHP?y"P*WT%j_uPlAP#,RfWPR;C_rfc%1f f>=	f!Effg8u#>_444
f@[Jf_,,PSt{w&'{/1=`QYr;f.;Ylt3UufǧYlA<mpf}Azffm fPtP= v	 +v:P,P}Hlf́   ~:HlfLP P 6Tl1|߃ tL;Wf݉ ǰǋ;PtXl Q.XlBYrrf@u0`b h,-arffpWf`f"0~ffROMIfMAGE0v;uq Wt#g0 yKP}Q (J 2 ofG f_ZYXug&wag&GweG0  "2/t"t  V   9cu'[0io&w j3
G94g&GGfԣ f>Cf-+׊Ӹ00pD;gf3!@ h쀀1"`YW, `П.V.`B@~
>t1~a"pR ZoWR  oP&abpZ&&FdOR< uQS/RpBgtXr),uRG`SQr9R'$8tWYOtr$V簄O㰆HAr(QSFr(!zsqtrp@ppmq9P`N `4fq48 f܀g'p!>~@  ` FFBZss`b PQfWfVEUU &*4P U hX-ULP'G@3 .;qt3 _YXhSG% `#no0@	F`ٿ `l"'`sJ4 "`".-2'.q q#80? pgW
sfUgg& suf3ɊfXl]tVfY{AfWڳ]g<t,fUzgR r!8tfGpPQq^$@'}a@8tPUvPCtF X PSrN&0tp .t[XPSN?0taA@f!.?SRغ P BDð1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ,-./01289       Z `a     3 coRRFa` $a,P~G3""
P![2t*:aÜ`>@ l>0l!GA lBla6$?C ! G @ A  B  $0sF  ؎v n _"v   BnnnJF$a %JF P  <  tq ̢ P  ̠̡t ޢu     llB  ؿ/  lBB@_  l@    @ lr Тs WN?&O 'f l  /$а 
@  
FFnK  	n	Un	n	n	n	5n	nnn 
 r s  t  ca  ACd̀E`  |3nnC q
^p		 nA
` nta4u4aPfW@ f4g&g&f_X'=                     S '0 OL$ tT MSt& u BMK aSRP t@B u$Z[SfQWP 
#Xgg_fY[f`Q
`fgfafQRfWPSf3f3ɿOf0<  P tPf; X tDtN[Xf_ZfY<fPffffX,fV>fVf PJE gf^! f^	V	R				:	^	N	^	n	f	W		fWf	_
g&' f @f&:ÿfPSQWV! Q tOъ#$"A$$hfP u	fXc  h TQ @sY3^_Y[fX>ְuD`諥t`X X3S,([C vS3ۀ> tzt't:'tC  [0st<w>t8t,>+̤
 
ñ a r !t3C,٤ߤ (.'(Ɗ"(
t r3覒<5JfP@ &6(r! 

AR	 fX`{t
.#3	Ơ
A
 Tt1-bT(.fr
Rt0
Šs< t
t:@ `k  @( > uݣktJ( aÉ  H?!

pE!I;! J.!@!@P  2ؾL
s3y@si  Y 11F0עJKMoâ:Ju;pu;thprPsY`us 0! G PWu0+._K`:u r:Ȉ@&u  u 7 &	&Q[mۆ%0ww
w2:rp	
À
v߶ ><  22_ f`8P%A#%z  t
ف     t3sPR0@ZXW⇩ t(  G7Xt
 %@  Pé t u>0M 9  t`> @ `3pt%%tNtGcȿ fp|ff3uԖ[fff#f  
f!]+ mX sà^R.Q#؁_ ~U~	c	%@Q#Y3#0Ћ!` ZY[0y).5 2 &%?
 ˀghZ p	b
x  uʳ # r`u
[ `(qA
 9a nb%bt
z~%fZPiQ =$f@$f#$S%/ 5 Aq p#f- P
 0%uffe 0$# %3 '9ou
A&qf+ZYfsPSM4MSaT? TSh _yTydڑwRaW1Ar5   f-4S-#"3pߊ؀.@uRttQ@t
1
uf
=ِ#fSfL2KtE K PJp  P+Gh5Ft 2Q b /u43` 'G4Q(tC̱B5ft.f76A !A   u^1  dhQ)
  '  `--h9Ka@$)#4"& b
 babR	p  /ZPQpuG4 pyKq,b @Y!I0R- hH"1H	
2
.&\g t#.\:0Q' T
.t&*0 0pRVhl_BtDh̹h]l5hm7r2, f^fZf`2 =rb2 <XlTFrhYfa~f`yX
0Pf3۰//8PPcX!7"" h?&ߪ=Qf`/)
4/O
\ "	 	 R"	7/	(	!e&!_!!!p!hoDÓhdwG	qf~xf0&u 2Rt F<tP$rfe@03d^tsfQVWb 0 _^Y}TfP  Df!yfyft
{t %Sy!y隐gf75rSQ?f  %P^ЛWWVhE?2r=ыt
 pu	  tt uʋ?^_B7fQf:Eb3:EF c6W p 2:> u6 GH\o hyj/T3Ҭ؋hB^_fZfj
XK̈́
{>
2
Y
VT[>T2@OHp
Nt.
Or&   =-a-/ -ao/ / /  DO-<RwS2.~[S  ~fQh$_fY݉щ ;aEf3ɋPoo`0X&G     &Wft ffBf;Pgfwlw~rtwR{tpff@hDp3QgfY t?gho\#a$%AP0Y[0U>aPS 2hoWh`$2f[  t=> u輸% *>p u0۸fhvְy_"貎t9;茍螎t3芎tP 4s5 it
] 
PX> tp 	sdu
)eP
6` Au9 5謑r/<t+t&Pu
$&Z萸.蟷aq虍t"Qtq2t`cg&G Q !Ӡwhui<uC><w&t } &! 0 &!!
ܿÀ>ڰ 
8s ٌ  
t V$<
v
ط  R tǀ>! t =$
=ؐ Qh?aŸߊ$(
d t㋷%؊ w^рhY%

5d	
	
s	 
,mu !&! !!>! u
8wpR 4
*A "N`ff@Af   fOf BC?\0Q'  @/%dBPh p>ft	p'7f%ң \ @!GkĀX<t<t<=PS$<w .E# 
g"  T 6G4	 6  Q,P<ĳa	P 	Xug2BCہ	bS!uh  [@2P oX	@2aXP2۠/ˀ~a	n$

Àug<X[X fQa>a
K2ͯtqP@<KrK:PR}0$Z0>1.$ /BZ s  ""
ZP1@%% Jq vJ_úQ R (( PB/X
	ؠذ4ۋ םZ1mQSW @%_[.׃%%	&&&*&5&@&K&V& ߸  `pgp b&u@ PP @~̀R ĺ,:%  3` C ȳ;  A1A5إf 33 3iJo?  h M (J7QW<u
湬y 洝{oN_I+z |ϰ,"~[ðZh!|礿xѰ|  F!*! - 	% "Q r ,-(!, (!	󷭵	! -% ^(h(|(r((,a(F!ݨ (* (% 0.&, ;(0z>Ѝ0z((2/0s 2zzc[yUV<20y2 Pظ $J w7[.vv>a=&vE^]vv2 	R?sÙ)S rc.ߟ) Xgr&eȁ.t 軴'r肬x;u_0-׃Yp/D2f.f ){f.q u^hż?>t ,Яfrҿc. b d. oh(u`@@bUh*.*P//
03!4&-+t
3NO+t3GN߬OUN***N*P aT*SR*``xQ!loh}j   Tuuu&gq 矀дp  肆[hj_EPrXh"hk FUvPS,F X PS1y&@,&>,&<,[XPS"{@,>,<,,&,,^<n$_T/x+/H-S8rdd}rS<dr
d2bT HJdp08=p~-%i rN
&r Q                                    /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              K 0!$SMM MODULE -- COMPAQVERSION: 1.0 A 	 	  ( T*(     ښ      g {`g  h } Z +  ;tp?    / 7h 8Z( w9* AS          P          %X%H_&                                                                                    U `*Y} `U UPzQ@    @ 	@
 
@P X@Yhi j@klm n@o { @    3f3ۻ%fðfg!+)A7 f" 0 gf+ =/`hfPu	fXc  h  fUf&af&>m` 6a  !ŀX[ &SP`@ /'ao&Uߡ&@r
f3f僰gf }f3fh   󯪰@p h &?ïf`f1fffef   % ŀ-fWf0M0U0!0)ffXf9ffaf 
  fi@] 0 m q:  ,f5q fPeP Q Z  ͡ՅAp  A` efaa  !6>釿eуp  ՃnPك"` eɃ w	
e} f~e&` b "jeɃffefAffgd:ugdfepfa3 ?gCT "8fF3ۊde3 
td	 Ä p)'Ґ @ v
peuxu._RTC u:/
y'
%&bfgfd.S` [WP9A`XP&EX% &E{_YǨ o2oooǸoce  f`Fffut$up$Ūur쪺  .<t
../W NA NfafPSRV=fpr؀tU./tA
 NUN?:h?54^^Z[fX;4} PSWR/Qa>K u&E q 7eZ_[Xðh*$_gÀ> t>R_
ftRsHPSfQW_fY[X ;; ;?w;øPR0?B1Z 0B1o3 $ `%>&:%	 
  3  t!  { 9 z &@u#9?2h2_xrt0RW0_Zw gMNo<'fSS|R1Uh?Af    f0Lfs$R8 fZI%CPRrfPTmf!`	'yS'b'

R)	t2*[w.>g"s aPQRp$<?@t hEOt
uZY50' wBAC
x`h1` 艆  }!w0q1k2e _ Y1/fW Oqg&?t"g&Gbg&Gbu qq&} ufaκ( 0 
~.uf_@5`mP    NumaÊa$$
a ]C PB B;ra 5-8蠙q8S1Z2@
w,0V2:*Z : ,
 Q2RXĺZP ,>%:؁ Ë34 g&[D40eD
 <X6G   VVuW YH G 1VWhyl?%dt$h
ZY'V6ASl`DDDtD (g@a H2F`r[2Mt"s@#&<T ^hf
$1!/f2f3f% g0(p!P!q ? f`
Q0XX!!Áfgf?f%lffP @R
 `0C  fsA{"a nPl\t`# u8$쨀u0?	u,htPuX(t    Ȁ  b$B  ߰  @ <@ D ` d h!p   ػ ܢ @  `b   %ܠH PO X \HT                    x ~`        14PT   |  meb(L'0= #`    0 P    Paa ) M    Z PXYhijklmno 	

 K                  K _,89:@NNO OhXhd1@hf0u}|tf&c@qOZ	A · D|fВQfRVW f Q  !Q  A!!ȑf%隿3f3p.pffu_^fpŔfW"Q ء |& 3隗
f0P3XPSVWfQ߀s:qؾKي Pu uf`kfpv @uf  fY_^[X}PQfWfV̾  ˹  GFf:в +F4'pf^f_Y EEbR5   豠PSQxp#uԔp`@,@ fq$<s!ػ锐@t6@1%<@"*fuGjF|
sK1Ѫ0$P
f>	@
 o( '$
s1ֻǺ$vs f_ޭ3̀@Yp4'o%eD:ZW% SQ$
$
ذvzu$5w]u@$-˿ @x0f_5A^@p٢L|#Thf`m &a  6&P&`X v
``.f&r&&r!Br  Pq X
䏀  Pf < X20uPt	<u <p+ õr$Rr q&&O2qrr]rN a`z]7da(SvxБQ`01P"" QYoaLP  r&&ʠG Ob 
y' P"S""F"&&[̠a ˠbR ~ ZQRr3'H2't2ZY`2ٵ߀t"5 tt(TZYa~r#S-ER-Y03!pٸ ;q4 ~ r f & &E{ZP 2&r豂r8t320`.ʠ&EO h?,.ˠtGSQp1?h[&M.̱2tð$; 	#h .5 \.W< t -4?fRh2h]lFt 2Q b hm<fZrj  pvw@5 &E
, #!|	A	2ahj
%00`P 0i縨S%-  D``6(    pM aVī^`W ] j_r- +˸ fDZ_ED;Հ ]B@<B O B<`<2rruO0W2&*G_YýS	 7&*,u&}Zu&Eq_[DAP`Q ?گ>  0 2ۃ<OtY	B<tmH777rPBBLѯ: r1 r,q h/$do8SQk
gpqlat)?$<Pt+f#KuҴhwQpB`UY[Qn @qj"yjuBAuYoof0P	V Wo^W m ghl?1tD=F==rN|UtGV Q4^t1Vph_:5f^Df`]	


 @`W3  mt1f0fd f[ BC_2.fUf.6f]f]ae`a** End SetActiveDisplays: \ $^t5<;x )ڊ視98t  u
8?ud 9@!Sk[00t@uSQ2t= +P  t@࿐V
 ̰  uO.SQ TRQ 	
30p  D }PS1
S
Lp!
  ӲY p
^נR	Q9 SRx] xP$@ xxċ؀ xXxX|x}ZR\utogMxZ
R0``Ib t!:xP À߫2@.QRPS [X"3t0z  
rU[  N9`<
u&yr
u02,RW_Z tr0PX&&E&]  ֛pP%b=???=>.!S LfWU]fy_0A#W_@#ð PR Zb,.<t rH r0GXtwfSfhBhftu?` hCpqwfYf 1ٰP!Q">P'xr	  {g f_Q`MtK tf ITAf_gf`qL%hP1uaP פP2gaYd 
|StX/%WH &=&M_0g.g͵ 2? t0;r+gCC P -JPȸསRMp@uu(tQ; AP@Bff Ѱ q6/~1Ȏ؎t  1<  w >`Q'a8tY_Oj< O ΠRT' -RBPi
1
ffZt'DtuB ; Atu P_u3鈰u#Q?`
u"Qh9u
3tuC*u{r'p .uruqtg&OwN  Rx R#ncu@os  a d  D3   ; Z x     0Nm$
 odu	q @2oXÃ$:V HRyȃI@yذJ9y2ȉÏ-' 鲛_ w	.Qq奠 Ja  %Aw$tҭ¥ ~PRhy$hrEsd/(#/FJo'*/錏"YïF}hY!cf>QPH_u(Dr#1 0dOf@M  sLg-rU(QE -roGVfWG>fpV  gwbܼ f@l f  fff!2g&g
fKffRg&& gre hѻur . VhݟZ,
-ē ^SU!P s?fbqfRj07W6uLt;wEf6fB|Ч8 r/fg&bP Bfg&rf 00  afWu
 酀> ff`g? t]ǀ t
trV@ f?t
 :  
A'!s[f` 0;  }6frv`gGwf3ې fPffr:p>ff0o;w!fVg&f_^ufFrPf`Q.f3$pft Qg&9@#0 <&`=f=ATADtlf q:&Ǉ  p s  S3a  osb s1݋ E 0s3Ɋn0Gj@psUFWP
@XUu&.>J@   ub >u `	`	rt=p$l0{rrݒrC๰ź(fSIMWuUf, "f0Nr(ofOff;w(hG%/FI"Q[ap qQ#08?SECU70uBfS@:>ϰR SXfG9ؐ)u(E_-p$8tT q Gt+Stp
 _pTcT<tTDUpa%>6ph 
u 
00*@ @ jwffw	޻ßJl& t
&f_r2X$g&  Eg&	d2WVWp^fGtt2t~tyf   f`w'pA,u(0vǩ z^ @ u^uBO`xd rFf;r>`L: t, f    ur%)rQY9;	 1s+V  ߀ t%h't`A5
A!:0.2 r&q
"

rTr@ZSV!rP#j   t
ff;t;0
 + t DU@@DC@p@0Ű0/8rwp		P? u ff!` B
fff#Lp 


g#rϧS
!ХƠ3Ұ"t3 v'%`hůNƯGgpɀV1
< t6<t1}2:u"FIhqr() D01' E-fY&7@ wY.	A_S 
fUfp>t	 _--


f+f
B#f]^R)""u  ,gbXv@? An@u`$fB %  
羘@_#_#_#Mf}vfrg #g& hpoAP \ޓ}NfX2X'%U yV4	hlt.z rJ۾ `ųw8\u@	׸2 5Ѐ^aB 	 ! Za1 - Cp )zPJ	FB
 ^C m
كIڈ#
Nffff+fMs_	f-Efffq BPAMSuff>r^p!OwS@Pbɸ`X>¸ f?|	B( Єf`)r!PoWV&^Y ~2E6`P < u s/99r5f fO-^Y
`2222Bq2E^u@
/Pk
`MfӾ(JP"a`΅j uL$<tD"ЎQiOr&=t&} tV" &GF^YՃ"
s\A0 	 hy\!
 



Z
P
	



_


	h@G~L P~̀R ĺZ:SRغ0 t@Z[Xñ)b+S+r[ 0PQ> uι c r\d`Y PSCtC>r-ǿt`w60 r uҊ1 r
-`u`d Y	P rdItf s7`QR `SRNr&@r!ww3҆r r	ZZpPRcprqz z"RR
RAFZ7PQpq	s
d Sr	?r!V>RPpm dtg {uwRQR }hZkC Z.]߰ P " Y0 `2  p",u ЂQP hE\*R))Z@u eSذ* o rQ(`( p*PS  I /SQ ڿR(/R0 011`XgDC	 4_P>Pb7S t3306J*b7R
t#4 c tt ÈQz̹+3QAa^_C|!#3CG<uo
tDV 4^Wݿ _ "  !(̹ 	
R
q0P#H	
g&/ܱ1q;-r s;R(Xó 蕐J2{0 RVа$rN ;rCr<,	r32;t  rr;wҀ tsڋƿ^ZW
   е0u
˾   
u N f! uf _2 J3322t@ ?0 	rn
$	"
uƋ߱d;sRZ3QFqF2t
2t	u˸
S_ø
_...p.Ԡ  r.Y.2YD_VPC}poÐ3 <  <`2<
 1ꀤ                                                              x UPRPRVFZX}0RR30ZO                              喌Ȏ؎ Ѝߋh,3 u<
w'> u'b $<w	(f@<u13@ڀ= u7 u1}*<t&{t!uVr0Br	Bb [ڰQfWLtZgf&g;tKVr38g&GȻ sP0ar$
 !O   2f_YPKtg&G"jr Q|Ktt@	
 ?  VȾ: 8t"8tr1^SQ^Y[3t,&
u*Ӣ>ut
$sE t>g u"Nþ"t$	&
bsD
t E1	>} 2
T@$t yIP!'u/btC P  @$	< t7 &$  
` uִґ>ý ؀
	 1>t JM0ü0q
/u,g *r$@, t׀>1u
 rdq `(]r"/|t >Mp2֐]SQPXOt}V
r@.SGHtB03T0p.r3//6Ht_6tP rB36su% м "6H6 RE6A$ptzu RcaШtbF;sW;sQaQ@_Ju "A
Qё"
23Q$. 6 à6ۢ
.t HELw+ H.A*QP6t9XSfW1`
KGtD_8؊f_[EbfÀsg]?  r4ށÃ-# fPRPS0ff%|h f
 1 fȺ}4Af# uOf3\f   t(,#%9tf!! 1 f0 t0f.fFf`fo[fYZOo! 	oo}ݓݩ 8FCPfW @ fg& u8  *t fP
	_5ff f' ø  <Zuw`?FrF `/<%E@P hdFt 2Q b f
`tb@Q 4fpa̠$
g
0
ú:d[t.f@
# NƇQ{  D_ 1úd udO!	/Of|@ @D "b0@U @g&!f@ ? % K &!"ېE`R&$0'*1"}RG,f#f%L*ރ8c0#B' # 
 f 3Q'
f~墋Z$S	)} P''p
f1fޠ
s!<qfXfĳ& A$#?3ҋS؁@á]SBVq#t6D7 $f&ȿ ff\t33u^Zfp
iR3һX3t@s6ro I
&` ' h?%Zf! 
 ) 4`)Zԕ$AT/	f%10NIiC!kۊC&$ P1S؃20ATppRfZ`غ   nBnnntnJFn aS [ À 3ێ7!C &?!Cu3ۏR .Zh$fP u	fXc  h fqJֲԭ!XŲE[踲H%&JJ6蔭䱊>&o.pu	 luQ %FP
 ^tPFt +t8QWP3 P炍hX@.X=X@uX_Y߰Pďup$ q!.D$> u
PH@Xu6C @B T ASQgfrg tHeu.g :f`sg&ffw(1(`2ffߋgffGf<R<(.&gfBfsDP
h3!!
#4	fRc6U t q

(
uX-O0fMSQHBf   t t@GVp Up qhIk,yRÃHt%tg&g!gg@f`MrRft9߃tg>E @P9g5CggfxVf),g>E %g> !Pq'^d`g
^
".   bOf᠝ "Q1` 1Ya,.028 <q '+xj & 
&o֐"3+H~v ͽS7,K_T|`Ⱥ -  q&aiu x  
~| j1 Ь;taR~0m 躨mPff}X@ff݁oaఃs_Qs  S ` 
a!ǒR濖滈湿 33#of<?f
 
w@f }ć%\h!{{܁# 'py@    r#᪳rSaɋf ?Cth!CKdrQa!% = u5
== uu=  `0+!g0f33fCb 9~8P3<HaA+ r߂޺P񠺭 Q   ,A048 N`?˸8#᪀5 A cP`?! 2'h%!fo 3 Pހ_f4f!@Y  Bt[7fop2 q7:t2 t,^fP _"DADiAR'1㧅'1'Y0 Z7   2iPQ (tu
YXPp͡` ؠu 
X `K؎Rf¿쨀u Zlfap.Jnh P@(00	{0Ef1 p D0  &Et"D  $D( s `&tʀ  4>2@"߃Q
g&t
 0HL &}u?p ?u8&= r1	&
I$Br P
` 肐 m  m Gm p-'s 0 _ ar * $oOQa	 & aQ# $$<?@t"hXO=T?KuKP Kuף`.>g"st&3r	&*Qr>Ģڢ­迭^aô`prr X ? trʗCr0}qw1#!8Q909$Vϳa0){fRQS۱[YfZt'1{1( u
| @˲ar0QP
ADȁmG}>Pv Pf  hruf>Crf2  jf jr<fffHff#f+ִ f;w_fс3oS ec
uff+f뺀
ن -/ -ntϽ!'@~ Y	V:-CK-y
	-Ŀ-"7cW%o]m|ď-]-
 	-'-&-ݯ,͗DG	Űqɶ*f. x+!u<u<ww2.е;f&@ Sذs9r9'[fSfm;x_V4tw? u_A&[ff[v8ø_ o8'`_Ah...6
2l" *]2r'fدh]ls"q#8`+.7hr0ЦA@fP@`.c'6fAqFm}drY
>h!z<sGcohQ;IKydpD@ h
sx W`"D H.wȧt._fYPVp&TiqYf^@jR5_'clRQ,蘵lzڏsqF4B+ràq"Py76` À>tp"6u%h[tuCr>> u,5 t
p ph5@uCc
 !3@p_} ; W`g meP` VXSpOp B                                                              z-O4Q Drd             p                                                                    &F  x  R    
 MBA U<2<     d$ $PnPM@ X  Hewlett-Packard Company HP Base de PXE-2.1 v1.0.0 
Copyright (C) 2000,P 4 Development, L.P}.=1997- Intelprporation

$$BC$  \ @:L_ 
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 thP~SwQpRibWZT1
-AX- -BQ C DR S@ES-:-DIS SP- #Ph/)tX
Waiting... 93 D
  tL_A%  hX p t `SfQfRfVv&  &\f?UNDIt?h o
3EC4:  ROM ID structure was not found. Gs<hh/ '5is invaliPPj Sj < uf. fGf;sfA f    `Ef
@ &6 +&p fRSfP& fA%3ffJtuہ 3fX[fZNp' ߋW.;	s.
`6&PԋfP WfUj j f2 R0	RVQ캐	&v &D6E     
 
 Ff 0ЉVuH6U9Whw
˃f6U_fV  
Z cA
7 tl tcc tZ  tQ  tHhZRjh'%09 !nexpected!loader error.  Status ==  Pt)20: BIOS extend memory c^^3,6޴'drivimag{'.8: !0c_.S.*c1fsegabp
pgNVq+.> >u=h2!a! ݕ%93C44f)J4Nf04^f.P sLhP  roo  AyH" N'rv&D &L. &;D&s&D&Q- @T] Bq.HPeJR&DBVB&(Dv
VAE=A	66ޖ6Wj 1\0
0 uvv| t  uj@GH FF  R{Xt&t1u1f
G HF+F)F[?fSVW |1N  6,
Tۑ IfoT     f`_^f[PA^@@f]f_f[fXw? t8sVTUgf1 PUUJt u] VYY1i< f^fZffX`t ]˜= t.. ﾭ!. s	N]&}t	q t+{f&} us . 9wf&+f&;Esp UfXRw%=  o
 s@8r &f.+QA)ufwDA	f]r.>@u	 . 	P`Pn.( #%.P<Xt/`Press <Esc> to abort?in`sz¦aB~RfW ߀>  $u> PuMu	>p GufpZß 	AxS}@xf>f . ._ .P 2`<t8hnE^WOpѰKrequi
 DDIMO supSf0'  ˂)B	.<0gfh fRjfj0w~fЃhQplrzfu0h|%{
I# PMM func2
numbec` u)hgE allocufP~pfprgfgfff_-.Jah   .tf.>J r$/t      blksize tb   AU ~z { (  ' "& H% `$ # " !   *2 6; H< d6 3 5 8 9 Q R 2S r` b c d e f Hg th i : ? a y w <v bt x j; ( |  LIENT MAC ADDR:A  #x     GUID: DHCPPXECli:Arc;h:@00:A i0# IP PSKePROXY3@
GATEWA ?MD  BD` 
Auto-s{el:
  BOOT SEORVER)     -->  MT7FTPTT ! A1Hed@roxyservice d 51replyJ?est  @> 4011g.  ul.25e acer Miss0 T addqQ BIS bad `checksum "get signnform<failfreeboobj authortW flagA	shutdow
[/Ocred '0] R/
integritPcNetworkc
cancp%d by key0ok0@ARP timeout^copen+EQo - F@ NAcchViolrg Srece:dPom ##ounknop!c$re*		connp!RB NoS7p6)offers we	' @ f#nam %eRAPI}e 5u{ICPr multicastdwh~0th /)PHY+figur3lDataL+@)aW8EEPM<7i
sett<a,rrup(too many packsdF ; Media tAE7,D8cable NBPabi o=7basE> BCQ>4FdiscopDsFlim6H-u and/)mpH CPFO&%s`Q,QnE6jbn-mq.Ppܟ  /-\r]

SM/DMIŏe Hd_UJs_u	 Db
Ⴝ 
`~ uː  u^& >.3 u3].3h[t0F-  r- vHHt
- r 뾐9: LP3   fv?FF)~! o'ҽ ȣ  -u
hx9P_[FCt[놂[侃mocA{벣=#?	3=1 tw5= }.f   @ / $=q)w-2 tHt-= 7-sHHP !339  >9 t Lff9f2 hQ99@t{Itq ^h߀
KShRF` Rߋ^	SF9*9Fr䡸9M Jp>2#YQ"1pJMI>I t0 tEVOhuRp"
FP)9Fu9R 9뮐3>'uۀ> (t_IZI!
. 
ta@0`9^0 o  V@/Z0.+ҊԊ*A FVF	+$FVu3^>гt3y(3*3(h2vڸ Eճ/5	(36f(3 fpsEy N_T3Q44h96:6@ 636H3 |3}7tְE}<2u}% 0ҀĀ FVfFNHFf9+	`v6 FV֢u>P>fw6(bK
:	@" 9;V:WF@V^fGPVr$=NVu^F^G(P	WXD^Ľ  G-- v%0&iGN ^& u*&oGO=p u6`&&G Go#&r&`O0 	!M ""`'u7'G P99uGF9@Gf9  fP2 UH@&#P6US*&	Q&(G G0FF`FF9G6@NfNfQhA TUU T^*&O;~S*P
u3s  S3#G$PpTcP(G	\1'G!E~I<<hwV;?.3%lB  t&} }??XWEdְSV RPV`T 
 C3& _2),Ph!o&G2?E3:Yw			7pfL(s,  8-tHHu9N5COBv-*}OO$+CDA20 GP)a b   Q  u  P  H2cV";{G& 4@ P`_

6C/*WE S3Wn*Ј@1CiuQX(PB@	=3 =2 }Nc|wE-6 t`/KiuhBB 7Gf30QG.o'	
Cp'P3Bm"ol~N~ t	I01DRfQ [:×3URF);v; 			[
wR`
 HG0**c&W6p![ ȝ0XFP 1Y+`ppp q`q$IfjF G$*F $ t
{! FFFt|#f^ÐBaOfV_4`?F$ 5dg2
kH2
0F28
1
H~f"fF"B
%a "2
 7,vTE&$U
81_G~fBo'F蠨{EPfL +;Vr
w;FvF@F3!h3E^0L@Q"dP򻐘p (Fb +ﾭaޠ+)(G)ల1EN)z) t)ZD)`WuC` WV2! Nt2^_2&spO( 	HP⸀22ߎfftrHuVHu0Hu "RPKp0A~ /V\Ht1DEfSRPV tDt@u2^[+v
rD7D0Nw&N0pQfx0F`4 ht3 @t3R3u3Ңv
 Lf2fx{3DM|pg!cSc>vtQG}Htp-`IPtJ-
 tE~3 Rn@ 5F FR1qptc\|@Ȑ@f3뷀o~+u!S2T" p7Fv&#	$		$

$
$$

$+6$<C$$$$F*FN`^ 9

  R 2 -
 t4qFu{>p4p h"~CG			th&eCժ	Dh.VCf>	 kt.a Fp&I1u(as$]HJ &^lQ_@	&`aL h6pVHҋǺ
 _ /da{Fq urt= ,1R#F&3GF>t'h*;FFb5-0wf% wIZ3M._3:F!^33%&PF639F|׃>> B.?%Af FzgQfG8]8!Kбh: C$S-h:L[GPV3 Qa BFjƒCG<Dp  o@*DNH;븎Li	T֎X\
`Nh܏#_haquRcd=X)= wA.JNl=Yk-`[& \5Q D- t-;\^-o t@9vOa0j`c=4P`C0Htz0N` - b ϐFBSB6GAr pdϋÌ!q&W#qFx;pA&ntiGW	$$q	r"iG$BhX	 F{*c 鮠lhW
pnS
qM$~j`j,hN,5,TCs#,&_* |&_~-5z{{-#	 t- t:-P@| t $ u&?  u
cr! q?tS&9Guf& u   t؍GY
*aASWPB!DvvvB07Vj
 &fXfYffff9H9 ):ߠ :FQjPP+0hBix ؀JBRP0T
ix &n F>#Dep0<Y F=zӂPq7!u~ t	F$3 SlDpXf32W'Ȏ  ǆr DP˯78 8S9*Ӳȍӆt0@ t^`uf~ҁ9Glup"pu$F%:Aqee&`afP
h`21dQh&O#6
7# 7#O8@mu)̋- Dt-gkuB%Pt)@ upuh)5'9@D04Wг}Pi,)oP-)蓥
p&&^cy
BFP`0z0&C~o%*`0priv1t u-FF9F"3u3x 鰝pS
Rv35er ɲ,u"`1}O.iv; F
t۶0o=>P-"RhQ,"-o

uۡ	@v)&j&hy4B{sX5tۢdtxuH1É> zH"lT=1AiFU7PX"=% pXAD` 2	 9t2Pgc
4 cׄ_*\p^fp0)!HtHti @
 T4H
p&6
-wo4F@Ch92 <g c{;, ַ4t	"]
3ޗ9!

t3iF$ pah\04`!1$$3 #;qpqQ&$ ; c207:
?2!5
90ndu>L2;~ t3]j{搅S:9&Y` }AUF9@ّ3dwtq  u
!NC D ~ 7rq r`0ނlFP^ V Cu~3+賓*v^F*"  SRPW^Qu/n 0a0R޿P "8kt@1au`u\p1V:O780qϣiv"ĘT41 F~9G9O#N; ~ taWRVPV9
P'P`XG&W9FVЭAVcsq#9 u9@u3t[~o tH׋Fa-Rovi~`؎Fp*@>PSS;\u>St
FR`_s	.!P` z`V6hb5@tްn' 2f1f>&fp9f9thx0Eh`ΰ*9 t@3f 1 +uh0 09P!0rh0^`2
b2 f|
fPȡp`:޳1h:U76ubQ^ 6dF 51Ċ 9F~A !@ux z k ^
 L  ?  @}/^ۋ  F_PСz0egQ&>pSp8Q @
uTRRS pF9v~!uU- `u1BK+o t'uft1$epQyyy \tÐfv0p 5b#L`c qa4 t&Gt,!@ 8!t&lŀ (| u>bl t | ~G:lp u0UpxT%xTp 4r_t--Ű%`Ez *3BƉf&)f1FFtbQ~ t^uK{ 륀99 t
^Mw4:pݸ #^4:FFu	63PaX`Py	* 4*6 FuH^SzHq u9,3ܒ	24  %4 ؄ tw^Q`u

43	VVxC `= = > w$1,~̋V; -z^qδك#tOQf/6 2K1@찥)da&ğɤa)@L"A!1!P8PR&7P?3  
pI3T f+@F^h
&FpS^qecNF#	9FsA^b	&9u "#^	 !ru$1:GR&GPtP@PQ@tp1w 'q@;EP [tutЀ@6~ tz>_T9P/h߬"*Z`	*#$(pK@|0z&+F`](R0>`ci 
s	
hfp +	裊)		 	/	&4			cu^ABsI.h&yVL)~vf&0a`_f`~^NvVFn
foa
@P~  hRP&$ RNh^V6  u/*	gA$d t^!U$tfX u	   $uy$T u
vay%C2     v? wr#@4
XpnXs$htfuwt&h=!	GXpZF΋	ХP6	pcXv&@* F"\;Fw7~d\ `n`t`1 tu\r0eKR
Nx!
\^%
R
"


 Gqx(e
R
dz'3`&8g 3&3;v
ސ&`Frb@s
hu8p@?Ht'|+h۽%)&Q[NEx|E#i3+Ǎ[%%!n%m%"c%*:`IsCrr 3%(H!up%郟 ǆ )fǆl @ Ɔh$2_& u ] $ 0O5&= Btw3-O-,u 1!?0h{I! t#( 
@b- [t- 
tQ אĞ&8t&׊ `	
uAp@)h8$ȁ
 v/$Ƞ $
̃ P%
h #3j*"gb #W9A	ؠ
@Rр#ơR
9FrF
0$*+P/ЇvЎf`f^z2hXfhp VV3QP
wPfh  pv)vp+- PY3 A$=.t = t -t ) [ tNfhs
V
'q

pc
g
U=KF{0=ikI'HS-	t-
-= K-w- 9t-
t- ,Mt- t>trV>Pu$ >T 9  r'9>
 tFu '^ U!^ fq q2/4RPV90
 (@(°N J63L3١FVxp(\ rt	tp	M ht3h9 29
 8 . L3"  6 jPP ff92uvfް u:9ou1Sʰ'';wҡ !  f9S&:Qt?F3u[Ju9L3 =2 2 
>J3`kE~F vN3('@'toHHt	HZ !"(~ u"hd@nhl3p , E%>} ۸; \&u< Ou	=  6 t4ft3DpuxPp
 I`p7N3 >r-m&+'Ht
X&pVtge94&- P9pQ~L~~? ?D#)>2 u@9 Pp:?h2 f$7"0-2Cur_ā? /ScjRY~O} dෝ< Q#@@=t9느p
Ff=E` vz`W  QM "Z?(3*3#v	v	 ְg}Kc    _	-C$а=v9s!vp29a|YL&v9P31$PQv9"> l
GpSM>4J{4Mp9$ GG$LQ?M?tfG[GGID:D/p
L
3LL9 3t\E6Ni2u@:ADE5? 9莠(뻁> K9ӽ"9]-U"Us>":Pea 3dfÐnP3t 1*䊇N otqu; wb ѐ:Аvv+{2@ fj
 fXfYffffF~"FwF`^)FX~@/9Fv	FF ;Fs"O=~#vPp Fg~s}@~f+f:P63
H3r~tR}P? tH9u}b  3O;F
z:Aj` mP`
  E03v9f"z0fPfF  FQ32 23-6@|p[~6v!HFP@2:R}Y9"
C<	vaRs
9}" *cOb__gPԯ @X)W) f:fаHj&ډN^+wFV;r
w;vQ:k@+oF @H$ z3
`6@3s pq(~6F:7`6t 843[`Ff(3f@ 9F-/	
L
0ޠPdFu\

=t)233a.UVVvpx$=  t)ArZw <Ar<Zw FC:t^T j  " lVf*Nʿ-008 t` 0r 9v҃ F   WVA?P0bNq؋B λ RV3^_V ȱ@'}=@S~u!tF70T QNV
 FXơD@
P"{
 ވv3 vmaufpocteF t  q9[EuEc>f4av3d.ҕ%! c~ t?(r4@3^
0A 	z r"hBo8 V3 ,V3X3LY)Z3@03\3`3pa3br䠯`qpȣl38n3p`aͣ9Хݾ99p3m999!ʰ9Zv2r:qd3vh3  ZP	@^ X3
? b!ggu	W3 &?r"` wh83t{A۲ 1ŋ  >kuёaa_`{V` FV
22##b&w#2#62;ȿu5;u12`=1Sas%7`N
 Z3a]S$Sp"p-`f`m  3AfFo
a%RV =	b- PZFp ^ $ tF f+F;Fwwrp"NN+V  " 9'2 @3QЄFFf>6 tKa;8rBw;6v:> 'F
?+v6 68=P 
@Р@;P~t	F~drc $ú> uŲBup۞11;Fu$<uVt
f>  u M% Ht `&S¡69F8wN$ @~ t*f Ŧ^&G&tp&9&9WF %  Fb`;u9Fpum t p1~ @PҐK`K9qKèpKpK 99~ u-aL _=t10M]
 'P t7@F^(Pt#$
9FR
9F?W0YrI	 
dp7Ю	 >QuF9FnLn@ZF;F
 F09FO̕9<7!Rs][	"? 
rvqKS! VpIt11!0Q6T\k^9u9ukFP\="`ps
 uhh? 3`!χh9qx Ʒ9090ؾ
9h9
 fPSS3&R39vp9P?9wwG@,P9@G
PX`b`F :
"qmkFC	xQB#sQZC


cw
l9

󙐭	
@o!f= uΰEߺ 2"zpB ^`
=p*pT
uS
 ufS~9ku1A ۪8X00ܖr2@@!VcZX JҔz {a	 ^x@^q h:a@3Mp09ߴ9fh.:  t0\!=b m  `ol38FPj9&_A@ɫÐ`GKC͍Fu6~Ku+~Tu%ua :d~Bu~Pu
 q tްEԨ
oaaz   ǆ~ x~B F 
 FIMSQ @@  ;؋sY[qF +0Fآ ֣R0ԣң9[F
Hq b	V`ՍFFVv!6YFF~ iF@H  FFFċFF?FF`nF&uF FF@F`"?#Ђ_VF %%2FP%
L.|NXf* PWQRU}>@@ 0׿> j>*]A/ us>@ ul>L |is b w[>* L &D F +ѽ  ( B V6H ^;s#  ԡ( ]ZY_  ~W

_f`.
>9tJw.b
0 q.a
<a
0t9а r   fa.>N t&.~N! 9r & ӄt"Qf ~N u8Pwh3ظVO&.~N&G.N[i Y HYaKSQ3ۿËȋ$tFhfa_tbY[@f.~NI f.p	 PQRvo`q
˃ӈ`
  .N
X tZYXÿ."˂N
jV3 Ӌû^]
 PY  ǃt2W  _^]Q  2sYÀ>[
 u[
 lZ
XpA^P;PX
R5T
ωV
aSX
c  Pb> uV?+T
pVfT
!sPff/  2p+9Vw-r@w)
|ba댐>
 tZF p` hl* %`^ְ$9@+ ߷P m@NQhUn PV7$
F 8Ft)F ~ t/$$* ^t +PJ FyR1$Toh y?	-t-w,tyPWVݚVN ^ 4~&&Q#2#222##;u;u3Fsސ7f9 usD?99r;u;u?o^_­`VBХqզ;Ftiu09f	L24	96a9Pt4Zͱu%PPR" fSfQfR?fP< f;sf;wf;or v s@fZfYf[]PSQ?rPPY[ PS? ["BpFt%&?	u
h*~tF
倐a!:wP'  Đw: .9'1:aqa*'I+@0>ɡMQ 
pq&Gf \DR 
4wC9*d !۔	$
d
ڤ{DAտu 2Ru	s2?2ZPRZXPRZXpaIP
 F N0C L2aG6`SvP^  F+2` @tHH  \^
 t\
fw`
`fq d
-	k d
 @h` td
37d
+
@_2f
9puc?f>`0i_4ߣ@ϡh
Pf`
fj
+j
l
f6j
2+[TQU0΋d
o)`뫁R U%pUPɟÃ> j
^ 0]uݡmV+ɉNFu3P\^f&@gp wsWI &O
N@PU`FF&9wvhV a9GtS
=uVdoY@vthn
V	n
 ܊q܂ rrÌ ơOVfWOˋfV0 +N uf3lf30fƉFfFfF /ߍlV?Vv ^`˿^~320Uf_f^] d2Z
OfCORPfEDOMfp!ǰW'fufuf=23AIt
f=46AI`(uР[ ^_p< htFqKV1Ypm`ыV
lFtSYnF&U C@P*C#~ ~NB.`xDN0׋Vw"WV~yÇWVRft x.F&%G<ar<zw, arzw :wr 8 SpwGhGWwGg
oF GFGWFGOG2Cuԉ[3#[[2ҹ G;twGg
 ogwww_ߒ^FV m*&'*@?û@ &l &n f%"Pf ##f#f#f#f#f#f#fXS & [ÌWVS3йp}G@9ڃVp 
VN03tQ||8 pV0ށKu~f
 r;Vwr;FvN3ҖOu؃ [^_N
Ȑuu	!Swf
Ӣށ$0@<9vFMSW ۋSR3.:uJGuZRƀt%@}uP{09t
 tPCr< u	ZXCu33_[΀^_SM_^v_DMI_0 ^a$PnPB@^M_SYSID_BPx ʡ1 tc'dD03NtaA tn䞊аȑ /+tۂ6                                                        
 UNDIU\(O    @ ` d$ UNDI  L  NhPCIR$I  E      ?\ v #$PnP ]u_ 	!
HP Ethernet Boot Agent v7.6.3 Copyright (C) 2000,P 4 Hewlett-Packard DevelopmCompany, L.P.N1997- Intelrporation 	All s reserved.
 p
 PXE-2.1
Remote Program LoaderMBA 3Sl
0 
 Ps Ctrl-S to E	rnfigu
 Menu ..1	 @  
t2ôu3 Uf`F  fa] j j
j
PS^< t	2PC[X] $0<9vPPr ѧFPa &fPffsP f~j:6DݫHSQ
^f^NgfCYf[2]
 UfV0 +N uf3lf3ffFfFfF / FlVVv ^`^~]0Uf^]2 t`+3h68+ VP@ ء .;u
Xt2X.6>| . ^SQW  0_Y[QSH .> t" u.uX
 S2.ur*= eu 4= f   @g@0  .9u
>l :@ tIu[Y@ @@ uB    1*WSR..>f&=1Eu#&uFPj`hf 
˃ u  S3=_Su}M_u22]rP-[Cu[V[}#|OfSf]S_fS#= t#It2E uqGG1G؀}|E$t2Z[_] 0-Ѐ&h  fPh 轋p @ }&eKq7f)jc \USQfRWVsf.> t.@   ځ>  Uts r r h,PH IX%
OEC1: Base-code ROM ID structure was np\found.   r덊  t	}Sfj j ?@Fl>  t;sf@BC$uErPj W_ێÅ}0 b# ʀ
  .6 %6Q   j Ph &
 %Z@%t'h?R?C5X
BC_3_() ==  Tr!hjcM0F: Exiting odfP6 X^_fZY["
fXHX=eKt, q ./ fТ 0 S&[t ~f
E&6 +&p fRSfP& f!Q3ffJtuہ 3fX[fZ,n.0	J6&ԋ]SfWfUj j |@RV`M&@.6E. ..ā.
l:v(VV9E6UYW0f6UfKV  !@Fi	 t	 t Ȱ6
4WPO3203IOS extended m ry cp error66:Cdriv@image is invali5%98: !$o8b8;seg9:эNVa+%GF uXG u
h
_If "` p)ӎF.3½ F 5]I3ICOII=f^f sDh* P35  AH@dsrvf&D~F&D@B B! H`PeJR&DPVS&(DvAE=@	O6O6C6Wj 
&_\P
/f f3fp  WhX6 u96} t2 L ` N b 6EF` 6]
076u7]fS˶ Rfc	fXf?Z  Yju
 [$8v uj@OH F F RvXmtauPtfҲG HF +F )F[fSVWFU  6Qˌ0(!(QfT`k   f`_^f[^if]f_f[a!8s]T\f   !%P\\Jt u ]K``T%f1pfP> = t.. ﾭq.s	!N]&}t	q t+{f&} us.z9wf&+f&;Eysp `_fXRw/=  
 s@8r&_f.+QA@4ufAaf]e3;_` Y  fPb tofXÔMtqs @^p.G3. G3 O0 Ra_Q Qc Qp0 	 aTTR!U'Up郑H. 16%_%IOs}
  ]'uTNtTs
P²	ݾ&<jt.;60 r RMXrإM*< u wG&DA 0S  &L\pS&S SU"]GT(T*!T0PV8UV2V:41QWXzUqUQrt VV,rUYo˲G:*.
 T
 b	$Z1	R$?Ƹ f[]s,pfZp*>t 0fX;/
UWQ߳hf5f8PfU` f@_f4H_ܰ.ӢQba	7d	/fpbfu`ff# H9dC fr
"I!fp8Iuq.	ItffHqu'fM Բ趢0ff  .405 .0bǕ Qf@! fP^n$Y#0`jɰp| `0	q" #t m  4 #1 c!fZQK4т$] S roR[)'R!#xQP
A$f`( $f`1 3WP)1%+6f_ [p,V swfH{Evq.rau vm-zȆQf 	 f'Q ufd7fIu"<uf1f$
2@ W&w c,u2VO R<4f<6$&tf<1>fSx/fP   2$|{ 4!D }I#8Ӵ V`CA$-$-PzRq(¯--#'!I J%u=Fd!/P)"$"CUfIt~7^QBu4ST  fPp  @ PT[T[d 6 <u-ft  qf,~@ `" TSr[U$Du]]X t@ M `ۊl 	:p u{c2 fX@#+ `R!f
0`f_ffZSPsfXSQȡ8tY93 >!gu!g if;st20r0q4PH X3. .P #.a.@P`	Pfj pu.(? SXf%D3pAVp%p']ѴHP Ethernet Bo@Ag v7.6.3
Cright (C) 2000,P 4 Hewlett-Packard Develop Company, L.P.
All 2s reserve MBAnfiguration _Menu p  <Esc> Ctrl-F6 Left/RQ	4<Up/Down&F4> QuitABlink LEDs"Change Value3$FieldRSave Thpop2
n0selectable  `eDi}s   En  K       i Protocol  ebExecuEnviron(p)~Remoteqgram Load (RPL) b#strap (BOOTPx 5[S&  r(S"Type  Auto &t BSI*18h 9 jx@  Hide Setumpt akU*e whe2:1!displayed during ROM initializ-   %@ 7s;`Keyok`r.S$/B  kذps in-v` t)c4@8_u  @BannMessap/Timeout  q1  /  2  2  3 45y6I78910 5 7	7
7  NonT;  &3@MZgt4'>    LASpeed&Neg.10Mbps oHalf	FuM( +;K[k+{%8 1 `1i:-;Wa@?On LAN)1\\955oȜyCoпffbf5 0OuIsu@QWqRf0˱ ԁ{# u.P_ElW]@>] u
fUPf]WT ` dq{	 A<f0fu` E,=
u=nu A%C  t 4B 11fH
E2`u
$_WSQ1VfEPE`!%> tPpPfs0	BPݸaC`	 
>u
>vp}fEP
 `{?u0aǿfA]qY[_^q3KtRMtpPtHt.ct>  ~ =C} Cs }h 륃} t=} u7} uEEHEE 22@;Ev3& b.;#@uUCNRVUm^P	X^um
>nP]^ZQP>=; uXYWQUQR=m׈uUZ]Y_PRR ZXQR	 ZR {     [ ZYQR 2f4RvO ͞xS2_SQ  Y[P< <FX
PSQU  >_]Y[XUP3>F 
tEA@]PQS >[  &\ Y[YXø ΂ RU  
uP	]Z(*q3ɺO 	f`C  `!`:m" 1. PbL7RZRZP0D>\[3faaSfQ ۻL?_SM_ts OvQj S ݀A  ЀwrgrafGSWOpQ踠T Yuf= MwPXX,g8 tIt#gfXg f@fg@tgeAf&=$PnPuW32&C&:]u
uB }
 t7j &uSj`&]
[<e3tXCRfW ߀>u> PuMu	>p GufAm o !< uf>pf  [Q1f1q t;h&Y
p-E07:  PCI BIOS callTuppor}t.	uL.;_D u3 tnh&:}U1: Un60ice! h'ۊPA^	4: Error`adqQ
space. f3ffS]m
T^nvwXY|}~DEFGHBus =x`ƃ	 FuncAQW \'_Ya.s =f f :rf)Q 0h'ځPFh'$P1P'PfXp3S.i 0s`6Ur5fqep.>tB@6[j  wPаXu
U |U.pP  >.VfTSAFu u
.~.>` t'h p    hرFfR. .P 2 <t@hl)PH 
XK.6: OsrequirDDIM.. 7  f M  f8H jfjf.9fPj -)fQ˃Qu0h*&؀b=x
Inv00MM f&number`- u&/h8*6E@;@:oce!2. f Df	pRfrgfgf *f_?f.> gك0t=t	 t` b 3fd f.׮ d f   $ Ph  P^.(%tfP& r. 靝UU *
 V4 33 x ZZ j͠Z >. 
Z  PA     ` , ?  ( `Ē

D  < @7!+<g&A'< $o 4D $ $
 $!8k@    '}  <  h`hb B4  @cP$ <"x   c4 Q@
!<" B0 $ CCBwD   P 4Db8DcDdA@# K$		B@ U<Uc4  @ U<U< 
 CP  G!  	 !(  hcCB $* @A@P A
@
 +Cp@<AwP
 @DDcD $ DH B00 B$ B,@<@$%  8\d01\ @!Pׁq  c
BB0A
Eq$!(A<=@#!0  #%I#P/I#/0B4 0 !@(7݄ < #@ # ` c$P\!H@#A-  a@@`$#A!@A7Fc@ ! !H@:pD )@ )%MhdE D E F@(G; J# K&#Du 9,8(  9   {A 5/B @ (:<"1ks)@>@ 
@8 b 8<1& 2&@ < s6D hp 2 2h@BN $zBFE "	hK  C@P   "$ 
 B,-H<  @htJ'UFBے%D2A1@BPC$

 3 ᢁCP; ƐO +;N@Ts(Pt2Q0E<BLA@L w< @   R$E y	,SA8@0I6  GB4ݔAc4[b@=< c 2\ W]@WV -[< h G]  #<  H!(` #X# \@P@[b$B,'!$ TN](0ew o b?, c,% NA$+ a  ^0@_ _E-b$O, d$"/ h, g \@g DMc@)Ah"\$b0B  B$@`  C, qp^ot:! q!a Bp51\q qbd &A^	0@1 7r W B0
6`DZc@& lw @k]	Z tAw܀p<E lw܀vBbAl/ 
mnn8loC	<nGP nAn| -wBCLb&*l$C$  LeP
Ldooc- b@zo8L6c Iqt00$]]\ lXb CCEwvv^z) *4@*\d'
Z@)B .@1  3G  	a= b$]  B a@B@b!Aq! @0Ac & D "T @'4@ A)C|4 A C@ B RbG4	s K0@A? 4	n 4@ # &K
@n 6N"F   %b  D $,@(Iн !Nc(c}$E  b@dB|]b4 ]d'$(mE@ <%   } 22T<b8<c!(<<bA ]P$}  7  !cAA
8ĺ0 !  4 !AA8 !  <, ^ T_8δL8@p} aB00P1<$@̈́q4AddF+ nqDC`BA|p
D@ E $cg .B,#q$ߠ @bB8<BR6 <@sؠ g g! `e 2 <B4%@ԁ<ppq 42qd԰eA!0 8< 4Kr@s !0ׅ* 	  E
E  wg3
q0
(A8H{
{ 
A Bc4@rE
@ Nw*Դu 1&!  `E

 @2FB05MG $ÃIJN '  %<   Df@(Aǰ8B4(з	@r$  .Cq43/*w5Ef 3  U ;@< = ;@ @APL@>H D @ < 8@( =A7<.A	@H@?E?3)E$@ P'2 <<$@^s64р  9q-16A%5C	kh` sC:A&S:,Ad `BC  RA0E,B .@TȄmR K<A
 S(ACUODVR@ACFd$q@"2@A:i.A&Y"2Ai@,C"2o 0A! 4A@W Q$[! @%@%@%@%@%@%*X  wD R#S!Ag]AAHBCp!?` !l̿ `B@cz@Sʀc@[!pQOq_ @    
 @   b0 ] b"Â3@ A% B
 ) @E  PE
	 

  .A  Õ@ b,N Vx !" P"9@2 < čE;@ ̀0
@@yځ@$   Í H1 @B"FF(@# q_B, WA 
<J5 
$?$$@A%@ 	$8 A @c0%8 $H   H"$$0&sl%0$$(ż"0%(^$   k BAAA
 Ǫ@ ɀ   @í $JcJ5A
 ÑA$π![!% '4@&D:(  +C. 	D? $d @dA+	JedBč@ H< ̍@J5	)5 54 4
5@4
#A. ˕$`Bc0 %~ $PC@AÍ%PB$HIā4pH#$@( 0% %@#C 8o $05č3BC%0? $h   `%h@xY0 y#:#BA(@#;2ހ  8˥"##A.n# @;ŭA&  $/ c49A7"@",FA7<ABA
B@CA@]j. AC6A	A @A@O-
@T	FIBD'
$HBLn@K<N(53ADd_wfv_vr31.1  0.rDwfreviEatafrrElEebifknLr!rdwfinIvIa_whgotuE @ 8 t@  A  @  D  HT@@   ܄ I  _ DIX+802.3 Media test failure, check cable 
CLIENT MAC ADDR:ownlo{ad"ed

`Searching for RPL Server ...  AbortBCM570X FounERVER NODE

Transferrd fromrsxne Control to program @  :   /-\|` ! tttttWS ˌt&  ˍ  !!PXEXspwNC h  NV+,/E@ ~i'fUfSfQfRfWfVfPF= twM. ~
f&lێӼu WPD
 fXf^f_fZfYf[f].>  u
 p`  fv
Phr.6߸ j @fUf		g]g}
owcr^c
f&h؎p
fU
S
m
f]
f0͝1&u	f]f܃>d tj  Sf. ff`f3 A. 3h f&ۋ  f&d W[]@j 9h uf. fh @   V@ g&5P+g& ;^R t0+?>S_\[$0	eP
fX&
=PVu NVf.  ,f ]# 0$ . . SR[.9,u r   Z[aVSv"q GfD[^]f`p1 > t;_`u .D%tÊа Wfa1  t-. .>t!  r nӄt"Qf4֠48Pwh3Ɏظ&.@&G. [i Y3YÜSQ3ێË /#tFh'09wtY[*P# 7H.p	3PQRv`q
˃ӈ`
Bop
X tZYXï"o
ZSKJTp'S>+ 73y\uVV6r6pFS^N[SR3t^nN[tu VS3	3^ f~ `H   u^& UꐋFRyFa aH@C}{#;cy뽚9됣C{q gC]S{I#?K5c+!= tw#=
 w@.= tw#- dHiQ n s xFi+= t_w-v{-Ht-0@!~@ˁ>_G t hD2^^&GSGp TG DUq W YQ[
]GD	Ar CK_Guf3 c 	B	GFd	p^FG 2
[uβr áGK T>Fu
@B C >MG"	}B
P49 4i_Gp>FDw%@ F;Ph@`P l]FR&9Gw~^9q Zc#t!a%F*r@FDf+fF!GwNR  ba7&


\FF

^
FVw0"0(!E  V*D^uRptu?L(
FVFtB
;Fu;Vt P
u9 ^q+ICF Î 	~ R u	PPX	FAF~'}*
f+fP <o	q%o Ltfo
fjr{	RuQPFB\!$@OfNG F^FP6pᄕ  t.zN

~}-^v&(F&>|xb0 6=*=HtH|pH~I	 /PZ FF^	ftvQpZ Fb eFQ#v:f&p &@
bZ
p@
 뻐p1GfGFG0G2 4G6u<tfG"fG8a*,' G
aAF!A33#%2L'>>>>>~Y>>SEYVS0r.F7v ވ燂F`]|D
f
CAGAEGADA[4=]	]u
4I:YpXq%& R JAdGST ,xK@BFg
@ޥաE.ej 0qGf 
ff dhhDhϙ|VTR{vPxcaPh`7hc5u$_&G	v 
v`RSlaG  ˪
ͤ4pȕnl
 UGF  5`Vfĵ3] #"ܠ^^F2tZkT!F[`L`9`FV``;F`f``RZ- ~  FЊHt- rP `*DVc迃5
t2[ p=	 T_uf#Ff0f{rcG$0wfPhsP<0'1k>Lt
"<o 0m>Gtps& 3a _Pb
n&ڠ70+G 8h  |h^\vRa
*&oFD; Aju+0ku$ku#z") .F F1A1Ԅ09?a&Str1 $- t- ts}Ts^C
u!tIP b`  /F!)nFǁ{9F~}teQ|DF:Q6%@_5%Fd2< 6`9Gu9Wt zB)`V2D)G) I):@)@)u9t!qUE0ufh-fjb01C,,9ۣ+Ë@ku2`GPSV/PNn9u2PtQv@2pV0G"eP4kÐ^On@RPx4蘳4J~4 Pu4eLRP u @Q  |8y8j/*%o8/f8wc6 8W M FVw%wPE  SVP^fh4pFfj1i45C 	G؉FG5m^ d@C. G_ 12HO
 
#=]GfF+K1Ըf~ tlCA$!% 2Fo6ˉV0؉pop $0oƎ+P=2f~
t2 t(CMtntރ~t
#mu
 Ƈ7 0* ,p=(u u,p
<IG
P鈇	}!∇`{#6ɱ
ˆ
!ƇnI&q u@Ft
nAptq qt{ǰ  Ǉ-gذƇm 5
a. o{~umb|Efj 3p50"z+poY5`% p37STa6Ƈ'qTveKFAX9P%0 +- tQ #ƀ8
z0   
- t.40۱ -o tQ pS @f@r3 o@) z*t.$q8@"Q

먃u:	2tPD/ t
@+P!
׿*ppt- 	T#quL34N?fp3lNBj@{rTZ3b!O t!$"vQر<s ]ݑ=`" #>Ǉ  dK fch j3lnp r3z'x~@(|(C)tv0)r55$߰ PV(FV ~VY裀܉VދFVK*1KFFߞa䈇c ۣL܋VފĊVS܈~ U c`Us}p~ B`*ui ذ_ 0sc+ҊԊ*5kX90>@"% S*P[		0*0PB0 !Nǐc 4#ƫ6O  $-@ `B=0 t_D&<?w7-C"0 : ` E>b (sc&@a])Fa@;@ lzpt`@@87Z})<w0Bu:t~t~ux2\/ unp	ugƇ/]   EIj@/@7 `#- ߄-p -t~ tF	ୃtrd pu{j h aQ3ooy(@'1P%zA  {$(mT$kQ#/@/ff+o0NCHHtEAr*Ǉ@B \o,D#&O*0Is uSH@TݔrR`"rv@#M12#+׸ 0(^t $ Îq  
R@pr p  5+0 WpU삦G@"uG@A|   $|^+W	pWF!~!" +\0!GƇc Z `@q!	9@_v(kDG ^G`}'ǐfvR980PGv)I!G
re c,?')pñgp`PP8@QRS*~bQ/A+`0? tDaK%VQRUF!D Urd$ "%p3)Au	ǇT + V@.r߷T 0$/1FpPsPVĽݠ ` 	 | e /h!rd%+d40d8 )p`cXv}@A utX?v&>X H@vZ@vUבupb\lٱ  u#HV 1b4 $fj@D萠   @`u@|4]r
8h12#08˸O۸ @   W ,3 0]&@ @t""P$swT `2i0\X@`\H*͢ hPqNfP,证a,Ǉs4+ 6+Yp K v / ճ `r P
4@gQЀHǇ-M
`zC2;𥄲HR	 9uE,02
V7t転 | B:.2:*䑘*튏   %~%vP8[_S<R  &dPE  ;@~k .  !@
pu
  d%</Ah%  lp0x| z$t(yAL8 o#w< 	a0	Wn4
Ip/Up/@P< @0D /$+0
 
/
10`Vp@24*T #QU$`akhfؐf	04U<#v&RP߯NP(R%>HW 
dj%a_L <HD">(: 080  @ @tBAp: @`!  C #<\Sgt\yPQd\\@նXX<fXh PA2'HtHtHtHt8^1 hRpC	Y`Ck
ؐ kssv80S8*RPPm+$;ȋ+p:yw;+ Hs;haIȊX02: 1ȩ:`EoPGW$z3#h8$3bcpTrH9l sh`vt2'S(jQ( 3c@J#  PSV7؋GF  P؃肿
H a~ F - FFF !eP
v %< fD3^ h
)Gp p"b`4w*^/f@`P@@0@P(F^@GWP~bhNA#`FF+9W rᨀO@@WrBV@%FV@+;Fu;V7FVox"ww _UF$$%-E
	
FJѾ:F Ma6a6YBt^qujn&Ҁ8l@ #6##!~ (  R(CfGZFtf  @BfFйNfkP!`5Q a&ЯuMvLp^ҋVKÉ>^@FX! ^ҁ; FVڊF$F$`Fހff  Nfffvށ 	B	RF 9߇9.v frpM~} SfjPSVs^^^_ѡ[̱^VWf~'  s2^uco.by">Aڰ 6@@w4F~skF|FlHP
>@w誐 ȰCRKQ:9Gu9Wt<`wN?@(P Gq@?B?cIUPS	~ =tQ C	
 qa'4As
^ʋGzW?|G~1T%PWFVf9_F9ʲt_IVFG̉V΍FаN%C$s1%FVPQv P6^0Rd0< t ʰEq0g- GGq _P>Gf G0x]s-t1wKF0SѠ
czC`GW򸄰JS!^q_M f#Ffpu"z07 2pCt©u; tq t
N%0a>	`0 `UtIFt)` tFtޠ 7 t}1p *W#"o Q9^Xt DC
QӣףO]\ 2459s{t
$ Fa"$f=P ` h jЉphA@j0/b߭h5Sh2 :3|Pyh uOlh r_u'u
hפKAp- t	-  ?hu
	(hh z h x	 3,YV=(u# uљ^抇72FF` N Fqбhr
F롐VpN! h`;A \  < P!<D@@1`1o 3`@a#!u- = w.4f4p4|4444As4!v3)qP L~ <uh T1"0e [Œj<߹tpuujPvҰ^t0u 8Q7p  hp"(]b"(p6
PB0d'F~ }r*(AF/tHaA= u tB3 F9F~%C. TfNv*~` N,`fjF `Yu/! tohcʚ;u%Q= w#7W6h  "   ܑ V@
Va @fh]~[
t	q^fjbbtHuTDP<`2?V] fP
@NrPqL`iϚ u3rHa#& )׋NQܴܶ 0|RPx`^	@4` ](  1C
h@t"+F~|a"fj @#r-fhTveK^PpV?ܰFP裰mК ,~}C=` uC7
Rj0
'  7 : @uQ  trx P^R۸(pZL044	  1Pl߰4 w ( 8fs@ P
E!#!@8 s=ut	Ya0-:p؁f;R股
d0i~N!"zt |Sڀ! UQTP0A0̸P8ڸ p #ڀ0%RM0?p _ 30 pPV8'Rwfc0$V΂p*1)
0(~d}v4@tݡ3u ba<!*ȋъĊn*ɋ؋VԊ*j P\/F= `"6?Fu.>Y{Zupt   P  F_r@tTrF*!{qACcH `d @r^&)fzP 
J&G V U @FV? >` }74 +؃g:ؐXĲmqosG
9u&9WuJr{ M5TfFwДF 1&FVl RP-	b
f~t  !w Px Ts[ZW:^,,-֔ tͿtUPSV` 7Fp	}+F%PjZ f}Ftfv ϸ`9F}v &1F1VҒb
@ahd`hN00u#j
rHpu,h{ 7<ذHȦyC2`oFᝑF@Np h  tvt7{
B~=fP MP@`0o&h@rMtR!ᢟ0Sh@ġGR	6 h -h o3 hp
hK=1h"AĒ2} bf} @ ^9 u $!g Q j5`h@5Sh F|`'0;w3jbvQ%ķ`	d	Ra}V|hڑH`"Pb
F`#pM:Q2t- 
?A⢤}T_BS `ZDB

,
u oh Sf70U5(d϶(%( $ӯ=uDT E G F:p-uG@ EHZ ǀU PߥM UuSET	U]
^`Um0n 
yR
ty tndtctXvtMtwtB$|t7}{t,~t!4tXta	Yu?2^۸fY!Вf% = pX@W5VU\!, pгtF` t@[ff3ff	ff±v~~@V*}Dfh `7oPiqvu`qoa,b	t}PrP#f P3y^_` "h  <Δ`A^諐
!$i@)it"g4u7vP2ZeI=7wa`
	Fu
ِ_UpqP`<h  !^hy*QOj
h#@- tQ fB8h1}hhe]	xhp	ky^p0tV@uP0a0OPAП~
})fc`YE@puΊFW$uYgV%=th1 0iz7 uy,$j z 2|zF ЎqGFG9GG@@
@+wr2q7/@{@,?GGcG NtGvYGqk@	3O @W0x? _Gyu.fGtpu@tg 0?6XpϧW`P`m	G@0@4I#+ҖsVt 2fGxPKf8됐^0ΉGtWvR(Gqr2}rt(*' r %fh>PhASƇf+f   pG \dfSh j#lnp rqvt!Ƈ](#2ր>Pޠ     ځ ҁCuH= w.JDJPJXJ`JhWJpJ 8ˠPq >`9W$rLw9G"vE&e-ip GfGP  i^ Uѱ#$WpH@7뤉V"' rOw90vG  [8GtVP&Y8lS"W$a|"
eP袦u@kA/F|P:aA+K F0`?b@EE?P?;Ft ؃~ {@  l &n má` of5@{^Qȸ {3@Bk9FvBG+F 3p7:fYy>ۡf6>-X J 9pfh!*|bb /P/P/P/P/P/P/P#P2䰓f
_fP 1| P Аff]a~WO@!f_] G#2C@@PQRN;ssZYX]1X	S[Pÿ[P<AZ pF| f^ fbqF_pfdAqhF$Wfj nqI\#{67@}!d^¸3= uuڰ_ R~ u,~}&f!9ƍF² y `%7V^AT& p 輴D蹴rGhG貴tG VuG?f}GVDE~	^B8З&F*]Aj`P at$hZG) hz[@ovވM 4ZMkF@rQ`Q
q ph?tfGqA>GvMGy sD
mgPh 3 Бhw(À>_u+0$Pj
 .}G?f~

YtG*HtHHt7K>yG}}S<yGu]
@{GwV@{GQ	ǅHCF!`~Zc	
u! 	2}X	G@WB'嗰'at^: (F&Mv@C|P? 
&*c	A(2i/Lv u	P>ZX¤+fP < Q֙$~'|X6RA²uQP b1AGQPBr}fG0 43E׋G" 8p#,PPA
p/FJf<BuMG ]PS 莐G1GpGQyE @ BW  0W	@ߺ !W#%
 'W)@dp+@ -W/D;=@1T<|@ 7W9;( 虃<W>$ 臣o@WBGDB|PNN~s	LrGB3
?N 6
G@R Ws	BS3
XQ1Z Ph=d LcCRvLC}ОGC+^cetaP bauGwGvGW%we#IJG,) A@1BγC}a	RYC	A="r1n10!6F^^&}{^- ^?a Y QG0G F=C]$Ht	HH~} : W	=@PW
t=WtueNu	{V   gcC0 }-f`@"xN t?N bہG[}bttc!G<0h'` |r/` wu_hef|lq  uGG tGߋWn@𣟈G@@t)GWI NGGf06>-GfРG%pF @@+G0u	)h
 M`t1Y h ^
G
hBQ
0
т
a* ܱ  +`nHAbԀrձ {+{1Ѳ|&妐-1_   RVFCe ^&9G,~_! &x2 ~G f&p.fv@2ww
!1PpXq)F| ڕDA E 	`DOPVq pqgPq@;fPM L^Gp6hWFf _8vYO QxP39V3P~2Q2///////$܀>D uDDD0$PDoRDDa~aD@ʀ> ud V+DVfDsbf p+9Vwr-w V)
Q댤F@8Ft,F@Q(tDٻJ$* w	v	~ĊfAVpȋp֊n* VԊûְ	 	-t-,u!Adapter - BCM570x NetXtreme Family B57HardwareDriverMLID  
 mP頡\  @     ~	  
 xi 
 <      < d\e@n pO  i 4  
ڽ^@   ]]\ub_S__J`dBaz_`K_`8a`dd`b`q`r`y`t``aaaaaad! {a{a+`U^4 a+& Uu+`  	 
 ]˺G_;SVsrt*ݕ+]^[ø.^* &D&Tr++ډD&5&].^ù P^øtK
t(S [;Wrw;GrWڋR [;u+uߥ+DDuP XÎه\.Et. FǃPG*_G,_.O7HuùR.] t<]u_  gl0vgnv7 ..].T^]r0d7Gû^  7t&&TW~L+0`< .:uOuV.^]+.: uuL
Lt\
DPX~u< 0s"U\+Ұ.:^t+EZ^]ˑ  Î]0B _OOWOt&DB#V ^u]&|]+pE"u.]a!"]]V^pbEUң.QuMZY[Q Xu.^eZaQ.>U^ u u;^p Wu(gU^^D,ث+|t#6"\P\ <rg3.\.\ &u&D=vV ]3ɈM .Ɛ&틐\`!##Atʢ.9]u.9]u.?9]t@0.\rF;wrtItJE ]P9\D&D tz}R@Mt}2 s.
 @_ Q&|u`dE
ހ
E
ED)7
 Y@PQ<wp\
Dxt.&];wŉ5EEEU.>\tE  m.PM
u+P.\EP E E
EPZ^E.;]u]uJ&D@   3&L,pC&W@&l &T*:Mt
+;r*X.\3Ã
Ëŋ+HtCP
u&PIٽr+퍻\2!&/GIu*d  KBPUSQRWY薡X_ZY[]XA6D*V^+tU^,T+ێÊ&S&G[ú^|w! Lr	t+u+^TLʉLuIuËDD@ V^\uA!D<w<Xø^øN@ \øX]WVQ\0]P X].]ZP Q \^ dQ h l n^Y^_PS [X  FFt%&?	?u
hP0S&F}? u~A\VpV~@u 20QR 3ɺO@ 30`A V
Ftf~ tp @_F& QVb@RPWV~N{aV^_<B $~0ӤAWVS3P}GVVF

V@N 3Fp ӳ8pVu@f
r;Vwr;FvN3ҖOu؃ [^_]	N
[Ȑu	!wSf
/[$S		3EP^	۲	ɰ	ȱ	f		+FV
?+FV	!Vhohy^b&$0p<9vF%@ ܁                                                                                                                             ?  
     TPM U$   ? G  N y 7 U  fWfVfSˎێf3  _f9fG<t<t
<t<t]  
f[f^f_IFXTPMDRV-MP-SEG16 v0.17 Copyright 2003, Infineon TechnologiesAQfSfRE
gf.} g.3g.12Ƈp   ǇpJ gf4   uq u  fP< fXfZYñQ蛱t[RS s lgq	  )  3[Z0 0}
  '
_2% a	_lA[Qg..atr0p	f
 DFR<		g{P$u	T
oFC [3fa
f$
QfW
 f6fff9fg f3ɹ z=Q 2u3g~pb`RfgA  f(g3fGf߹ \"aDgf4$ +If߿fg` fG(  bR(		fGggfW`frtfJrr`Z4;gT".Ng0  f_fY<Z<à? 8!D3RQd.ʃ`ʊP a  3YZRfQSڃ <u- u!uD u3
 p= 4g:PM		ذ	 4 t P83 s d p8ZpsJu0t  [&$A	KbK'a
ӆpRqfRQt2p fx!^@NQ fRE}QI 8 f t|gf> tup ~ tm  te t]fݺAYf֐-NV-^0.6[Yf;s E[u
 '_Y΂ 1 
0JA:$
`Cð*q[^Pcr
3ҷaG 荱_ 輀Eu
ٽI `uJ ЃuBbb{`\gFۇF#hf<Pjpfusbgq@ L	uiWT/uG"0
uS p IƀtBCt$o2DD$ff+f{+9squ o^oQQ0JL$J	r
Rs Y B0b$3 uz}ǀ 7uj]ZZ tL 1A_vff3ff%f  gf a	QRpcqgadtff ;f;s gb
AegucCfZQnVSkmmGBk01fgPR$S$"R$Q$ڑh ffVW+	 shL
jcj nƇv^d 	R_Ꮘr5 [pa7 `r
fRS2 a@BN n2k1k j\\ s
ph `9 kr
 x ]`Qf3Wg**P3=,|?@;@ NwQfi-
h-k--o-`-b-`-0yp!\SАQ(Ѭ$A)lrplrtP Dtt%53Q . ) Pt  tA@tPtO
 o.b.:(L*g%P2"1fQ10mj(ll 126zs_{"Br2p%s` ɹkdhf+fH  lgUHȲЬQK1oqt4ĄҒY((0s!)@rA" t_f!Nu0I3^`%Ƞ C0 z 6, mAsIu3PaQ X7 PSJP- / ?[Xp$
pqS q[ك! tKrCX 裃ҕ3p   = hrr f2
كa/ff)8f#b%  t	fˡf3dfk%dt_x$syz Fidk
    XBuf1       	R
  4      VID1U  AIBM 761295520C??  2005/04/26 14:35T 
$S' @<@	C
Vail M24P 64/128MB BR12758 270m/400e
 (C) 1988- 3, ATI Technologies Inc. BK-VER008.019M.04 07  pnVAIL12.v611  P24 PCIEDGD1UN  OEM 1.052 l 0l $:^>   aP1ǃzp
  $TVS6'  3 @$ 0R!  MOBILITY RADEON X600    Kv= S     @ @ D  H@    U	!!@ W+    xi@ P#A@@
 C%p&LZ"<"0 Q&4'0  p
@0S D HC` :,0  .@P/ i d`
 OD  P P`X "|1 2X&J 03@A= x 0
|5  5E+ f`e !UU  P &B/	m۶ %""#=MT#[
u`!q! "2
O0L  'HCQDTD//DO)QS2 21	1(Z @9`+1)dM J@  O``-
ns- H.@QAD0&  M0:LL 0a q9)VQq2q#
  5}?>   RT- Q`U
(;$@l%.  g:NE`  o P PpF   LQ` `E
H < B o-939UQ  BBpmA -5?7p  ;uuR9_0 #  ! o a  2 2   2 r2  ߧ   8__^2iQ%P`j %OQlA&_Bm*n  %2=RS2 "aqR1-

  ??a@@FA(H?,H?0u%\r$q
3 #BV(et@345a4x74
  oPðQ"R.C;b{-mQb҂g ',_lt. \)c8 `Og
aCsd h  Sd Δ  2l f`.>6 u>.6.8	  u  `1u .:.9P u.:Ȳ.6fa.w4.>q u.x.&x. xмz. xf`f1INIucd	.f	Jd2E h rE SU[)$
 t.VW	 _^FIRE GL T2*!#	P
VlUV$aUT+$X>piT
G
fab4_t.qp"4P mX ` U e f WP2X _Wֱ   @PXuC &GOfGGOOf& G OOR? ZRP@+ CCP2?FX 1FXfPISff- f
Q$ f$fPV6s^nt"qfPff
 @"߀qVU vq"fX kqX=Zu/ѨPV߾ H4 
 踧S
Kύn$6C PCX %DR ?ubr=26ft 4 t f0auAfÍX_mò CG  ,RƗ} ;L^ u:J^첺2ĸ tTe 
| F2~ Y6@$@  B%.J^ȣ%(%:%VB <v  p32Ĉ&! .@2ɨd^	aԁ NhV{@*81P@Ld
FP
H
!W@ 
 a  _ $ 
[ uZ>iE F
u6cѦ3ettavv"tv(c2>STN)N=d2Pˣ< @lb @ JgB   "t
u!#< $stu	@$<to tjf;Qs Ys
aF;$<t*<t0<
t'<t<t)<t<
@	t<t(<t<t (C>
up(k"R9 HF f;c [# ~ tF: FmfwF6eF2Q~h wtÈn<uj``$t }t  ^"N `39X8u跽 P P$X"8t+N ;N"rҋNN"	F;t
~<uF17a 0s2~@tRSf_Nfϱ7 PIǁI K&f݋Pr  sByQW; 3_YSPUQيn  F CuY]f<u,f nNFFFȊ܀ 
F X[ÊFf@F$FFt@F&F(P( tR.&!@{6Z.ߟ0-[PR.L^t2M ZX` @ Fvu@z=J	;5vǿv `tU;5tEt:]r9Urmt5f3_uif3ۋ^$f3fa  C s
`8sn~=}:n=a	Ð  1'(? -V   S?BDbcOQ]MJpPOVShoOQN^gORE0c	R 
l	jcgvWX ce
pVZa	cj| [is  cf	U'  qd% L̥a	d2 z!ҟ`	r36!% ן/  =!ҟ)p 81h!
a	*0*!
ǟ
	
pui	ӟW,b	
0
OpՇ4 A13P4oY]UM`62a-b6ip #B8qٯ?J +%2":b6jU
u%2S.<t
 C[3Ы3Àu#ڋHQ   u u 2 U 1sFg
 h@h ҋv ]jUb,HSR	C	8t	C$[. PRH\ouP tY@ @L,^P@  Xj  U    8@xSQRVWf<t< tux.D.< uh`G$?
t\2Ҋ`ltʊ»m2..;w
( `) @..Tt& _^ZY[&G@p}u
b $@
@@S;[PUu H<uTG<uOG-H
,Pt G2 0AH%p	Kgu/辁BJ k	 A@	G@[S dXˮ.?6
 Bte uY2@ t.0<L'f&6_C'%  Lm
gmY{VQـ.bjY~	 
 pfFm Fzm߉Fk`  .!$FDV힀.6A |pmt ?@EofppmFLFNF zF{4W  _< ?_SQfY_S螯[BSWXP u2  )  @X_[(SXX@JX[_tF$F& 0
u9C+$
||IXP?X`t5X^C `+f3a  v 迟K^ el N6   } tpXo|c V ) x PR>^Za XCޠ6D @D7 CBS$  {P3WG
Ĳa ud
V"tQVDtPMt@uN,u'"0϶4VF  fa`  ߀t>/S/7BU[0߲Y$  >
u2B[XTiDoSbD! typUt Ut U@ߚ0 t
 t}t5J
tSubU@A %?P%@
Ā?
XÐ( 	 c-'(+  1O }0P 0c_OPU
(	@ s  1p퓰0	@ T(   Ӓ m	M](
c    c
   0bc7 O
 B89:;o<=>?
 +
G _B$d "ozcfk
I2  >ꏟ2 
P~  
> @( $	

 0@0 	   
      
 %( (,%*26', 49$,0	
!&.3+0$8=-2o $8? (8,(c @# 	,
( 0HH0 (,	H 8H 
8X	 > XgX<	X0TDgT@	Ttf(XHH888 ? 4<$
$ < @XA8@	d@Ap@ @ À?O/2.r!KsuNP =Ou &.1P=: sX.$XqBP%,&Gۢߢצ9HحE+X$' ,\FG0eI6% 0+Zt&oP$K$pM<~.;u*6P8Dt	\S
OX:PjM
X.체0&G	tԱ G	p?
u&.+X&c F./VX0`PW.E#𵶶_v]uksu
2R`
X&IFUD0UD 3]U 
F CE]Y[	
 FXPv(XU ̈SM[( 衆YvQv t
9 u8u 	uP	HD]sP[XZN- ۨutGGU]Q S[[S݋@026'C[2S  &'B[ ĸ Ë#utt&FS޹ 2&C@qUut	 F07	 2
n Ȋ3S0.P
[t v 0(7t ̓rPHXuSصyS[	$
`&[Êg% ot4$
@   t$Ê$0
}P X3<J1u P<~$<t <t<t@؁ð@  HuPÁ@ÿ")O)3  @
@@ b !"# 3@tb
%ƿ`]đSI)e&f[,0(0-0)0*0.0?)0.8%u.]3Ã;uouK>L tDI @.>H^`3u&"0F^<~D^&g7*0u3 32PQ3f3f@  fYX2PR@4$@tZXZP+Q  R< 4Z 8 b3"ߊP 3 U3s AQR趱$W;DrDT D fRȊnZPRP ߊX@ZX8t
tPZYXenuTu  w 2u  `.3@
t	u$ Z0t Pɇ!^X_0u$0<0u  ߀&o#6<uA	ut	
t0
߈ )<u+V봀1u0*!*QS3u<u "	,܀4u< up 
ha6u& <t	 0{0=뤜@SB"
3 o o`>%ȋ^N"	 y T`h.P <>cu>.@ 3ۊÜ$.B.ߊEq J@^X]l+[t8 &KH  <8t<?t0! .B   볠K%/+Q` &L >Li Y@ 3Y |RQ
 Yf. _.  ~b . *# ?#  F 
ܐ
 G@s 	 GޝÐ~~|ֺ| |8 8|~ 8  l  <~<vW ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x~p 10pp0ѝ}P$ff$78|||
<<a lll"ll  l ~|@0` 8l8Ovvp P``0 @ 0`   axa88 || x" f<| <l |Mƀ | t ~ C P
a0qP 
  ~
 ff|ff| f< ll  b`|`[` 
r P< p w `b% Ɓ|ְ|~Zl܀) l88#< p P
| %| | -W03x|O~ `   `̀ 6000q(vU |8 x`flxl@ 	lܢ-u| p%| '| 06p'( x*2
v 0d 61  8 v5plp;؀5 |2ƅ88
l8|'!5f|ƃP/&&00 %:l~n ~ހ1 -7 0
	A'!r~`l`fl fEK>c8c>  >a+<4   ,+> >`gc=  G0`2#`?#: 0|6> l<~61Fll6P` l  "# U# ݑw# ##d  6 P P 05 `ROpqPDJU1UQ2d770?B?0a a66R9 Ba	
 R>     f~ 9xeb]Pf``y`p_d~̀M֒i|?܀g8 ]Sl8T(vr(l`"8fj~C|q^ 8`T`/Paa! b~ Y f`[ ps xdaw<<S2tflD8\p&mp0t| oQiqAQفPQCmlEc%oFlpxpq5 aq3Ԇ3v 3w҇ Qx>6`vflqB~~`4{>~~>ՂR2$ P3~ {p4`||s4S
x@ cUtE9_2 `!@AHiP!3pxF)bfwP0v~mi {168 79
G-3 a5әAPp|@ѓ `;Ҝ2#a=Ғ~BC ҥ  R*ҤљނtPa47`p0iQ.f`d|d``
` Lӥ񦴝Rpbq
 xp S 		
q`QF#a`( L%4bL@Z ~EQ࠵  4-B0a
6P6rc l   a 	P $jǷb[6 q b
P$=b X
cO 5. 'Ma0
 ABоc 3A U0t"{ pځY
0x" p	#	$@%#Qb 
#p
 
% 	"Ђ#Da6f0 Prʀ
$ 	%  		C	JCdw@`1|cc0c$ 	?!	8 ld>BPP<@ WWd!_ 3`p3 B< ;8>hdp` ~0]Zwl^l Q6>6n6 @s&t"#D+ f 5ڿ Z Ed
 
Z Ӥc g52cb 
d
d 5e<5ek 
c
 eqeeu %


 9Ը=3;1N Q1b0i2S$|ҏ05Yap``<Af	`q| Y a0^0 v 3 ј/AX`ixx x8#I?~ sY6t?W2@ _ &&M4SWI &FG_&E"&E#Wl_&]%&}&I2.2_
t@' k)p = ~=^~=~=~ &U*&$
$

S0B$
Ļ	-	1R2;t4&wt  pu`2RԊ%@+F,_t=@ eR ݸ  t` t:t ?FP܋w !?u?q&ܒ?ek ڊJQ 2쇽  &GF %G @GÜQW+&oQ&D&TAα !	ʑ  p&RW_:&&TAP
 XF2 CD	&Za
CD#`	 +
a@[@_Z_Y`GQWZP$0-󤾄p   jr ts | :&?Qh%a~ " G 	ĸ  2
WRW` 1RFJuyCZt 2f 	2wPYs	QwO&G<{YO 74 7@Y t' EPJJ  B2BBXJ9wGA!U,~VBBq#5)^!]P9  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

			   


  P r 
*   **Q p  : ?  ??Q r     $$$(((---222888? ? ?/  /? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h@   1   ҙh1 ho1 P,h   1   h
1 
h
1 
hP$
ĲXðߴM WMM^  t o>I~&G3u 	u&IbtԀ`cNpb  P3&2J&Gq  GLq ģ`À0c B2[a awjb{mphrm
  !"#$@ABCDrstuvk(
K} [!{ ;Al(L \!|<An2N ^}!~ߦ>Am@M ]!}=A`P@ P!p}0A aPA Q!q1AbPB R!r!/Acj)dC S!s"?AdU/D} T!t#4Af?F V!v$6A@h@AH BX}!CxD8ArgJsG tW!uwv7AeVESA   0  JPmS  $@ ) ATI Technologies Inc. P24  01.00  @ @   W   sVBE/FP t:.6p <r2.
^WVSQR  f&=2u " WA_WȎ؋oRp" uz &u&Eǫ_WPPPwU bp M_ǃ"``ƐuZY[^_O ËRQSVWU?WQ30
Y_u5WV6/S2^_@

.D^EE
tE M]2B].l.DEEӀ~ZEE!@ #  
E" $ ~W7pq_~$@@@@ #  P"%~@ EeUeBS3ۋ3[@N
tȈE}~=
 Pw1E*؋EMډE,].

-_+E0pX1 
 f3O]_^[YZp0#RQUSˊ$ w
 V< @t| dQLPY
 b 
FŀuZdĠT2ʋD<u<t<u<uAA2PQ/3 X23`pƻ
`	$XPC@oDI0oD0o2 2pDoY6tu`[.F. |2O[]YZ)ø eVP$6Pش!t8\t,	2^ƀ t %Ӓ @^;O-  	9s3"0WV>ȒF^&Vf=>^_ÊFG< uûZ.J^.:W 6 
._@StwCCPS(.$] #y[XS.[ utzt
uPSR Z[X8
t
<RBB@Z2ÀuI tp<wjut`2.F^s0ap!`O2̋AaPXq(
uË uW3&J/_ADOD< uLA.؋6IS [';vȁ~P@JS,f[Dt@S&[%@عSQ$.2f<ff3f` Y[f;Ës Y@-wryf@Ч
2uGf`PRPfZf
ff3-fX<uS$f[fa==f "$[f%fP?O@
XZRJZfX"[
uQR~hZY!]"uRY)Zot^3"t	$B wl wf= ]QRW&9f&f?$4 Mfgq_	uZ$& n  T8<\ VRf 3tZ^fOf33sfffPfVX V@cPQRfRfQY  $  OZYX!
9]PfBffvWf4<0B?&q?fIu" B&$@[A\`tW!_f.  ;t} u2X#%5$$ ,3>QSu:3ɆtA
 [YQ
ڿ$YqD?SQVWP# bS &_Is  =R^Y[l7QRVWy{	_^ZY^ڋ_  >$[ SHRa3MR+ Zt $$}!
  t߀7SR #uZDQSСP&= PH`USlTUW9XFWXY"ZYZZ6^% t\\ []ÐPMIDu$P^   kأ%(%:%lB^XR ZR
 q  ZW2 _Ü"oQ K.63 f.;uw u h 
	rrs2[fX)D%)7 $4S
 &`ffQQ2
QQQR@WP& 0JfXR2Z[ff_fXZ - R]fqf_
V
蹂4
X

H
틪RpfZf`f_ZvfPRl g +1KK;rZ  S 
S  S@ [hSSSR	QpQ @DQYÜ2C @`)@h #  ;  ` #  d # B f 03.Dfa.T
.d"쪡   $!'!Z/RBr2& -Y&
y"
	.Dt fXZ
+

<t%+%
D Ԡ0F`
DGQ e8t#^su*cr Y$QP0ΫXr	8u
@Pu5,XP	r%0єrtr@jrXQfuQ2 PvqtQrSP?u$XPQrKru
 uKuXuW` _  QS 

O ztGrNpr0t;Vt3r,Gt$ޠrr1PB?NKu`~ u! rdr
psr1ށ	Y`ϲ#isRP*s2Z W _YQWs`Gr	zKuq_P Q Ys%  $  >j5OO<Surj"[rbfa uٷIrE8w8r&IP2XPr+rr60)Or @a,X u3ÀKu3S QPXY [<ߢt<Ⱐ[<u < pǃ3\PQWGGNrp!_YGXuoW搠u_WP@_
t  ꜑
AÀ>it[a:uuao0Y	V u	@		uAa|ðpPXq a <Zr,ZP2P [SUpg6_;w2XXXYf`s	A@		ut6P%2X0 x  t P DwDX ut!P% Xt_ueP{ 	dX P)P%t:u@PXt0PK  #u#P P. 軠 " ~ 5
 qPtfaPt t
`	tsqѧ
ufgtu*QPQ_#L @ @
0lXu
 	8U`  7XЮ@qOrrs u$gefPfPPjQM:PfPQR̮t
t]PRi	 i.? t.;u.;Wt3@^-'(+ ]c@7h?^_OPU Y7 oo XGW 6OF  	@sTv2ed. _
90  *+P;
2'SQ
t/+u'3~At		ttuC۰]4U :g i ]a!S3  [/B$J .gp s  J$
z2	䟰@
e`	P] 	!
U 
̀^			
0ȎS[	 z1PI.
$@
JP@=^v	@=v$?
ÿZ[@5S;?1/ͫIJS nQ$`$@fP,8 T 0 ; PsfXAk @c*S3;s.:GuP4u.{R&$ SffȻf
  ~ ff N[VWQPS= Nu]߸ Ўa3f<8ATIuI 44 t4Dp4u*D.x
D.zp .3.4.>z [XY_^û..z.?t` up.G4yG ZYWVQm0lm1Y^_ 52   v=P1t=T1t=`Tt=dTt* <w 
 <wf.! p SU[Z662i;rbb. t[uAhnĿP q X i'_ua`Q```d
|$ ЩBe6][3۩@߀ 0{   PN Xu22@t $C  t7ւqW@pPv $ـ AgBٸu K)$<t2
#4r
p
w/$ 5肞 
a9|a0t$=!^$ S$H <#=\0pr" }k  ̀1$
R$w
WR
$@[5 "Rj|<CP	I￸ HER9U + @WAG~$CHw~#\$!Pѭ@Ѐ  RS%B'0C"2[$%pD Os U~oQPQX  R thimuNjukЇ^ ]]]^MEFqGGHF,F"F^RZ<{ykOh`j蛠jǓQǓ3 Pr].]2^&]a
G{HZGf
]`k7bѱ 'c %@" !R?!R7u7?S+A "P?"
 2ɲ ^1=Ă  00 +Pp+Л+z $RkQ>뀆$
3<'$P$=R@Be #$1{"q#v;$gRk$ w&O$ ;wPP&uQW2dF{2䀫9PM <  
ltQ{
B{P@sP.G
tP <?XR NQ'FE{E#hg0f hZh!	]}U	 ;A3'[7#1%L[ZyY@@(C
 ϡ p葿n02Шu~hef43g.E#[XUROCh hYA`uDA Ap7kDDEUu"ށZYNZ[a$JCRW$I<#t=<2t9<3t5	  L	pf -SI[@>_f!!PfXP!0Q
$<@<t#<t< < < <
 jF* #z&E3uku{u	fF4т 8Q_._f.EfPF .GF4XH ulF6XH迖duHff%  fF8fXf;qPf	F8;jc2>..>FF4 fZ(P
`[Q
CP@CC[  Lu	 Q^LtR3ZF Y.HF
GFF`
GP0F`G$`@F~	F G
G.M	̀

`3T
ňFF	
G	F	P
FG_F	GFG
F3F'F2F@FGB <a @QRF;#t7<t3@/##
<t<tk2NAVBA FX !                               3 S(4Xf
   fX[QdR>] ĀuBp u*@ fEGtff.#Gf.Gf뺊uvbuS0I[`.O.t	q tIt䰔!ٻPIt6$<Ȳ2YÐ@ n Ps d r     	 p   RR   p 	   P G p 0  P  p  P ^p ^ ^>P^p  P "p  P	 @?KZPb @fPWQ2ɋYSQ2Y[SQt93.OɃ.;v˰a0A1 21Y[VS@{~
SйSt/X~ QSfX PQ3@G YX fSfP f%f[݋õwlf[0i :
 fðd
^_fX2QV2{.^"Su= v8ǰB} YRfPP#fXfX0fPxm!%
@fXy&^^!K3s4z萾Q2]P$?XVk"-fQfR0	$2BP;%P1$i%_0[PX93Qf
Y;fsfPV!.^;2<fXߝfZfY&u85f`$PJqfbYf{
}(<tAϊOMPWVRQ+Ë&G
36 2}a!$@fX&2&YZ" QR
FFBu P$fZY&Н b"SQR3߹.
 I@ ÀtntQ  tt"BU@O@OO]`tRp #  Q`2Y|@t.Q
yYf.9VZYPSQVJ %,< u`X It	ߔX.XP $o
 Yյ^aRcf f.;Tvq vPbp  гf@ wjvef+бRvMv? v2 v%}vs u	r	wUNfV.Lf^pf f.fff;rf@frxf N ^f;rLfPL.Of;wff+f'>sv
oACX
	؋N]~
tt= r = rA.DP.Ã. [Fpҡr )À )tӻ$ 0T ۲V$T$a PXWPVoS$yڧ۲P%&O@tp$&W7u t@ @w``LHqZX`<q	ZX RW'ۿɃtݲ Ӿ_ @`0Sf4[ø \Dw3p4H 				      
*ǃ2ڲ[Y."D
$.
ǃtcЃs] pC &L2`8/`ᲰsP 
  ]0&E}q P00![OX0ٲ[&ߊDVB 
 &^DWp$^ Ftf
^~fԀNnЊ;w' ڨ[Xu;@fPRٸPO` B  F_F Ƞ 	r}pF D
T% FyFq{Ԗe	FȊă{41nw0%
8sF%QXQ0VPFf=$@|-,3)@f
 ߞZYfË؀~Àu 
Y$׸
tQq~dA>
R}!ʸ HZ 4 X[4 ,F 84qZ QRc3ҹd YSRb.DZ[   (d
$ʼtp  $$@!
u{&4p5 *; u.:t.6=63Ý W߃ ^[ WQRVSqPֲ+$װ 2@ Wfu5DQвXfOֲ|P@EB t	@2|X `Ȓ >`0wjor[= 
RI_[^ZY_BOtw:b0Ww2ftu% tK   W&@   ul]0
 0
0
 Vf^fPB j֟0֑@af;ufY9?$_p`rƐ'69ËË0"QCBr `jV0w`ԾV uf ZX^.tWpz,Կ
ID_BqDеpVSΊ .;uw[^ӿ|\1A	Ӿ } ^( 
 : 3!LfBCC胤У    QwײRXYҲ1S@4Ԩu[S觯Ҳ,XA	&  Q %Q$Ӌ@SY`("ӂӝIҨ
 ԓ3 Xh l   Bp   & @*@LN  QRSUP ػ
+P$耿һd
 jһ0 ҲXP%
XX@ X{CXUa[`Q(P ?>t@w t0	-ѾUP@0=ѱ]ЊB		4UBUXЯfXZX20	R_   sM  @.$1L2Ra֐>! q>ёF NK.֋F_2K{ۍaqQ n ^ 
uO в) ]$лS 
PmuYKt  NVRuN8K4Kt
@ϐ$

`k(0Wt	
t yoYϑn@ZXt3d  ܌KLt6݊2qJt+ 2  c3y@N鍌P  Jt&$
N\2䁒  1#'2n !_ @r 
Q@P;XY^8싳CI	͋%T$ȰU$ uӀɰɑpuЏT `週u  Ui jN_XBY@0IN_HG;'f3.O>f.O% Ͳ$f3
tff%P A
f@,.O>uuߊr*
齊W % %} 
0 pu0&&@
%	<s̆(1
] ^}
KLM
K?P
.C<t8tXp@'X) /`t:KΒ㒔(^p2!:t`0%$@ 1
cΉ-$@*̑|$饉ؐ 鏉"`AAp2ˀu$Wrp?2`$pIK߀uR!= Nt(ˑ(8p " 2۞	% $߯7u6$
 b	+	
؀
߶@JZXÐ( :0e˻D 9 [X@
8tuupSPݻM̃c[vaS	袈 u[S
t`@ 茈J!BaD PA [
qMðT -3ɸ.6T 2Gzq̸ mP rPʻx]SDvAI$ʡH$D?+ʻg%`ʻXt
<%fQ
,fYfPfQ
 QspfY 
  .Q PA$kt:rq 0ʻf%gQv#
%ʸ YKIȊ/ 0S@a08
{F
ø w oM gY Su K C- ;m3縵A+#\T}@渔{s済渒 fɸM渍u0
 p-am _ 渁AqxA'$T
^渕  P
 r
H渟q@(Vȳ-%
f WQ 帕?@  ۔ # ap" ù?ItRZ8uR
Z CRƲP  XZ CPyM$f1ubrL. gf.&#  &ñ Ry 尅@R23Ұ
Ϳ)u 
Z`..L^ un> tgp b2P>bP22AQJ2=QRP觋Pq 32ZYYy2 XaZYYR*8}2.D^Zà؋m 2Ku2W {S
uSj[+с2Ê2+U**&R  āZHuТB$0JB J.B^r c 㐃 ޱ  PQC3BBaaPQ YXaY eԨuX}N
+.J
u8~` F^$0<0tH^:Jt. ` S +*21+uX  up*tX⑰ p/. P"㨀t0׊4"
ވÊ$"ð(0Pѝ = !$%D
m݁ ? +

,QVW++    e_^"YԊǊ竊_ S8v2QY2P >It(P
_RS"82 PL[[ZRРJ2Z.Z Z 03<?& t
uV E,ņ!&J aZ	뺀-[a2RqZ1L0 }
+ȴ@A
t
2&LP    >&}S`YظU`J<t
A<Ut2[ð
 6% B B2+Q+++YZ0"ƯȰ+Ջ+Nuÿ`$` t  aݍ"t|kÑȆ8~Ptd\8tX|0I~D*0
8t8`t2ſ
8~
~Ȑ}ݿRt*Ŵ
RQVW3ۋs@ P/2 1t@   _^Y@ ZC\WQRV`T3G  ZYxs& 	r Ǣ	 POFP J ff*f / baS[F_@fWfVfRfPb`pfV +Ɗ2BAXZf^f_SRP10`VfZ2f04[wu.N i wy} r鿄f&Iw$餄|t;@ _v[`ovI|bR:Z\K`R!eh60@A3hz
twFs
PdP+>PEbF+Zh
tĿ鸃R
#
+ 鐃yrnAU~6|m ~ &F^ +Xu &F E&   P wQa+>2u	&}uƀtGVW_^t!#ut
>|  21
a|u\݂tPA drqF`u
oQˀ
С
6JX 2B$]Xc@]SO4߹ 2
FfKu[3q,~!#|AommpBuG镁PF eXЅ$6| 62 'tmU؊Pu)#ëp &N>Xz !1{   PO Àt!g&0@ b?`$ &PO 騀8r2Êв2,Ћ!=1HJN@PRXWQP͵sêuXY_bQ(IY+'qGtrG _vqG
ov  _u　PUoP[,@.X`)Vي`4|4F umXPRJWQQW@3_G?8v
 VQGY_Pİ@[KZ&%_G+B;v
ZPݠ òθ!&/2R_oҰie0XRWQRQWP8tXoP蕄5$FX_YFZ Y_Z 		0								ɲ		>ctqP}}>
u&fP 3 f \f$߀t  
@}}SP
3 t&  ~ &]X@9	UĴɧP _qG@Ā`ey
L'}CkP}AD^+A%  %%&|&Ę*(DrX&|t
ޑUn~|Ct-t|̢2"[}~J|yr/>b2PI<
vLw?5`GrǪA8sZt{at u2<
u:6u鿖 Ɖ{<u{<u
t22+at++&eP>Ҫ󥋙peA{pбz,{.u~&2p
O3Ɋ7ʰ'ﲿuF zzcR`R8buaz~1T`NVzb$
Ip(!Q̊.t.;t$.
DY^D;z#+3*2d!d"<PR3=ZXt
A>t
z>u<s .ު8M߫Ū!  #ŪU@ etÆ% =@&yk}+>&}s! 32 =w0$&e߀ te ò 3NsQ2ߜB0:JG `;/^ xQ&5&m&M CYx
u	$aP0cu4x0P} !vr &5&MUx[NL ~ >x}4  P^a ,AWT xtX9 @Y.ڰP;PY0 d2|XR~ ZSߋںYB [Z SBB  ws Ȋ`PSfQf  :t^$t"$2t t=fIuvޕt%utfY[X$ .<t
4vaav<wPSPRRR@n@	[e@}P=s=s=|s^=Js ZXj[X <t<tˊ߀~ S&[&v ȫt@ > B Fv.| ~ v2..u 
*9 ԽF.ȽY60:_
u00w5wpP&p u͎..ZF.lQFF kuY6F.F2F6Y  Sp$[$y&G&g3t!<}
<}0
~ô <t
<̀
&Gpu2@P ߋP$`"3ҹ <uȰ {P' X
PuÀu
&~à@S[t (22QPF t  +YsuчPW>&}t0&<t$8tG Ȣ?&E+ _X`3t_tG8Pmu&2. aѬtV$
J	 ȋ@/utHa& L2ܾY6t
F t<t F0J>=&]&M&U&E
wPp>X}21PSQR.L^t	00ZH<|xrSH!`5[VQS&F E<
"@<
t2Bdpp\p' t&^ E	qVras ߉-Pһ q	t2䆠SU@,][ X[YZ u:Хuq`IEq~Am^Fq<u	Cnq0.:r2.] IÆ$0<0tu` tq
2.;tq `i8~û 3n tPmU#)Vqnpt#  P 2       ?     @  R*$Z.$SQTSQuY[f.
uY0t5Xu	f._>T Ef0(`f.Iŀt?
uPa*R j
PRt|Zpr .@i(-2.OA.WB-tW+A_t;r˿ÀtR p D
u(B.&Ɇċȸ 3  u,A	t0t𼀭| ]
PGTtu?M2@c
uJJ Ѐ@1

@  P2@[ZPQVWS.>Nt .TTux]..	CANP Ў3f<8ATIu? 7;2QRS$<uP`F|<2[ZYY.ɰ.ɁU@諨[_^Y@Hƴ 
XÜf`PSZYstytrS f!f-¨[7[-!fq[2ݨ03p
	>`	f{  sVs  fa-fP22ɻ| ϨfPfI_8"'0 f h B_/,#2ɐ $
ȁXgϧ   	@fX7S.= t.;u.;]t3Х5W4uR hW.׊eD <t<<t8<t4<t0<t< u0P`S4=@uuX5
X
=u
諦_:@E=@ Xx ^}     Ѐ  @jPmm @{wj X--    
V 

u`P=uaS	dF$:?|$!Ho$+`yͥ  ;v$u p Dp H$ 0MWDW PW .? t.9u.9Wu.G2tpU22T_Sb.Ɋ
܀gqi:p[;D;;ûd q#Wt\3PR$ZpR[
% ffR t3t+t#@t.tpt>tg%ff O%fjzf$<t$f- < tf+ `f
 f2) ffffZfYf[V<ݰ2(¾6ȴ2f3.Df3ɋ% ffp.	 L_  
P!f{fpf  !Xff;t9`fX!6"ꥰ" 
"t@pkb ?b Ym
PG{>^')C( `.^(߰pDEFG.F*.~/ ]ط tttt	tr@%yCp g^ 0Uƣ۰IAfX^    q  + C  C @CъR?muu	 .F3_H  H@" ufXfJ	p{^`.~0`ƃ

p0xq 	yp)tfM0~4x00   8hkf fPRQQgluЀP=:3/H!pXP  ︠TC￸ 	^$ ,LՐF T P  X@r
\ `#fku 0^u8ۑ Phtq jt=  A0o p2pC
uu
lXT1mtY]IUDrnEoM<~	<%  Yt P YZRSfPW4xJ轞躀.E_fX[Z褞4ƒF
@0 g<0 _F;  (P;; >p/HN   })%88 A~	I? CJfPVQ0y{<t%g<tW\
 $W贝B"EA!H A"`-YN
 Zf
  9F-fnPka{Ơ1p^D f.2tJt3;d4 ,Tff
@ Svf% 1MtAN   [>:מ__ZY`^RVWEVh ֝3Pg.;s& j?>.\e?ËQ O^ oL.L.2
0>G_^UCSD0[@ Jۃ(c IK0u3HS#ʜ,肜 Q t@腝ae0uǯXPTGPS2 Q
~aRPb֟JXG bfW+&G5 ffa~tf.#jf߃qv}P"ɛ3۹!fC X赛f" 	WfVwf.
fꛃeowH脛XMf^p$[H  $,48<DLPTX\`dhlptx|  ;@>Q  _`//  ? c$
k*6
mc8*1 C D
  
 =! !A- @^#
l"  = @ rI  
I @ .q&y$`,>$EAs/BJ @  ?- vK I'm$ j8!ha	̈́&@R c۶(, - Y- =P0\ y5%1#~ +.C[/H8CАO @Kd"#CF( N%_ ؏'	.# wEm9 Ƣ( [GqF+ ϡ /#-+vk+ [P} z _Bmc	o	b	y`	 gP~ B+ 1@ : IR?# (O6 i  nb8(+ h"6 w-(, QPT PT PaP=U! lA?-'A.P]hq1,{.a5c
5^O1] a`0U 1&c cA$hG!A_	6eavWPp4V10  $TV N b PWVt  Sǜ[w^
 2؎@< u+~@PVf >藜^[a   :{ ;@f=$pA@f=0 #?؃  ?=	wIu'= Nvu @SC+[<wqȎ؋t @봨qĀ@*뎨1<녨tN{2q?_fY  藟_ HD  x@ PSR' $P D
XtuZPRP$"
X꒻H$螓= $oB@10|P'v @ /ra: 
tRP~rQ
t 試	\ pXZWPX2 t3ɿS;t t_pP33 t= $@$Ћʊ$ P$2Ƞ$=u$	$Q> = >  =p nTþF`赀8@`B f=r w~_Q
<<$
ăQ<:0Xü4 Q *@d @A &06L 0+  A  0`e  1X ( 0XB 8xVVA P	 -`N ((' @$
>QW]f_YuE#@a-t?  1/Б$ÀB60$Qt$PƐP=@r	譏Td
$zt0TSoC5␐58GLQĝ>\a`S$0:
* u<}$ӏr1DܐQ-U$諏D3!$#!y" @@X?j}蛎#p  G`΁Dy$@3h%z YH t
tQKnL`ݎTpt2G2;rאWF`GV_Fx+i  Z bð9 =9ðwqӍ96qq}m	fp?Z
P9bDq=p4.q
-p1 /|p+$؍ sWx  !ZP*hTo^Xsc\HHx$n
 a_?[UQmFP;s I8 V RFNP'uڃ?^
[F ߰98[2FF
V|Fً?"~?P7XӀ
QYINpY ^HF7FVЉVW153]V7@dF F^9F$v F?fH~F f8f@72Fp41~;F	Fz 0
6AFm
6FPQR2$M& 
Ⱥ$?
ZYA5fS@5V }бEkۋ 'AEEfP'ËfX
@T`c+qkj*[	U #
4E #85s { 9 踯?f>ĜcB$J&e 

BA
  u0f	QS ãIM 8%= v$B, 7@c4$q7ˊ% {188k݉4MVs @@f3 P3ҹ ȋIXA;r$	藧tX;v;tKXPQ j
LvYX  tPfCjIXAfQffffYf 	&\`   fiBpGYf^O%rN[$P # OqHk$诿t އ.>G
pi`ñ .<  -3f<8ATIu 2؃? u2蕇 {PV ׬`	8uĊ^P2.ۗM؋7t .& t._&@.?tǐ?.E7t ECCVWfSꆀP@ШW.}&.E_.]1f ..M0Xf[_^f9ȿ
Ȃ-0
̻$
E.E6Cfp$
ׇ$`)Ї$.e`s2W=	_K.]9t"=f 	0=%f	}&f1	'P	e$Ǥ	80IFl!/_1& |@t訅
=`%
Ĳ
=2.>.1#%:u

P&ó~ '  ) 

=ðu!1*#c -fp4ȸxi3(ZYf[
 .  0u  t < RȄZ0bo⡵sQ׀T% Ru$ZW0,.E#_ @_VQdWe 誅$آfذТ%;E.uDff%   !&.:E0u12   1u"蛢f;wt
 nŀ~ _`ΏY^ 	-f= _Y _ xPW1̘h 
Є&)}@(襅4(+$0w B}"ɫ#_¶ic迃TɓˣQRR$ ?$4_
21
腃Z=u @o?QWm4:.Q.рB1WAB̓ .m DaC}pm@011"M,t藄]_4<$o˃P'ƚՑQ'}o4 t&a?QI)tA6$o茂D/#Y#M i
c0S 0%$V$"22ZMu.	ӑJ ȋF"F 1wmqF-c+a[F&2$Ҕv[$
[a;Q5`1e/#4:uF) Q\;$
F)T bPP쵁fF4` 8Ayyp?F7tp6wF; qXsFB#@0 tF'ȊF(`F2f)c3 `d^(2^Y[=u3ۃ@Ʀ ynm f _fb  J$1
ffe`
ff`
fJ$߁
f	f%
ff߰fCRQWUD 2F E]ܓuuu	fǫF4P  8 _._KPn.G 4XpЗHA 6XHfPuA T f_F8fXf;pPf	PA2>g.>ًFFm_Y3
1"o"
QWpǊ.Et.;
u
.;Uuÿ3_qh7o ^ IJtcS2lp4wې
BfE_6.Ip
PR P
F"F 2N(̀ N(>`FF'G'N'+$fF f`f1N})F
F$`2.O$F&Fqlp+%
ffPnF-Fa
.o`N3P.G$ 
Xnr
Fќf	sf	cb2c`nv+ '/0
$F1PF` N& n1f102,F,f.o.g` F`F @`RG	  $ 
F0` Fb !R B`Wf	Jf  G02ndq"0

sn/
3f/f	 
 n !`N2AV{B02`Pϣ F tZ賋tU1CWF:B62CC_A@ `3̢B2WA6~sD	F2_I@I6J2J_2D7DDag a2 8 C F H K L U Z d x    ȏ ( O#zSt$^pF Ft -
F u	F=!(^~.Ff.fBg``{y{0 Nwn.5 f0{
̢ _{tǰWF	zjvPz]Ef^K
 LVp?VFq|	i
@{	f{lzF6 2f|z|9|5|y11Xf^ˊ߃fٸ4P"^?~/|8l^ ^zQePFPx=$Ќ3`,. `@p)t
o  w"v!πؿgD	DfDa Ee]}gqt^TILDu'u?D*aw++؊}@@%??Dd2C_EeCÉDE	b*DEe}HDL0+S2]Ë؃$PeĈD\\[ˊE
b	|ȉL qB1cD3D<_vu$<@ $PX;}?Iw`d;DX4D!#!Ë!ߋȉD)z
'EPj2`D(D*&vu @D+L-DD0(D.E`9؛4~\1\/?ЉT23 ]'Ht@P D;XD5 @^@S @X ^P P @ XOP 11?`Q  @ 8Q    Samsung LTN150P?1-L02  Q  
 AA  H }  ! cRl L  "0Tn0F"d`  U Vf3ɹ ҋ|^
uy؎f<udf|  uZft y# =	wIu 3qDt ֨ *2QĀ ]`UOG1	0I1I	 AJ2fIa+:PeE;$up E;X e9= uPWA_= vU9жN3Ƀ= t09w'9Ew"xt=` 0wf.E.D`A.@Aн@ } ;uA7pVEDP@SQWVt^_Y[| u ?0?@.|& t.|&DZD&PDMmyMm 2]a$@VWaVS 2 Ў3!8ATIt[ ؋7[tFA5	
&G^±
p ±  廙.2% u== uߊDu
`
ް% &  _^VQfSpyp	G
ff;u.QfolY^E4_t*8r$qPzr%qQ3 蜏0蓏Y}4 _tbqqWq!q$3ۊS 0_r0Tr3
Cq
q
[Á=qE3_f_#`Ȼqq}E
q`%npap`q#pfPVWSuf$@0;R*KP&,=ܠA*D0.D1
.}4u'+` "
 2p._A16 ްs $}&3@ E.eq@3@ [_^`Sp [À
t{
1Bq  M24Y OEM? INFO1X                                                                                                                   Z 2  1COD  P h$3h &hS@.5h[.=EggS$ih$g  ifD1INI??SQP2.N= NXu2˃	w,.'
t #[ʠg  u.&ɰ p۰                                                                                                                                8g#3o            1600x1200  @  
 Bn}ۡ!! _]_Z _\!
E  xi@ PA    CХpL <a0 A4Ч0 ]  p
@0 D HVC` g0  @P i d OD  P   P`a0X 
|1  =X&J@u 0@A4= x @  E qE+ f`e_ !UU  * &B]/	m۶ %"""M[Ϡ
u`
!  _"2
O  'H%A&T&//D)QSB B1	2Z s@H3dM Qפ@'`J
 HT@QVAD0&  M0LL 0a Q)VޔAq#
  5?5   r!- B<
(;$@l%.  q2N  `  7 P P` }  LQt` `@<
H <@C- 43P4Q ʡ BBpmA -5?7p  ;u_uR9_0 #  ! oCw PJB p B B rB 3  __^%A* %1GQA&__A E %2=BW "OL
?? a@@FAP;;(H?dH?0u(>#Z0G/Z /Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z,Z>/Z/Z/Zx/Z/Z%ZU%Z /ZP'Z $ZC/Z/Z-Za%Z/Z/Z+Z"/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z.Z/Z/Z/Z/Z/Z/Z @a/ZWV*Z? 'Z _[%Z`/Z/Z.ZpA&/Z/Z/ZP#Z  #Z$Z/Z/Z-Z ?/Z/Z%ZP;/Z%Z-/Za/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z/Z-Z/Z/Z/Z/Z/ZUU&Z /ZO/Z/Z/Z/Z+Z0/Z,Z/Z!ZC/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z.Z% E)/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/Z/ZV  %Z__] M=/Z/ZD#@&/Z /Z/Z/Z/Z/Z@/Z/ZOONC J/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z+Z O/Z/Z/Z/Z/Z/Z+Z&Z $Z(/Z/Z-Z!%Z/Z/Z O/ZO/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/ZN /Z/Z/Z/Z/Z/Z/Z/Z/Z/Z !/ZVV/Z __.ZO/ZO/Z/Z L2C3sLD /Z/ZO/Z/Z/Z/Z&Z#ZO/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z /Z/Z/ZK/Z/Z/Z/Z/ZU&Z /Z F O/Z/ZO+Z /Z/Z/ZO/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z-Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/ZOVV3 0/Z__*Z0/Z/Z /Z/Z/Z/Zp1sP2 M/Z/Z/Z/Z/Z/Z" 6/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/Z/Z /Z/Z/Z/ZO/ZP F /Z/Z/Z/ZO/Z +ZP/Z/Z/Z/Z/Z/Z /Z/Z/Z/Z/Z/Z/ZH)/Z/Z/Z,Z/Z/Z/Z/Z/Z/Z/ZVVL __^M=/Z/ZTQ#@&/Z/Z/Z2C3 -Z/Z/Z/Z/ZIO/Z@-S
9B     ? c$
k*6
mc8*1P0
0
 ! !b^< @^#
`"  d	a; 0Y    
I >.H@&y$ـ`,>$>!EAg/BJ @  -Xb	K ZI'mB$ j8!]ha	̈́&@R ~c0W', - Y- =PX ~P y5Q%5^_#~8+.C[H8C`	O @%d"#CF( N% ؏'	`{# wE9@ Ƣ( [GF+  /# } -+vk+ [P z P%Bmc	o	b	y`	 B+ 1@ : IR# (O6 i љa8(+ yh"6 -(, !%PTၣ" PT PaPUÄ! A?-'A.P]h=1,.'a5c
51-^O1]k A+`0U 1&ccA$hыA3_	d6eaWWPp4V10SX1
w*
OS"|S1CSS !@=" "0"
TSASpA
S Ab6ASAN$/)SSsBF }`A   ZtS@\ZS<S# 	/ A&SrU@4=@
6@`]bM ZS= oڛgJ	=& GX4 a	SS`s яf:pHVSASA&/-S'/
S~  s`oM s'X+SqSm%HW.V4@yˀfLDSV~(jZz% Q6  So-+b{6']r  J5 ! S<S.- X+fc._!o# ]3V2hhh	 ``	{7#V
] )Ve` ) AySЀNSRS SVSWSW^SSRAS aC.S2Gw.P1PQ/Sp.p!cqA.1RjBb2ycox6SCnc"`QV11WiPDSSoSd10?
u). $OjQ%S# T/P$2V#sSrSZ'΀GSȄ!o	~A`3 ya9 @`sqS c).ΆK@S
o	V/dÂ!v/# bbAy9noWcPAbb	O %kbAobMuaJM   k  夏+. 񣅧,
內`6tUᩒuZllŮYSS$G<   a    ̝     VID2Upk  ,BIBM0 76129552ք??D04/25/05,16:59:13   :Sg d<@	
o FGL M26-P PCI_EXPRESS DDR1 
HP HoustonAP BR12755/Rel9.10.1.2/CL173812   
YOU HAVE NOT CONNECTED THE POWER CABLE TO R VIDEO@RD.PLEASE REF` 1'GETTING oSTARGU' FOR PROP HWARE INPLLATION.(C) 1988-2003,  Technologies Inc.  ATOMBIOSBK-!VER009.0001@ 2    config.}h $  Q F,@زRSV  Qp 
	   	I|
c	 ? ..hfPfQfRfSfUfVfW555	#fľ(4tf\fL;u
f^ fN   SfPV> >f=q)rf)f- P  fD^fX[E9 e`4@4E 'u 7l~l%LP.	.&fP. fXt f."f_f^f]f[fZfYfX˃F f3qFRӋFZÃ>
 u. fe @B  | 6u~@Iy@"o ȣ$o4oFoPMIDF@      R1ff@XEACUu0t.:&*u$<u f Z O JY^uut* _=uu313=˯$
< u
{!
<u 3,
 ^Ff
<u V
o<u@&0S Fcfk
fF3~  .2Y
<u8
uǻ u u3N7
&'&
  f
< 'TYF
 ?
uK0#UE5@4`(F   kw M	F ,
]	aF _>_>T>P>!	<u	(f
f	<uD
$L"q<u6 3$
PL
Xp  0o
"
<< 
u!(  C%N_	 %>t#L
 %  u6 m$t+*u&
S~@lϥZuq	5.8 <I
eR"DD:@t;rH\LPLfK/
)
Kf 
f#fD
Fu	`1u
P+^)0 ]N@]Y%// âV`Nf4S+a Ā/V qsfT
f?f
[fY
tf< 8(F xNgu "
$bCQK4 $A g
@!=/Q!
$
Y	uG <#{
	ޣ< Q7,+
^3f t߀
  tL
 t
f߁   Otea
 
 
.	%@Pɀƽ @ @`̀44B<4y#ÀP$
X$"
؀
ߊR
Z"

Sht5Rw	;	<Ȁ
[W T23q	
	dz<1uJ7U`]1AڦȀ`f 
<Q-f   ?f"FAc%	ucSQ   f&aY[1& mʋЇȎU0k!2vV^F. b0u'n	: 6ugRQ@@t 》Y;vȋZ{;А 					%΀	u+;rl^,`rE
U
AnɰGBpًߋÀPt t f0nzpS R[@ Q@6YC<u#Q#)4 $ ))$pE)<ur*3"<u\,uw( z]W  };q?<݄P u.Qk Ȁ騽 E0Ap kɩ  `auJ$0M``M]F0u2tS0	u(bQ{$P%uMSQ{D[W%  8fXt&2f%f
f7Q~y"BI覞S
 uo!uDz$f-eF {u(o (eua~$G` (Du 'r
 u
's BF 2䰠f "u
@w w?D#<P,<u&M<&U
<+'
u33u3 u3Au@?s@*Cu"&
۰"(˰3tf.9tKPtS0u'[.> u2w..pܿ. 2 βuKtC;w	K+ڋ+;ru;w+Ë+ɿ+Ҹ À UV+rEw;vMx +r s߁ pQ3^]ÓP1~XP RfPa$ffXZRf  2GQ  ZÜ违 躣 Cu{詃k ff0 nf2P fXf[Z9f/QfPrfXYRQASR>_pf[Y"y6Q";_$5uB軦F
 L7ptTYfXPfgo\#aa1E ;F { ffR 2: 'w `*eDXRhEv z  R
PffЊfZp;U@3VVw BF
@3]Ѡa@ߋVVpFZ])Xf``w	f09.
f` U 0Q..Y{1(YÊ0 $?n Ê$?p[}Oq,zC@% 
0~  ËqA!68|& pSP3Ɋp} X[S	 P F ! 1
t1ްȇ`w9% `[P%
wpu	Á~P? <0Nthf%_? u`-h ~LE\ސ3z2`3 !$>#)t
t
|@vit
#@1j  (-.${x' S=4v ^8p6kt&2S t,;DvDu@tQ
Y@	 0	t
֓
S苰[QSè 
u[$;3[tw;0Yf%P EDq  @A1t
D
d8t-N[t|A  t!u7t2P0+oDu 
$9p	  t	 Q
R
PT
U
NS
P
pU
;aVDa@b^ 0fti @8qNc4* P86FF x/?D j8Ep t~p)vqtQp>s
pt(B?v =f / t{06m1D$<vlRAQ  4!aI0 ))_rp<ȃ菉/P +B }
fR!V!Q! _!X!/U!E p  p0*( (Q\f@ 3@TF,A,'   ///<+6O  ;Q
̃!0N p12 ɈR@j"`
9tj Ŀ99	P	oFf(./9 9t^97A	Q1=c
&s((y(@OAeÑx=Gu<	{ACwF GYP f?up8-GuZaAoeE AW q_@	E

?  { 
A;O?1=#9e9u"66 3O	,R)0*07@	.O	c  q t!(5o" Jo'8`$SR CTt$
Z[pPS
~[ $rta<SR[$<u<f-3a M9%s N:  	N0&	A'	PF
 9&'V拜a!^ !#%x'P*(- 0250rt"/ES# EpY#uqPQ 2s9Y"o$bV3ɪ@q0`u$"<tg:uLT[3t/ tJ
u$<#u 8<2 ,<3{u( 
P& :Dt LT
^~   @Q Q AA^
1 Q Q # 2 3 %!L ;t	!DP2L^PSQR%$ȸ  ff3fff3fZYf"[ðd	[tC19вVqpv)f^L(| wC|
 w<d(63ɾĸa:tLƟ.FGxDP
E.D($tE EQ  aZ 'UWfV ^p} D[+< ~ ( :@t; Tt
ߊTp0uDdg@ufV Tt'Ou
ЀTر b^ KVvSAc[
ڋNc]fQffPfs `eCf#`KfXU M~fYKC=Kf6mqJ3QϿĂ L0z $1ww I@PS.tL	lSQ@Q  @QR	 PR  + KK;rZXÜ2C @0p V> vp  	!  32Ĉ&! ^`HC3BBaaĹȿ papI ƕ_qt 5o jQ ӟp> 2anTÐ76[0p*N^+ ܠ@P@S;R"蟜 [:@ 5@t"S` [t Q`-Q}7Y@T%f\"f\$f	bt%i  Xt2?UD@		(G S-8fVvQ p9q	z
0ۃ]Hi0OD3fF f@ PBpDpDF' ,S15Ms[ A ]
5@)@FF[h1  },  #(-UQR f3f^f\~10
 Y^dSP-PX[tt;s0ÀFfAr-FesDN;±  pa2of`b\R@bFcDRff;rF2d ffa ffñfkd fef_d   f	f@B 1hff;?ff+@'(ų
fٷ^Pѱ+ZYRPQ0YfX upSajan@ۉF0a ̀2OF3ۉ^^F^f_^-ʀ-qt
  PF ffX v^;w+à xwF  3ɋF^N y Ffˉ^@8fF^A[f;v`.F
FFF<p/F
"7V>v
V@ċ]s
` fF N"  ' <7c^frt@`nf$Qho"@ "ff+f;Fw4P^ ^}0vPw
r N}%Z3,Fȃ
]QRf=0u  wf=  s$S9f18 872/[SfA*r39 /[U5t+  H rd 
4B3tMb1@1u
B Pw/
-?nNS6 [케1hSQ#"yQvQ/[$;r "R[;rL;DHw2Y6o=1`𴠖
>}	2Qt9Tt(& G? Ot`u
t:dGu5(@;Lu;T
+u5c
pCc/.0S03f\+[df\
#g[qD 7T H  r
Ot&s0
w;Tw`}f UfWfVfRfSfQџ <   ߁fPxf3f=  \e<  i  "+X&?l\#4}`ۋп3% tE
  t;|6 ! u&<ufAh߃f˳ @ 2 \A3<w
P@4w	XE~   @stH3Z23ҋ2
Dj9f@kKl@ٺPxwf   qt.3v@A 2
f1t	fX `XffZf^f_]H18t
C? uf[$%6 n2 Pi1 tPfY s2f Iq"_O"C>	3Í]-`ʀ$<G@<u""?Ë2p
B<t;$?<$_& 33''Í\~33 t x$ tu3O"Ouǀ  	}@   
>@
	 } ~
    p qq% 0
 X<b 8 Kb H1 !<~ F Kc  EsAKH   ~LO$Ь	 Qy ϰQvu޻pD޻ ޻A	@sD޻&޻PQ޻ {uP _m޻	@Aa޻ X޻O߻ f!&'B rqf Q Y񰀻ߠ!G$zY55T55586 +0
 $4\Pfp
 @ݿJasBX	 ? $ʘ 6ʚ
[ޣ*1N  `u@.X@1
 ʝ
ۓ1CNB  PP !; "?^u).
 @ e
ޝdr5s 	'\L
+OOOO/	? ̋ @<u2sCÊ7Nu2= Nu\333tp @tU Uqr
À
UU _
43ôP!$
VEЊ\)^{d$y Qt   @3pVE2۹h s 	 v}@ Cp^   ^4 s.
,FuY @E@  Vp 		 PƊ5E:Ht
;r23Lf^SSff[$
4fRRQ 8WYZCBES ٻ ٳ?DQs1ٳ1>7ٳ+gٳrٽ[0'u# ^u 2L)7 @u6An슿>u)#u"Z`uQMQBpZyYu#0!It
2	u *zur $nY 0Т@RQߖteP
ia29{t`
vuKOeu:!ṯt*b@
t <uIu
alc
 u-+S#
F19	r PpgXCᚋ0 10QfRWSd$uouhuau\	uT uC< uy  ŔsuBfb| ѳۋǴί[_Ya0[]ucu\uUu @1P/1rmup7uF}-3RV&w  &G&G@&G3& T֎ &	2$r	v,t?SuO&Gu&ѿg&W
 .1Dq=ÿįԯ^Zp=	D&7&4	&_
&&\^[<<<<==< 
W،q
|@sy'  Et\,@<wS2A
.O`<Gw6wvG`$2	G&	_G+_)B
&WA y- ,1_&wG G t 5 1?&D sU ;v 2T; "3O&)G 0 P+  >>>+?>?!?SQ! u!p @[s"_&r1-u^_wY!>P2WL20WB3:&O+2 3'_oA^Y|__# >07
?=F9$"" wT9r<G#((ͥ"0RL9WE	뤧DF=!H3#G#a?h2Ko&_`#2HJ&!G&W!O>"SpTgO9Atq_SPմQOPwPO"23p3T_?30
QRQOЎ&#k tH$ ]f0JW
I,0Ke%'8UW"T\19J,0	r_PdpW&	0[	@aZ	1_,!G@AT
ڲd/5
e" W"2r??4		`	!	! `7@F W  Pp9#-
 oc)7$p'<QR

[#~6	0	zU""D
Q	)'D
UQR&\$2q3D}T+\%A12DTi00\@NL`TBW//(.%׎\ЉLcQ3@8;Gu
&;Wu[(Z1ruWspj (Z2OG((,(CUMYF8FfV~FFCoC&#G#t!<!1?юb<?s&OB^CA#6ZBዠAQO0OfO]0&Wt k eFg%k/E#EE#McntAd\W"s	/K//k~<ZZt[<cu3`~f;W
uݭ0,u&_GgԯDsTһu@  g`]@Àg'dEt g$	p&mV8DbFXdyֲ+
2< tJD&W)34T2 A
 {&RW&&*Ɛ
G a [!$t>b~&:G(u=@ȉ7w__c4(2(0$u 0?8S3>PD D.؉F؃? V~ʀfF  fF  F  F~ V ^tx&EȰA2	2&E t3Pđ̅tA˃1^`cb 60v^ 
0		F2ߵ f ? _?f  r} ^f[uPc
^^̅t3-^&)qF3 2@ tZ ~ tp2f_]Рw&T vq`,R.@-]%4/#0/"_^Z΋ƋtH@؋tÃ| SQN0>"8Wb!C]$PBUF!B A7B%ŋfZ
fPRWW2;2VwSa2sËK 0ŃY|髥2K }SB_)d_
݋؇ӿfڀSk2U_Åp- 5uf	Lg/%	`Rи 怋oV--Z]`]˸NøNøyJð,ð2ðQ Q   @22ð*AëQ ( <}`] fPfQfRfSfUfVfW < u^ <  <@: <uL^ < y  <	V <u;NQ <P@~
T <pP <	u	w<
u
~ Fc<0@f@T<u
1RC<52?<uh	fV< 

?	OAE
Ff_f^f]f[fZfYfXP.أ$o4oFo  XP086;uF` 5 觲X 01.00 VESA D  Acc
	 0dP U                            Q? ߃f3fP" OGOOO "(PtL <O2 QW _Y EE@ E@ 1a+YfEQMUEEEE@ YQPY/
?uQ%.E` ! "~`#EpEE  	+ 
t@E @W Gi
 " # <U I`
tPEE g EE.EE6E E7E!E8E"E9E#E:EE2EE5E4fǿE> ft
(2O tT
utOKt@P
@	)$t"   !Āu0cJ 33&J &&_Q ` Pb Ib&L  Iy& 
I@ 	

  0 yU 	 2} U1
Nu'u&$<#u	<2 
<3 0
O øO Q5Ytr tt:tJU44&04QpحtY t. ( TR 8Aw3ۭ1Yt$t(t,t)t&t.P[` Ρ * Œ 0 ߺ24  ' D;fC0, 諻- Ѽfaq	T	#	&	)	0	@	*حm Ё ? yQ	q  8 pJ0	f薽0	 蝽舽肽D
LC
p@

  u.
;|v-m @;` i c'uau
ʑ뺀u(PʊXP3 ;wXȡ&e
u#sS 輻$k[  \ tZ: t*S1<^@[u A u 5W`RSfP? @] WfX[ZÜp
 uDÀtOɑfA ppffǻ "» θ2Q2ɊjHfqϡj3ߘ f  t
t<@O-̭A8P.gf Ffn1HB6W81!8{謹f&4蚹 =.AH !C03t?ʲ<z
z& G O5 ;Lu;T
u 'zC  &l,Vzű
t /߻ `J% 蝷A$t N ?D .OrE8uָ o _T u	B 蒞a2 kU:t+ D	L$1 t@tPڷ2%t%Ą`Cx f.!L";*_
ɱ  w>ۣ ~
 :ǳ R>!Q3}  i
ٱ2Y,`u "Ǉi3S[
tQS!ж#PXYu
ƇYpUu/2[o 8
 Ͷ #Lā w鉰Xu6	#wK i1i	QN u
	
f΁ u٦- {» px  u>$u?@ʹUY/Q_/uu0 zt `3WfHrBoTPX.^N^̞_cMJbq^' A7u"&Pa;uX체0&GԱ} OI	8AS4H
[u&.+X&c A6qVX葶t/蒶 4 C{Eܶ44ËF / # O 6S
` 02&'C[2SФ&G	A?Ë#PuEq߀t&FШS{P2&CЧ34t	F[1720
ûg
} 3@Jau"$<~&<t"<t<t@؁/  'uCp@ÿa/a  @
@@ b #@23tb
-toq`q-tq$SI0N2.ae&f[,0(0-0)0*0.0?)0.8%u.]3>Ч;u3+}uC>t<I @.>+3u0<~&g73 3a00631_u`q  ]q2u2豳s5uK<u@ "@ 
 uݕ1'0 '0Q PD8P0
u$0<0u  &o6@A	ut	
t0
߈ )P+V봀1u_
t !Qa9 i3u< ?4u<`ZAG@QCÐl6u& <t	   B"
ϳ 1J0% ^N 菌  (-2 $8?  $(-28?%/83.*%')*,##%'*,+*))-27;974234551,'/0 433258:=<:98899:741	
	
   

	

O		 

  a r 
:U *   **Q p   ?  ??Q r  @   $$$(((---222888? ? ?/  /?? ? h?'?/?7??1 7?/?'h--?1-?6-?:-??1 :?-6?-1h     1   h1 ho1 P,h     1   h
1 
h
1 ?
h
//( 	 c-'(+ Q1 Q7s1;p9 3 P _OPU
(	@ A   
C0	@ T:(  PW W K
0(o MM](
c J1 pJ1  
   
> @QP 0VU %@   bk  O
 B89:;<=>?
$*
G$WB'k+_B,/1  4 	  
  ,     
|%( (,%*26', 49$,0	
!&.3+0$8= (,$(3c $&va'.  ,!
( 0HH0 ( 	H 8H
8@X j X!gX8	X@T`nMgT<	T:f(XHHH( H* 4
$$ < PXAX@d	dPAhPg?#Bo ?+
 ]848tX$v& c Ãf;uA  : F   P  ];ÓSRƠP >cu/p@ 3ۊP.B.EQ J &G+qt0 ck<8t<?tkB]IP%@].@*0Q` d `dl Y @ 3\ 	Q- 0YpX[2о2p0F ._p  >bpÜC
YGS G@~~|ֺ| |8`8| 8  l  <~<RÁ7 ff 6xx~~~p`>>66f<ff<  >qf  f {; <f8ll8x1~0P[ \0pp0$fwf$8||s|
<<a lllrll  l ~| a0` 8l8vvPb P``0y @ 0`   caa88 || x" f<| <l |ƀD j|  ~`!B alP
a01 P 
  ~
 ff|ff f< ll  b`o|`` 
Mr < p  `b% OƁ|tְ|~Zsl) ll#<  P
| %|| -0x|~ `R   `̀ 6000q(v |8 x`flxlLd l ܢ-| p%| '| 06p'(Ɓ *2
v 0dG 6k1  8 v4plp;5 |ƅ8y8
l8|'!f|ƃP/&&00 %:l~n ~ހ1-7 0
	'!r~`l`?fl fEK>c8c> >Wa<4  ټ ,+> >`gc=  G0`2#`?#: 0|6> l<~61F ? 6ll6` l  "# U# w# rd  6 P P 5 `ROqPd[J@UQ2d770??0 a066 R9˃ a	
 R>     f 9xWeb]Pf```p_d~̀Mi|pv܀=8 Sl8eT(r(l`"w8fj~C{|q^ 8`T`/Paa! b~ Y f`[ ps x ma ʐ<<S2tflD8p&mp%0t| wqҁ၁PQOlEcFl pxpq5aq 3Ԇч >6`vf ~~`>~~>ՂR2$ P {p4?`||s 4S
3 tu9_2`!@ AH	P!3pxF)bqfwP0v~m	ǰ {16879
 G-3a5әA0Pp| @ѓ`;Ҝ 2#a=Ғ~B C ҥ R`*ҤљނtPa7`p0iQ.f`d|d``
`ζL ӥpRp bqP
 xp S	 	
qQF#a`(L %4bL~Ec࠵ 4-@z0a6P6rFl q  a  	PS$j b[6 qb
 P$=bX 
TO5.  'Ma0
A оcs\ A Ug^t"{ ځY
0x"p	# 	$@%#Qb  
#p
 
%	"Ђ #Da6f0Prʀ 
$ 	% 	 	C	JCdw@`1|cc0cД~	?!	8  ld>BPP<@ WWd! 3`p3 B< ;8>dp
` ~0]Zwl^l Q6>6n6@s&t؅D + f 5ڿZ E d

Z  Ӥcgफ़ cb
d 
d5e全 5ek 
c
eq ee:%
 

9 =3;1N Q1>b0i2S$|ҏ05Yap<``<f	(`q|  t0^0v  3 ј7/AX `ix /x8#	?~ SY/(ҡ sP2M  T"TpYV!" tWrX^"f<<fDY3Z\Qmy pf1hwf  Iy$0 Inq    ts | >>j^
Ë3Ҏ&&Ϭ
į&PSSUSSSQRPtFW2@ _/&&M. W@
&FG_&E"&E#W:_&]%&}&It2.2
t@' ) = ~=^~=~=~ &U*&$
$

0B$
	-0
12;t4&w_t  Upu`2Ԋ%+Fàt6@ X2 ø  t` :t0?FË هPuB>%C ܊J 2{  &GF %7G @GÜQW+& &D&TAα !	ʑ  p&
&TA2 [PD_ 	 I!?_Y` GQW(6(5p 65r ts | :&?_Q 0
G@6D	?ĸ 

 2w
P2	2wY?Q4;G4~vn"f2^Y /4 /9EPJJ  B2B0 XJws|?VBB~F^ú$
Ĳ@`  t Q%P䀀p;;$<~&G3u<#t<2t<3tP	u&IRtAcNb  P3&2JGq IGLq ģ`XR23Ұ
)u 
Z`N.
 un> tgp baLP>bP22AQJ2=QRP0
u 32ZYYw2ߢ XaZYYR*8}2.Zà؋!+m 2Ku(W S
u
P]`[+сÊ2+**&߅R9  @/ZHu}U
J@B Jå"b1 P#Ԩ`X3d>I#t(q 2t! 3tQt.t1pd  Q@ !
+ .J
u8~` @sC<0t :Jt. ` S +!*2~+uX  u*tX⑰ `u"㨀t0 ]׊4"
ވÊ$"ð(cр g !O$%D
m݁  +

,QVW++    e_^Q"YԊǊ*}_ S8v2QY2P  t (P
RS7P2 PL[[ZRРJ2ZË.  03<?& t
uV EÁ,ņߊ!O&J aZ5~	 [aw2RqZ 7L0 }
+ȴ@A
t
2&LP zW >&}SjcظU`T<t
K<Ut2[o
 6C%A`A2+Q+++YZ0"ƯȰ+Ջ+Nu` $` t  2tatB8~
td\8tX΀|0I~D*
u
8t8`t2
8~
~Ȁ}RtɊ*Ŵ
^!NQTt
w拄0['$j谋tPi"t
wwyÀ|t#GZqKR2#Ze~<RMHU9Qpw@ @ AK+>+r,+Z 	f"+RT7t|S`ı@ (&Ѭm +>u@F E&   P !V1GO+>2u	&}uƀtGVW_^t##ut~>|  ?2 	1
.qh|Z`+0w{!?  pjr,`u
UoQPЁ
6JX>2D|`BQ> CS O2PpoFfKu[3cdT)!o(|=ϊTSUku~jGPbs> 1KXPk$6| 62 &ti߰U؊PPu'U#ëNp &Np>Xr ì.1%   P I ãÀt&0@ "?   ì&O 8r2pÊ02fQ ]fPfff_  ~@JpPbXWQP; sfGufXY_Q@*IY+R3ێ8t8t]ޠ	ZbG1b*u　PuoP[/ .X m,Vي0 7|7F0umXPRJWQo2_`8v
TaGYY_]g[KZ_G+B;v
3ap òθԣct c0tu&fP - f tf$߀t  
SP
St to&   &]X t3ĴI@\@G`ĀݝdtkwcL0[A`.uA% |%{%@ÑcĢ<H`yX lbt1?tx4Rl)N"2"J}~`_`3s Ԋ2PI<
vJceu34RxǪA8sYQԚOt u <
u:6u Ɖu@e<ug<u
t22+qt++&eP>@@ڋ?@@ *ޢñ.#t	O3Ɋ0ʰbxwF Tb=8uuq?pzN׉V`
IB^bu-PD!Q̊.AJt.;t$.
DY^#+3*2<PRs;ZXt΁<t`x =u<s .}f! AY] # @%IB}tÆ^;&~`D0=&}# 2 0<뵀w\0$&e߀ te  ?02Nx~2q0aJGP`bZ ËQ&5&m&M CY\$1N0^>u4?@N  v &5&MLq вpXq48 ߳ ^{s *TR  `[V9 WPP;PY0 d߀2|@XRZSںA[ SBB  s Ȋ PQuvX$ ك.
*Ȣ$ߣ<t,1m<wPSPRI߀@@	 tv@=s=s=|s^=Js ZX][Xa`<t<tˊ~ @St[`Wt@ 8 < @É.| ~ ÌȎ02.. 
*@ ֽ6qʽIy1
uw5߀wx&P u͎..(.{HF
FIy6q6u6yIyIS&G&g3t"<}A
<}	q-<t
<t
&G~20' [ |ྀ ֋P$"3ҹ <u`Ȱ  3 "|utw0_
P`uÀu
&~̀R@SR[t (22QŀF t  +YsuAPW>&}t0&<t$@G Ȣ&gE+@!_X@3 _tG8du&2.Q{̐tN$
J	޵ ȋӸm>/uvt_H & L2ܾIt
6yt<t F0J>=&]&M&U&E
ސP>X}21PSQR.
t	00ZY[XpD|S1zP5[VQS& <
@<
t2~bZ' t&^ E	蛷rꠈsP+Piu w	bt2SU% ][ X[YZ>:0.d* B
e^F<u	A g ?.:r2@.] IPÆà$0<0tu` tq
2.;twq a8~û f CtPt!C(Կt0.nPt#  P 2       ?     @ t
$#K  1 (-=	x'/2 f
$Aa 0t$@6QR1%,Rxu#Pk=@Xv$tHxuPs$f3zifû @k$u*d 2, i- fV Fi ki|kpvp0fQ !k # f jg u1Zj$<vFu t:L'tO(`P0XXZXejwu
w$  wtVx^:t	Ou2ÊLo 		     
& *R 
-#F ` 
. &w>V-#7|I_^ I 	pm  $X  H[_΀
@K+j/

c{c	k 	z	[ , -  
v3P[z
 1	F :   B+RI4	  
rU b]/Xo`b 
Z 
Ap 6b/ďjc^`%
	 * s  	+[3
g{	6 	!	jr  &o %b{J
 )	Se
   
 * `V
	j
U fq lffpFdv
 fGKe f$e@vMPfPu t	st M;u	  n! fU 4  Α^^_WÐPfR L_.ff2ffGfOfRSWP? uDO@T  ;PB@u-f ff³f@P <Q&֠D8@EfX2fPX_[fZÐQ u&Qj UP2AYi$K jY~WVSP6]fS%PY3f ~q[fIf0
A@qX {  pn u&A`up
 uf [^_QSPǀt7P2sPp&`\u@6	2X[Rf׋f PX Mu" $ 6M" L# zMg" Tn$ #M" L# W@/" ?# ;6<n<	=C=b==%>n>3?x??=& ?@<m  F p6I   L01@ 0dA dA@    CC   @2F @ *   @D @    @      ^^^^^^H  H@   t_G mEA    @I I@    "J] @  g WG@   ] ? U_@׀  U    I A /B /B@    I NNOOO	O
O`  OOO"O'O,O6O;O>OAON1ONL¼  켌  &0<n!Ƣl  :V  r\̴,hptϔ  к  TԪr  ՒJV  ڔN>   ި@  2 VDO	
ηpԸ@  BD?"(N0@0   "pF   < P rD%F@0m@ ^~ NUn%
U 0q` 
 
	$  w <( 
HH( }K
8 
U0H 
 
	
U 0q@ЪX0 %j<} 0s8H qgY 
80uXx } 
H0P VK}0y@@ w
U@x &p d	U<0 1p w 	U+0L
F ~`  p [
K`0 ($
U@ `a 0*	$K `p < @ :
Uj 0 *
<4
K0=
 xx 
+  0Up  m H?	2<
+D
A
`SF
O	Y
U	  r`A O	8< `o e
K	@ pq AU	<< 
@ p
K(
   h[	@<P t
KY `
	؋  `C B Pì	IK `'c @d F N 
 H   @E2  8  F     , @5X3;P4`4	 0@ 	HR0 H?@04 @ ЗCK  
	<(  t@t@ 
/P
	R\0  N
$  rO@FJ
! pR 0`
  + _	1W, , g- Whf h i g  U l m k  ,   #~ @$4p0$jU	 #
 20 3
jj
jUU
U


 @ 


 	
3456
STUVW
c d e Uf !
" 
#	$ 	ХDEF
stuv
    
$
l  / -`@ 5y r P (`7 v FE >3K8-@X <
 $ATI5b0	@ k 	@&	 Gp   l)w.`W`U؋[R 43L_ 3@}z} )RRGR4@R
` R``% 
% [ P70B0Su%qC   p
@qsC yIQ%!?P
f ; Op\  @_TPAT XT "TT  @[\Yu `T D  
e7  OO p  44  ee 
L 

Y 



	 C@\ @\ \%  
f>MB  D$aL%  ~@
 @FB, R7[$  
p_ B
B
Y $V #0
c OOQ 3bDeK4) Q@ R S siWXpYZU[r`a b`cPhPi l m$Aq IqB
e^ 0
|R#Q C$  A@BC CI% I
]I
!aR**q 2
H.
Df	 ?

I= [|G F&|T(^0|BAhC_ J
J  "BDi %r [uF B<a  `яP)UQb B &{+0R!*@ Y "%""Y /`
!IY HY IY LudkY R[Qa[N%o [ P+ R<`EJ%T D K D. `%%%
D2 %
Q
%Q%

eV  9 !>@_b e Cfq 8%Q` QȑB" c c ZZC % s "
 Q
[	N\'	
b ;4QP`R<
H `@
wwDKo Xq
%SQTzr b  3e - p
 
RR=RRR@R;RQRH[F Z=G ,
 U8B1c: c`c}GN cU\ cc cjpV Cn Wt  S3	`
e=pbD @ I @	r r r C@% aR#% RA%P%PWp@pinPg[ L`]
@@+ I@	,q r -*@* ,!*B-ΰ[>"*`n=% I* 
 
_`5~C= o
 5[^.%Q2J%_ D#+QV  @A7ABQ2O%$WDJqr 0ե0]@Q2[(4alamQ n oepQJ%P ; _lm@ n oepPmlmz@ n o[pB%`
0`
 0f hI0 
C4j
iIB e$CJ7$}@@7%2Qʻ%$0  y
5oP[X!I@|| ?Aq	%A>%A0D p  Dy S8 f|!2AqA20]|A
A@
A  6#@@̐ j|@ @C8sAs`|Pgc	
A/Ar
I/pV"

V0rI|f Y|[!W^[f
-< `o P?`M\BCepq0  [ch3 I. P_%`
3pZ5l%R[\ 0 R

@w P  gP[ 2 k%Y& h    AA`E?
e fL% P\
 
E П  j dA	%p>D=~0' IyC~ 
j 
lQ k PF##U
% % oP #P
x #	e >@ I e`M Wp@_@I
5݀0IR 2
"[6LB! c* c 0```$o
ߴ [` [
%0` [<&P 1 \%dA$}Ae C;0[)! C#`=0G p D[ C =\ 0C(@ 0[X Y0T [`l@` 8|`
@pdp(xe p[!qа_s tZ uv0vhT wRG	F	rp D(9"@  [P
fDP-  [Dhe@ |% [RF!q߯ C(q !	}>P\P" v! P "P@"@P%"ץ-qF `%C̝;>TT Z@P { 
( " <e#
b,C
X 	[(D   ?
%0 f$
  	 5r$    aC P@6 P\% $   ^% q- 9"Ѝ `s^p [ 
	&pHѴ@0P	@TC f & ds 'қ/B
PPa7eY1%% <w
"AN ap`
`0  @`p  @-Ls@
a=($ Y!$  $` [JD((	'I` J
 I=@W CB( 忣 qP ߡ P
e C	2o9q  0,  	
 >  FiP^P\pwC  
 PT >   FX`b߰ 

	 @	'!
PR3 Fr9Qq8D<PO AR#P  K[fSp__ [R^ U!;
` l;J :)&o ProC: i `lǱp[0@[^q%
 p pL   
 
`\ |  J\@V P B0 cbt ct!yG H0W>
Ij @P0 I @` 헥 D-QR#9tg`[ *p8pC [.! `5 4a 3Q=DT  
"I@5abCt01]81
 _:@ 
 3
    ` J
=I P?  Gu4P  B 
S0DaU-*#"'W
VN )e2?@ L}m@ c @ 
!Y C낙 
Ye-" -e 
apV 8P@Y
U
Weacd[!.T ࠉR8 H1э@d`d `dpY1W V_ h cq c	`P\e C(  % u	RYq# =q2&1&
0A q]9Wc=&`c
BcYZZ= I5 CpeP q0,?   ;BB:2o@`.11! Y  f -P[`   MkD ' w!P Ix 
@

 7p
-U rc88 eTIQy [ 2h
p`] [ $. 
P!
 
a& 
'P0}>܃dp HQPl@ e   @[g6od
oojgQP	HJG z K
   M JrM(<
hǀ LqOK%D{  <П +/<
ʀ \SD` \ @zɢ\%o  j lpFjl Jm I j l02efqX Aq
%jv@%l;  mq q IF0P `qCP qe` P0-- 
O%pDvG -e  @gP D	JD - n"CP>@t  .ϲ6
R  - > [eo `"FPIT @ qj r p s$p  @@Vp"`2-z  R%<%E0QRn`6b6@`@D}`e!GD :W6@ WU -e%$ '%  010&p-* & `0T.9 ~!1Il V "~e W R8 =eIoP$Q!%dqP0z?1 ; `Q   ,",*@ 2 :`3`,PSU(;zoB:c c`c+ c7> \7 > D+ p C+ `>`I+ 2e-% !e  C@ ]![ !c KDphBq`נ&"v$P-
BV21lIS C BQb623p D Q
Je$ I `@eT !$0}e%
$$1`%	R	 #@+&B{!r,52%e 22D,
pe w[[[`U  [ +C a a  [z2> p~H) !l|C]0uA`
 Y  !@a-@
  '@@!@
@ l`@9rBjz' r ϥ!! v!
@R"u !W% 0p=00Zp1> IWIf '
@  sIy"^@w[ ar 7 rR& (#  F,  QFH_H I@ J K L!Ms N @ As B CSDE3FGP3UQs UR SSTU3UVWXYUZc[\C]u^#_[ AX"! M6 c p&3 Pnl"`0@
 %3`%0p=DK@e 
k R\_% 0|Dp{ 
"" N @ C1*0*0,+N%3D1	
	
>
I 2	7q "Saw0 0 
 1	
|1Iq!	@!
 N73@p/@d .  /./Q'AP @
@ 2Czp 
g2 b'
"@M3J3 93 @~%00Y"3O wQ
 [W DА` e [`  [              K     
    	 HPLO_BM  vp }( J  0_   i O O  ! P d ܊ ,̠  ! $a&"  , ߀  "K$
  (   π/(!  
//KA	 	oo+ "ʩ`@!
*//π,a!/// #//& (&ooo  ooo%#	1bd35D4  7a	*΁*!e9
!,`11^"<* d 5#0
!( &=bGD`	 >a>>@.ALMZO@XPAMB%H
  +@ @;@I Ta< !L  ]o o o o  o o o o o o o j(a)Xg j k rC*i\ b (@t :(ng`  YϠ)!v;& plb@mc+ͩxf_
z5"`s"^d" BA @mA@0
aAJhA	  h&hC
|@eB!|Nj u	?  A=`	` ;B@!@~x@Ebl p"B	 0AZlf?bA3A3 Gޠc`\!`~@br d^@ $ L !ZZaM`͊cgI`	XCa'I VA&v	 $
TB&!= @a$vDR 	 $A A$!HP` ~".. c!Nh{".ͪa".0 bDL lg2g0-(@2$2AJC7 4$7
͇H7  @B-*Fv874gC8?ܤͧD@{:@6 >mϊ<B>> H@HI@DH87@@ H BXH
B &íU'>D (Bb;DS$M*Ë`	N,~@"X?IUY
@g< CaX!Z
`,gXBFaZd	JaZ"M   Kb Xe@ Sc$
:@ Vc 
b%
`R
 gH
 X	uf!tb
A [o ^aaehE)*$o
k8b-h)e%+@
ke$ϭf@y`z0: /A#@Bz1!>
1 ☭1 G.Ni?00 .OYCO 11oPgPOPGP@J"" /0'P ', ,PO0&Bo`#PAMP" oǡ]GD0a @P@PID1V a$ /1$@}aA_@O P  g MJbGb  LpKbKy@Iu KŃ $a"A
.$$`$a !$a  kë#	A!Aˢ$&᥊"4@ @*VD A&@!V! T#3R,1`+ȡ'·Pm=e<@ѡRNԀEAÑLA֥XL&WJ
bHߥeHcu#tF#Ј!DĊD~ kBCދe!<!рKT&ad#V"ⲁXBoBZf	@zb0Q\&. ^h!d,.(`Ԡ!&d0@!< Wf`8A!!h"ܢKD'lK"bc`pH@?  dv#K@zA" 
E~Cm     hΠa^h @!%`
3f|C
`' `A@ Gtaz"́Fxcp
`%
AAcAybfa@A`#dtC"d`'ޠ*~pB"db!Pf  UUr68DTV   BIN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    戰 iys谂 f    Q?sY 戰f
   ff    f   tf ff
  rfBYi戰Yf3gC &f3f   戰 fHr4f f戰䈰xf戰 rfFf    戰戰3{f  f   f戰fSf[f   f   3f   f  戰g&fFfCg戰{}s 撰fPfSfQf   fQf3یff
    xfYsfYf[fXSgu
  ;u[fPfSfQfRfWf   f3یff
  	 wfBf    f3g}
    fg
  r%fG;wg}
  f_fZfYf[fX  fffsf fsf f
   fffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffыf~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   ffъf~fsf~fsf fsfffsf fsf f
   ffff~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fsfffsf fsf fffsf fsf Ⱥf
   fff~fsf~fsf fs f
   "fT   (fsf ff   fT   (fsf wfD   f @(fsf [(fsf 5)fsf )fsf c1)fsf MG)fsf 7])fsf !s)fsf )fsf 7)fsf )fsf 3	)fsf 	)fsf 
)fsf F
f   t*fsf c
n&*fsf xX<*fsf 
BnnfLg&nffOg&fffsf fsf f   f   *fsf f~fs*fsf ef   *fsf F<|*fsf  6*fsf j
+fsf +fsf -+fsf x=+fsf =f   tV+fsf f+fsf of   t+fsf h+fsf +fsf S+fsf +fsf &f   u+fsf "+fsf +fsf Y&,fsf ,fsf )'(,fsf L'8,fsf 'f   N,fsf <wb,fsf 4 f%"f   t
f9Agf  ,fsf {ta$f  ,fsf ;Ef  ,fsf Df  ,fsf    Iuf  -fsf f fsff   f   f   P-fsf tff Ag&uf-fsf &r8u:-fsf &u$f3f   u
ffuf   tf fsf   -fsf 0<|%f0Lg& @fLg& ug&  fOg& f   tfOg& t&f   tfOg& tfOg&wf  t.fsf $f  .fsf i-Df  .fsf rf  .fsf 6   Iu f fsf   ffuf
/fsf %tf   ),/fsf $8uf   uffuf fsff   ftLt/fsf $f   t$<t)<t//fsf $ufffff   uf fsff   ft(
/fsf 8$<t<tfffff   uf fsf   t8f   ftF0fsf #t"ff   uf   tuf fsfffsf fsf ff   t	f `  f    f~fsfffsf fsf 2f   f   tTT0f   1fsf $t<tff @   f 51fsf "2  +O2._1fsf "<  ff   f.:w .D1fsf "<  .:EvE |ff   f    f   tf @  f;tnf    ffff   /ff   tt1u	f   #f   tu	f   f   f~fsf fs	
2Tff   f
.f   2f   f   ft/2fsf !< t8stff   uffff fs2Tff   f
.f   2f   ft(%3fsf  < t8stff   uff ff fs2Tff   f
.f   2f   ft(3fsf  < t8stff   uffff fsf   f    ft'3fsf $ $t<s
f   <tff   ufff fsf   ftT4fsf uff   uf fs2Tff   f
.f   2f   ft($4fsf m< t8stff   uf?fff fsfffsf fsf 2Tff   f
.f33f   f fLg&f   tf   t@Of   tf    t@4f   tf   @t@f   t:f   t@ t%_f   t_.;s$t"ff   M2fffff  f~fsff fs3f   fu.fftfftfT2.<u f   t2kf   uff   u6fsf uBtt22,߀0Ƿ<t<	t<t<t ߊt0u0}}f fsfffsf fsf f   37fsf <|f`Agf&   f    f    f   r7fsf f    f    3f   ft7fsf Ufft7fsf ;fft7fsf !fft7fsf 8uf Bgf&'gf&f4f Bgf&'gf& f Bgf&'f Bgf&'gf&f Bgf&   fLg& f0Lg& f   8fsf <|g&f~fsf fsfLf   f3f3ftr2f   t8fsf Qtf˰8fsf 5<	rIа9fsf <
r1$,
	
2g&	ff   xf3ff fsf   f   f   tf   uVf   f   Hf   f   f   uf3f   uf   f   uf3f   uf    f$Agf&' gf&	fAgf&' gf&	f fsfffsf fsf fLg&f   fufx_.fftff~fsf fsfffsf fsf fffsf fsf f Lgf&ff~ f Lgf&ffff%   f	ffgf&fNgf&f   tf Lff
   fgf&[ff%   f= `  |f Lff
   fgf&ff%   f=    u"f Lgf&$<uff
   fgf&f L0 f
   `"ff%gf&f
   gf&  f%"f~fsf~fsf fsfffsf fsf f Lgf&fpfffsf fsf f8_  f Lgf&fftf_  f~fsffHfuff Lgf&f   ftf@l<fsf f Lgf&fftf^  f   tf^  f^  f   tf_  f Lgf&fpffHf   tfHf~fs<fsf f fsfBgf&Pf   ugf&   	gf&   f   ugf&   @	gf&   f|Cg&fCg&f   u(f}Cg&fCg&fZCg&'g& @fBg&' f   t g&	=fsf fBgf&=fsf  =fsf  Tff%   f
fHf   t
.f@Cg&Tff%   f
fHf   t
.fCg&fKgf&I>fsf Ff fs侳Tff%   f
fHff%   ff.ffAgf&'gf&	fAgf&'gf&	Ff.f.
fBgf&'gf&	f fsTff%   f
fHf   t UfHf.f.Tf Cf   gf&gf&Ggf&   gf&   ff fsf30t
0t}_.fDg&(_σ.fDg&.DfDg&f3Uf   tf0   0t	fffffffsf fsf fDf   .g&f`fDf   .g&f`[f~fsfffsf fsf f Ef   .@ fffsf fsf Xfffsf fsf f   gf.f~fsf~fs`f Dgf&   f fsf   u ff%   fff8Af   gf.ffAf   gf.f fsfBf   gf.f fsf   fAg&' fAg&' ftftf   ug&Pg&ff   tfAf   uf fsf@@gf&fD@gf&f0Bgf&f fsfffsf fsf f Agf&gf&'fAgf&gf&'ff%   f=   u$f Agf&   f   uf`Agf&@_Bfsf f$Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	f(Af   f   tf3f   uf
   gf&	f   f   tf3f   uf
   gf&	fAf   f   tf3f   uf
   gf&	f   gf&	ff%   ffff ؃f   t%ff%   ftt؃fffAgf&'gf&	fAgf&'gf&	ff%   f
_fHf   t_fHfffsf fsf ff%   ffAgf&' f.gf&	fAgf&' gf&	_f   t_f~fsff3 f.f~fsfffsf fsf f  fffvff`Agf&fAgf&fffAgf&'gf&	fAgf&'gf&	f   t^ff%   f= `  uMfLg&f   Ѓ t3tJu
fuffAgf&   fAgf&   f   tfAgf&   fAgf&   fAgf&'?fAgf&'?f   t2fAgf&   gf&'fAgf&   gf&'fAgf&   fAgf&   ff%   f
H_f.fAgf&'  gf&	fAgf&'  gf&	f~fsf fsfffsf fsf fLg&f   fH  Hfffsf fsf f x_.f   uf   t	f   ugf.zg&'gf.:g&'ffftfgf.:g&'ffffsf fsf f~fsf|_  g.ffu$ff.<g&fffsf fsf f~fshf    uf   t	f   u
gf.zg&gf.:g&fgf.:g&ff~fsfffsf fsf ff   f~fsfAff%   f   g&tfAg&f   tvf   xHfsf f~fsf fs AAAAAAAAA	AAAf$Agf&   fAgf&   f fsfBgf&@@  ff%f=   tfhAg&gfAg&gfT  f Lgf&f   tfT  ff%   ffhAgf.gf&' gf&	fAgf&' gf&	fgf.flAgf&'  gf&	fAgf&'  gf&	f fsf Lgf&f   t,fAgf&' gf&(fAgf&' gf&(*fAgf&' gf&0fAgf&' gf&0f$Agf&   fAgf&   fD@gf&0f fsfBgf&'?gf&  f   tfBg&@f Bgf&  ! f$Bgf&   f0Agf&  f4Agf&mfAgf&  fAgf&mf fsfffsf fsf f   yf Lgf&ffbfNgf&f   MfLg&fLg&fLgf&/  fLg&fLg&fLg&fLgf& 2  fLg&f+`  f3f   tf Lg&uf Lg&fp0 ffHAgf&fAgf&f  fLAgf&fAgf&f{)fPAgf&fAgf&fffTAgf&fAgf&f ,  fXAgf&fAgf& ffHAgf&fAgf&f  fLAgf&fAgf&f$-ZfPAgf&fAgf&f6cfTAgf&fAgf&f =  fXAgf&fAgf&f   ugf.1f@Agf&fAgf&f   fk`  g.1fDAgf&fAgf&fDAgf&   fAgf&   fXAgf&   fAgf&   fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&@ t?C fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg&< t t8|*g&g&fLg& fLg& f~fsf fsf3f   fu	fff3f   t
f   tf@fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&f   t:f Bgf&'gf&  $ gf&f Bgf&'gf&  D gf&f Bgf&'gf&   f   tf   f   tf   gf&ff~fsfffsf fsf f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <4	     <4	     <4	    <4	    ,<4	    ,<4	    ,<4	    	,<4	    	 T <4	    , <4	    ,0<4	    ,<4	    ,<4	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<4	     #<4	    P0#<4	    @#<4	    PP#<4	    	 #   !    8       ,      (  *  .         ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < flf%f  $f$
t)ppqtfFmfupppppq`mDflm{fupppppqf  f  gffLggf^gfnf    f
   "颼fm!fupppppqg- fmffmff  @$f@$
= u$<& f?nff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰f<of䎊fNoff`of掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  M"lfr  A"對 f    < tg      f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽wݰffڰf)f3?ܰf?fI߰fUf_0 f%"fwpfjٽܰfTfHf>f <ݰf&f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tVg&4  g&;  ĀuH g&  vɃ  f˃  G 
f  ՇfaPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀjs>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma          `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fUf[fBfD    2ø     "  @ 04/28/05DVTP f Bgf&'gf&   ff%   f   tWf uf=   u fffsf fsf ff   ffAff~fsf=   u f=   u @f   tfffsf fsf f   t
 
 gf&f~fsf~fsfffsf fsf fffsf fsf f Bgf&'gf&   gf&f Bgf&'gf&   gf&gf&f Bgf&'gf&   f~fsfffsf fsf gf&f~fsf~fsf}afA1Rf.|f.4g&? tg&g&&fAuf   t2f   uf8tf   tfff fs AAAAAAAAf Bf   tgf&'gf&   Rfsf f@@gf&'f0Bgf&'f fsfAf   tg&f   tg&fAf   tg&f   tg&f fsf   uf   f   f Agf&'gf&	fAgf&'gf&	f fsf   uf Dgf&   f Bgf&   f fsf Dgf&'f fsf Dgf&'gf&f   tfBgf&   f Dgf&   f fsf  Sfsf ,$f  Tfsf f fs<f fsfffsf fsf  fӇ.TfH $ttf~fsf fs䠢  `p    P`=P          "@    U    TD  TDU  TD''''''''DDDDDDDD77777777333333333333    333333333"3333"333333""333333""""""""""33333                                                         33333         33333                                                                                                                                                                    333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333    333333333"3333"333333""33""3 3""3 3""3 3""3 3""3                                                 3  3  3  3  3 3  3  3  3  3                                                                	

!#%')+-/13		

!#%')+-/13579	
!#%')+-/13579;=??!#%')+-/13579;=???????? 
 "$&(*,.02468:<	
!#%')+-/13579;=????  	
!!#%')+-/13	
!#%')+-/13579;=?    	
!!#%')+-/	
!#%')+-/13579;=??
 "$&(*,.02468:<>???
!#%')+-/3579;=??


!#%')+-/1357	

 "$&(*,.024	

 "$&(*,.0	

!#%')+-/1	

	

 "$&(*,.0246	


 "$&(*,.02468:<>
!#%')+-/13579;
 "$&(*,.02468: 	

	
!#%')+-		


 "$&(*,.02468: 	













                                                















































																																																











                                                                                                                 "3D  ,          0x (x  x 0x (x  x                                        

  P Q  P U  P      P    P       P    P      P  W9u W9u Y:w Y:w pR pR rS rS ,; ,; ,; ,; 8)G 8)G 9*H 9*H ")+"(*"$fffsf fsf f Lgf&ff uf   tff @  f~fsf fsfffsf fsf 
f  afsf Ű < urf   6afsf $<  <t<t
<t xfNgf&f   uf   afsf $p2<uB >tHH3f  afsf fƳ 
f  afsf *Ż  f  afsf Ű < uHf   bfsf $` < te<t
<t UfNgf&f   uB >tHH3f  Ubfsf ų
f  obfsf Ļ  f  bfsf $
f  bfsf Rf  bfsf ^$w<u|f   bfsf B<|2f  bfsf (f  cfsf 0f  #cfsf $f  =cfsf f  Scfsf ĳ

f  mcfsf Àf  cfsf qÀf  cfsf Xf~fsf fs            D   @    L       @       H         `      T    G R         	 	
     X   	 	       	 		       
H@ ,@          	  	    @      
B  
B T     T    L     L    	 	 D    P   X     `  D     X      P    D    X      P    `                O    O    
Ol`

Ol`
Ol`	O A    A             
  @      I         	04
         	  	' 
 
> 
H> 
> 
N> 	1 	 4	4d	$	  	  	  	  	 
D1 
B1e   @
	 	P 	P0	 	0	T
	t         @  4 	4	 x   @,  <D	     <D	     <D	    <D	    ,<D	    ,<D	    ,<D	    	,<D	    	 T <D	    , <D	    ,0<D	    ,<D	    ,<D	    	 _. U . " /   . # /   . $ /  .  / 	 . ` /  . a /   . 0 /  .  /  . p /  . r /  . 0 /  .  /  . ` /   . a / b . 0 /  .  /  . ` /  . a /   . 0 /  .  .         !  !  !  !     p       C 6 @   @   C T A     H        L         <                    0      4                                       	4 @      T                      d  ` h   X  ?     @@             A   \   Z 	  X 	     ? \   Z 	  X 	     ?                              /     >  	 # @ #<D	     #<D	    P0#<D	    @#<D	    PP#<D	    	 #   !    8       ,      (  *  .           ,   :  8    h   d   f   N U N   O   N  O  N 
 O G N  O  N $ O  N ( O C N 0 O Q N 3 O   N 7 O  N            0           N U N 0 O Q  N 7 O  N  < fmf%f  $f$
t)ppqtfKmfupppppqemDfqm{fupppppqf  f  gffLggf^gfnf    f
   "靼fm!fupppppqg- fmffnff  @$f@$
= u$<& fDnff  @$f@$
и f  D$fD$
аfnaf% = ufnEf fn0f % ugfnfU../0./.fnf d< ufofd< t<t
u掰fAof䎊fSoffeof掺<ufocf  f%"f   2f%0 f
   `"	  "	f  2f@0f  2f% 0f3f3fP  0fX  0fA0fh  0fAfo  vf3f3f   0fAf  vf   f f    0f  f f   0f  2f
   0f    f3f3f  0UNNNO$ONNO$ONNO$ O'NNO$O#NONNOO(NNO$O$NON3Ҋ ^@'f3
fq  * t
^+;w
t@fغ  ff% f؀f   ttf   ff% f;rff  ff ff4g&g&f  $f$
аf  $f$
аf  $f$
и4f  @$f@$
= ttf  H$fH$
и f  L$fL$
а ff%fUN&NN`O'NNONff
   fcfr  H"lfr  <"對 f    < tg f   ff   2fff   ff3~s.7tXf.;|uf.;Duf   f   f30fy   f  f\0ff30f   f3f30f   f   2s{           &l                           e<sQɺTXm:NzpG6p)dngC:@yk>Xl78t:#j'LRuuͰpW10
	-7g,L:2ս]̡0@yi-v5n1Nc}~k!xyQ#gcK9GӸrgFQnCρ3W+HLYŔAIΠ
Cf:hBZ@]>WTe,uNHmtU4nKl$`n923sC&8>O).J5:4~+3ʱ e4VA.pUųo5P>	T#rJ$2ܩ`/[n۴>|EM)fm@vb۟gG&1cy4XYֽ6ٞ\hD|a,VeσaxPA33Қ}N*?X剣<;L˘.LmQ;YwŐj/XY7^^A 2̊[k6o%YHpLh[]ETxEOI[)qΤee<=rl%_ڿ4iUSϗm@RLo<˒0#h6U|,̴*,
{'K;*ͯ;^)2`xU˾*Z
_ِGUV%7on[nI'^꯽v&٘alc;̨%(%oGdqLq35?_
Q*W?jw߿&j31DI
jVe)LUt
)|X\*{]p~	XEzK9Go7t2=$Cv
	V+JL^3I׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE        "  2Wm/                           b&+kzڋXFF[XP(+QcJ}{J+LibO%-!X<E`F?0$u<*kDg6p-7).2/GhqXP],pHuїS*p2!9+M
I:ǁg#tPPɕŢ>9??
>
)/<R06xtD->:~=hyoTSՎHOPX꿺"< =mҟGi 7qiEs6Rdbtڡ2$fA
D͘ wP6{sJS$M-5(q{'Vluv!0߉XG.nrb	Y>g*cQ}·]j\^yz3-c7UvY@,GVHrgR.kS.j5cKU˓ƿf2z?b幰o<&17jVMpr+oPbf8(~jsFyf pU~{]|eN3}T]ۄ(li*D[.a߬.2/fH&?ǝmKRM؃s)	*3D*ߡX9w;)uM ,Rf%`)k2yyvNzYXA#[ߟYW4d+Z?~xHTW(}T
K5@{z)O$k7,Nг.IL~]5:zuހ`w2M`^㳇UgoV|Q]zWvj
٣+@TxXäFn]g8gbL1">/H9g]L~~׽4yalUG96zb]Jɇ@$7,F"#s](9!O՜6[~J نufbbH8%΀\0e51|m+u =zDD
`;5	pAWIH]գ)X!p!FԋR:{YLcGE{p\ f,)={C%^u6Zpr0B0=rol+,si~|7xNKޘ' O**Bs
4-m<`,: v1ŒK
p[^nr6)[eU=B㇏MﭴOp	6OߜCy)RURt.%;r[*TbA9ƼtGa!PBxYVaV;o\oNXGN!_{3J
3/i`lX9aՌO'3UMcBtJd|.1ƉHcT>h1.011ilÉL3Cbk0V,!L<S:p~)Tݮvq+~0.%@:eSϏ
-Gc#('S)\S:s~deߛ&{޳]uTLemd𸣨F|m_2)svԊK>,@~!.(i(ȏN.KݘOԈ5{Z }@MU1 !/
X,-u+#~T]!Td<M)%zqP};uxR{ßvq[)M!X4, Ad?BND2GB5~J3CP";v7hT.3Ua/N B|d휯˥-XX]pYRE\\H͢"'#!F}0FI _$N	hƧϽ`.
ת>⫞:(d6cv箨dP{q޵,m_;+恑~!j -k&>O^VthE                                    	            !      p     -           i     p     -          i               p     -         8i         8i  (      8i  0      8i  8      8i  @      8i  H      8i  P      8i  X       8     PR 
 ZXPSR  C vZ[XPSR !Z[XPSR  C v
 !Z[XfPf   .>u	f   fgf&Ef`  ffgf&EfXfPf   gf&Egf&EfXfPSQVfWf   fgf&D= fGgf&D=F f`  D$
D fgf&D= ff|uf`  fgf&Ef_^Y[fXfPfSf    f   fgfdD ff   rf[fXfPfSf    f   gfdD ff   rf[fXfPSQfV4 f`  fg&Ftt vugf&>tgf&6f٢ &fE ~f^Y[fXPSRfV tA % g&ƅ    f  \g&  	uf^Z[XPSRfV tA % g&ƅ    f  g&  	uf^Z[XPSR     qZ[XSR  zC vZ[PSRRZZ[XÃ<t  9    (PRt)t<ZXfPfSQfRV%"   f3۹ f   gfdT gfdTgfdTgfdTf   "UC v    qC v^fZYf[fXfPSQfRfVfW<v PfUffJf  ff   ffŀ  $f+f3 f	3f7fff]X t fff3 f	3f7f  ff+f_f^fZY[fXRfŋӃf3ӃZfPSQ  f¢A vY[fXf` f;.t
f.   ~$C vf3 
 f    fgf&E   > uF f˃  gf;tgf+gfkf0f  gf;tgf+gfkffaPf  3XPSRfVg&ƅ    f   <  f  g&"  @v@ g&  s f  > u&g&.  ug&.  ug&/  uDf^Z[XÃ t                       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Ԋ    戰䈽j戰䈽|ݰffڰf)f3Dܰf?fI߰fUf_5 f%"fwufoٽܰfYfHfCf Aݰf+f˓ܰfדf f
   `"	f   f3f30f  0ffuf   f f    0f  f f   0	 f%"fTff.Ԓf.Ȋ f"  ؎ f%" 3؎ f"   ؎ f%" 3؎f.ڒf.Ίcf  
'jf  .<t.<r.<	re ff.\f$f.< t.<t.<t&$
."D.
D$
.#D.D	ff.#D	f.Df
.T.<t.<t(.<t2.<t
.<t.<t"."D.
DQ.#D.DAff.#Df.Df-f.|.<	t.<
t .<t4g&."D.
Dg&g&g&.#D.Dg&g&	gf&f.#D	f.Dgf&gf&
      PfD   FOUusO M 6
Z  >MrfZgP  P ( rZ  .PZLV>ZMZfQfD<>Z3ZfQfHfHrrfHfDf>D wfD   >ZZfQfH%fHU3fHfDf>D trUf>D wfD   >ZZQ/>ZZQm>ZdZQff   fF>Z=ZQS,>Z#ZQS>Z	ZQfSf ZL >Z ZfQfH'fHUr$fHfDf>D tUrf>D wѰLfD    ZM} >ZurZQd>Zu]ZQRZ	 D>Zu=ZQN/>Zu(ZfQ 'LZ]  Z>Z	rZ  KI	s 撰 Xü˖){ۗ+<ϘݘfSgf[gfPfR>Ouz.fZfXfSfRy$$8u4@fZf[P$4XfPfSfRf@@
 >O u> 5xzytsfZf[fXúz.yuksfZf[fXPR tĺZXfSfRf@@
 >O uB ;yM@t&s(xغz,y0@u	sz.fZf[Ru	sZp     -          i    p    8-        8        8`        8i    t    8-        8h        8i          i   t     i        i`       i       i       i        i`       i        i        i   f`> tSg&4  g&;  ĀuE g&  vɃ  f˃  G
f  ؇faPSQV0L	;t	 @ ^Y[XPSD	%ÉD	f<t[XQfWf    gf&D=     f_Yf`f   g&D5 f6Ƀms>t fafWf   g&D= g&D= f_`r r8 a`f0  gF
$&
gF
&sw>taf`f  gF
$&
gF
&s@f  g&|5  t>tVfarfWr<f_    f`ff   g&D= (fgf&T=fg&D=rL6 G r6QfPf   f> gf&D5 gf&fff>fXYsufa`f@  & gF
$
gF
f@  sF>tma             `f   $f$
$0f   $f$
Њf   $f$
$3f   $f$
Њva  f
   `"	f3f3f   0fffP  0 f%"	- ttu! o-sô ` uR Zt s+R Z<u+R Z<u<uR  ZfSfg;xxf[ú          Tf  ?   f.  +   fB     fV  j  f   fHt	f쨎tf<w' H$tt
f  fPfSfQfR8f  $f$
f  ܺ$f$
Ћf f   g f   g fZfYf[fXfPfRfS8 f  $f$
؃f  ܺ$f$
Ћf[fZfXfWfUUgf*gUfUUgf  g'gGgf_ZF֥`F֥fPfQfW3 .;t3f_fYfXðR ǺZR úZR źZR ZR ĺZP4R Z
 u?R ZR ZR ZR ZPSR Z؀ˀR úZ/[X                            0 ] YPS㋇Ģʢ¢[XPSQRW0  3=  3/  3!_ZY[XPSȎػ    	   !    A   f   $       [XR Ģ# Ƣ1 ȢZSQW   l_Y[SQW   W_Y[SQW   B_Y[    f  fp  fPQgf0& YfXf    gf~gfNgfVgfofPfSfQfW<w f./
tff_fYf[fX戰fffgfˀtgff Uf`fVf3f3g<uf   gfnu:жts
gfNu&gfVff   "Ȁf+fgf)^f^ufafP	 f%"fXfP f
   `"	fX           .<t ø fSQ >Ntf  r	f r[fS  f[r^fSfUUgf*gUfUUgfUUgf*gUf[g0f@p   rg<uf   ⃸   Yf[fS>Ntf  r	f r>PfSfUUgf*gUfUUgf[Xgf@   T r
g8u   f[                                Q  YPSR+;wZ[Xf>@ tf@tf`f  f3f3f3f @ gfffCgftftfaf@   f@uQYfVfSfQf
   f   fH<rfHfYf[f^fQfWfVf @  f   f  gff^f_fY               PUN
NNOపNZtzXfPUNNNO$ONNO$ O'NNO$O#NONfXfPQRUNNNOO(NNO$O$NON䄺B 䄺t	 ZYfX   fff
   ffPRZfXfPRZfXfPRffZfXfPRZfXfPRZfXfPRffZfX     戰3ظ  м{fZf[fGfD    2ø     "  @ _Nf04/19/05DATpMZYY  @  
   _             
(      C   
  `  C            P  
          v  -  Q  t  c  Z                y  S  =        {"  u"                     ,
 ,
 ,
&  &  &  |&  Y&  )&  &   
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
,
~,
z,
v,
r,
n,
j,
f,
b,
^,
Z,
V,
R,
N,
J,
F,
B,
>,
:,
6,
2,
.,
*,
&,
",
,
,
,
,
,

,
B  A  A  ?  ?  ?  ?  j?  D  D  sD  B  vB  ,,
,
,
,
,
,
l,
N,
$,
,
,
,
,
,
,
d,
F,
(,
 
kO  (O  O  O  N   
\  \  \  \  u\  _  d`  `    G	,
,
,
,
  v                                                            3Ðj茏ː
  F  F~ F F^Z9 uvfv%}fvfv%~hH	h jKRP蟊Vtj
fvvP輋
hH	h jL`RPrVtj
fvvP菋
 Ð3f>\  tf6\  f>  tf6 
j ]胃  Vh jh jth jih  h j]h ~3F ^v&v& =d t" -!  - tHHt-3 teH  L  F^v&v&8 ^v&v& t^v&v&   T  T  P  T  N  >T  uT  |H  J  mF^vf&0hl ǀF^v&v&8 uNV  ,-f t-
 tHHj- {- |f6B jrRPfjbRP芄jRRPzjBRPjj2RPZj"RPJj	RP:j
RP*jRPjRP
j
RPj]NFF9F}-^v&&?-t^F&&?/uF jYZ=sjvtRP蜃j]@YtjwURP}jt]>V   hH	h hl bFHFuj fh  ! h(
h4豈f6Ffh   h(
h4tbz f6FXafF    .^	| ^&04^&4F~	vF  Fz 9F|F= t= ujRP谂j\BYXfh  j l\ ^ \ ujxMRPujl\i
>R  t5C  Xt( !  9  =  A  E  I jJj1fj   ujxRPj[t(`       ؎f&fjvRP豁j[>P  t>R  tZ  X  L  >Z t>Z u& & & >Z uuD>T  u	>L   >L   >Z u3T Ht	HtHt8j uwjJ-ulj?j.>Z u?T Ht
HtHtHtIjj AȐj3u+jRPˀjT HHtH
>T  t7>N  t0fLA  hLhLj#}
>X tjJRPr>J  tj \ZhD  F >D >P  t>R  tZ  X  L  >Z t>Z u& & & >Z uC$~ tfj fj ,F  t=HtkI-
 -!- - - 
tFf>  ~  H    6 H; ~    ߃>  ~   H  6 Ĵ &@u  H; ~     6 Ĵ &@u    FV^& &G|&Wpfj ?d     F >J  tE<KD B= M- K- '-M- 0- )fjF6>J  tp
j 6X^ÐU	^&H&JÐ  F f fF     ;Fu;Vt^& FFԡ    ؊F&ÐL"N
z hthLhLj=>X2  fFffFf+fFFPj ff-    fPfvFP~ uf~uF    ÐfFffFfFfFfFF+Ҋ*FVFV;Vrw;Fvfjfv`TÐfFfFfFfFf-   f;FvfvSFVِf~ t3ÐF+Ҋ*ҋN^+ډN^fFfFVf9FvRPfSFᐃ~   F  FF+; w;   ӹ  ؋F+NV&&W     ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP襀
3Ðfv T  Vfh  P FPՀfLK  FTzhthLhLj}>X t3^ÐFPTwBFVhH	h FP@~RPhvhH	h fv$~RPhb vfvhb Hv ^Ð  F4F(
L"NFTFzhthLhLj0}M*ÐU~uhH	h  Ð~ fh  `hH	h hb YFHFu3Ðf@    
f@   ff9@sVfh   f6@fh  `f6\ Iu*u%f6Ffh  f6\ Z= uF&G
 tf6FX놐f6FWA~ uhH	h 3a     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP~
#fh   vfh`  j f6\ r
Bv  WVH	~" f~ thH	h FPRt~ FPu3^_hH	h hb WFHFtj ff-   fPf6Fv
f6FjFPu
f6Fx~ uF.~uF6d 8Fue 8Fuf 8Ftf6FVkFPh`Rf6FU ^_Ð~ fh  G.hH	h hb VFHF
f@    	@Bff9@sTf6Ffh  f6\ V= XF&G
 Kfh   f6@fh  `f6\ )t!f6F>Ufh  `b^_Ðfh   vfh`  j f6\ \U     ء^ +\  &&W    ؋F&  &G    ؎f&       ؎& 6 h(
h4    RP${
FF> tjJj1j f6 Z{jhH	h(      RPz
6 h(
h4     RPz
     ء^ +\  &&W    f&        ؎f&       ؎&  E&  FF܌VF X   R   Z   fL
S hLhLj^q
>X u_>O@X RfLN  fP    FޣtFܣVhthLhLj%w>X t>MuR   hJNu~ tZ   Ft
F$p*Z Ð&  VFF܌VfLD VQCzThthLhLjv>X t3^F  FvڊB^& Fڃ~ | ^Ð>H  t	L&LZhthLhLjMv>X tjifRPs  fh  ! h(
h4xj=RPUF  @ +FHuF F^	&4,x(&*(h(j*mVF 9F}j zĈf<t<uhH	h2 QUÐ  -= t= u%F  F~}
F
u~|3Ð Ð>X  u#jIzRPrjJjRPr3ø ,x(&(h(jUh~tuÐ  fh  u3fF    fFfff;FvEfFf  `fP!IFVfFf  fP	I;Fu;Vt>F  uf~t뛐 Ð   j:F "h(j
TjoRPSFF*;s6PjNRPSF*Pu,x(&
(뫐,x(&
(h(j
}TjzRP!qju,jCRPqjDRPp>J  t`hhb jRP-SÐ  fh  h`hqt"jKeRPpjLURP}pjyCRPkpfh  ujEF  h(j
SjRPRF~uJ~FF*;sPjRPbRj F*PNu,x(&
(띐t~ F b,x(&
(h(j
RF~sF F sh(j
RjQRPQ>J   FF*;sfh   Pfh  j f6\ fh   F*Pfh`  j f6\ F*Pj&RPjQj F*PVu,_(&
(\h`hb jRP)QjYRPjXRPhH	h4 	QÐ  fh h`hMt"jKARPinjL1RPYnjyRPGnfh  ujEF  h(j
kQjRPkPF~uJ~FF*;sPjRP>PjF*P*u,x(&
(띐it~ F b,x(&
(h(j
PF~sF F sh(j
Pj-RPO>J   FF*;sfh   Pfh  j f6\ qfh   F*Pfh`  j f6\ F*Pj&RPFOjF*P2u,_(&
(\h`hb j RPOjYqRPjXgRPhH	h4 NÐ  F >Z ut~ thH	h< hH	hH FP.hhH	h FPKFVu3vPfh  f6\ |K= s^&G
 tF  fvPJO>Z u~ t	hH	hT hH	h` FPghH	h FP	KFVtvPfh   놋FÐ  VfFfFfFfF    fFfFVf9Fs1fFfFfPYBȋFVF  V&^Ð  fFfFfFfF    fFfFVf9Fs/FVF  V؎&PfFfFfP4B  F .u3tF f6\ FPy0F~rhH	h hH	h< IFVtvPfh  f6\ QK= s^&G
 tF  fvH~ uj/RPLhH	h< j!RPLF*  F xu3E-t*t~ thH	h< FPej"hH	hH FPej#RPFPehH	h FPIFVtvPfh  f6\ H= s^&G
 tF  fvG~ tj$MRPK/F~  F oh(j
LF  h(j LFj$;F~,x(& (܊F*PjRPcKf6\ FP/FF~s#~ t~ u,w(&
(tFPFPj%RPK~ u~ tjjgRPJF  F f6\ FP).~uPhH	h hH	h< GFVu3vPfh  f6\  I= s^&G
 tF  fvdFFÐUf6\ FP.Ð  F u3F F~s7F*PjRP*Jf6\ FP<uhH	h2 JhH	h hH	hT FFVtvPfh   f6\ BH= s^&G
 tF  fvE,x(&
(
h(j
JF h(j wJFj N*;~,x(& (Ր,x(&
(h(j
+J~ ujRP%IhH	hT j!RP
IF*  F u3t~ thH	hT FPQbj"hH	h` FP<bj#0RPFP'bhH	h FP~EFVtvPfh   f6\ yE= s^&G
 tF  fvMD~  j$RPIH9EF ph(j
IF  h(j 	IFj$R;F~,x(& (܊F*Pj[RPGf6\ FP:FF~s#~ t~ u,w(&
(t~ tFPFPj%RPG~ u~ tjjRPaGF  F f6\ FP9u3À~uLhH	h hH	hT DFVtvPfh   f6\ rE= s^&G
 tF  fvBFÐUf6\ FP9ÐU  
2

 UvV>
Ð  >
vVF*^&F^&  >% 
FNÐU
U  À6
U6

Ð  F
+F@FFF!vvW	F>

NFF@;FUj fvfvà *P Pfj   FPNQ *PfvvU  ÐU
% ^&
*^&ÐUF
F
Ð  >
FF  FPNQ *;F|	F>

 F@PvYÐ  ~ ~
FPFNuU
&PF^&? uÐ  FfFfUN  F  tF FÐ  FFU*F3t- t U~v 3UvtF2UvtF*F= tFÐ2F>F 	F  iÐFi  ~ t	h7FNuÐ  FjfvFP]
F FPNQVRhH	hl ^Sab~uvvhH	hv fvaÃ~P|FlFFPvvhH	h fvaÐ  FPNQVRhH	hl fvavvvhH	h FPraFPNQVRhH	hl fvavvvhH	h FP9aFPFPs\ÐUv'RP\
  F  FFVF#PFF9F~FF^F&uډFFFÐ  Vfvfv[fv$\F
^v&  FF9F|^v&  ^UVfvfv[FN^v&8 t&@ ^fj <fh  vfh   !j;RPf6B [ *+IQj f6B Ð  FPNQfj vj ivvÐ  VF  	 & FF  @	 &ğ &0FVRPZFF9F~FFFF9FFfh   }vj,jvjj}F F  Pvv^	6 &Ĵ &@t2j>vjqj+jFvv^	6 &Ĵ &@ F  F j 9Fu
F F  ^	6 &Ĵ &@tF vv}	 &ğ v&0:߃FVRPYFj kfvF9F}+F- Pj j Bfh   j.jFFF9Fvvjvj5jjF PF@PiF Px^  fjLfh   ,fh  1F  ^ 9FuFPFP%fjNj l	^& 
ރRPj Gfh   F 9F|vÐ  FPFPFPFPj  *Pfh   ij *Pl> tF^fvjm݃FVRPW *+ȃQ *P%jj fvvvvv9ÐUj=fvhW 
  ^*&G*&O+@FFPFP^*&G
Pv^*&GP&G
PjF- Pjj^&7QFF+F+^*&OP*&G
P8^&7N܃RP^*&GP&G
@PjrF- Pjj[j^*&G
 F?*&GPvj)^*&GPvjjF^*&G@;F*&GP&GPvjF- Pj	jjk^&w4^*&O+Q*&GP)^&w>ۃRP^*&G P*&G@Pvvv*  V^&7F^&wFF;F}F FF3FF^&G Ff&GfFF  F;F}FFF^*&G;F v^&@u؋*&@Fv&@tFF;F}FF^ۋv&0Fv^&@ tF&x QF;F}FFN *+F-	 FFF&GF;F~FF F~ tFF;F}F;F}FFF  z&@tF&x tT*&@Fv&@tFF9F}%^ۋv&0F ;F~FF^*&G;F~v^&@cNӠ *+F+@F *+F+@FF&G
F^&GFF^&GFF^&G^*&GPS^*&G
P&G	PF@PF PCF- Pj F@PF P"F  fh   v^&@ tfh   ^v&0׃RPv^&x U*&@Fv&@tFF9F FF ;F~jFPNQ{^*&G+FPj FFv^&@^*&G@Pv&^*&G*&O++F- -FPNQ^*&G+F+F- 	F+F Pj v^&@tj[&FPNQFv^&@v^&@t*&@Pj j]FPNQe^*&G+FPj Fvv-F^*&G;F FPNQv^&@u&@tF- Pj FvvFv^&@^v&0Fv^&@ tF&@VF- Pj 
F+F+FHPvG^v&0RՃRPF- Pj ^  F  vfvv@ FHt-t-9t!- 	tFt3ø Ðfv  V~
؉Fte`fh  j  *P HPfj
' 	6 &Ĵ &pԃRPf~ t
fvd~ tv
VF
~ tF
^UF
Ft^&G% PS/fvÐUV6^&x t&@u ^Ð3^Ð  ^f&GNfF^&G &  &Gt*&G- *&GHP*&GPj9Fufh  jjG^& tDfh  yj +FHu
^&Guʡ+F@u
^&GujjA^*&GP&GP^*&GPj ~^*&GP&GPf~
 tfv
z
  V^f&GfF*&G
P&G	PF   v^&@ ^*&G@Pv^*&@PFfh   9Fufh  lj ^v&0)҃RPFPNQ^*&G+F- Pj ^*&G
P&G	Pfh   `F^*&G;F ^Ð  fvFFPF  VF
FF;D}DF;F~FFPvP~ uF^fh  {F  F= K [= ;tV-tH- - t	-	 t&NFFF
9F}, NF
9F}FFFF9F~
F  F FDPv~ 7
FDF
FhFF9F~ÐFF9F~F9FBFFFNF9F}F
9FuF!FFN낐F9FuF
9FoNFFF9FuF9Fug< uNFFFF_F FF0FFFFFPvv5FNF9F}NF9F|uǋFŋFFFF6FPvvFFF9F~FFFF9F	FFߐFFFF
FPFF9FzF9FFFg- DV- - -  "- vaF
2P?%> tFFFF4FFV= P)%-KN- '-  - p- i-P- - -  r- kmTF7FF9F)vvP^+^
v&+^v& FF9FFF뺐U>Z uFP_!ÐFP>Z u0 ÐU>Z uFP+ÐFPU>Z uFPÐFPuÐ  VF  ^v&  F  %^v&8 uF ^&  ^& *FF9F}~ t^v^Ð  VFFHFF  F
FFFF  F9F~FF^v&8 uvvE~ u
FF^Ðfh  F  F=/5t( =t@ -
t/-" t-  F  F vv~  F	ېF9Ft׋F9Fu< uNj vv^+^v&  먐j*F^+^v& FF9F}FF|- o-	 h-
tvuF
VF9Fu:< tA=H5- ;,- 	 - - P- - G- @~FUfvh[j fvvÐ"   HPh4FP
FPj hUF=
tK-
t
-.t-	 NF  HP*PPh4vFt(=t#= ;t= DuÐ- Ht- t- t- tà Ȣh=htLth=hِ 1= t= ut Ӄ>X  t fj h
N3  F"1 ~ ujQFÐF Df>   FF Fff   ffffN*+;<|;s6F*@N*1 "Sh>h(*F*P̓uF"z j h>h( j̓]FUtKjh̓h(
hb j h@lfj hG=th>h(EtÐh(
h`h(
h~&u{Ðu&{ÐU~ u h(
hjhHh(
h`jh7F  F~ ujFÐF Df>   FXy j h
@h^fh  L΃uF  Fff   ffffN*+;=|;s7F*@N*1 XSh
@h^j F*P̓uF2uF~ u~ X1 F F~sF X1 F cFff   ffffN*+;t|;snjSF*PShSf6\ Tڃfh   F*Pfh`  j f6\ ڃF*@N*1 Xj h
@h^j F*P	̓h~ tfj h!F\  fh  ̃h(
hb !fh  ̃t"h(
h`h(
ht";fj hE/fj hb=uuh?ht!h
@h^tfj hrU~ u h(
hjhh(
h`jhF  F~ ujOFÐF Df>   Fy j hBhdfh ˃uF  Fff   ffffN*+;=|;s7F*@N*1 ShBhjF*PR˃uFuF~ u~ 1 F F~sF 1 F cFff   ffffN*+;t|;snjSF*PShSf6\ ׃fh   F*Pfh`  j f6\ ؃F*@N*1 j hBh#jF*Pyʃh~ tfj hF\  fh 5ʃh(
hb fh ʃt"h(
h`h(
h聻t"fj hEfj hb=uhlBht!hBhtdfj hÃ>J  tj htD D   1 ~ uj߃FÐF Dj Ճub j h EhtF F~s3a F*1 j h EhFPuFA j h Eh|he>Z utTtMttFj t:hlBhCfj hb=th EhtÐ  1 ~ ujރFÐF DF F~s-F*1 j h4FhFPuFA j h4Fhh
또>Z ut>t7j h@wfj h=th4FhtÐ  01 ~ uj݃FÐjӃuÐF D*b j h Gh6tF F~s3*h F*1 0j h Gh6FPuF0A j h Gh6h
c>Z utTtMtFjt:hlBhafj hb=th Gh6tÐUfvhf  |JF.fh. U Lfh.   Kj/KFfh. ! Kj/K~ufh.  K~u
|NJOÐU*FP|PKJ*PKÐU*FP|PKF*PJPwKÐ  >x u7]  FVL;Vrw;Fv	x ÐFP
uh h Ux  >x u
FPh iÐUx  >x u
FPh IÐUFPh 9FPh -j>x th UFPh FPh FPh j|MÐ  >z tRFPh FPh FPh FPh j0 h l<uz  >z u&v*N"FF FF
FPvB|JÐ=tw$-t-| u)~  >~t% Ð~ -t-t t-0 t~ Ր3ÐU+ҋF+  U~ tfh  hh fh   hj fh? U~FPgÐFPtHtÐ~	tHt  ~u ÐvdFVF  F~}(^&@F^&^&F^&8u^&^&~u3Ð  p h FF )fF~}j v`tFp  F~s#>p tFPh F  f+fF볐>p  F  `>p t(^&k^&?tp  FfF~|F~s>p tFPh ;f+fFҐ>p uKF~}Afh   j FV^& ^& h.p F 닐FPh j FV^&^&pÐ
  V~ u jh yFfh   F*+ڒ% FVfFF*+ ڒ% ;V|=;Fv6v0FV^&ȋFVF  V&똀~uFPh Z^Ð  jj	h rfh   FrPh FÐ  F ~ ufh   F*+ڒ% FVfFF*+ ڒ% ;V|9;Fv2~ t,FVF  V؎&PvFu~urPh Zj FF  	& FP*ătFPh(
hփ~ thH	h
hH	h
FP3hH	h FPUFVu3vPfh0  FPLfv4FPh(
h`kָ U6֊FPfh  fh@x h
hl
RPhw
Ðfh@x h`
h?
RPhI
fh   fh  hՃh 
ufh  h j
u  {fh@ hhRPhFPfh  =fh\  hhlnfh\  hj 6lh{fhL8 hlhC  fh@ hHh'RPh1fh\  h"f6lhfhL8 hh%CFfhL8 hF$PhCfh   Tfh  H.hFԃh 
ufh  #h 
uÐ  hxB$PhxBj2ӃhxqBPhxsBhxYBPhx[Bj
Ӄhx<BPhx>Bj
ӃF  hxB$PhxBohxBPhxB`F~|hxA$PhxAhN  fhx AF  F~
}YhxA$PhxAj2ӃhxAPhxAh҃fh  gFh҃~ t  j7j,h *h Fx*FFj FÐUjFPh iFPh ]jjÐPhD҃m$PÐUj
*ҋFPh fh  	jmjҋh 
t3h ^& Ð  F
Ph FPh .jIh 
t3h t^&FFN
uȸ ÐUj
xыFPh bfh  WFPh Kjh 
t3Ð Ð  F
Ph FPh 
0^&Ph FjZh 
t3ÐFN
uƸ Ð  F  ^&?<u F~
}FPfvru3Ð  F  F~
}'fh  tjFPtָ Ð3fhx >fhx >h7ЃÐ  F  F~
}'fh    tj FP1tָ Ð3  F2FFFj2σfh   Mu3j FPtfh   FPqtj FPtŸ   F2FFFfh   u3j FPtfh   FP
tj FP\tŸ   fh   u3j FP.tfFfFfh   fPj FPtĸ Ð  F F~
sfh0   0j FPtڀ~
teF 3j FPTj FPtAFuFu5 ÐF~
s&hQ΃fhp   j FPfu3Ð  fh    j FP@u3ÐF F~
sh̓fhp   ej FPtj FPj FPtFuF	u   F  0j FPZj FPt4F@uFt,&F~
}!fhp   j FPyu3ø Ð  F*
FVFV~  h ̓fh@   j FP)u3fh    gfh    [fh    Ofh   Cfh   fvtFj FPttF F  FFF~@sWfhD   j FP^fh   fvHFj FP\1u' Ð  F  F~
s'fh  vtjFPtָ Ð3  F  F~
s'fh  6tjFPtָ Ð3  F2FFFFN*
NVNV8Fuxfh  NQ$jFPwu3fh  jFPVtfh  fv6tjFV@RPRv0
FF F  NFFL^&Ffh  JjFPrfh  fvt
F^&FF~@rF   $  #F Fހ~
s
I.t~
tattFPu3
 ~u
 @F Fހ~
sth ʃ2t~
t ÐUfvFPt Ð  fvFPF~ujsF  F ~ uFu3ÐfvFPF~u
t/FF  	& FP貶tFPh(
haɃ~ thH	h
hH	h
FP&hH	h FP	FVu3fj hvPo(
fvfh  FP	fvFPh(
h`ȸ SQR ZY[UfPVfffXUfPVfFffXQ YPR؃ tCZXÜa$aaCaBaBa++҃ a tû~ |Ë~aË|aUCaFBaBa tfB  s     t =4u<f  fff%f
   ff  fff%f
   fUfS..^f^gef[UfS..^f^gef[UfS..^f^gfeff[UPfS..^f^Fgef[XUPfS..^f^Fgef[XUfPfS..^f^fFgfef[fX                           UfPS^tf3ff^  f.
_._ "  u  $" u [fX 0!<s3P˿(
6 + r ׁĞsh3P1L!66ƱH666gP6g
P6g6g6&6 +۴J!6
+3	O3X 66666נP.`ظ MaP.`ۚe  y>	uXP	 P(
 5! %J`!	)&6, 		3	sx		 	&, >3&= t4
 t3u!,Ar
,Ar
ª  D!r
t@Ky		 		 		 U3U UVW UVW.Q
u'
8t 88z 		b >	u			M 		S  tX
Pu~ uF  X
uFL!_^]Ë	 	 %!;s
OO
;sEtU P> t P]ø Y+r
;rQ3 V3B 22Ut
 Pt ^Ï  <t)&, 3 3uGG>ыѿ  < t<	t<
to
tkGN< t<	t<
t\
tX<"t$<\tB3A<\t<"tӋѨuN<
t+
t'<"t<\tB3A<\t<"tۋѨu>GB+ģ6?6W6
u6 3< t<	t<
u 
u}6?6WN< t<	t<
tb
t^<"t'<\t3A<\t<"t\Ѱ\s"N<
t.
t*<"t<\t3A<\t<"t\ٰ\s"3  G  & U&, ÌF333t&>   tFu@$F	  RP Vϋ3_I36;uQVW _^Yt^?G^
u͎^O]UVWV 
;t@t3_^] UWvt 3I >	u	@!_] SQ |QP,[|Yt[Ë r3]sP X2]s ]2 â
u">r<"s< r<vטÊ  UWVFG
@tG
  D
u VށFVD*P{|]~ tZPNQ!FFV~\tPFPN
 PvvvFP-tD
 ^_]UAVu3vPvv
vvv|]U3Pv
vvv]ÐUVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut2Dt+;vPSQPt4S$
Y[X+)D `;Nr/3ҋv+SQPS3DPY[t+t,+SQVY[t&CIEF먀L
L
 F+]UVWFf
tcFV^vu!trPSRj Z[X+ <w QPSRI Z[X_+ ;rs $u tN+ȋNʋvF
_^]UN-D
utE FD
ut5Dt.;vPSQPSt4e#
Y[X+)D u ;NrND
utSQV Y[u^3ҋv+PSQPS3DP?'Y[Zt3+;u-3&SQVPY[tCIEu@F}L
 F+] UW(PFPvv(PF(PWF_]ÐU
t]UVWvD
t^@uZuGD
u
uVDutP3ۊ\StuL
 
L
 	L
D  %炀u|
ǂu
 HD3&C_^] UVWvD
ti@ueD  ttXL$$D
3ۊ\uPuuG(t4tLu%@t ~QWS% EL
 cSV [D
tҋT+BUJT$QQttSR%Y|V&;u3F3 t QPPS
3_^]UVvD
t$t ttm&d
3DDDD^] UVv PW&YށtL
G L
G ڍGTTDD  ^] UWVxFF  ^&=w tWw,at[,t33FF F^&? u ~ u &=t t<w,+t$,7t>tF,tTF  ƐF뷐	 uF uЁ @ uā 닃~ uF N@y~ uF fgPvVvv
F}7Fȁ؊FG
+EEEFEيF3EGǌ^_]ÐUVWv (t4t	LuVD
uFuAWt!DTTD E L
 S Pu$[[tW3_^]UVWvt,3ۊ\@t Vu ~ t3EDDD_^]UVFFu3P <vv9 t'v@t^*&GPy= ^]ÐUWV3F؋O
рuGut7+DF~+PttD*P!;FuD
t
d
L
 DTTD  ^_]Ð P UWV3~~ uD
tV@uF96r~uD
tV@tGݐ~uF^_] U츶WV3Rpn^&? u&*t/ppPvvPvvF^&*u^&?%t2XdVZ\T`3jfh~` uoF^*&tfh-0 hȐ=l tw/<Lt!,*t,td\\T,Nt,t`늀T u^F&&Wz|Ɔ` ^& *nt*=c t={ tpPvv
pvvf t
h uf ufhǆrt)ǆrFFV
rt&?^u	@rV  P3PFP{t Ğr&?]t ƆX]rF  &br<-uX t
r&?]u>bXъˀيʉP˳㊎PNb*F؊N6_r&b:Xv^X^bXXbر*NيȀ6bb8^sƆX Ğr&?]t7&? u{u^F
z|vxpVvv!f thht`pvvt>F62V΀ tT uĞzz&뢐vpVvvz|9vu	9xu!T tncu؎& d -uZ+u"hu
f t`pvv
0tpvv<xt<Xupvvx gjxto WpPvv0 Bd u\F -uZ	+t ht f u `xt
ptFt t)~҉~V=Fu3j t,:u!~l+~ǆjp 0 ǆj  `` usjDЙ~f t	huTpvvPtou$8}~҉~뙐
 RP~P뇐pVvv` upu\ tl~Z t
~ Fuǆj  j uT tn\ t~Ğz&&Wt~Ğz&fp~Ɛrt-u6-rt+uhpvvf th]~5ǆh]-hht'jĞrr&pvv\u̓.uMhhtAĞrr&.hht'jĞrr&pvv
u̓j u <et<Et hhtyĞrr&epvv-uĞrr&-+u?hhu$h-hht'jĞrr&pvvnupVvvj u
T t nĞr& \~P|z\P
 P|z\P^*&;tpVvv RT uInC-c = w.~wpsZuZuZu>wr>w>w>w>wJuss>w>wp>ws>w>wr>w>wpRF"pvvo ^F&*;tot|^&?%u
&nuiun uR tn^_]U^t$- ] U^&Ox&&W&؎FF&*S] U~tvvvq] UV^&vvu^] yy4yhyyyyyUwVW3FFv&vF
t~ }F, <Xw$ FF.xV 53FFFF  HF뛊F<-uN<+uN< uNy<#uNnNgN*u\y؀N02F
 F;F  3N*u(y02F
 F
F<luN"<FuN <NuN<LuNNF<du<iu<uu<Xu<xu<ou<ct<st'<ntQ<pt`<Et<Gt  O uumsWN2uOY+bFFt3;F0u296Fu0F R3ҍ  X3Ҿ Ɔ:	 F 3ҍ  MFN@F ~ tF 
guF vvVWvvFt
F
~FFt~ u	WguF u	W&=-uGNW OY+ N@F
5FF'FtF F0QVVFFtNFFt  F@t3F@t}N؃ ڃ~ }F fuF  ~N2v?Ft&=0tO&0A F@t1FtF-F  FtF+F Ft	F F F++F}3WQFuȲ  P~N XFt
FuȲ0 Y_Pu XFtȲ   v&vv&&vF tuØW^&Ox&?&&G3_QRSPsZYuNW3&_tFNW3_tFW
uu30<9vFNY+G_^]UV+FF96r&D
uD
 D  +DDDDv^FV^]UWVvFtG
uG
tG
t>EEuWU9Eu
9Uu} uE
e
&M
*^_]ÐU^;r 	>!rƇ U^;r 	1>z tOF tH~
 t3ɋѸB!rKF
 uFVy( 6VFѸB!FVy
NV B!؋VNF
B!rP U2>r~
FF
U2~FF  u @uwuFV$
Ǵ=!su	 t 哋% = u	>! F D!tN@F@t F t t	3ɴ@! >!V C!iFu  u ѸB!V?!t~uًѸB!3ɴ@!3ɋѸ B!mF N
 N
FuF uV<!sFuF u4>!F$
FV=!rؓFuF
 tVC!rF@u?V C!2ɃtF t ;r
>! 
NË]2ܡ#3ɨuU^;r 	s3N
lue>	u	N
V?!s	Gt@VW^'
<
u&:t<u&G+_^t<
t@t D!  u
V?!rΰ
0F V?!rt~
tѸB! ~
t
VV눀~
uQWGtf t+IAAwtOs	33B(
&|=  t ;ru"rHs3#R. Zs
t +WGw
JBw
_YËGtJwN;v9Ws6BSQގƱu Gt
Ƌ+ÎËشJ!Y[rGtJWWw;w
uwt$OO_U׋~3u~t+A+؎FFuII tI]U׋v؎3~tItI]U׋v~3+t] U~3uI] UWV~vߋN
t2Ì^_]UVWN
F3҃
u~7	UVW
F͋FF<%t
<&tFFFDFDVFF~]MUu}
U^]W~
]MUuE
r3YQ u
_^] UF+F
F +F ]  WVX3V@tG96s^_UVWV~UJ^
~tTO;v7
Q:X7t2)G+SRSZ[t<
tJ;~tG
 t
3+)G3FV_^]UVvD
t~~ }	 Nd
~uVK FV
F  VD
td
vv
vD*P=u	;u3^]ÐUWVFȁ؉NO*N }G   P+PPQFV}CD
u^uDȋڋFV++DFD
t>^t$DTFV^&?
uFF9FrFFuF+ D
u yD
u | u	F   +DDF^t~ Q+QQS;Fu?;Vu:|L~DFN^&?
uFFF9Fw^ t.F)3Pvvvk^GF^t@FF+)FVFVF ^_]UWV(vv&(PF(PW Pvv;u),x((&

V
 PF  FVvF^_]ÐUWVF*LPpd
D
tD
$D
3PPPWw^_]UWV
BFV


T
FPv
vVp
x

& V3P,^_]ÐUV
IFV


TRP
FPv
v
P^]ÐUWVv|96	 4&=}3#tVIt
>	 ^_]ÐUFI!]UVW^FȋFǋt3Gwrw
wr#tmr#t
3rZ ك  H!r@;vJ;v ;s33󫖹 +v*39	tvvv	t9_^]UVW
F͋FF<%t
<&tFFFDFDVFF~]MUuu
~]_U^]W~E~
]MUuE
r3(
 u
_^]U VW 3~v
tȰCvu&6	% uN&6	&	HȰ"Cu׍D&	&	% uDȰ"Ctd&	_^] UVW~3uI>IN~3uI+Vv)vuыߋNuG
F3_^] UNWVu v~VWNxW+ sPIs s AH+#+#@+\u- ؃uь- ȋH+#+#@+u uǌ 뾋FV^_]UNWVHv~H+#+#@+u uǌ 뾋FV^_]UN
8W~t+#ч+ыFÁ _FV]ËNFV~W
t
uy
-ۃ ڋ3t0<9v'uODD;rX_^] UU3ȋ	8t	F3] UFu		u { rFGFF3҃vvډWNu(t$> uS#5![j#%!us厌ʻ 	FV]U컧 .8tK
Iໜ	]PPR.`؃> u		w1uRUVV EE< uF F]ZXXˣ		UWVQS3		 P	X[Y^_]ZXX˃PU(
ء	F	F]XSQR(
2P P/ZY[UfԀu	u3
tuH]U^h! UV		Ȏغy$%!3]UWVRQSP.`ۉ&	UVWP	&	[YZ^_]UF US^v
vw7 W[]  UWVS3F}GVڃ FVF
}GVڃ F
VuNF3؋F8؋NVFuf
Fr;Vwr;FvN3ҖOu؃ [^_] UFN
ȋNu	F] S؋Ff
؋F[] U^;r 	ԁ>	u	 tB3ɋ!rtz^FV3FFWVfN
=
uO^ = vJܺ =(s +ԋN
<
t;t% x
;u 
F ^_^lPSQ+Q^@!YrF;wY[Xß~ u%s	$^@t^^?u F+Ff^_^ӋN
uV@!s	u@t&?u Y;s+3UVv&L^]UVWNwi	tH6		VW_^s+_;uX6	&t	;u΁t΁^t
	r 		39	tv	tt_^]WOOw
HƌڎGG3_&Eu	&]&&u&\&\Gw&]
&]&]&]ASw_
3#[uBSw_;t6K3T;sr#tH;s#rЭtD[GG[Lt	+H+ƌËу'H!r&;v;v3&EGUVA!S 	
t>	u	S	[!  	
u	>	u	S	[! UV2] UVF ]UV] UVF]    (
              4.63  mm/dd/yyyy  rb    .BAK  wb  .BIN  ROMIMAGE  
 %s %s
  VFLASH.BAK  VFLASH.BIN  TFLASH.BAK  TFLASH.BIN  %d/%d/%d  %02d/%02d/xxxx  %02d/%02d/%04d  %04d/%02d/%02d    Rompaq BIOS Update Utility  F1=Help Rompaq %s
  usage: Rompaq [/D] [/U] [/B] [/R] [/X] [/C | /!] [/P xx.bin]  where: /D        = Dock (operation applies to docking station)         /U        = Update BIOS with new version        /B        = Backup BIOS (save to disk)        /R        = Restore BIOS (program with backup image)        /X        = reset CMOS/ECMOS to factory defaults        /F        = force docking station recovery        /C        = do not allow exit to DOS (power cycle)        /!        = do not allow exit to DOS (power off)        /P xx.bin = admin password is read from encrypted file xx.bin  Error: failed to update BIOS  Error: failed to save BIOS  Error: failed to restore BIOS Error: failed to recover original BIOS  Error: failed to update docking station Error: failed to save docking station Error: failed to restore docking station  Error: cannot open password file  Error: invalid password in file Invalid command Machine is not docked Error resetting CMOS/ECMOS  Enter setup password:   
Updating bank %d 
BIOS image was updated from %s (%s)
 
Saving bank %d 
BIOS image was saved in %s (%s)
 
Restoring bank %d  
BIOS image was restored from %s (%s)
  BIOS image was saved to %s
 restored  updated Erasing, please wait... 
BIOS image was %s from %s
 
Recovering original bank %d  System BIOS Update  Update system BIOS  Updating system BIOS... Backup  Save current system BIOS to disk  Saving system BIOS... Restore Restore previous system BIOS from disk  Restoring system BIOS...  0%  6%     12%   18%    25%   31%    37%   43%    50%   56%    62%   68%    75%   81%    87%   93%    100%  Error Cannot write to disk. Please make sure  disk is not full or write-protected Cannot read from disk Please make sure you are using the correct disk Failure writing to flash device Please try updating the BIOS again  The computer must be running on AC  power to perform this operation BIOS version mm/dd/yyyy is incompatible with this update  Please update to BIOS version mm/dd/yyyy first  Enter Setup Password  Setup Password  Invalid password  Warning Confirmation  Warning: new BIOS is older than current BIOS  Replace the current BIOS ?  Create or replace backup file ? Current BIOS date:      New BIOS date:  Update complete The new BIOS will be used the next time the machine is powered up Exit  Exit BIOS update utility  Power Off Confirmation  Are you sure you want to power off the machine? Docking Station BIOS  Update docking station BIOS Updating docking station BIOS...  Erasing docking station BIOS  Save current docking station BIOS to disk Saving docking station BIOS...  Restore previous docking station BIOS from disk Restoring docking station BIOS... Please power off the machine  Press any key to continue F10=Continue, ESC=Cancel  F10=Accept, ESC=Cancel  Please wait Help  Use the arrow keys to highlight a menu item, then press the ENTER key.  Update  = program the BIOS with a new version Backup  = saves the current BIOS on the disk  Restore = program the BIOS with the backup  Setup password  Enter the setup password  This version of Rompaq is designed for newer machines Rompaq is not designed to run in protected mode Not enough memory Reading file... Writing file... vflash.bak  vflash.bin  tflash.bak  tflash.bin                MS Run-Time Library - Copyright (c) 1992, Microsoft Corp   H	                          68xxx.BIN xxxxxxxx.BIN    GKOPLMLHTM               $ ( , 0 ( ) A  + , Z?  . / TD  Z [ D _ ` E c d F f g G '  (
 ^  (
  D10/17/2001  O                                                                           H	 H	 H	 H	 H	H	VH	H	H	H	(H	ZH	H	H	H	0H	LH	jH	H	H	H	
H	,H	LH	\H	rH	H	H	H	H	H	H	$H	LH	hH	rH	zH	H	H	H	H	H	H	H	H	6H	LH	TH	|H	H	H	H	H	H	H	H	H	H	H	H	H	$H	6H	JH	^H	tH	H	H	H	H	H	"H	BH	fH	H	H	H		H	*	H	:	H	L	H	T	H	b	H		H		H		H		H		H	
H	"
H	F
H	L
H	f
H	~
H	
H	H	
H	
H	H	H	 H	JH	LH	jH	H	H	H	H	H	&H	2H	8H	ZH	H	H	H	
H	
H	2
H	h
H	
H	
H	
H	                                  E    F    B j V(
      C    D    B j t(
      G    H    B j (
      K    L    B j (
      O    P j (
      N    M l (
      I    J    P j (
      -     1    + m (
      T     Q l :(
      *    1    ( m R(
      R    S     U   
V   
Q k p(
      X    Y    W j (
      0     1    . m (
      ]    \ k (
      a     1    _ m (
      e     1    c m (
      h     1    f m *(
      o    p    q    r     s     n j H(
               Ta                           _C_FILE_INFO=                                                         (
               
	
\ \                                  1(
  1(
                                                                                                                                                                                                                                                                                                                                                                                                                                              (
             	-
] ]        EEE50 P      0PX 000WP         ``````  ppxxxx        (null)          6b6b6b6b6b6b6b               (((((                  H                                                                                                                                        
                                                     I`I`I`                  i(
(
(
(
(
<<NMSG>>  R6000
- stack overflow
  R6003
- integer divide by 0
 	 R6009
- not enough space for environment
  
  run-time error   R6002
- floating-point support not loaded
  R6001
- null pointer assignment
                                                                                                                                                                        