###############################################################################

PREFIX=V;export PREFIX
VERSION=440; export VERSION
WEBESVER=${VERSION};export WEBESVER
WEBESDOTVER=4.4;export WEBESDOTVER
WEBESBUILDLEVEL=##WEBESBUILDNUM##;export WEBESBUILDLEVEL
WCCVER=440;export WCCVER
WCCDOTVER=4.4;export WCCDOTVER
CAVER=440;export CAVER
CADOTVER=4.4;export CADOTVER
CCATVER=512;export CCATVER
CCATDOTVER=5.1.2;export CCATDOTVER
KNOWN_WEBESVER="${PREFIX}${WEBESDOTVER}";export KNOWN_WEBESVER
WCCPROXYVER=131;export WCCPROXYVER
WCCPROXYDOTVER=1.3.1;export WCCPROXYDOTVER
WCCPROXY_HOME=${INSTDIR}/opt/hp/svctools; export WCCPROXY_HOME
REGISTRY_HOME=${WCCPROXY_HOME}/specific/wccproxy/config; export REGISTRY_HOME

display_welcome_banner ()
{
  /bin/cat <<EOF

Welcome to the Web-Based Enterprise Service Suite ${PREFIX}${WEBESDOTVER}
Installation Utility.

This wrapper script will do the necessary pre-requisite checks for Webes kit installation. 

EOF

}

 
increment_proxy_count()
 {
   if [ -f ${WCCPROXY_HOME}/common/wccproxy/ref.cnt ]; then
   FILE=${WCCPROXY_HOME}/common/wccproxy/ref.cnt
   GR_ITEM=""
   GR_ITEM=`/bin/grep REFERENCE_COUNT $FILE | /bin/cut -f 2 -d=`
   GR_ITEM=`expr $GR_ITEM + 1`
   rm -rf ${WCCPROXY_HOME}/common/wccproxy/ref.cnt
   touch ${WCCPROXY_HOME}/common/wccproxy/ref.cnt
   /bin/cat << EOF >> ${WCCPROXY_HOME}/common/wccproxy/ref.cnt
REFERENCE_COUNT=$GR_ITEM
EOF
 fi

 }    
     
exit_if_WEBES_installed ()
{
  
# verify_webesproxy

 INSTALLED=""
 INSTALLEDVER=""
 INSTALLEDDOTVER=""

 PKG=`swlist | /usr/bin/grep WEBESBASE`

 if [ "$PKG" != "" ]; then

    INSTALLED="true"

      CUTNUM=10
      BASE_PRODUCT="WEBESBASE[0-9][0-9][0-9]"

#INSTALLEDVER="`echo $PKG 2> /dev/null | /bin/cut -f2 -d \" \" | /bin/cut -c2,4,6`";export INSTALLEDVER
#INSTALLEDDOTVER="`echo $PKG 2> /dev/null | /bin/cut -f2 -d \" \" `";export INSTALLEDDOTVER

INSTALLEDVER="`/usr/bin/ls -d /var/adm/sw/products/${BASE_PRODUCT} 2> /dev/null | /usr/bin/cut -f 6 -d/ | /usr/bin/cut -c${CUTNUM}- `";export INSTALLEDVER
INSTALLEDDOTVER ="`/usr/bin/echo $INSTALLEDVER | /usr/bin/sed -n 's/\([0-9]\)\([0-9]\)\([0-9]\)/\1.\2.\3/p'`";export INSTALLEDDOTVER


    if [ -n "${INSTALLED}" ]; then
        if [ "${WCCVER}" -gt "${INSTALLEDVER}" ]; then
         /bin/cat <<EOF

An older version of the Web-Based Enterprise Service Suite (${INSTALLEDDOTVER}) is currently installed.

That version must be deinstalled before this procedure can be executed.


EOF
                echo "Exiting ..." 
                exit  1
         fi


         if [ -n  "${INSTALLEDVER}" ]; then

	       /bin/cat <<EOF


A version of the Web-Based Enterprise Service Suite (${INSTALLEDDOTVER}) is currently installed.
 That version must be deinstalled before this procedure can be executed.

EOF

                echo "Exiting ..." 
        	exit  1

         fi

    fi

fi


##Now install WCCProxy kit
/sbin/rm -f /WCCProxyInstaller
  /usr/bin/echo WEBESBASE${WEBESVER} > /WCCProxyInstaller
/usr/bin/echo " Installing WEBES PROXY Kit... "
/usr/sbin/swinstall -s `pwd`/WEBESPROXY${WCCPROXYVER}.depot WEBESPROXY${WCCPROXYVER}
/sbin/rm -f /WCCProxyInstaller

if [ -n "$ANSWER_FILE" ]
then
	SEA_Select=""
	CCAT_Select=""

	get_answer_item WebesInstallComponents; ComponentsToBeInstalled="$GA_ITEM"

	TEMP="`for N in $GA_ITEM; do /usr/bin/echo $N | /usr/bin/grep SEA; done`"
	[ -n "$TEMP" ] && SEA_Select="true"

	TEMP="`for N in $GA_ITEM; do /usr/bin/echo $N | /usr/bin/grep CCAT; done`"
	[ -n "$TEMP" ] && CCAT_Select="true"
	/usr/bin/echo "Installing WEBES Kit... "
	/usr/sbin/swinstall -s `pwd`/WEBESBASE${WEBESVER}.depot WEBESBASE${WEBESVER}
	if [ -n "$SEA_Select" ]
	then
		/usr/bin/echo " Installing SEA... "
		/usr/sbin/swinstall -s `pwd`/WEBESBASE${WEBESVER}.depot WEBESSEA${CAVER}
	fi
	if [ -n "$CCAT_Select" ]
	then
		/usr/bin/echo " Installing CCAT... "
		/usr/sbin/swinstall -s `pwd`/WEBESBASE${WEBESVER}.depot WEBESCCAT${CCATVER}		
	fi
	echo "Configuring Webes and its installed components..."
	/usr/sbin/webes_install_update -a $ANSWER_FILE
else
	/usr/bin/echo "Installing WEBES Kit.."
	/usr/sbin/swinstall -s `pwd`/WEBESBASE${WEBESVER}.depot
	/usr/bin/echo ""

 /sbin/cat <<EOF

  This procedure only installs the WEBES components.
  It is necessary to run the post-installation update utility
  to configure the system. Any optional components that
  are not being installed now may be installed later from
  the same utility:

    System Event Analyzer ${PREFIX}${CADOTVER}
    Computer Crash Analysis Tool ${PREFIX}${CCATDOTVER}

  The update utility's path and filename:

    /usr/sbin/webes_install_update

EOF


fi

echo "done"
}

verify_webesproxy() 
{

#exit_if_WEBES_installed

# Now check for any standalone WCCPROXY kits that might have installed
# by other kits like ISEE.
#
   PROXY_INSTALLED=""
   PROXY_INSTALLEDVER=""
   PROXY_INSTALLEDDOTVER=""
    
   PROXY_PKG=`swlist |/usr/bin/grep WEBESPROXY`

   if [ "$PROXY_PKG" != "" ]; then

   PROXY_INSTALLED="true"


PROXY_INSTALLEDVER="`echo $PROXY_PKG 2> /dev/null | /bin/cut -f2,3 -d "-" | cut -c1,3,5`"
PROXY_INSTALLEDDOTVER="`echo $PROXY_PKG 2> /dev/null | /bin/cut -f2 -d "-"`";export PROXY_INSTALLEDDOTVER
PROXY_INSTALLEDRPM="`echo $PROXY_INSTALLEDVER 2> /dev/null | /bin/sed -n 's/\([0-9]\)\([0-9]\)\([0-9]\)/\1.\2-\3/p'`"


     if [ -n "${PROXY_INSTALLED}" ]; then
#     PROXY_INSTALLEDVER="`expr $PROXY_INSTALLEDVER \* 10`"
      if [ "${PROXY_INSTALLEDVER}" -gt "${WCCPROXYVER}" ]; then
        /bin/cat <<EOF

A newer version of WCCPROXY-${PROXY_INSTALLEDRPM} is currently installed.

Hence no update action  is required.

EOF
        increment_proxy_count
       #exit 1
      elif [ "${PROXY_INSTALLEDVER}" -lt "${WCCPROXYVER}" ]; then
        /bin/cat <<EOF

An older version of the WCCPROXY-${PROXY_INSTALLEDRPM} is currently installed.
This will be deinstalled first and newer version will be installed.

EOF

         remove_existing_proxy
      elif [ -n "${PROXY_INSTALLEDVER}" ]; then
        /bin/cat <<EOF

Same version of the WCCPROXY-${PROXY_INSTALLEDRPM}
is currently found installed. Hence no update action is required.

EOF
        increment_proxy_count
       # exit 1
      fi
   fi

fi
}

#############Dec18,2003 The exit_gracefully() is intended only for Dec19,2003 release.
############# This function needs to be deleted after the Dec19,2003

exit_gracefully()
{

   PROXY_INSTALLED_CHECK=""
   WEBES_INSTALLED_CHECK=""

   PROXY_INSTALLED_CHECK=`/usr/sbin/swlist |/usr/bin/grep WEBESPROXY`
   WEBES_INSTALLED_CHECK=`/usr/sbin/swlist|/usr/bin/grep WEBESBASE`

     if [ "$PROXY_INSTALLED_CHECK" != "" ]; then
         if [  "$WEBES_INSTALLED_CHECK" != "" ]; then
            /bin/echo "   Upgrade is not supported by WEBES ${PREFIX}${WEBESDOTVER} version "
             exit 1
         elif [ "$WEBES_INSTALLED_CHECK" = "" ]; then
             exit_if_WEBES_installed
      fi
     elif [ "$PROXY_INSTALLED_CHECK" = "" ]; then
           exit_if_WEBES_installed
     fi

}

#############Dec18,2003 The exit_gracefully() is intended only for Dec19,2003 release.
############# This function needs to be deleted after the Dec19,2003

get_answer_item()
{
   GA_ITEM=""
   GA_LINES=""; GA_TOKEN=""; GA_VALUE=""; GA_NODE=""

   # Try to retrieve a node-specific entry first. If no hostname was supplied use
   # FULL_HOSTNAME. For a given token only one such line will exist and will
   # have the form:
   #                 tokenFlag=nodeA nodeB nodeC
   #            or:  token@nodeA=value

  FULL_HOSTNAME="`hostname`"
    if [ -z "${FULL_HOSTNAME}" ]; then
	FULL_HOSTNAME="`/usr/bin/uname -n`"
    fi
    if [ -z "${FULL_HOSTNAME}" ]; then
	/usr/bin/echo ""
	/usr/bin/echo "....unable to determine local system's hostname"
	/usr/bin/echo ""
	UPPER_HOSTNAME=""
	HOSTNAME=""
    fi

   [ "$#" = 1 -o "$#" = 2 -a -z "$2" ] && GA_NODE=$FULL_HOSTNAME
   [ "$#" = 2 -a -n "$2" ] && GA_NODE=$2

   GA_LINES=`/usr/bin/grep $1 $ANSWER_FILE | /usr/bin/grep $GA_NODE | /usr/bin/grep -v "#"`
   if [ -z "$GA_LINES" ]; then
      # nothing node-specific, read without any node names
      GA_LINES=`/usr/bin/grep $1 $ANSWER_FILE | /usr/bin/grep -v "$1@" | /usr/bin/grep -v "#"`
      if [ -z "$GA_LINES" ]; then
	 /usr/bin/echo "....get_answer_item: ITEM MISSING - token ($1), node ($2)"
         GA_ITEM=""
	 return 1
      fi
   fi
   /usr/bin/echo "....get_answer_item: token ($1), node ($2), recovered entry - $GA_LINES"

   # GA_LINES may now hold ONE of the following entry forms, with the correct token
   # and the correct nodename:
   #   token=value
   #   tokenFlag={true|false}
   #   tokenFlag=nodeA nodeB nodeC   : list includes the correct node
   #   token@nodeA=value             : nodeA is the correct node

   GA_VALUE=`/usr/bin/echo $GA_LINES | cut -f2 -d=`

   if [ -n "`/usr/bin/echo $1 | /usr/bin/grep Flag`" ]
   then
      # Dealing with a boolean - value is true | false | node list
      if [ -n "`/usr/bin/echo $GA_VALUE | /usr/bin/egrep '(true|false)'`" ]; then
	 # return true or false
	 GA_ITEM=$GA_VALUE
      else
         # node list - if node is in the list return true.
         if [ -n "`/usr/bin/echo $GA_VALUE | /usr/bin/grep $GA_NODE`" ]; then
	    GA_ITEM="true"
	 else
	    GA_ITEM="false"
	 fi
      fi
   else
      # Dealing with string data, return the value.
      GA_ITEM=$GA_VALUE
   fi
   /usr/bin/echo "....get_answer_item: returning value - $GA_ITEM"
   return 0
}


##################### START EXECUTION OF SCRIPT #############################

# the permissions check and include the utilities script.

  WHO=`/usr/bin/whoami`
  WHO=`echo $WHO|cut -f1 -d " "`
  if [ "$WHO" != "root" ]; then
     /bin/echo ""
     /bin/echo "Permission denied. Script may only be executed by root "
     /bin/echo ""
     exit 1
  fi

# We could be invoked with an answer file, i.e., "webes_install_update -a <path_and_filename>".
# Capture the filename for later use.

  if [ $# = 2 -a "$1" = "-a" ]; then
     /usr/bin/echo ""
     ANSWER_FILE=$2
     if [ -f $ANSWER_FILE ]; then
        /usr/bin/echo "Using answer file ${ANSWER_FILE}."
     else
        /usr/bin/echo "Unable to find answer file: ${ANSWER_FILE}"
        /usr/bin/echo ""
        ANSWER_FILE=""
	exit 0
     fi
     export ANSWER_FILE
  fi

 display_welcome_banner

 exit_gracefully

# Dec17,2003 hashed for graceful exit.....   exit_if_WEBES_installed 
# unhash the exit_if_WEBES_installed

# Not sure why verify_webesproxy was hashed out.
#  verify_webesproxy












