DEFINITION MODULE RTErrors;

   FROM SYSTEM IMPORT ADDRESS;

   TYPE
      Kind = (noError, halt, case, stack, crend, prio, fret, range);
      RangeCheck = (none, unsigned, signed, sign, dyn);

      Error = POINTER TO ErrorRec;
      ErrorRec =
	 RECORD
	    kind: Kind;
	    module: ADDRESS; (* points to name of module *)
	    line: CARDINAL; (* line number in source *)
	    pc: ADDRESS; (* program counter *)
	    CASE (* kind *) : Kind OF
	    | range: CASE rtype: RangeCheck OF
		     | unsigned, dyn:
			   value, min, max: CARDINAL;
		     | signed:
			   ivalue, imin, imax: INTEGER;
		     END;
	    END;
	 END;

      Handler = PROCEDURE (Error);

   PROCEDURE Notify(error: Error);
      (* called by runtime system *)

   PROCEDURE SetHandler(handler: Handler);
      (* define alternative handler of runtime errors *)

END RTErrors.
