IMPLEMENTATION MODULE RTErrors;

   FROM FtdIO IMPORT FwriteString, FwriteLn, FwriteInt, FwriteCard;
   FROM StdIO IMPORT stderr;

   VAR
      handler: Handler;

   PROCEDURE StandardHandler(error: Error);
      TYPE
	 String = POINTER TO ARRAY [0..31] OF CHAR;
      VAR
	 modname: String;
	 msg: ARRAY [0..79] OF CHAR;
   BEGIN
      WITH error^ DO
	 FwriteLn(stderr); (* don't start in the middle of a line *)
	 IF (module # 0) & (line # 0) THEN
	    FwriteString(stderr, "runtime error in module ");
	    modname := module; FwriteString(stderr, modname^);
	    FwriteString(stderr, " at line "); FwriteCard(stderr, line, 1);
	    FwriteString(stderr, ":"); FwriteLn(stderr);
	 END;
	 IF kind = range THEN
	    CASE rtype OF
	    | unsigned: FwriteString(stderr, "CARDINAL value ");
	                FwriteCard(stderr, value, 1);
			FwriteString(stderr, " out of [");
			FwriteCard(stderr, min, 1);
			FwriteString(stderr, "..");
			FwriteCard(stderr, max, 1);
			FwriteString(stderr, "]");
	    | signed:   FwriteString(stderr, "INTEGER value ");
	                FwriteInt(stderr, ivalue, 1);
			FwriteString(stderr, " out of [");
			FwriteInt(stderr, imin, 1);
			FwriteString(stderr, "..");
			FwriteInt(stderr, imax, 1);
			FwriteString(stderr, "]");
	    | sign:     FwriteString(stderr,
			   "CARDINAL/INTEGER conversion error");
	    | dyn:      FwriteString(stderr, "index ");
			FwriteCard(stderr, value, 1);
	                FwriteString(stderr, " out of bounds of ");
	                FwriteString(stderr, "dynamic array [0..");
			FwriteCard(stderr, max, 1);
			FwriteString(stderr, "]");
	    END;
	 ELSE
	    CASE kind OF
	    | halt:  msg := "call of procedure HALT";
	    | case:  msg := "no case label";
	    | stack: msg := "stack overflow";
	    | crend: msg := "RETURN of coroutine body";
	    | prio:  msg := "priority of module is lower than current priority";
	    | fret:  msg := "function does not return any value";
	    END;
	    FwriteString(stderr, msg);
	 END;
	 FwriteLn(stderr);
      END;
   END StandardHandler;

   PROCEDURE Notify(error: Error);
      (* called by runtime system *)
   BEGIN
      handler(error);
   END Notify;

   PROCEDURE SetHandler(newHandler: Handler);
      (* define alternative handler of runtime errors *)
   BEGIN
      handler := newHandler;
   END SetHandler;

BEGIN
   handler := StandardHandler;
END RTErrors.
