(* Modula-2 Library    -  UNIX System V  -     AFB 9/88 *)
(* (c) Universitaet Ulm, Sektion Informatik, D-7900 Ulm *)
DEFINITION MODULE SystemTypes; (* and constants *)

   (* see...
	/usr/include/fcntl.h
	/usr/include/signal.h
	/usr/include/sys/dir.h
	/usr/include/sys/param.h
	/usr/include/sys/types.h
   *)

   CONST
      DirSize = 255;
      MaxOpenFiles = 128;
      (* file control options; arguments of fcntl(2) and open(2) *)
      rdonly = {};
      wronly = { 31 };
      rdwr = { 30 };
      ndelay = { 29 };
      append = { 28 };
      async = { 25 };
      creat = { 22 };
      trunc = { 21 };
      excl = { 20 };
      nbio = { 19 };
      sync = { 18 };
   TYPE
      Sig = (SIG0,                                                     (*  0 *)
	     SIGHUP, SIGINT, SIGQUIT, SIGILL, SIGTRAP, SIGIOT, SIGEMT, (*  7 *)
	     SIGFPE, SIGKILL, SIGBUS, SIGSEGV, SIGSYS, SIGPIPE,        (* 13 *)
	     SIGALRM, SIGTERM, SIGUSR1, SIGUSR2, SIGCHLD, SIGPWR,      (* 19 *)
	     SIGWINCH, SIGURG, SIGPOLL, SIGSTOP, SIGTSTP, SIGCONT,     (* 25 *)
	     SIGTTIN, SIGTTOU, SIGVTALRM, SIGPROF, SIGXCPU, SIGXFSZ,   (* 31 *)
	     SIGWAITING, SIGLWP, SIGFREEZE, SIGTHAW,                   (* 35 *)
	     SIGRT36, SIGRT37, SIGRT38, SIGRT39, SIGRT40, SIGRT41,     (* 41 *)
	     SIGRT42, SIGRT43);                                        (* 43 *)
   CONST
      (* aliases *)
      SIGABRT = SIGIOT;
      SIGCLD = SIGCHLD;
      SIGIO = SIGPOLL;
      SIGRTMIN = SIGRT36;
      SIGRTMAX = SIGRT43;

   TYPE
      SigSet = SET OF Sig;

      ProcessId = INTEGER;	(* ProcessId may be -1 for kill *)
      TIME = LONGINT;
      OFF = LONGINT;		(* offset/size of files *)

END SystemTypes.
