/*
*
* Copyright (c) 1997 Jan Kr"uger <Jan.Krueger@stud.uni-hannover.de>
*
* In short: you can do whatever you want with this, but don't blame me!
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
*
*/

#ifdef MAP_REGEX

#include "sendmail.h"
#include <sys/types.h>
#include <regex.h>

#define DEFAULT_DELIM	CONDELSE	

#define END_OF_FIELDS	-1

#define ERRBUF_SIZE	80
#define RETBUF_SIZE	256
#define MAX_MATCH	32

#define MF_REGEX_NOT	0x00040000 /* move to sendmail.h */

#define xnalloc(s)	memset(xalloc(s), 0, s);

struct regex_map {
regex_t pattern_buf; /* xalloc it */
long regex_flags; /* move to map->map_mflags */
int *regex_subfields; /* move to type MAP */
char *delim; /* move to type MAP */
};

int parse_fields(s, ibuf, blen)
char *s;
int *ibuf; /* array */
int blen;
{
	register char *cp;
	int i = 0;
	int lastone = 0; /* bool */
	blen--; /* for terminating END_OF_FIELDS */
	cp = s; 
	do {
		for(;; cp++)
		{
			if(*cp == ',')
			{
				*cp = '\0';
				break;
			}
			if(*cp == '\0')
			{
				lastone++;
				break;
			}
		}
		if(i < blen)
			ibuf[i++] = atoi(s);
		else
		{
			syserr("too much fields, %d max\n", blen);
			return -1;
		}
		s = ++cp;
	} while(!lastone);
	ibuf[i] = END_OF_FIELDS;
	return i;
}

int substring_count(p, f)
char *p;
int f;
{
	int sc = 0;
	char *cp;
	char lastc = '\0';
	for(cp = p; *cp; cp++)
	{
		if( *cp == '(' && ( (f && (lastc != '\\')) || 
			(!f && (lastc == '\\')) ) )
		{ /* f -> (  
		    !f -> \( */
			sc++;
		}

		if(*cp == '\\' && lastc == '\\')
		{ /* \\ */
			lastc = '\0';
		}
		else
		{ /* other */
			lastc = *cp;
		}
	}
	if(tTd(72, 1))
		printf("regex_map_init: substrings %d\n", sc);

	return(sc + 1);
}


int regex_map_init(map, ap)
	MAP *map;
	char *ap;
{
	int regerr;
	struct regex_map *map_p;
	register char *p;
	char *sub_param;
	int pflags;
	static char defdstr[] = { DEFAULT_DELIM, '\0' };

	if(tTd(72, 1))
		printf("regex_map_init: mapname '%s', args '%s'\n", 
				map->map_mname, ap);

	pflags = REG_ICASE | REG_EXTENDED | REG_NOSUB;

	p = ap;

	map_p = xnalloc(sizeof(struct regex_map));

	for (;;)
        {
		while (isascii(*p) && isspace(*p))
			p++;
		if (*p != '-')
			break;
		switch (*++p)
		{
			case 'n': /* not */
				map_p->regex_flags = MF_REGEX_NOT;
				break;

			case 'f': /* case sensitive */
				map->map_mflags |= MF_NOFOLDCASE;
				pflags &= ~REG_ICASE;
				break;

			case 'b': /* basic regular expressions */
				pflags &= ~REG_EXTENDED;
				break;

			case 's': /* substring match () syntax */
				sub_param = ++p;
				pflags &= ~REG_NOSUB;
				break;

			case 'd': /* delimiter */
				map_p->delim = ++p;
				break;

			case 'a': /* map append */
				map->map_app = ++p;
				break;

			case 'm': /* matchonly */
				map->map_mflags |= MF_MATCHONLY;
				break;
								  
		}
                while (*p != '\0' && !(isascii(*p) && isspace(*p)))
                        p++;
                if (*p != '\0')
                        *p++ = '\0';
	}
	if(tTd(72, 1))
		printf("regex_map_init: compile '%s' %x\n", p, pflags);

	if((regerr = regcomp(&(map_p->pattern_buf), p, pflags)) != 0)
	{ /* Errorhandling */
		char errbuf[ERRBUF_SIZE];
		regerror(regerr, &(map_p->pattern_buf), errbuf, ERRBUF_SIZE);
		syserr("pattern-compile-error: %s\n", errbuf);
		free(map_p);
		return FALSE;	
	}

	if (map->map_app != NULL)
		map->map_app = newstr(map->map_app);
	if (map_p->delim != NULL)
		map_p->delim = newstr(map_p->delim);
	else
		map_p->delim = defdstr;

	if(!bitset(REG_NOSUB, pflags))
	{ /* substring matching */
		int substrings;
		int *fields = (int *)xalloc(sizeof(int) * (MAX_MATCH + 1));
		substrings = substring_count(p, pflags & REG_EXTENDED);
		if(substrings >= MAX_MATCH)
		{
			syserr("too much substrings, %d max\n", MAX_MATCH);
			free(map_p);
			return FALSE;	
		}
		if(sub_param[0] != '\0')
		{ /* optional parameter -sfields */
			if(parse_fields(sub_param, fields, 
				MAX_MATCH + 1) == -1)
			return FALSE;
		}
		else
		{ /* set default fields  */
			int i;
			for(i = 0; i < substrings; i++)
				fields[i] = i;
			fields[i] = END_OF_FIELDS;
		}
		map_p->regex_subfields = fields;
		if(tTd(72, 1))
		{
			int *ip;
			printf("regex_map_init: subfields");
			for(ip = fields; *ip != END_OF_FIELDS; ip++)
				printf(" %d", *ip);
			printf("\n");
		}
	}
	map->map_file = (char *)map_p; /* dirty hack */

	return TRUE;
}

char *regex_map_rewrite(map, s, slen, av)
	MAP *map;
	const char *s;
	int slen;
	char **av;
{
	if(bitset(MF_MATCHONLY, map->map_mflags))
		return map_rewrite(map, av[0], strlen(av[0]), NULL);
	else
		return map_rewrite(map, s, slen, NULL);
}

char *regex_map_lookup(map, name, av, statp)
	MAP *map;
	char *name;
	char **av;
	int *statp;
{
	int regret;
	struct regex_map *map_p;
	regmatch_t pmatch[MAX_MATCH];

	if(tTd(72, 1))
	{
		char **cpp;
		printf("regex_map_lookup: key '%s'\n", name);
		for(cpp = av; cpp && *cpp; cpp++)
			printf("regex_map_lookup: arg '%s'\n", *cpp);
	}

	map_p = (struct regex_map *)(map->map_file);
	regret = regexec(&(map_p->pattern_buf),
			 name, MAX_MATCH, pmatch, 0);
	
	if(bitset(MF_REGEX_NOT, map_p->regex_flags))
	{ /* option -n */
		if(regret == REG_NOMATCH)
			return regex_map_rewrite(map, "", 0, av);
		else
			return NULL;
	}
	if(regret == REG_NOMATCH)
		return NULL;

	if(map_p->regex_subfields != NULL)
	{ /* option -s */
		static char retbuf[RETBUF_SIZE];
		int fields[MAX_MATCH + 1];
		bool first = 1; 
		int anglecnt = 0, cmntcnt = 0, spacecnt = 0;
		bool quotemode = FALSE, bslashmode = FALSE;
		register char *dp, *sp;
		char *endp, *ldp;
		int *ip;

		dp = retbuf;
		ldp = retbuf + RETBUF_SIZE - 1;

		if(av[1] != NULL)
		{
			if(parse_fields(av[1], fields, MAX_MATCH + 1) == -1)
			{
				syserr("too much fields, %d max\n", MAX_MATCH);
				*statp = EX_CONFIG;
				return NULL;
			}
			ip = fields;
		}
		else
			ip = map_p->regex_subfields;

		for( ; *ip != END_OF_FIELDS; ip++)
		{
			if(!first)
			{
				for(sp = map_p->delim; *sp; sp++)
					if(dp < ldp)
						*dp++ = *sp;
			}
			else
				first = 0;
			

			if(pmatch[*ip].rm_so < 0 || pmatch[*ip].rm_eo < 0)	
				continue;
			
			for(sp = name + pmatch[*ip].rm_so, 
			    endp = name + pmatch[*ip].rm_eo;
			    endp - sp > 0; 
			    sp++)
			{
				if(dp < ldp)
				{
					if(bslashmode)
					{
						*dp++ = *sp;
						bslashmode = FALSE;
					}
					else switch(*dp++ = *sp)
					{
						case '\\':
						bslashmode = TRUE;
						break;

						case '(':
						cmntcnt++;
						break;

						case ')':
						cmntcnt--;
						break;

						case '<':
						anglecnt++;
						break;

						case '>':
						anglecnt--;
						break;

						case ' ':
						spacecnt++;
						break;

						case '"':
						quotemode = !quotemode;
						break;
					}
				}
			}
		}
		if (anglecnt != 0 || cmntcnt != 0 || quotemode ||
		    bslashmode || spacecnt != 0)
		{
			sm_syslog(LOG_WARNING, NOQID, 
				 "Warning: regex may cause prescan() failure "
				 "map=%s lookup=%s", map->map_mname, name);
			return NULL;
		}

		*dp = '\0';

		return regex_map_rewrite(map, retbuf, strlen(retbuf), av);
	}
	return regex_map_rewrite(map, "", 0, av);
}
#endif /* MAP_REGEX */
