/*
*
* Copyright (c) 1997 Jan Kr"uger <Jan.Krueger@stud.uni-hannover.de>
*
* In short: you can do whatever you want with this, but don't blame me!
*
* THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
*
*/

#ifdef MAP_STORAGE

#include "sendmail.h"

#define DEF_STORAGE_SIZE	100

#define CHAR1	'@'
#define CHAR0	'.'

struct storage_map {
int storage_size;
char *storage;
};

int storage_map_init(map, ap)
	MAP *map;
	char *ap;
{
	char *p = ap;
	char *size_str = NULL;
	struct storage_map *storage_p;

	storage_p = (struct storage_map *)xalloc(sizeof(struct storage_map));
	storage_p->storage_size = DEF_STORAGE_SIZE;

	for (;;)
        {
		while (isascii(*p) && isspace(*p))
			p++;
		if (*p != '-')
			break;
		switch (*++p)
		{
			case 's': /* size */
				size_str = ++p;
				break;
		}
                while (*p != '\0' && !(isascii(*p) && isspace(*p)))
                        p++;
                if (*p != '\0')
                        *p++ = '\0';
	}
	if(size_str != NULL)
		storage_p->storage_size = atoi(size_str);

	storage_p->storage = xalloc(storage_p->storage_size + 1);

	snprintf(storage_p->storage, storage_p->storage_size, "%s", p);

	if(tTd(73, 1))
		printf("storage_map_init: len %d value '%s'\n",
			storage_p->storage_size, storage_p->storage);

	map->map_file = (char *)storage_p;
	
	return TRUE;
}


char *storage_rewrite_ip_bin(map, ip)
	MAP *map;
	char *ip;
{
	char buf[32 + 1];
	register char *dp = buf;
	int b[4];
	int byte;
	register int bit;

	if(tTd(73, 1))
		printf("ip_to_bin %s\n", ip);

	if(sscanf(ip, "%d.%d.%d.%d", &b[3], &b[2], &b[1], &b[0]) != 4)
		return NULL;
	
	for(byte = 3; byte >= 0; byte--)
		for(bit = 8; bit > 0; bit--)
		{
			if((b[byte] & 0x80) == 0x80)
				*dp++ = CHAR1;
			else	
				*dp++ = CHAR0;

			b[byte] <<= 1;
		}

	*dp = '\0';

	return map_rewrite(map, buf, 32, NULL);
}

char *storage_map_lookup(map, key, av, statp)
	MAP *map;
	char *key;
	char **av;
	int *statp;
{
	struct storage_map *storage_p;
	bool assignmode = FALSE;

	if(tTd(73, 1))
	{
		char **cpp;
		printf("storage_map_lookup: key '%s'\n", key);
		for(cpp = av; cpp && *cpp; cpp++)
			printf("storage_map_lookup: arg '%s'\n", *cpp);
	}

	storage_p = (struct storage_map *)map->map_file;

	if(key[0] != '\0')
	{ /* assign */
		snprintf(storage_p->storage, storage_p->storage_size,
				"%s", key);
		assignmode = TRUE;
	}
	if(av && av[0] && av[1])
	{ /* has option */
		switch(av[1][0])
		{
			case 'b':
			return storage_rewrite_ip_bin(map, storage_p->storage);

			case 'l':
			return map_rewrite(map, 
				storage_p->storage, 
				strlen(storage_p->storage), NULL);
		}
	}
	if(assignmode)
		return NULL;
	else
		/* lookup */
		return map_rewrite(map, 
			storage_p->storage, strlen(storage_p->storage), NULL);

}
#endif /* MAP_STORAGE */
